/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.WidgetToolBarComposite;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class RProjectContainerComposite
extends Composite {
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private final IProject project;
    private IContainer pkgBaseContainer;
    private TreeViewer treeViewer;
    private ToolBarManager rightToolBarMgr;

    public RProjectContainerComposite(Composite parent, IProject project) {
        super(parent, 0);
        this.project = project;
        this.createContents();
    }

    protected void createContents() {
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer();
        Dialog.applyDialogFont((Control)this);
        this.treeViewer.setInput((Object)new IContainer[]{this.project});
        this.treeViewer.expandToLevel(2);
        if (this.pkgBaseContainer != null) {
            this.treeViewer.expandToLevel((Object)this.pkgBaseContainer, 1);
        }
    }

    protected void createTreeViewer() {
        WidgetToolBarComposite treeGroup = new WidgetToolBarComposite((Composite)this, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 320;
        gd.heightHint = 300;
        treeGroup.setLayoutData((Object)gd);
        this.rightToolBarMgr = new ToolBarManager(treeGroup.getRightToolBar());
        this.treeViewer = new TreeViewer((Composite)treeGroup, 0);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.rightToolBarMgr.add((IAction)new CollapseAllAction());
        this.rightToolBarMgr.add((IAction)new ExpandAllAction());
        this.rightToolBarMgr.update(true);
        treeGroup.layout();
        this.treeViewer.setContentProvider((IContentProvider)new ResourceContentProvider(6));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        ViewerUtils.addDoubleClickExpansion((TreeViewer)this.treeViewer);
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setPkgBaseContainer(IPath path) {
        this.pkgBaseContainer = path == null ? null : (path.segmentCount() == 0 ? this.project : this.project.getFolder(path));
        this.treeViewer.refresh(true);
    }

    public void togglePkgBaseContainer() {
        Object element = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        this.pkgBaseContainer = element instanceof IContainer ? (element != null && !element.equals(this.pkgBaseContainer) ? (IContainer)element : null) : null;
        this.treeViewer.refresh(true);
    }

    public IPath getPkgBaseContainer() {
        if (this.pkgBaseContainer == null) {
            return null;
        }
        return this.pkgBaseContainer.getProjectRelativePath();
    }

    private class CollapseAllAction
    extends Action {
        CollapseAllAction() {
            this.setText(SharedMessages.CollapseAllAction_label);
            this.setDescription(SharedMessages.CollapseAllAction_description);
            this.setToolTipText(SharedMessages.CollapseAllAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/collapse.all"));
        }

        public void run() {
            RProjectContainerComposite.this.treeViewer.collapseAll();
        }
    }

    private class ExpandAllAction
    extends Action {
        ExpandAllAction() {
            this.setText(SharedMessages.ExpandAllAction_label);
            this.setDescription(SharedMessages.ExpandAllAction_description);
            this.setToolTipText(SharedMessages.ExpandAllAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/expand.all"));
        }

        public void run() {
            RProjectContainerComposite.this.treeViewer.expandAll();
        }
    }

    private class RLabelProvider
    extends LabelProvider {
        private final WorkbenchLabelProvider baseProvider = new WorkbenchLabelProvider();

        public Image getImage(Object element) {
            return this.baseProvider.getImage(element);
        }

        public String getText(Object element) {
            String text = this.baseProvider.getText(element);
            boolean flags = false;
            if (RProjectContainerComposite.this.pkgBaseContainer != null && RProjectContainerComposite.this.pkgBaseContainer.equals(element)) {
                flags |= true;
            }
            if (flags) {
                StringBuilder sb = new StringBuilder(text);
                sb.append("\u2002(");
                if (flags & true) {
                    sb.append("R Package Root");
                    sb.append(", ");
                }
                sb.replace(sb.length() - 2, sb.length(), ")");
                return sb.toString();
            }
            return text;
        }
    }
}

