/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.core.source;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.core.sections.AbstractDocContentSections;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.redocs.r.core.source.IDocContentSectionsRweaveExtension;
import org.eclipse.statet.redocs.r.core.source.RweaveDocSectionTreePartImpl;
import org.eclipse.statet.redocs.tex.r.core.source.ITexRweaveDocumentConstants;

public class LtxRweaveDocumentContentInfo
extends AbstractDocContentSections
implements IDocContentSectionsRweaveExtension {
    public static final String LTX = "org.eclipse.statet.Ltx";
    public static final String R_CHUNK_CONTROL = "org.eclipse.statet.LtxR-ChunkControl";
    public static final String R = "org.eclipse.statet.R";
    public static final IDocContentSectionsRweaveExtension INSTANCE = new LtxRweaveDocumentContentInfo();
    private final RweaveDocSectionTreePartImpl rweaveImpl = new RweaveDocSectionTreePartImpl((IDocContentSections)this);

    public LtxRweaveDocumentContentInfo() {
        super("org.eclipse.statet.LtxRweave", LTX, ImCollections.newList((Object[])new String[]{LTX, R_CHUNK_CONTROL, R}));
    }

    public final String getTypeByPartition(String contentType) {
        if (IRDocumentConstants.R_ANY_CONTENT_CONSTRAINT.matches(contentType)) {
            return R;
        }
        if (ITexRweaveDocumentConstants.RCHUNK_PARTITION_CONSTRAINT.matches(contentType)) {
            return R_CHUNK_CONTROL;
        }
        return LTX;
    }

    public ITreePartitionNode getRChunkRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkRegion(document, offset);
    }

    public List<ITreePartitionNode> getRChunkRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }

    public IRegion getRChunkContentRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRChunkContentRegion(document, offset);
    }

    public ITreePartitionNode getRCodeRegion(IDocument document, int offset) throws BadLocationException {
        return this.rweaveImpl.getRCodeRegion(document, offset);
    }

    public List<ITreePartitionNode> getRChunkCodeRegions(IDocument document, int offset, int length) throws BadLocationException {
        return this.rweaveImpl.getRChunkCodeRegions(document, offset, length);
    }
}

