/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;

public class OutlineContentProvider
implements ITreeContentProvider {
    private final IOutlineContent content;

    public OutlineContentProvider(IOutlineContent content) {
        this.content = content;
    }

    protected final IOutlineContent getContent() {
        return this.content;
    }

    public ISourceModelStamp getStamp(Object inputElement) {
        ISourceUnitModelInfo modelInfo = this.getContent().getModelInfo(inputElement);
        return modelInfo != null ? modelInfo.getStamp() : null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ISourceUnitModelInfo modelInfo = this.getContent().getModelInfo(inputElement);
        if (modelInfo != null) {
            List children = modelInfo.getSourceElement().getSourceChildren(this.getContent().getContentFilter());
            return children.toArray(new ISourceStructElement[children.size()]);
        }
        return new ISourceStructElement[0];
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        ISourceStructElement o = (ISourceStructElement)element;
        return o.getSourceParent();
    }

    public boolean hasChildren(Object element) {
        ISourceStructElement o = (ISourceStructElement)element;
        return o.hasSourceChildren(this.getContent().getContentFilter());
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISourceStructElement) {
            ISourceStructElement o = (ISourceStructElement)parentElement;
            List children = o.getSourceChildren(this.getContent().getContentFilter());
            return children.toArray(new ISourceStructElement[children.size()]);
        }
        return new ISourceStructElement[0];
    }

    public static interface IOutlineContent {
        public ISourceUnitModelInfo getModelInfo(Object var1);

        public IModelElement.Filter getContentFilter();
    }
}

