/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.IMarkupCompletionExtension;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.swt.graphics.Point;

public class MarkupLabelCompletionComputer
implements IContentAssistComputer,
IMarkupCompletionExtension {
    private IMarkupLanguage markupLanguage;
    private IMarkupCompletionExtension completionExtension;

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)editor.getViewer().getDocument(), (String)editor.getDocumentContentInfo().getPartitioning());
        if (this.markupLanguage != null) {
            this.completionExtension = (IMarkupCompletionExtension)Platform.getAdapterManager().getAdapter((Object)this.markupLanguage, IMarkupCompletionExtension.class);
        }
    }

    public void sessionEnded() {
        this.markupLanguage = null;
        this.completionExtension = null;
    }

    protected IMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        IMarkupLanguage markupLanguage = this.markupLanguage;
        IMarkupCompletionExtension ext = this.completionExtension != null ? this.completionExtension : this;
        IWikidocModelInfo modelInfo = (IWikidocModelInfo)context.getModelInfo();
        IMarkupCompletionExtension.CompletionType type = ext.getLinkAnchorLabel(context, markupLanguage);
        if (type != null) {
            this.addLabelProposals(context, type, (NameAccessSet<WikitextNameAccess>)modelInfo.getLinkAnchorLabels(), proposals);
        }
        if ((type = ext.getLinkRefLabel(context, markupLanguage)) != null) {
            this.addLabelProposals(context, type, (NameAccessSet<WikitextNameAccess>)modelInfo.getLinkRefLabels(), proposals);
        }
        return Status.OK_STATUS;
    }

    public IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        return null;
    }

    private void addLabelProposals(AssistInvocationContext context, IMarkupCompletionExtension.CompletionType type, NameAccessSet<WikitextNameAccess> labels, AssistProposalCollector proposals) {
        for (String label : labels.getNames()) {
            ImList accessList;
            if (!label.startsWith(type.getLookupPrefix()) || (accessList = labels.getAllInUnit(label)).size() == 1 && this.isCurrent((WikitextAstNode)((WikitextNameAccess)accessList.get(0)).getNameNode(), context.getInvocationOffset())) continue;
            WikitextNameAccess defAccess = null;
            IWikitextSourceElement defElement = null;
            block1: for (WikitextNameAccess access : accessList) {
                if (!access.isWriteAccess()) continue;
                for (Object attachment : ((WikitextAstNode)access.getNode()).getAttachments()) {
                    if (!(attachment instanceof IWikitextSourceElement)) continue;
                    defAccess = access;
                    defElement = (IWikitextSourceElement)attachment;
                    break block1;
                }
                if (defAccess != null) continue;
                defAccess = access;
            }
            if (defAccess == null) {
                defAccess = (WikitextNameAccess)accessList.get(0);
            }
            proposals.add(this.createProposal(defAccess.getDisplayName(), context, type.getSourcePrefix(), defElement));
        }
    }

    private boolean isCurrent(WikitextAstNode node, int offset) {
        return node != null && node.getStartOffset() <= offset && node.getEndOffset() >= offset;
    }

    protected IAssistCompletionProposal createProposal(String name, AssistInvocationContext context, String prefix, IWikitextSourceElement element) {
        return new LabelCompletionProposal(context, name, context.getInvocationOffset() - prefix.length(), element);
    }

    @Override
    public IMarkupCompletionExtension.CompletionType getLinkAnchorLabel(AssistInvocationContext context, IMarkupLanguage markupLanguage) {
        try {
            int endOffset;
            IDocument document = context.getDocument();
            int startOffset = endOffset = context.getOffset();
            while (startOffset > 0) {
                char c;
                if (Character.isLetterOrDigit(c = document.getChar(--startOffset)) || c == '-' || c == '_' || c == ':' || c == '.' || c != '#') continue;
                return new IMarkupCompletionExtension.CompletionType(document.get(++startOffset, endOffset - startOffset));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IMarkupCompletionExtension.CompletionType getLinkRefLabel(AssistInvocationContext context, IMarkupLanguage markupLanguage) {
        return null;
    }

    private static class LabelCompletionProposal
    extends SimpleCompletionProposal
    implements ICompletionProposalExtension6 {
        private final IWikitextSourceElement refElement;

        public LabelCompletionProposal(AssistInvocationContext context, String replacementString, int replacementOffset, IWikitextSourceElement refElement) {
            super(context, replacementString, replacementOffset);
            this.refElement = refElement;
        }

        protected String getPluginId() {
            return "org.eclipse.statet.docmlet.wikitext.ui";
        }

        public StyledString getStyledDisplayString() {
            String name;
            StyledString styledString = new StyledString(this.getDisplayString());
            if (this.refElement != null && (name = this.refElement.getElementName().getDisplayName()) != null) {
                styledString.append(" (", StyledString.DECORATIONS_STYLER);
                if ((this.refElement.getElementType() & 0xFF0) == 1056) {
                    styledString.append("h:" + (this.refElement.getElementType() & 0xF) + " ");
                }
                styledString.append(name, StyledString.DECORATIONS_STYLER);
                styledString.append(')', StyledString.DECORATIONS_STYLER);
            }
            return styledString;
        }

        public boolean isAutoInsertable() {
            return false;
        }

        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = this.getInvocationContext().getDocument();
                --end;
                while (++end < document.getLength()) {
                    char c = document.getChar(end);
                    if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != ':' && c != '.') break;
                }
            }
            return end - replacementOffset;
        }
    }
}

