/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.internal.actions.providers;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.explorer.internal.actions.CloseResourceOverrideAction;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class ResourceMgmtOverrideActionProvider
extends CommonActionProvider {
    private BuildAction buildAction;
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private RefreshAction refreshAction;
    private CommonNavigator navigator;

    public void init(ICommonActionExtensionSite site) {
        IWorkbenchPart part;
        super.init(site);
        ICommonViewerSite viewSite = site.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite && (part = ((ICommonViewerWorkbenchSite)viewSite).getPart()) instanceof CommonNavigator) {
            this.navigator = (CommonNavigator)part;
            this.makeActions();
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                project = (IProject)((IAdaptable)next).getAdapter(IProject.class);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && !ResourcesPlugin.getWorkspace().isAutoBuilding() && hasBuilder) {
            this.buildAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.buildAction);
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.build", (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.build", (IAction)this.closeProjectAction);
            }
        }
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    protected void makeActions() {
        IWorkbenchPartSite provider = this.navigator.getSite();
        this.openProjectAction = this.createOpenResourceAction((IShellProvider)provider);
        this.closeProjectAction = this.createCloseResourceAction((IShellProvider)provider);
        this.refreshAction = this.createRefreshAction((IShellProvider)provider);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.buildAction = this.createBuildAction((IShellProvider)provider);
        this.buildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
    }

    protected OpenResourceAction createOpenResourceAction(IShellProvider provider) {
        return new OpenResourceAction(provider);
    }

    protected CloseResourceAction createCloseResourceAction(IShellProvider provider) {
        return new CloseResourceOverrideAction(provider);
    }

    protected RefreshAction createRefreshAction(final IShellProvider provider) {
        return new RefreshAction(provider){

            public void run() {
                final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
                final WorkspaceModifyOperation op = (WorkspaceModifyOperation)this.createOperation(errorStatus);
                WorkspaceJob job = new WorkspaceJob("refresh"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            op.run(monitor);
                            Shell shell = provider.getShell();
                            if (shell != null && !shell.isDisposed()) {
                                shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        StructuredViewer viewer = ResourceMgmtOverrideActionProvider.this.getActionSite().getStructuredViewer();
                                        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                                            viewer.refresh();
                                        }
                                    }
                                });
                            }
                        }
                        catch (InvocationTargetException e) {
                            throw new CoreException(StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)e.getTargetException()));
                        }
                        catch (InterruptedException e) {
                            return Status.CANCEL_STATUS;
                        }
                        return errorStatus[0];
                    }
                };
                ISchedulingRule rule = op.getRule();
                if (rule != null) {
                    job.setRule(rule);
                }
                job.setUser(true);
                job.schedule();
            }
        };
    }

    protected BuildAction createBuildAction(IShellProvider provider) {
        return new BuildAction(provider, 10);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.getIDEImageDescriptor((String)relativePath);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.buildAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }
}

