/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.set.basis.constants.TextType;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.set.utils.ToolboxVersion;
import org.eclipse.swt.widgets.Composite;

public class ToolboxConfiguration {
    private static Path defaultDirectory;
    private static final String MAP_SOURCES_DEFAULT = "BKG_TOPPLUS|BKG_SENT";
    private static final String HERE_API_KEY_DEFAULT = "";
    private static final String HERE_CLIENT_ID_DEFAULT = "";
    private static final String MAPBOX_API_KEY_DEFAULT = "";
    private static final String DOP20_API_KEY_DEFAULT = "";
    private static final String DOP20_INTERN_URL_DEFAULT = "https://sg.geodatenzentrum.de/wms_dop";
    private static final String LOD_SCALE_DEFAULT = "10000";
    private static final String EXPORT_DPI_DEFAULT = "300";
    private static final String TRACK_WIDTH = "3|1.5|0.75|1";
    private static final String TRACK_WIDTH_INTERVALL = "1,10|0.5,8|0.25,3|0.5,3";
    private static final String BASE_ZOOM_LEVEL = "20";
    private static final String DEFAULT_COLLISIONS_ENABLED = "true";
    private static final String DEFAULT_SHEETCUT_CRS = "DR0";
    private static final String BANK_LINE_TOP_PATH_OFFSET_LIMIT = "0.2";
    private static final String EXPORT_SITEPLAN_SCALE_DEFAULT = "1000";
    private static final String PATH_FINDING_TOLERANCE = "0.001";

    public static float getDefaultHeight() {
        return Float.parseFloat(System.getProperty("toolbox.default.line.height", Float.toString(0.6f)));
    }

    public static Path getDefaultPath() {
        if (defaultDirectory != null) {
            return defaultDirectory;
        }
        String dir = System.getProperty("toolbox.defaultdir", "$USERPROFILE$\\planpro");
        defaultDirectory = Paths.get(StringExtensions.expandFromEnvironment(dir), new String[0]);
        File file = defaultDirectory.toFile();
        if (file.exists() || file.mkdirs()) {
            return defaultDirectory;
        }
        throw new RuntimeException("Creation of default directory " + String.valueOf(defaultDirectory) + " failed.");
    }

    public static float getTablesScaleFactor() {
        return Float.parseFloat(System.getProperty("toolbox.tables.scale", Float.toString(50.0f)));
    }

    public static String getTextAttribute(TextType type, String defaultDescription, Composite parent) {
        return System.getProperty(type.getProperty(), defaultDescription);
    }

    public static String getTextFont(String defaultDescription) {
        return System.getProperty("toolbox.text.font", defaultDescription);
    }

    public static String getToolboxLogfile() {
        return System.getProperty("toolbox.logfile");
    }

    public static ToolboxVersion getToolboxVersion() {
        return new ToolboxVersion(System.getProperty("toolbox.detailversion"));
    }

    public static int getTableTreeMinimum() {
        String property = System.getProperty("toolbox.table.tree.minimum");
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public static String getShortName() {
        return System.getProperty("toolbox.shortname");
    }

    public static boolean isDevelopmentMode() {
        return Boolean.parseBoolean(System.getProperty("toolbox.development.mode", Boolean.TRUE.toString()));
    }

    public static boolean isPdfExportTestFilling() {
        return Boolean.parseBoolean(System.getProperty("toolbox.export.pdf.test.filling", Boolean.FALSE.toString()));
    }

    public static boolean isDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") > -1;
    }

    public static String getMapSources() {
        return System.getProperty("toolbox.siteplan.mapsources", MAP_SOURCES_DEFAULT);
    }

    public static String getHereClientID() {
        return System.getProperty("toolbox.siteplan.mapsources.here_clientid", "");
    }

    public static String getHereApiKey() {
        return System.getProperty("toolbox.siteplan.mapsources.here_apikey", "");
    }

    public static String getMapboxApiKey() {
        return System.getProperty("toolbox.siteplan.mapsources.mapbox_apikey", "");
    }

    public static String getDop20ApiKey() {
        return System.getProperty("toolbox.siteplan.mapsources.dop20_apikey", "");
    }

    public static String getDop20InternUrl() {
        return System.getProperty("toolbox.siteplan.mapsources.dop20_intern_url", DOP20_INTERN_URL_DEFAULT);
    }

    public static int getLodScale() {
        return Integer.parseInt(System.getProperty("toolbox.siteplan.lod_scale", LOD_SCALE_DEFAULT));
    }

    public static int getExportDPI() {
        return Integer.parseInt(System.getProperty("toolbox.siteplan.export_dpi", EXPORT_DPI_DEFAULT));
    }

    public static int getSiteplanExportScale() {
        return Integer.parseInt(System.getProperty("toolbox.siteplan.export.scale", EXPORT_SITEPLAN_SCALE_DEFAULT));
    }

    public static String getTrackWidth() {
        return System.getProperty("toolbox.siteplan.track_width", TRACK_WIDTH);
    }

    public static String getTrackWidthIntervall() {
        return System.getProperty("toolbox.siteplan.track_width_intervall", TRACK_WIDTH_INTERVALL);
    }

    public static int getBaseZoomLevel() {
        return Integer.parseInt(System.getProperty("toolbox.siteplan.base_zoom_level", BASE_ZOOM_LEVEL));
    }

    public static boolean getDefaultCollisionsEnabled() {
        return System.getProperty("toolbox.siteplan.default_collisions_enabled", DEFAULT_COLLISIONS_ENABLED).equals(DEFAULT_COLLISIONS_ENABLED);
    }

    public static String getDefaultSheetCutCRS() {
        return System.getProperty("toolbox.siteplan.sheetcut_crs", DEFAULT_SHEETCUT_CRS);
    }

    public static double getBankLineTopOffsetLimit() {
        return Double.parseDouble(System.getProperty("toolbox.bank_line_offset_limit", BANK_LINE_TOP_PATH_OFFSET_LIMIT));
    }

    public static double getPathFindingTolerance() {
        return Double.parseDouble(System.getProperty("toolbox.path_finding_tolerance", PATH_FINDING_TOLERANCE));
    }
}

