/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.GeometryCalculationOptions;
import org.eclipse.set.basis.geometry.GeometryOptionsBuilder;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.core.services.geometry.PointObjectPositionService;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Punkt_ohne_Proxy_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.GeoPunktExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(service={PlazCheck.class, EventHandler.class}, property={"event.topics=geometryService/done"})
public class GeoCoordinateValid
extends AbstractPlazContainerCheck
implements PlazCheck,
EventHandler {
    private static final double TOLERANT = 0.1;
    @Reference
    GeoKanteGeometryService geometryService;
    @Reference
    PointObjectPositionService pointObjectPositionService;
    @Reference
    EventAdmin eventAdmin;
    static BigDecimal FMA_LATERAL_DISTANCE = BigDecimal.valueOf(0.85);
    static BigDecimal PZB_LATERAL_DISTANCE = BigDecimal.valueOf(1.05);
    private static final List<GEOKanteMetadata> alreadyFoundMetaData = new ArrayList<GEOKanteMetadata>();

    public void handleEvent(Event event) {
        HashMap properties = new HashMap();
        properties.put("org.eclipse.e4.data", this.getClass());
        this.eventAdmin.sendEvent(new Event("plazmodel/check", properties));
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        if (!this.geometryService.isFindGeometryComplete()) {
            return List.of(this.createProcessingWarning());
        }
        ArrayList<PlazError> result = new ArrayList<PlazError>();
        GeoCoordinateValid.getRelevantPOs(container).forEach(po -> po.getPunktObjektTOPKante().forEach(potk -> {
            double diff;
            if (GeoCoordinateValid.isNotDistinctCoordinateSystem(potk)) {
                result.add(this.createGeoCoordinateError((EObject)po, "Der Punkt_Objekt_Top_Kante des Punkt_Objekt: {GUID} w\u00fcrde auf mehrere GEO_Punkt mit gleichen Koordinatensystem verweisen", Map.of("GUID", po.getIdentitaet().getWert())));
                return;
            }
            GEOKanteCoordinate geoKanteCoordinate = this.calculateCoordinate((Punkt_Objekt)po, (Punkt_Objekt_TOP_Kante_AttributeGroup)potk);
            if (geoKanteCoordinate == null || EObjectExtensions.getNullableObject((Object)geoKanteCoordinate, e -> e.getCoordinate()).isEmpty()) {
                return;
            }
            GEO_Punkt relevantGeoPunkt = GeoCoordinateValid.getSameCRSGEOPunkt(potk, geoKanteCoordinate.getCRS());
            if (relevantGeoPunkt == null) {
                return;
            }
            Coordinate coordinate = geoKanteCoordinate.getCoordinate();
            Coordinate gpCoordinate = GeoPunktExtensions.getCoordinate((GEO_Punkt)relevantGeoPunkt);
            if (gpCoordinate == null) {
                result.add(this.creatErrorReport(relevantGeoPunkt));
            }
            if ((diff = coordinate.distance(gpCoordinate)) > 0.1) {
                result.add(this.createErrorReport((Punkt_Objekt)po, (Punkt_Objekt_TOP_Kante_AttributeGroup)potk, relevantGeoPunkt, diff));
            }
        }));
        return result;
    }

    private static List<Punkt_Objekt> getRelevantPOs(MultiContainer_AttributeGroup container) {
        return ((Stream)Streams.stream((Iterable)container.getPunktObjekts()).parallel()).filter(po -> po.getPunktObjektTOPKante().stream().anyMatch(potk -> EObjectExtensions.getNullableObject((Object)potk, ele -> ele.getSeitlicherAbstand().getWert()).isPresent()) || po instanceof FMA_Komponente || po instanceof PZB_Element).toList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GEOKanteCoordinate calculateCoordinate(Punkt_Objekt po, Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        try {
            BigDecimal lateralDistance = null;
            GEOKanteMetadata geoKanteMetaData = alreadyFoundMetaData.parallelStream().filter(md -> md.getGeoKante().getIDGEOArt().getValue().equals(potk.getIDTOPKante().getValue()) && md.getStart().compareTo(potk.getAbstand().getWert()) <= 0 && md.getEnd().compareTo(potk.getAbstand().getWert()) >= 0).findFirst().orElse(null);
            if (geoKanteMetaData == null) {
                geoKanteMetaData = GeoCoordinateValid.getGeoKanteMetaData(potk);
                if (geoKanteMetaData == null) {
                    return null;
                }
                alreadyFoundMetaData.add(geoKanteMetaData);
            }
            if (po instanceof PZB_Element) {
                lateralDistance = PZB_LATERAL_DISTANCE;
            } else if (po instanceof FMA_Komponente) {
                lateralDistance = FMA_LATERAL_DISTANCE;
            }
            if (lateralDistance == null) {
                return this.calculateCoordinate(geoKanteMetaData, potk);
            }
            ENUMLinksRechts side = EObjectExtensions.getNullableObject((Object)potk, point -> point.getSeitlicheLage().getWert()).orElse(null);
            if (side != null && side == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS) {
                return GeoCoordinateValid.calculateCoordinate(geoKanteMetaData, potk, lateralDistance.negate());
            }
            return GeoCoordinateValid.calculateCoordinate(geoKanteMetaData, potk, lateralDistance);
        }
        catch (Exception e) {
            return null;
        }
    }

    private GEOKanteCoordinate calculateCoordinate(GEOKanteMetadata geoKanteMetadata, Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        BigDecimal lateralDistance = this.pointObjectPositionService.getLateralDistance(potk, geoKanteMetadata);
        return GeoCoordinateValid.calculateCoordinate(geoKanteMetadata, potk, lateralDistance);
    }

    private static GEOKanteCoordinate calculateCoordinate(GEOKanteMetadata geoKanteMetadata, Punkt_Objekt_TOP_Kante_AttributeGroup potk, BigDecimal lateralDistance) {
        ENUMWirkrichtung direction = null;
        if (potk.getWirkrichtung() != null) {
            direction = potk.getWirkrichtung().getWert();
        }
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE) {
            direction = ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN;
        }
        return GeoCoordinateValid.calculateCoordinate(geoKanteMetadata, potk, lateralDistance, direction);
    }

    private static GEOKanteCoordinate calculateCoordinate(GEOKanteMetadata md, Punkt_Objekt_TOP_Kante_AttributeGroup potk, BigDecimal lateralDistance, ENUMWirkrichtung wirkrichtung) {
        BigDecimal geoLength = BigDecimal.valueOf(md.getGeometry().getLength());
        BigDecimal geoKanteLength = md.getGeoKante().getGEOKanteAllg().getGEOLaenge().getWert();
        BigDecimal localDistance = potk.getAbstand().getWert().subtract(md.getStart());
        BigDecimal scaleDistance = localDistance.doubleValue() != 0.0 ? localDistance.multiply(geoLength.divide(geoKanteLength, 5, RoundingMode.HALF_UP)) : BigDecimal.ZERO;
        SegmentPosition position = Geometries.getSegmentPosition((LineString)md.getGeometry(), (Coordinate)GeoKnotenExtensions.getCoordinate((GEO_Knoten)md.getGeoKnoten()), (BigDecimal)scaleDistance);
        LineSegment tangent = GeoKanteExtensions.getTangent((GEO_Kante)md.getGeoKante(), (SegmentPosition)position);
        GeoPosition geoPosition = GeoKanteExtensions.getCoordinate((LineSegment)tangent, (SegmentPosition)position, (BigDecimal)lateralDistance, (ENUMWirkrichtung)wirkrichtung);
        return new GEOKanteCoordinate(geoPosition, md, GeoKnotenExtensions.getCRS((GEO_Knoten)md.getGeoKnoten()));
    }

    private static GEOKanteMetadata getGeoKanteMetaData(Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        try {
            TOP_Kante topkante = potk.getIDTOPKante().getValue();
            GeoKnotenRange relevantGeoKnotenRange = GeoCoordinateValid.getRelevantGeoKnotenRange(potk);
            GEO_Kante geoKante = relevantGeoKnotenRange.getGeoKante();
            BigDecimal geoArtScalingFactor = BasisObjektExtensions.getGeoArtScalingFactor((Basis_Objekt)topkante);
            BigDecimal geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().multiply(BigDecimal.ONE.divide(geoArtScalingFactor, 5, RoundingMode.HALF_UP));
            LineString geometry = GEOKanteGeometryExtensions.defineEdgeGeometry((GEO_Kante)geoKante, (GeometryCalculationOptions)new GeometryCalculationOptions.GeometryCalculationOptionsBuilder().setChordOptions(new GeometryOptionsBuilder().setStepSize(1.0E-4).build()).build());
            List bereichObjekts = Streams.stream((Iterable)BasisAttributExtensions.getContainer((EObject)topkante).getBereichObjekt()).toList();
            return new GEOKanteMetadata(geoKante, relevantGeoKnotenRange.startDistance(), geoKanteLength, bereichObjekts, topkante, relevantGeoKnotenRange.startNode(), geometry);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    private static GeoKnotenRange getRelevantGeoKnotenRange(Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        TOP_Kante topKante = potk.getIDTOPKante().getValue();
        BigDecimal distance = potk.getAbstand().getWert();
        Iterator geoKnotenWithDistance = Streams.stream((Iterable)TopKanteExtensions.getGeoKnotenWithDistance((TOP_Kante)topKante)).iterator();
        ArrayList<GeoKnotenRange> ranges = new ArrayList<GeoKnotenRange>();
        Pair current = (Pair)geoKnotenWithDistance.next();
        while (geoKnotenWithDistance.hasNext()) {
            Pair next = (Pair)geoKnotenWithDistance.next();
            ranges.add(new GeoKnotenRange((Pair<GEO_Knoten, BigDecimal>)current, (Pair<GEO_Knoten, BigDecimal>)next));
            current = next;
        }
        return ranges.stream().filter(r -> r.contain(distance)).findFirst().orElse(null);
    }

    private static GEO_Punkt getSameCRSGEOPunkt(Punkt_Objekt_TOP_Kante_AttributeGroup potk, ENUMGEOKoordinatensystem crs) {
        return potk.getIDGEOPunktBerechnet().stream().map(e -> e.getValue()).filter(Objects::nonNull).filter(gp -> {
            ENUMGEOKoordinatensystem geoPunktCRS = EObjectExtensions.getNullableObject((Object)gp, e -> e.getGEOPunktAllg().getGEOKoordinatensystem().getWert()).orElse(null);
            return geoPunktCRS != null && geoPunktCRS.equals((Object)crs);
        }).findFirst().orElse(null);
    }

    private PlazError creatErrorReport(GEO_Punkt gp) {
        GEO_Punkt errObj = gp;
        if (gp.getGEOPunktAllg() == null) {
            errObj = gp.getGEOPunktAllg();
        } else if (gp.getGEOPunktAllg().getGKX() == null) {
            errObj = gp.getGEOPunktAllg().getGKX();
        } else if (gp.getGEOPunktAllg().getGKY() == null) {
            errObj = gp.getGEOPunktAllg().getGKY();
        }
        return this.createGeoCoordinateError((EObject)errObj, "GEO_Punkt: {GUID} fehlt Koordinate", Map.of(gp.getIdentitaet().getWert(), "GUID"));
    }

    private PlazError createErrorReport(Punkt_Objekt po, Punkt_Objekt_TOP_Kante_AttributeGroup potk, GEO_Punkt gp, double diff) {
        ID_GEO_Punkt_ohne_Proxy_TypeClass errorObject = potk.getIDGEOPunktBerechnet().stream().filter(idgp -> idgp.getValue().equals(gp)).findFirst().orElse(null);
        if (errorObject == null) {
            throw new IllegalArgumentException(String.format("GEO_Punkt: %s geh\u00f6rt nicht zu Punkt_Objekt: %s", gp.getIdentitaet().getWert(), po.getIdentitaet().getWert()));
        }
        return this.createGeoCoordinateError((EObject)errorObject, "Die Koordinaten des referenzierten GEO_Punkt: {GEO_PUNKT_ID} weichen mehr als {TOLERANT} cm von der topologisch definierten Position ab. (Differenz: {DIFF} cm)", Map.of("GEO_PUNKT_ID", errorObject.getWert(), "TOLERANT", new DecimalFormat("0.00").format(10.0), "DIFF", new DecimalFormat("0.00").format(diff * 100.0)));
    }

    private PlazError createGeoCoordinateError(EObject object, String message, Map<String, String> data) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setObject(object);
        plazError.setSeverity(ValidationSeverity.WARNING);
        plazError.setType(this.checkType());
        plazError.setMessage(StringSubstitutor.replace((Object)message, data, (String)"{", (String)"}"));
        return plazError;
    }

    @Override
    public String checkType() {
        return "Verortungsvergleich";
    }

    @Override
    public String getDescription() {
        return "Die topologische Verortung der berechneten Geo-Koordinaten sind plausibilisiert";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die topologische Verortung des Punkt-Objekts stimmt nicht mit den berechneten Geo-Koordinaten \u00fcberein.";
    }

    private PlazError createProcessingWarning() {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setType(this.checkType());
        plazError.setSeverity(ValidationSeverity.WARNING);
        plazError.setMessage("Die Pr\u00fcfung auf ID_GEO_Punkt_Berechnen is noch nicht beenden");
        return plazError;
    }

    public static boolean isNotDistinctCoordinateSystem(Punkt_Objekt_TOP_Kante_AttributeGroup potk) {
        List<GEO_Punkt> givenGeoPunkts = potk.getIDGEOPunktBerechnet().stream().map(gp -> gp.getValue()).filter(Objects::nonNull).toList();
        if (givenGeoPunkts.isEmpty()) {
            return false;
        }
        Iterable notDistinctBy = IterableExtensions.notDistinctBy(givenGeoPunkts, gp -> EObjectExtensions.getNullableObject((Object)gp, e -> e.getGEOPunktAllg().getGEOKoordinatensystem().getWert()));
        return notDistinctBy.iterator().hasNext();
    }

    private record GeoKnotenRange(Pair<GEO_Knoten, BigDecimal> start, Pair<GEO_Knoten, BigDecimal> end) {
        public boolean contain(BigDecimal distance) {
            return ((BigDecimal)this.start.getValue()).compareTo(distance) <= 0 && ((BigDecimal)this.end.getValue()).compareTo(distance) >= 0;
        }

        public GEO_Knoten startNode() {
            return (GEO_Knoten)this.start.getKey();
        }

        public BigDecimal startDistance() {
            return (BigDecimal)this.start.getValue();
        }

        public GEO_Knoten endNode() {
            return (GEO_Knoten)this.start.getKey();
        }

        public GEO_Kante getGeoKante() {
            GEO_Kante geoKante = Streams.stream((Iterable)GeoKnotenExtensions.getGeoKanten((GEO_Knoten)this.startNode())).filter(edge -> Streams.stream((Iterable)GeoKnotenExtensions.getGeoKanten((GEO_Knoten)this.endNode())).anyMatch(e -> e == edge)).findFirst().orElse(null);
            if (geoKante == null) {
                throw new IllegalArgumentException();
            }
            return geoKante;
        }
    }
}

