/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.set.basis.Lists;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class IterableExtensions {
    public static <T> List<T> toUniqueList(Iterable<T> iterator) {
        LinkedList result = new LinkedList();
        Lists.addAllNew(result, (Collection)org.eclipse.xtext.xbase.lib.IterableExtensions.toList(iterator));
        return result;
    }

    public static <T, U> Iterable<Iterable<T>> consecutiveGroups(Iterable<T> iterable, Function<T, U> condition) {
        Object currentValue = null;
        ArrayList<T> currentList = null;
        ArrayList<Iterable<T>> result = new ArrayList<Iterable<T>>();
        for (T value : iterable) {
            ArrayList<T> _arrayList;
            U groupValue = condition.apply(value);
            boolean _equals = groupValue.equals(currentValue);
            if (_equals) {
                currentList.add(value);
                continue;
            }
            currentList = _arrayList = new ArrayList<T>();
            currentList.add(value);
            result.add(currentList);
            currentValue = groupValue;
        }
        return result;
    }

    public static <T, U> Iterable<T> distinctBy(Iterable<T> iterable, Functions.Function1<? super T, ? extends U> predicate) {
        HashSet knownSet = CollectionLiterals.newHashSet();
        Functions.Function1 _function = it -> knownSet.add(predicate.apply(it));
        return org.eclipse.xtext.xbase.lib.IterableExtensions.filter(iterable, (Functions.Function1)_function);
    }

    public static <T, U> Iterable<T> notDistinctBy(Iterable<T> iterable, Functions.Function1<? super T, ? extends U> predicate) {
        HashSet knownSet = CollectionLiterals.newHashSet();
        Functions.Function1 _function = it -> {
            boolean _add = knownSet.add(predicate.apply(it));
            return !_add;
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.filter(iterable, (Functions.Function1)_function);
    }

    public static <T, U> Iterable<U> mapIndex(Iterable<T> iterable, Functions.Function2<? super T, ? super Integer, ? extends U> function) {
        ArrayList result = CollectionLiterals.newArrayList();
        Procedures.Procedure2 _function = (it, index) -> result.add(function.apply(it, index));
        org.eclipse.xtext.xbase.lib.IterableExtensions.forEach(iterable, (Procedures.Procedure2)_function);
        return result;
    }

    public static <T> T getFirstOrNull(Iterable<T> iterable) {
        boolean _isNullOrEmpty = org.eclipse.xtext.xbase.lib.IterableExtensions.isNullOrEmpty(iterable);
        if (_isNullOrEmpty) {
            return null;
        }
        return (T)((Object[])Conversions.unwrapArray(iterable, Object.class))[0];
    }
}

