/**
 * @licstart The following is the entire license notice for the
 * JavaScript code in this page
 *
 * Copyright 2023 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * JavaScript code in this page
 */(()=>{"use strict";var e=[,(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GenericCom=void 0;var n=i(2),s=i(42),o=i(43),a=i(44),r=i(46);t.GenericCom={};class l extends s.BasePreferences{async _writeToStorage(e){localStorage.setItem("pdfjs.preferences",JSON.stringify(e))}async _readFromStorage(e){return JSON.parse(localStorage.getItem("pdfjs.preferences"))}}class d extends n.DefaultExternalServices{static createDownloadManager(){return new o.DownloadManager}static createPreferences(){return new l}static createL10n({locale:e="en-US"}){return new a.GenericL10n(e)}static createScripting({sandboxBundleSrc:e}){return new r.GenericScripting(e)}}n.PDFViewerApplication.externalServices=d},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFViewerApplication=t.PDFPrintServiceFactory=t.DefaultExternalServices=void 0;var n=i(3),s=i(4),o=i(5),a=i(6),r=i(7),l=i(8),d=i(9),h=i(10),c=i(11),u=i(12),p=i(14),g=i(16),m=i(17),f=i(18),v=i(20),w=i(21),b=i(22),_=i(23),y=i(24),P=i(25),E=i(26),S=i(27),C=i(29),L=i(39),T=i(40),M=i(41);const I=1e3,A=-1,x=1,D={AUTOMATIC:0,LIGHT:1,DARK:2};class N{constructor(){throw new Error("Cannot initialize DefaultExternalServices.")}static updateFindControlState(e){}static updateFindMatchesCount(e){}static initPassiveLoading(e){}static reportTelemetry(e){}static createDownloadManager(){throw new Error("Not implemented: createDownloadManager")}static createPreferences(){throw new Error("Not implemented: createPreferences")}static createL10n(e){throw new Error("Not implemented: createL10n")}static createScripting(e){throw new Error("Not implemented: createScripting")}static get supportsPinchToZoom(){return(0,s.shadow)(this,"supportsPinchToZoom",!0)}static get supportsIntegratedFind(){return(0,s.shadow)(this,"supportsIntegratedFind",!1)}static get supportsDocumentFonts(){return(0,s.shadow)(this,"supportsDocumentFonts",!0)}static get supportedMouseWheelZoomModifierKeys(){return(0,s.shadow)(this,"supportedMouseWheelZoomModifierKeys",{ctrlKey:!0,metaKey:!0})}static get isInAutomation(){return(0,s.shadow)(this,"isInAutomation",!1)}static updateEditorStates(e){throw new Error("Not implemented: updateEditorStates")}static get canvasMaxAreaInBytes(){return(0,s.shadow)(this,"canvasMaxAreaInBytes",-1)}static getNimbusExperimentData(){return(0,s.shadow)(this,"getNimbusExperimentData",Promise.resolve(null))}}t.DefaultExternalServices=N;const B={initialBookmark:document.location.hash.substring(1),_initializedCapability:new s.PromiseCapability,appConfig:null,pdfDocument:null,pdfLoadingTask:null,printService:null,pdfViewer:null,pdfThumbnailViewer:null,pdfRenderingQueue:null,pdfPresentationMode:null,pdfDocumentProperties:null,pdfLinkService:null,pdfHistory:null,pdfSidebar:null,pdfOutlineViewer:null,pdfAttachmentViewer:null,pdfLayerViewer:null,pdfCursorTools:null,pdfScriptingManager:null,store:null,downloadManager:null,overlayManager:null,preferences:null,toolbar:null,secondaryToolbar:null,eventBus:null,l10n:null,annotationEditorParams:null,isInitialViewSet:!1,downloadComplete:!1,isViewerEmbedded:window.parent!==window,url:"",baseUrl:"",_downloadUrl:"",externalServices:N,_boundEvents:Object.create(null),documentInfo:null,metadata:null,_contentDispositionFilename:null,_contentLength:null,_saveInProgress:!1,_wheelUnusedTicks:0,_wheelUnusedFactor:1,_touchUnusedTicks:0,_touchUnusedFactor:1,_PDFBug:null,_hasAnnotationEditors:!1,_title:document.title,_printAnnotationStoragePromise:null,_touchInfo:null,_isCtrlKeyDown:!1,_nimbusDataPromise:null,async initialize(e){this.preferences=this.externalServices.createPreferences(),this.appConfig=e,await this._initializeOptions(),this._forceCssTheme(),await this._initializeL10n(),this.isViewerEmbedded&&o.AppOptions.get("externalLinkTarget")===r.LinkTarget.NONE&&o.AppOptions.set("externalLinkTarget",r.LinkTarget.TOP),await this._initializeViewerComponents(),this.bindEvents(),this.bindWindowEvents();const t=e.appContainer||document.documentElement;this.l10n.translate(t).then((()=>{this.eventBus.dispatch("localized",{source:this})})),this._initializedCapability.resolve()},async _initializeOptions(){if(o.AppOptions.get("disablePreferences"))o.AppOptions.get("pdfBugEnabled")&&await this._parseHashParams();else{o.AppOptions._hasUserOptions()&&console.warn('_initializeOptions: The Preferences may override manually set AppOptions; please use the "disablePreferences"-option in order to prevent that.');try{o.AppOptions.setAll(await this.preferences.getAll())}catch(e){console.error(`_initializeOptions: "${e.message}".`)}o.AppOptions.get("pdfBugEnabled")&&await this._parseHashParams()}},async _parseHashParams(){const e=document.location.hash.substring(1);if(!e)return;const{mainContainer:t,viewerContainer:i}=this.appConfig,a=(0,n.parseQueryString)(e);if("true"===a.get("disableworker"))try{await async function(){s.GlobalWorkerOptions.workerSrc||=o.AppOptions.get("workerSrc"),await(0,s.loadScript)(s.PDFWorker.workerSrc)}()}catch(e){console.error(`_parseHashParams: "${e.message}".`)}if(a.has("disablerange")&&o.AppOptions.set("disableRange","true"===a.get("disablerange")),a.has("disablestream")&&o.AppOptions.set("disableStream","true"===a.get("disablestream")),a.has("disableautofetch")&&o.AppOptions.set("disableAutoFetch","true"===a.get("disableautofetch")),a.has("disablefontface")&&o.AppOptions.set("disableFontFace","true"===a.get("disablefontface")),a.has("disablehistory")&&o.AppOptions.set("disableHistory","true"===a.get("disablehistory")),a.has("verbosity")&&o.AppOptions.set("verbosity",0|a.get("verbosity")),a.has("textlayer"))switch(a.get("textlayer")){case"off":o.AppOptions.set("textLayerMode",n.TextLayerMode.DISABLE);break;case"visible":case"shadow":case"hover":i.classList.add(`textLayer-${a.get("textlayer")}`);try{await O(this),this._PDFBug.loadCSS()}catch(e){console.error(`_parseHashParams: "${e.message}".`)}}if(a.has("pdfbug")){o.AppOptions.set("pdfBug",!0),o.AppOptions.set("fontExtraProperties",!0);const e=a.get("pdfbug").split(",");try{await O(this),this._PDFBug.init(t,e)}catch(e){console.error(`_parseHashParams: "${e.message}".`)}}a.has("locale")&&o.AppOptions.set("locale",a.get("locale"))},async _initializeL10n(){this.l10n=this.externalServices.createL10n({locale:o.AppOptions.get("locale")});const e=await this.l10n.getDirection();document.getElementsByTagName("html")[0].dir=e},_forceCssTheme(){const e=o.AppOptions.get("viewerCssTheme");if(e!==D.AUTOMATIC&&Object.values(D).includes(e))try{const t=document.styleSheets[0],i=t?.cssRules||[];for(let n=0,s=i.length;n<s;n++){const s=i[n];if(s instanceof CSSMediaRule&&"(prefers-color-scheme: dark)"===s.media?.[0]){if(e===D.LIGHT)return void t.deleteRule(n);const i=/^@media \(prefers-color-scheme: dark\) {\n\s*([\w\s-.,:;/\\{}()]+)\n}$/.exec(s.cssText);return void(i?.[1]&&(t.deleteRule(n),t.insertRule(i[1],n)))}}}catch(e){console.error(`_forceCssTheme: "${e?.message}".`)}},async _initializeViewerComponents(){const{appConfig:e,externalServices:t,l10n:i}=this,M=t.isInAutomation?new a.AutomationEventBus:new a.EventBus;this.eventBus=M,this.overlayManager=new h.OverlayManager;const I=new y.PDFRenderingQueue;I.onIdle=this._cleanup.bind(this),this.pdfRenderingQueue=I;const A=new r.PDFLinkService({eventBus:M,externalLinkTarget:o.AppOptions.get("externalLinkTarget"),externalLinkRel:o.AppOptions.get("externalLinkRel"),ignoreDestinationZoom:o.AppOptions.get("ignoreDestinationZoom")});this.pdfLinkService=A;const x=t.createDownloadManager();this.downloadManager=x;const D=new f.PDFFindController({linkService:A,eventBus:M,updateMatchesCountOnProgress:!0});this.findController=D;const N=new P.PDFScriptingManager({eventBus:M,sandboxBundleSrc:o.AppOptions.get("sandboxBundleSrc"),externalServices:t,docProperties:this._scriptingDocProperties.bind(this)});this.pdfScriptingManager=N;const B=e.mainContainer,k=e.viewerContainer,O=o.AppOptions.get("annotationEditorMode"),V=o.AppOptions.get("isOffscreenCanvasSupported")&&s.FeatureTest.isOffscreenCanvasSupported,R=o.AppOptions.get("forcePageColors")||window.matchMedia("(forced-colors: active)").matches?{background:o.AppOptions.get("pageColorsBackground"),foreground:o.AppOptions.get("pageColorsForeground")}:null,F=e.altTextDialog?new l.AltTextManager(e.altTextDialog,B,this.overlayManager,M):null,U=new C.PDFViewer({container:B,viewer:k,eventBus:M,renderingQueue:I,linkService:A,downloadManager:x,altTextManager:F,findController:D,scriptingManager:o.AppOptions.get("enableScripting")&&N,l10n:i,textLayerMode:o.AppOptions.get("textLayerMode"),annotationMode:o.AppOptions.get("annotationMode"),annotationEditorMode:O,imageResourcesPath:o.AppOptions.get("imageResourcesPath"),enablePrintAutoRotate:o.AppOptions.get("enablePrintAutoRotate"),isOffscreenCanvasSupported:V,maxCanvasPixels:o.AppOptions.get("maxCanvasPixels"),enablePermissions:o.AppOptions.get("enablePermissions"),pageColors:R});if(this.pdfViewer=U,I.setViewer(U),A.setViewer(U),N.setViewer(U),e.sidebar?.thumbnailView&&(this.pdfThumbnailViewer=new S.PDFThumbnailViewer({container:e.sidebar.thumbnailView,eventBus:M,renderingQueue:I,linkService:A,l10n:i,pageColors:R}),I.setThumbnailViewer(this.pdfThumbnailViewer)),this.isViewerEmbedded||o.AppOptions.get("disableHistory")||(this.pdfHistory=new v.PDFHistory({linkService:A,eventBus:M}),A.setHistory(this.pdfHistory)),!this.supportsIntegratedFind&&e.findBar&&(this.findBar=new m.PDFFindBar(e.findBar,M,i)),e.annotationEditorParams)if(O!==s.AnnotationEditorType.DISABLE)o.AppOptions.get("enableStampEditor")&&V&&e.toolbar?.editorStampButton?.classList.remove("hidden"),this.annotationEditorParams=new d.AnnotationEditorParams(e.annotationEditorParams,M);else for(const e of["editorModeButtons","editorModeSeparator"])document.getElementById(e)?.classList.add("hidden");e.documentProperties&&(this.pdfDocumentProperties=new g.PDFDocumentProperties(e.documentProperties,this.overlayManager,M,i,(()=>this._docFilename))),e.secondaryToolbar?.cursorHandToolButton&&(this.pdfCursorTools=new p.PDFCursorTools({container:B,eventBus:M,cursorToolOnLoad:o.AppOptions.get("cursorToolOnLoad")})),e.toolbar&&(this.toolbar=new T.Toolbar(e.toolbar,M,i)),e.secondaryToolbar&&(this.secondaryToolbar=new L.SecondaryToolbar(e.secondaryToolbar,M)),this.supportsFullscreen&&e.secondaryToolbar?.presentationModeButton&&(this.pdfPresentationMode=new _.PDFPresentationMode({container:B,pdfViewer:U,eventBus:M})),e.passwordOverlay&&(this.passwordPrompt=new c.PasswordPrompt(e.passwordOverlay,this.overlayManager,i,this.isViewerEmbedded)),e.sidebar?.outlineView&&(this.pdfOutlineViewer=new b.PDFOutlineViewer({container:e.sidebar.outlineView,eventBus:M,linkService:A,downloadManager:x})),e.sidebar?.attachmentsView&&(this.pdfAttachmentViewer=new u.PDFAttachmentViewer({container:e.sidebar.attachmentsView,eventBus:M,downloadManager:x})),e.sidebar?.layersView&&(this.pdfLayerViewer=new w.PDFLayerViewer({container:e.sidebar.layersView,eventBus:M,l10n:i})),e.sidebar&&(this.pdfSidebar=new E.PDFSidebar({elements:e.sidebar,eventBus:M,l10n:i}),this.pdfSidebar.onToggled=this.forceRendering.bind(this),this.pdfSidebar.onUpdateThumbnails=()=>{for(const e of U.getCachedPageViews())e.renderingState===n.RenderingStates.FINISHED&&this.pdfThumbnailViewer.getThumbnail(e.id-1)?.setImage(e);this.pdfThumbnailViewer.scrollThumbnailIntoView(U.currentPageNumber)})},async run(e){await this.initialize(e);const{appConfig:t,eventBus:i}=this;let s;const a=document.location.search.substring(1);s=(0,n.parseQueryString)(a).get("file")??o.AppOptions.get("defaultUrl"),k(s);const r=t.openFileInput;r.value=null,r.addEventListener("change",(function(e){const{files:t}=e.target;t&&0!==t.length&&i.dispatch("fileinputchange",{source:this,fileInput:e.target})})),t.mainContainer.addEventListener("dragover",(function(e){e.preventDefault(),e.dataTransfer.dropEffect="copy"===e.dataTransfer.effectAllowed?"copy":"move"})),t.mainContainer.addEventListener("drop",(function(e){e.preventDefault();const{files:t}=e.dataTransfer;t&&0!==t.length&&i.dispatch("fileinputchange",{source:this,fileInput:e.dataTransfer})})),this.supportsDocumentFonts||(o.AppOptions.set("disableFontFace",!0),this.l10n.get("web_fonts_disabled").then((e=>{console.warn(e)}))),this.supportsPrinting||(t.toolbar?.print?.classList.add("hidden"),t.secondaryToolbar?.printButton.classList.add("hidden")),this.supportsFullscreen||t.secondaryToolbar?.presentationModeButton.classList.add("hidden"),this.supportsIntegratedFind&&t.toolbar?.viewFind?.classList.add("hidden"),t.mainContainer.addEventListener("transitionend",(function(e){e.target===this&&i.dispatch("resize",{source:this})}),!0),s?this.open({url:s}):this._hideViewBookmark()},get initialized(){return this._initializedCapability.settled},get initializedPromise(){return this._initializedCapability.promise},zoomIn(e,t){this.pdfViewer.isInPresentationMode||this.pdfViewer.increaseScale({drawingDelay:o.AppOptions.get("defaultZoomDelay"),steps:e,scaleFactor:t})},zoomOut(e,t){this.pdfViewer.isInPresentationMode||this.pdfViewer.decreaseScale({drawingDelay:o.AppOptions.get("defaultZoomDelay"),steps:e,scaleFactor:t})},zoomReset(){this.pdfViewer.isInPresentationMode||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0},get page(){return this.pdfViewer.currentPageNumber},set page(e){this.pdfViewer.currentPageNumber=e},get supportsPrinting(){return ke.instance.supportsPrinting},get supportsFullscreen(){return(0,s.shadow)(this,"supportsFullscreen",document.fullscreenEnabled)},get supportsPinchToZoom(){return this.externalServices.supportsPinchToZoom},get supportsIntegratedFind(){return this.externalServices.supportsIntegratedFind},get supportsDocumentFonts(){return this.externalServices.supportsDocumentFonts},get loadingBar(){const e=document.getElementById("loadingBar"),t=e?new n.ProgressBar(e):null;return(0,s.shadow)(this,"loadingBar",t)},get supportedMouseWheelZoomModifierKeys(){return this.externalServices.supportedMouseWheelZoomModifierKeys},initPassiveLoading(e){throw new Error("Not implemented: initPassiveLoading")},setTitleUsingUrl(e="",t=null){this.url=e,this.baseUrl=e.split("#")[0],t&&(this._downloadUrl=t===e?this.baseUrl:t.split("#")[0]),(0,s.isDataScheme)(e)&&this._hideViewBookmark();let i=(0,s.getPdfFilenameFromUrl)(e,"");if(!i)try{i=decodeURIComponent((0,s.getFilenameFromUrl)(e))||e}catch{i=e}this.setTitle(i)},setTitle(e=this._title){if(this._title=e,this.isViewerEmbedded)return;const t=this._hasAnnotationEditors&&!this.pdfRenderingQueue.printing;document.title=`${t?"* ":""}${e}`},get _docFilename(){return this._contentDispositionFilename||(0,s.getPdfFilenameFromUrl)(this.url)},_hideViewBookmark(){const{secondaryToolbar:e}=this.appConfig;e?.viewBookmarkButton.classList.add("hidden"),e?.presentationModeButton.classList.contains("hidden")&&document.getElementById("viewBookmarkSeparator")?.classList.add("hidden")},async close(){if(this._unblockDocumentLoadEvent(),this._hideViewBookmark(),!this.pdfLoadingTask)return;if(this.pdfDocument?.annotationStorage.size>0&&this._annotationStorageModified)try{await this.save()}catch{}const e=[];e.push(this.pdfLoadingTask.destroy()),this.pdfLoadingTask=null,this.pdfDocument&&(this.pdfDocument=null,this.pdfThumbnailViewer?.setDocument(null),this.pdfViewer.setDocument(null),this.pdfLinkService.setDocument(null),this.pdfDocumentProperties?.setDocument(null)),this.pdfLinkService.externalLinkEnabled=!0,this.store=null,this.isInitialViewSet=!1,this.downloadComplete=!1,this.url="",this.baseUrl="",this._downloadUrl="",this.documentInfo=null,this.metadata=null,this._contentDispositionFilename=null,this._contentLength=null,this._saveInProgress=!1,this._hasAnnotationEditors=!1,e.push(this.pdfScriptingManager.destroyPromise,this.passwordPrompt.close()),this.setTitle(),this.pdfSidebar?.reset(),this.pdfOutlineViewer?.reset(),this.pdfAttachmentViewer?.reset(),this.pdfLayerViewer?.reset(),this.pdfHistory?.reset(),this.findBar?.reset(),this.toolbar?.reset(),this.secondaryToolbar?.reset(),this._PDFBug?.cleanup(),await Promise.all(e)},async open(e){let t=!1;"string"==typeof e?(e={url:e},t=!0):e?.byteLength&&(e={data:e},t=!0),t&&console.error("The `PDFViewerApplication.open` signature was updated, please use an object instead."),this.pdfLoadingTask&&await this.close();const i=o.AppOptions.getAll(o.OptionKind.WORKER);Object.assign(s.GlobalWorkerOptions,i),e.url&&this.setTitleUsingUrl(e.originalUrl||e.url,e.url);const n=o.AppOptions.getAll(o.OptionKind.API),a={canvasMaxAreaInBytes:this.externalServices.canvasMaxAreaInBytes,...n,...e},r=(0,s.getDocument)(a);return this.pdfLoadingTask=r,r.onPassword=(e,t)=>{this.isViewerEmbedded&&this._unblockDocumentLoadEvent(),this.pdfLinkService.externalLinkEnabled=!1,this.passwordPrompt.setUpdateCallback(e,t),this.passwordPrompt.open()},r.onProgress=({loaded:e,total:t})=>{this.progress(e/t)},r.promise.then((e=>{this.load(e)}),(e=>{if(r!==this.pdfLoadingTask)return;let t="loading_error";return e instanceof s.InvalidPDFException?t="invalid_file_error":e instanceof s.MissingPDFException?t="missing_file_error":e instanceof s.UnexpectedResponseException&&(t="unexpected_response_error"),this.l10n.get(t).then((t=>{throw this._documentError(t,{message:e?.message}),e}))}))},_ensureDownloadComplete(){if(!this.pdfDocument||!this.downloadComplete)throw new Error("PDF document not downloaded.")},async download(e={}){const t=this._downloadUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.getData(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch{await this.downloadManager.downloadUrl(t,i,e)}},async save(e={}){if(this._saveInProgress)return;this._saveInProgress=!0,await this.pdfScriptingManager.dispatchWillSave();const t=this._downloadUrl,i=this._docFilename;try{this._ensureDownloadComplete();const n=await this.pdfDocument.saveDocument(),s=new Blob([n],{type:"application/pdf"});await this.downloadManager.download(s,t,i,e)}catch(t){console.error(`Error when saving the document: ${t.message}`),await this.download(e)}finally{await this.pdfScriptingManager.dispatchDidSave(),this._saveInProgress=!1}this._hasAnnotationEditors&&this.externalServices.reportTelemetry({type:"editing",data:{type:"save"}})},downloadOrSave(e={}){this.pdfDocument?.annotationStorage.size>0?this.save(e):this.download(e)},openInExternalApp(){this.downloadOrSave({openInExternalApp:!0})},_documentError(e,t=null){this._unblockDocumentLoadEvent(),this._otherError(e,t),this.eventBus.dispatch("documenterror",{source:this,message:e,reason:t?.message??null})},_otherError(e,t=null){const i=[`PDF.js v${s.version||"?"} (build: ${s.build||"?"})`];t&&(i.push(`Message: ${t.message}`),t.stack?i.push(`Stack: ${t.stack}`):(t.filename&&i.push(`File: ${t.filename}`),t.lineNumber&&i.push(`Line: ${t.lineNumber}`))),console.error(`${e}\n\n${i.join("\n")}`)},progress(e){if(!this.loadingBar||this.downloadComplete)return;const t=Math.round(100*e);t<=this.loadingBar.percent||(this.loadingBar.percent=t,(this.pdfDocument?.loadingParams.disableAutoFetch??o.AppOptions.get("disableAutoFetch"))&&this.loadingBar.setDisableAutoFetch())},load(e){this.pdfDocument=e,e.getDownloadInfo().then((({length:e})=>{this._contentLength=e,this.downloadComplete=!0,this.loadingBar?.hide(),r.then((()=>{this.eventBus.dispatch("documentloaded",{source:this})}))}));const t=e.getPageLayout().catch((()=>{})),i=e.getPageMode().catch((()=>{})),s=e.getOpenAction().catch((()=>{}));this.toolbar?.setPagesCount(e.numPages,!1),this.secondaryToolbar?.setPagesCount(e.numPages),this.pdfLinkService.setDocument(e),this.pdfDocumentProperties?.setDocument(e);const a=this.pdfViewer;a.setDocument(e);const{firstPagePromise:r,onePageRendered:l,pagesPromise:d}=a;this.pdfThumbnailViewer?.setDocument(e);const h=(this.store=new M.ViewHistory(e.fingerprints[0])).getMultiple({page:null,zoom:n.DEFAULT_SCALE_VALUE,scrollLeft:"0",scrollTop:"0",rotation:null,sidebarView:n.SidebarView.UNKNOWN,scrollMode:n.ScrollMode.UNKNOWN,spreadMode:n.SpreadMode.UNKNOWN}).catch((()=>{}));r.then((r=>{this.loadingBar?.setWidth(this.appConfig.viewerContainer),this._initializeAnnotationStorageCallbacks(e),Promise.all([n.animationStarted,h,t,i,s]).then((async([t,i,s,r,l])=>{const h=o.AppOptions.get("viewOnLoad");this._initializePdfHistory({fingerprint:e.fingerprints[0],viewOnLoad:h,initialDest:l?.dest});const c=this.initialBookmark,u=o.AppOptions.get("defaultZoomValue");let p=u?`zoom=${u}`:null,g=null,m=o.AppOptions.get("sidebarViewOnLoad"),f=o.AppOptions.get("scrollModeOnLoad"),v=o.AppOptions.get("spreadModeOnLoad");if(i?.page&&h!==x&&(p=`page=${i.page}&zoom=${u||i.zoom},${i.scrollLeft},${i.scrollTop}`,g=parseInt(i.rotation,10),m===n.SidebarView.UNKNOWN&&(m=0|i.sidebarView),f===n.ScrollMode.UNKNOWN&&(f=0|i.scrollMode),v===n.SpreadMode.UNKNOWN&&(v=0|i.spreadMode)),r&&m===n.SidebarView.UNKNOWN&&(m=(0,n.apiPageModeToSidebarView)(r)),s&&f===n.ScrollMode.UNKNOWN&&v===n.SpreadMode.UNKNOWN){v=(0,n.apiPageLayoutToViewerModes)(s).spreadMode}this.setInitialView(p,{rotation:g,sidebarView:m,scrollMode:f,spreadMode:v}),this.eventBus.dispatch("documentinit",{source:this}),this.isViewerEmbedded||a.focus(),await Promise.race([d,new Promise((e=>{setTimeout(e,1e4)}))]),(c||p)&&(a.hasEqualPageSizes||(this.initialBookmark=c,a.currentScaleValue=a.currentScaleValue,this.setInitialView(p)))})).catch((()=>{this.setInitialView()})).then((function(){a.update()}))})),d.then((()=>{this._unblockDocumentLoadEvent(),this._initializeAutoPrint(e,s)}),(e=>{this.l10n.get("loading_error").then((t=>{this._documentError(t,{message:e?.message})}))})),l.then((t=>{this.externalServices.reportTelemetry({type:"pageInfo",timestamp:t.timestamp}),this.pdfOutlineViewer&&e.getOutline().then((t=>{e===this.pdfDocument&&this.pdfOutlineViewer.render({outline:t,pdfDocument:e})})),this.pdfAttachmentViewer&&e.getAttachments().then((t=>{e===this.pdfDocument&&this.pdfAttachmentViewer.render({attachments:t})})),this.pdfLayerViewer&&a.optionalContentConfigPromise.then((t=>{e===this.pdfDocument&&this.pdfLayerViewer.render({optionalContentConfig:t,pdfDocument:e})}))})),this._initializePageLabels(e),this._initializeMetadata(e)},async _scriptingDocProperties(e){return(this.documentInfo||(await new Promise((e=>{this.eventBus._on("metadataloaded",e,{once:!0})})),e===this.pdfDocument))&&(this._contentLength||(await new Promise((e=>{this.eventBus._on("documentloaded",e,{once:!0})})),e===this.pdfDocument))?{...this.documentInfo,baseURL:this.baseUrl,filesize:this._contentLength,filename:this._docFilename,metadata:this.metadata?.getRaw(),authors:this.metadata?.get("dc:creator"),numPages:this.pagesCount,URL:this.url}:null},async _initializeAutoPrint(e,t){const[i,s]=await Promise.all([t,this.pdfViewer.enableScripting?null:e.getJSActions()]);if(e!==this.pdfDocument)return;let o="Print"===i?.action;if(s){console.warn("Warning: JavaScript support is not enabled");for(const e in s){if(o)break;switch(e){case"WillClose":case"WillSave":case"DidSave":case"WillPrint":case"DidPrint":continue}o=s[e].some((e=>n.AutoPrintRegExp.test(e)))}}o&&this.triggerPrinting()},async _initializeMetadata(e){const{info:t,metadata:i,contentDispositionFilename:n,contentLength:o}=await e.getMetadata();if(e!==this.pdfDocument)return;this.documentInfo=t,this.metadata=i,this._contentDispositionFilename??=n,this._contentLength??=o,console.log(`PDF ${e.fingerprints[0]} [${t.PDFFormatVersion} ${(t.Producer||"-").trim()} / ${(t.Creator||"-").trim()}] (PDF.js: ${s.version||"?"} [${s.build||"?"}])`);let a=t.Title;const r=i?.get("dc:title");r&&("Untitled"===r||/[\uFFF0-\uFFFF]/g.test(r)||(a=r)),a?this.setTitle(`${a} - ${this._contentDispositionFilename||this._title}`):this._contentDispositionFilename&&this.setTitle(this._contentDispositionFilename),!t.IsXFAPresent||t.IsAcroFormPresent||e.isPureXfa?!t.IsAcroFormPresent&&!t.IsXFAPresent||this.pdfViewer.renderForms||console.warn("Warning: Interactive form support is not enabled"):e.loadingParams.enableXfa?console.warn("Warning: XFA Foreground documents are not supported"):console.warn("Warning: XFA support is not enabled"),t.IsSignaturesPresent&&console.warn("Warning: Digital signatures validation is not supported"),this.eventBus.dispatch("metadataloaded",{source:this})},async _initializePageLabels(e){const t=await e.getPageLabels();if(e!==this.pdfDocument)return;if(!t||o.AppOptions.get("disablePageLabels"))return;const i=t.length;let n=0,s=0;for(let e=0;e<i;e++){const i=t[e];if(i===(e+1).toString())n++;else{if(""!==i)break;s++}}if(n>=i||s>=i)return;const{pdfViewer:a,pdfThumbnailViewer:r,toolbar:l}=this;a.setPageLabels(t),r?.setPageLabels(t),l?.setPagesCount(i,!0),l?.setPageNumber(a.currentPageNumber,a.currentPageLabel)},_initializePdfHistory({fingerprint:e,viewOnLoad:t,initialDest:i=null}){this.pdfHistory&&(this.pdfHistory.initialize({fingerprint:e,resetHistory:t===x,updateUrl:o.AppOptions.get("historyUpdateUrl")}),this.pdfHistory.initialBookmark&&(this.initialBookmark=this.pdfHistory.initialBookmark,this.initialRotation=this.pdfHistory.initialRotation),i&&!this.initialBookmark&&t===A&&(this.initialBookmark=JSON.stringify(i),this.pdfHistory.push({explicitDest:i,pageNumber:null})))},_initializeAnnotationStorageCallbacks(e){if(e!==this.pdfDocument)return;const{annotationStorage:t}=e;t.onSetModified=()=>{window.addEventListener("beforeunload",Be),this._annotationStorageModified=!0},t.onResetModified=()=>{window.removeEventListener("beforeunload",Be),delete this._annotationStorageModified},t.onAnnotationEditor=e=>{this._hasAnnotationEditors=!!e,this.setTitle(),e&&this.externalServices.reportTelemetry({type:"editing",data:{type:e}})}},setInitialView(e,{rotation:t,sidebarView:i,scrollMode:s,spreadMode:o}={}){const a=e=>{(0,n.isValidRotation)(e)&&(this.pdfViewer.pagesRotation=e)};this.isInitialViewSet=!0,this.pdfSidebar?.setInitialView(i),((e,t)=>{(0,n.isValidScrollMode)(e)&&(this.pdfViewer.scrollMode=e),(0,n.isValidSpreadMode)(t)&&(this.pdfViewer.spreadMode=t)})(s,o),this.initialBookmark?(a(this.initialRotation),delete this.initialRotation,this.pdfLinkService.setHash(this.initialBookmark),this.initialBookmark=null):e&&(a(t),this.pdfLinkService.setHash(e)),this.toolbar?.setPageNumber(this.pdfViewer.currentPageNumber,this.pdfViewer.currentPageLabel),this.secondaryToolbar?.setPageNumber(this.pdfViewer.currentPageNumber),this.pdfViewer.currentScaleValue||(this.pdfViewer.currentScaleValue=n.DEFAULT_SCALE_VALUE)},_cleanup(){this.pdfDocument&&(this.pdfViewer.cleanup(),this.pdfThumbnailViewer?.cleanup(),this.pdfDocument.cleanup())},forceRendering(){this.pdfRenderingQueue.printing=!!this.printService,this.pdfRenderingQueue.isThumbnailViewEnabled=this.pdfSidebar?.visibleView===n.SidebarView.THUMBS,this.pdfRenderingQueue.renderHighestPriority()},beforePrint(){if(this._printAnnotationStoragePromise=this.pdfScriptingManager.dispatchWillPrint().catch((()=>{})).then((()=>this.pdfDocument?.annotationStorage.print)),this.printService)return;if(!this.supportsPrinting)return void this.l10n.get("printing_not_supported").then((e=>{this._otherError(e)}));if(!this.pdfViewer.pageViewsReady)return void this.l10n.get("printing_not_ready").then((e=>{window.alert(e)}));const e=this.pdfViewer.getPagesOverview(),t=this.appConfig.printContainer,i=o.AppOptions.get("printResolution"),n=this.pdfViewer.optionalContentConfigPromise,s=ke.instance.createPrintService(this.pdfDocument,e,t,i,n,this._printAnnotationStoragePromise,this.l10n);this.printService=s,this.forceRendering(),this.setTitle(),s.layout(),this._hasAnnotationEditors&&this.externalServices.reportTelemetry({type:"editing",data:{type:"print"}})},afterPrint(){this._printAnnotationStoragePromise&&(this._printAnnotationStoragePromise.then((()=>{this.pdfScriptingManager.dispatchDidPrint()})),this._printAnnotationStoragePromise=null),this.printService&&(this.printService.destroy(),this.printService=null,this.pdfDocument?.annotationStorage.resetModified()),this.forceRendering(),this.setTitle()},rotatePages(e){this.pdfViewer.pagesRotation+=e},requestPresentationMode(){this.pdfPresentationMode?.request()},triggerPrinting(){this.supportsPrinting&&window.print()},bindEvents(){const{eventBus:e,_boundEvents:t}=this;t.beforePrint=this.beforePrint.bind(this),t.afterPrint=this.afterPrint.bind(this),e._on("resize",X),e._on("hashchange",K),e._on("beforeprint",t.beforePrint),e._on("afterprint",t.afterPrint),e._on("pagerender",R),e._on("pagerendered",F),e._on("updateviewarea",$),e._on("pagechanging",Ee),e._on("scalechanging",ye),e._on("rotationchanging",Pe),e._on("sidebarviewchanged",W),e._on("pagemode",U),e._on("namedaction",z),e._on("presentationmodechanged",H),e._on("presentationmode",q),e._on("switchannotationeditormode",Y),e._on("switchannotationeditorparams",J),e._on("print",ee),e._on("download",te),e._on("openinexternalapp",ie),e._on("firstpage",ne),e._on("lastpage",se),e._on("nextpage",oe),e._on("previouspage",ae),e._on("zoomin",re),e._on("zoomout",le),e._on("zoomreset",de),e._on("pagenumberchanged",he),e._on("scalechanged",ce),e._on("rotatecw",ue),e._on("rotateccw",pe),e._on("optionalcontentconfig",ge),e._on("switchscrollmode",me),e._on("scrollmodechanged",j),e._on("switchspreadmode",fe),e._on("spreadmodechanged",G),e._on("documentproperties",ve),e._on("findfromurlhash",we),e._on("updatefindmatchescount",be),e._on("updatefindcontrolstate",_e),o.AppOptions.get("pdfBug")&&(t.reportPageStatsPDFBug=V,e._on("pagerendered",t.reportPageStatsPDFBug),e._on("pagechanging",t.reportPageStatsPDFBug)),e._on("fileinputchange",Z),e._on("openfile",Q)},bindWindowEvents(){const{eventBus:e,_boundEvents:t}=this;!function e(i=null){i&&B.pdfViewer.refresh();const n=window.matchMedia(`(resolution: ${window.devicePixelRatio||1}dppx)`);n.addEventListener("change",e,{once:!0}),t.removeWindowResolutionChange||=function(){n.removeEventListener("change",e),t.removeWindowResolutionChange=null}}(),t.windowResize=()=>{e.dispatch("resize",{source:window})},t.windowHashChange=()=>{e.dispatch("hashchange",{source:window,hash:document.location.hash.substring(1)})},t.windowBeforePrint=()=>{e.dispatch("beforeprint",{source:window})},t.windowAfterPrint=()=>{e.dispatch("afterprint",{source:window})},t.windowUpdateFromSandbox=t=>{e.dispatch("updatefromsandbox",{source:window,detail:t.detail})},window.addEventListener("visibilitychange",Se),window.addEventListener("wheel",Te,{passive:!1}),window.addEventListener("touchstart",Me,{passive:!1}),window.addEventListener("touchmove",Ie,{passive:!1}),window.addEventListener("touchend",Ae,{passive:!1}),window.addEventListener("click",xe),window.addEventListener("keydown",Ne),window.addEventListener("keyup",De),window.addEventListener("resize",t.windowResize),window.addEventListener("hashchange",t.windowHashChange),window.addEventListener("beforeprint",t.windowBeforePrint),window.addEventListener("afterprint",t.windowAfterPrint),window.addEventListener("updatefromsandbox",t.windowUpdateFromSandbox)},unbindEvents(){const{eventBus:e,_boundEvents:t}=this;e._off("resize",X),e._off("hashchange",K),e._off("beforeprint",t.beforePrint),e._off("afterprint",t.afterPrint),e._off("pagerender",R),e._off("pagerendered",F),e._off("updateviewarea",$),e._off("pagechanging",Ee),e._off("scalechanging",ye),e._off("rotationchanging",Pe),e._off("sidebarviewchanged",W),e._off("pagemode",U),e._off("namedaction",z),e._off("presentationmodechanged",H),e._off("presentationmode",q),e._off("print",ee),e._off("download",te),e._off("openinexternalapp",ie),e._off("firstpage",ne),e._off("lastpage",se),e._off("nextpage",oe),e._off("previouspage",ae),e._off("zoomin",re),e._off("zoomout",le),e._off("zoomreset",de),e._off("pagenumberchanged",he),e._off("scalechanged",ce),e._off("rotatecw",ue),e._off("rotateccw",pe),e._off("optionalcontentconfig",ge),e._off("switchscrollmode",me),e._off("scrollmodechanged",j),e._off("switchspreadmode",fe),e._off("spreadmodechanged",G),e._off("documentproperties",ve),e._off("findfromurlhash",we),e._off("updatefindmatchescount",be),e._off("updatefindcontrolstate",_e),t.reportPageStatsPDFBug&&(e._off("pagerendered",t.reportPageStatsPDFBug),e._off("pagechanging",t.reportPageStatsPDFBug),t.reportPageStatsPDFBug=null),e._off("fileinputchange",Z),e._off("openfile",Q),t.beforePrint=null,t.afterPrint=null},unbindWindowEvents(){const{_boundEvents:e}=this;window.removeEventListener("visibilitychange",Se),window.removeEventListener("wheel",Te,{passive:!1}),window.removeEventListener("touchstart",Me,{passive:!1}),window.removeEventListener("touchmove",Ie,{passive:!1}),window.removeEventListener("touchend",Ae,{passive:!1}),window.removeEventListener("click",xe),window.removeEventListener("keydown",Ne),window.removeEventListener("keyup",De),window.removeEventListener("resize",e.windowResize),window.removeEventListener("hashchange",e.windowHashChange),window.removeEventListener("beforeprint",e.windowBeforePrint),window.removeEventListener("afterprint",e.windowAfterPrint),window.removeEventListener("updatefromsandbox",e.windowUpdateFromSandbox),e.removeWindowResolutionChange?.(),e.windowResize=null,e.windowHashChange=null,e.windowBeforePrint=null,e.windowAfterPrint=null,e.windowUpdateFromSandbox=null},_accumulateTicks(e,t){(this[t]>0&&e<0||this[t]<0&&e>0)&&(this[t]=0),this[t]+=e;const i=Math.trunc(this[t]);return this[t]-=i,i},_accumulateFactor(e,t,i){if(1===t)return 1;(this[i]>1&&t<1||this[i]<1&&t>1)&&(this[i]=1);const n=Math.floor(e*t*this[i]*100)/(100*e);return this[i]=t/n,n},_centerAtPos(e,t,i){const{pdfViewer:n}=this,s=n.currentScale/e-1;if(0!==s){const[e,o]=n.containerTopLeft;n.container.scrollLeft+=(t-o)*s,n.container.scrollTop+=(i-e)*s}},_unblockDocumentLoadEvent(){document.blockUnblockOnload?.(!1),this._unblockDocumentLoadEvent=()=>{}},get scriptingReady(){return this.pdfScriptingManager.ready}};t.PDFViewerApplication=B;{const e=["null","http://mozilla.github.io","https://mozilla.github.io"];var k=function(t){if(t)try{const i=new URL(window.location.href).origin||"null";if(e.includes(i))return;if(new URL(t,window.location.href).origin!==i)throw new Error("file origin does not match viewer's")}catch(e){throw B.l10n.get("loading_error").then((t=>{B._documentError(t,{message:e?.message})})),e}}}async function O(e){const{debuggerScriptPath:t}=e.appConfig,{PDFBug:i}=await import(t);e._PDFBug=i}function V({pageNumber:e}){if(!globalThis.Stats?.enabled)return;const t=B.pdfViewer.getPageView(e-1);globalThis.Stats.add(e,t?.pdfPage?.stats)}function R({pageNumber:e}){e===B.page&&B.toolbar?.updateLoadingIndicatorState(!0)}function F({pageNumber:e,error:t}){if(e===B.page&&B.toolbar?.updateLoadingIndicatorState(!1),B.pdfSidebar?.visibleView===n.SidebarView.THUMBS){const t=B.pdfViewer.getPageView(e-1),i=B.pdfThumbnailViewer?.getThumbnail(e-1);t&&i?.setImage(t)}t&&B.l10n.get("rendering_error").then((e=>{B._otherError(e,t)}))}function U({mode:e}){let t;switch(e){case"thumbs":t=n.SidebarView.THUMBS;break;case"bookmarks":case"outline":t=n.SidebarView.OUTLINE;break;case"attachments":t=n.SidebarView.ATTACHMENTS;break;case"layers":t=n.SidebarView.LAYERS;break;case"none":t=n.SidebarView.NONE;break;default:return void console.error('Invalid "pagemode" hash parameter: '+e)}B.pdfSidebar?.switchView(t,!0)}function z(e){switch(e.action){case"GoToPage":B.appConfig.toolbar?.pageNumber.select();break;case"Find":B.supportsIntegratedFind||B?.findBar.toggle();break;case"Print":B.triggerPrinting();break;case"SaveAs":B.downloadOrSave()}}function H(e){B.pdfViewer.presentationModeState=e.state}function W({view:e}){B.pdfRenderingQueue.isThumbnailViewEnabled=e===n.SidebarView.THUMBS,B.isInitialViewSet&&B.store?.set("sidebarView",e).catch((()=>{}))}function $({location:e}){if(B.isInitialViewSet&&B.store?.setMultiple({page:e.pageNumber,zoom:e.scale,scrollLeft:e.left,scrollTop:e.top,rotation:e.rotation}).catch((()=>{})),B.appConfig.secondaryToolbar){const t=B.pdfLinkService.getAnchorUrl(e.pdfOpenParams);B.appConfig.secondaryToolbar.viewBookmarkButton.href=t}}function j(e){B.isInitialViewSet&&!B.pdfViewer.isInPresentationMode&&B.store?.set("scrollMode",e.mode).catch((()=>{}))}function G(e){B.isInitialViewSet&&!B.pdfViewer.isInPresentationMode&&B.store?.set("spreadMode",e.mode).catch((()=>{}))}function X(){const{pdfDocument:e,pdfViewer:t,pdfRenderingQueue:i}=B;if(i.printing&&window.matchMedia("print").matches)return;if(!e)return;const n=t.currentScaleValue;"auto"!==n&&"page-fit"!==n&&"page-width"!==n||(t.currentScaleValue=n),t.update()}function K(e){const t=e.hash;t&&(B.isInitialViewSet?B.pdfHistory?.popStateInProgress||B.pdfLinkService.setHash(t):B.initialBookmark=t)}var Z=function(e){if(B.pdfViewer?.isInPresentationMode)return;const t=e.fileInput.files[0];B.open({url:URL.createObjectURL(t),originalUrl:t.name})},Q=function(e){B.appConfig.openFileInput.click()};function q(){B.requestPresentationMode()}function Y(e){B.pdfViewer.annotationEditorMode=e}function J(e){B.pdfViewer.annotationEditorParams=e}function ee(){B.triggerPrinting()}function te(){B.downloadOrSave()}function ie(){B.openInExternalApp()}function ne(){B.page=1}function se(){B.page=B.pagesCount}function oe(){B.pdfViewer.nextPage()}function ae(){B.pdfViewer.previousPage()}function re(){B.zoomIn()}function le(){B.zoomOut()}function de(){B.zoomReset()}function he(e){const t=B.pdfViewer;""!==e.value&&B.pdfLinkService.goToPage(e.value),e.value!==t.currentPageNumber.toString()&&e.value!==t.currentPageLabel&&B.toolbar?.setPageNumber(t.currentPageNumber,t.currentPageLabel)}function ce(e){B.pdfViewer.currentScaleValue=e.value}function ue(){B.rotatePages(90)}function pe(){B.rotatePages(-90)}function ge(e){B.pdfViewer.optionalContentConfigPromise=e.promise}function me(e){B.pdfViewer.scrollMode=e.mode}function fe(e){B.pdfViewer.spreadMode=e.mode}function ve(){B.pdfDocumentProperties?.open()}function we(e){B.eventBus.dispatch("find",{source:e.source,type:"",query:e.query,caseSensitive:!1,entireWord:!1,highlightAll:!0,findPrevious:!1,matchDiacritics:!0})}function be({matchesCount:e}){B.supportsIntegratedFind?B.externalServices.updateFindMatchesCount(e):B.findBar.updateResultsCount(e)}function _e({state:e,previous:t,matchesCount:i,rawQuery:n}){B.supportsIntegratedFind?B.externalServices.updateFindControlState({result:e,findPrevious:t,matchesCount:i,rawQuery:n}):B.findBar?.updateUIState(e,t,i)}function ye(e){B.toolbar?.setPageScale(e.presetValue,e.scale),B.pdfViewer.update()}function Pe(e){B.pdfThumbnailViewer&&(B.pdfThumbnailViewer.pagesRotation=e.pagesRotation),B.forceRendering(),B.pdfViewer.currentPageNumber=e.pageNumber}function Ee({pageNumber:e,pageLabel:t}){B.toolbar?.setPageNumber(e,t),B.secondaryToolbar?.setPageNumber(e),B.pdfSidebar?.visibleView===n.SidebarView.THUMBS&&B.pdfThumbnailViewer?.scrollThumbnailIntoView(e);const i=B.pdfViewer.getPageView(e-1);B.toolbar?.updateLoadingIndicatorState(i?.renderingState===n.RenderingStates.RUNNING)}function Se(e){"visible"===document.visibilityState&&Le()}let Ce=null;function Le(){Ce&&clearTimeout(Ce),Ce=setTimeout((function(){Ce=null}),I)}function Te(e){const{pdfViewer:t,supportedMouseWheelZoomModifierKeys:i,supportsPinchToZoom:s}=B;if(t.isInPresentationMode)return;const o=e.deltaMode;let a=Math.exp(-e.deltaY/100);const r=e.ctrlKey&&!B._isCtrlKeyDown&&o===WheelEvent.DOM_DELTA_PIXEL&&0===e.deltaX&&(Math.abs(a-1)<.05||!1)&&0===e.deltaZ;if(r||e.ctrlKey&&i.ctrlKey||e.metaKey&&i.metaKey){if(e.preventDefault(),Ce||"hidden"===document.visibilityState||B.overlayManager.active)return;const i=t.currentScale;if(r&&s)if(a=B._accumulateFactor(i,a,"_wheelUnusedFactor"),a<1)B.zoomOut(null,a);else{if(!(a>1))return;B.zoomIn(null,a)}else{const t=(0,n.normalizeWheelEventDirection)(e);let i=0;if(o===WheelEvent.DOM_DELTA_LINE||o===WheelEvent.DOM_DELTA_PAGE)i=Math.abs(t)>=1?Math.sign(t):B._accumulateTicks(t,"_wheelUnusedTicks");else{const e=30;i=B._accumulateTicks(t/e,"_wheelUnusedTicks")}if(i<0)B.zoomOut(-i);else{if(!(i>0))return;B.zoomIn(i)}}B._centerAtPos(i,e.clientX,e.clientY)}else Le()}function Me(e){if(B.pdfViewer.isInPresentationMode||e.touches.length<2)return;if(e.preventDefault(),2!==e.touches.length||B.overlayManager.active)return void(B._touchInfo=null);let[t,i]=e.touches;t.identifier>i.identifier&&([t,i]=[i,t]),B._touchInfo={touch0X:t.pageX,touch0Y:t.pageY,touch1X:i.pageX,touch1Y:i.pageY}}function Ie(e){if(!B._touchInfo||2!==e.touches.length)return;const{pdfViewer:t,_touchInfo:i,supportsPinchToZoom:n}=B;let[s,o]=e.touches;s.identifier>o.identifier&&([s,o]=[o,s]);const{pageX:a,pageY:r}=s,{pageX:l,pageY:d}=o,{touch0X:h,touch0Y:c,touch1X:u,touch1Y:p}=i;if(Math.abs(h-a)<=1&&Math.abs(c-r)<=1&&Math.abs(u-l)<=1&&Math.abs(p-d)<=1)return;if(i.touch0X=a,i.touch0Y=r,i.touch1X=l,i.touch1Y=d,h===a&&c===r){const e=u-a,t=p-r,i=l-a,n=d-r,s=e*n-t*i;if(Math.abs(s)>.02*Math.hypot(e,t)*Math.hypot(i,n))return}else if(u===l&&p===d){const e=h-l,t=c-d,i=a-l,n=r-d,s=e*n-t*i;if(Math.abs(s)>.02*Math.hypot(e,t)*Math.hypot(i,n))return}else{if((a-h)*(l-u)+(r-c)*(d-p)>=0)return}e.preventDefault();const g=Math.hypot(a-l,r-d)||1,m=Math.hypot(h-u,c-p)||1,f=t.currentScale;if(n){const e=B._accumulateFactor(f,g/m,"_touchUnusedFactor");if(e<1)B.zoomOut(null,e);else{if(!(e>1))return;B.zoomIn(null,e)}}else{const e=30,t=B._accumulateTicks((g-m)/e,"_touchUnusedTicks");if(t<0)B.zoomOut(-t);else{if(!(t>0))return;B.zoomIn(t)}}B._centerAtPos(f,(a+l)/2,(r+d)/2)}function Ae(e){B._touchInfo&&(e.preventDefault(),B._touchInfo=null,B._touchUnusedTicks=0,B._touchUnusedFactor=1)}function xe(e){if(!B.secondaryToolbar?.isOpen)return;const t=B.appConfig;(B.pdfViewer.containsElement(e.target)||t.toolbar?.container.contains(e.target)&&e.target!==t.secondaryToolbar?.toggleButton)&&B.secondaryToolbar.close()}function De(e){"Control"===e.key&&(B._isCtrlKeyDown=!1)}function Ne(e){if(B._isCtrlKeyDown="Control"===e.key,B.overlayManager.active)return;const{eventBus:t,pdfViewer:i}=B,s=i.isInPresentationMode;let o=!1,a=!1;const r=(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0);if(1===r||8===r||5===r||12===r)switch(e.keyCode){case 70:B.supportsIntegratedFind||e.shiftKey||(B.findBar?.open(),o=!0);break;case 71:if(!B.supportsIntegratedFind){const{state:e}=B.findController;if(e){const i={source:window,type:"again",findPrevious:5===r||12===r};t.dispatch("find",{...e,...i})}o=!0}break;case 61:case 107:case 187:case 171:B.zoomIn(),o=!0;break;case 173:case 109:case 189:B.zoomOut(),o=!0;break;case 48:case 96:s||(setTimeout((function(){B.zoomReset()})),o=!1);break;case 38:(s||B.page>1)&&(B.page=1,o=!0,a=!0);break;case 40:(s||B.page<B.pagesCount)&&(B.page=B.pagesCount,o=!0,a=!0)}if(1===r||8===r)switch(e.keyCode){case 83:t.dispatch("download",{source:window}),o=!0;break;case 79:t.dispatch("openfile",{source:window}),o=!0}if(3===r||10===r)switch(e.keyCode){case 80:B.requestPresentationMode(),o=!0,B.externalServices.reportTelemetry({type:"buttons",data:{id:"presentationModeKeyboard"}});break;case 71:B.appConfig.toolbar&&(B.appConfig.toolbar.pageNumber.select(),o=!0)}if(o)return a&&!s&&i.focus(),void e.preventDefault();const l=(0,n.getActiveOrFocusedElement)(),d=l?.tagName.toUpperCase();if("INPUT"!==d&&"TEXTAREA"!==d&&"SELECT"!==d&&!l?.isContentEditable||27===e.keyCode){if(0===r){let t=0,r=!1;switch(e.keyCode){case 38:case 33:i.isVerticalScrollbarEnabled&&(r=!0),t=-1;break;case 8:s||(r=!0),t=-1;break;case 37:i.isHorizontalScrollbarEnabled&&(r=!0);case 75:case 80:t=-1;break;case 27:B.secondaryToolbar?.isOpen&&(B.secondaryToolbar.close(),o=!0),!B.supportsIntegratedFind&&B.findBar?.opened&&(B.findBar.close(),o=!0);break;case 40:case 34:i.isVerticalScrollbarEnabled&&(r=!0),t=1;break;case 13:case 32:s||(r=!0),t=1;break;case 39:i.isHorizontalScrollbarEnabled&&(r=!0);case 74:case 78:t=1;break;case 36:(s||B.page>1)&&(B.page=1,o=!0,a=!0);break;case 35:(s||B.page<B.pagesCount)&&(B.page=B.pagesCount,o=!0,a=!0);break;case 83:B.pdfCursorTools?.switchTool(n.CursorTool.SELECT);break;case 72:B.pdfCursorTools?.switchTool(n.CursorTool.HAND);break;case 82:B.rotatePages(90);break;case 115:B.pdfSidebar?.toggle()}0===t||r&&"page-fit"!==i.currentScaleValue||(t>0?i.nextPage():i.previousPage(),o=!0)}if(4===r)switch(e.keyCode){case 13:case 32:if(!s&&"page-fit"!==i.currentScaleValue)break;i.previousPage(),o=!0;break;case 82:B.rotatePages(-90)}o||s||(e.keyCode>=33&&e.keyCode<=40||32===e.keyCode&&"BUTTON"!==d)&&(a=!0),a&&!i.containsElement(l)&&i.focus(),o&&e.preventDefault()}}function Be(e){return e.preventDefault(),e.returnValue="",!1}const ke={instance:{supportsPrinting:!1,createPrintService(){throw new Error("Not implemented: createPrintService")}}};t.PDFPrintServiceFactory=ke},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.animationStarted=t.VERTICAL_PADDING=t.UNKNOWN_SCALE=t.TextLayerMode=t.SpreadMode=t.SidebarView=t.ScrollMode=t.SCROLLBAR_PADDING=t.RenderingStates=t.ProgressBar=t.PresentationModeState=t.OutputScale=t.MIN_SCALE=t.MAX_SCALE=t.MAX_AUTO_SCALE=t.DEFAULT_SCALE_VALUE=t.DEFAULT_SCALE_DELTA=t.DEFAULT_SCALE=t.CursorTool=t.AutoPrintRegExp=void 0,t.apiPageLayoutToViewerModes=function(e){let t=n.VERTICAL,i=s.NONE;switch(e){case"SinglePage":t=n.PAGE;break;case"OneColumn":break;case"TwoPageLeft":t=n.PAGE;case"TwoColumnLeft":i=s.ODD;break;case"TwoPageRight":t=n.PAGE;case"TwoColumnRight":i=s.EVEN}return{scrollMode:t,spreadMode:i}},t.apiPageModeToSidebarView=function(e){switch(e){case"UseNone":return i.NONE;case"UseThumbs":return i.THUMBS;case"UseOutlines":return i.OUTLINE;case"UseAttachments":return i.ATTACHMENTS;case"UseOC":return i.LAYERS}return i.NONE},t.approximateFraction=function(e){if(Math.floor(e)===e)return[e,1];const t=1/e;if(t>8)return[1,8];if(Math.floor(t)===t)return[1,t];const i=e>1?t:e;let n,s=0,o=1,a=1,r=1;for(;;){const e=s+a,t=o+r;if(t>8)break;i<=e/t?(a=e,r=t):(s=e,o=t)}n=i-s/o<a/r-i?i===e?[s,o]:[o,s]:i===e?[a,r]:[r,a];return n},t.backtrackBeforeAllVisibleElements=r,t.binarySearchFirstItem=a,t.docStyle=void 0,t.getActiveOrFocusedElement=function(){let e=document,t=e.activeElement||e.querySelector(":focus");for(;t?.shadowRoot;)e=t.shadowRoot,t=e.activeElement||e.querySelector(":focus");return t},t.getPageSizeInches=function({view:e,userUnit:t,rotate:i}){const[n,s,o,a]=e,r=i%180!=0,l=(o-n)/72*t,d=(a-s)/72*t;return{width:r?d:l,height:r?l:d}},t.getVisibleElements=function({scrollEl:e,views:t,sortByVisibility:i=!1,horizontal:n=!1,rtl:s=!1}){const o=e.scrollTop,l=o+e.clientHeight,d=e.scrollLeft,h=d+e.clientWidth;const c=[],u=new Set,p=t.length;let g=a(t,n?function(e){const t=e.div,i=t.offsetLeft+t.clientLeft,n=i+t.clientWidth;return s?i<h:n>d}:function(e){const t=e.div;return t.offsetTop+t.clientTop+t.clientHeight>o});g>0&&g<p&&!n&&(g=r(g,t,o));let m=n?h:-1;for(let e=g;e<p;e++){const i=t[e],s=i.div,a=s.offsetLeft+s.clientLeft,r=s.offsetTop+s.clientTop,p=s.clientWidth,g=s.clientHeight,f=a+p,v=r+g;if(-1===m)v>=l&&(m=v);else if((n?a:r)>m)break;if(v<=o||r>=l||f<=d||a>=h)continue;const w=Math.max(0,o-r)+Math.max(0,v-l),b=(p-(Math.max(0,d-a)+Math.max(0,f-h)))/p,_=(g-w)/g*b*100|0;c.push({id:i.id,x:a,y:r,view:i,percent:_,widthPercent:100*b|0}),u.add(i.id)}const f=c[0],v=c.at(-1);i&&c.sort((function(e,t){const i=e.percent-t.percent;return Math.abs(i)>.001?-i:e.id-t.id}));return{first:f,last:v,views:c,ids:u}},t.isPortraitOrientation=function(e){return e.width<=e.height},t.isValidRotation=function(e){return Number.isInteger(e)&&e%90==0},t.isValidScrollMode=function(e){return Number.isInteger(e)&&Object.values(n).includes(e)&&e!==n.UNKNOWN},t.isValidSpreadMode=function(e){return Number.isInteger(e)&&Object.values(s).includes(e)&&e!==s.UNKNOWN},t.normalizeWheelEventDelta=function(e){const t=e.deltaMode;let i=l(e);t===WheelEvent.DOM_DELTA_PIXEL?i/=900:t===WheelEvent.DOM_DELTA_LINE&&(i/=30);return i},t.normalizeWheelEventDirection=l,t.parseQueryString=function(e){const t=new Map;for(const[i,n]of new URLSearchParams(e))t.set(i.toLowerCase(),n);return t},t.removeNullCharacters=function(e,t=!1){if("string"!=typeof e)return console.error("The argument must be a string."),e;t&&(e=e.replaceAll(o," "));return e.replaceAll("\0","")},t.roundToDivide=function(e,t){const i=e%t;return 0===i?e:Math.round(e-i+t)},t.scrollIntoView=function(e,t,i=!1){let n=e.offsetParent;if(!n)return void console.error("offsetParent is not set -- cannot scroll");let s=e.offsetTop+e.clientTop,o=e.offsetLeft+e.clientLeft;for(;n.clientHeight===n.scrollHeight&&n.clientWidth===n.scrollWidth||i&&(n.classList.contains("markedContent")||"hidden"===getComputedStyle(n).overflow);)if(s+=n.offsetTop,o+=n.offsetLeft,n=n.offsetParent,!n)return;t&&(void 0!==t.top&&(s+=t.top),void 0!==t.left&&(o+=t.left,n.scrollLeft=o));n.scrollTop=s},t.toggleCheckedBtn=function(e,t,i=null){e.classList.toggle("toggled",t),e.setAttribute("aria-checked",t),i?.classList.toggle("hidden",!t)},t.toggleExpandedBtn=function(e,t,i=null){e.classList.toggle("toggled",t),e.setAttribute("aria-expanded",t),i?.classList.toggle("hidden",!t)},t.watchScroll=function(e,t){const i=function(i){s||(s=window.requestAnimationFrame((function(){s=null;const i=e.scrollLeft,o=n.lastX;i!==o&&(n.right=i>o),n.lastX=i;const a=e.scrollTop,r=n.lastY;a!==r&&(n.down=a>r),n.lastY=a,t(n)})))},n={right:!0,down:!0,lastX:e.scrollLeft,lastY:e.scrollTop,_eventHandler:i};let s=null;return e.addEventListener("scroll",i,!0),n};t.DEFAULT_SCALE_VALUE="auto";t.DEFAULT_SCALE=1;t.DEFAULT_SCALE_DELTA=1.1;t.MIN_SCALE=.1;t.MAX_SCALE=10;t.UNKNOWN_SCALE=0;t.MAX_AUTO_SCALE=1.25;t.SCROLLBAR_PADDING=40;t.VERTICAL_PADDING=5;t.RenderingStates={INITIAL:0,RUNNING:1,PAUSED:2,FINISHED:3};t.PresentationModeState={UNKNOWN:0,NORMAL:1,CHANGING:2,FULLSCREEN:3};const i={UNKNOWN:-1,NONE:0,THUMBS:1,OUTLINE:2,ATTACHMENTS:3,LAYERS:4};t.SidebarView=i;t.TextLayerMode={DISABLE:0,ENABLE:1,ENABLE_PERMISSIONS:2};const n={UNKNOWN:-1,VERTICAL:0,HORIZONTAL:1,WRAPPED:2,PAGE:3};t.ScrollMode=n;const s={UNKNOWN:-1,NONE:0,ODD:1,EVEN:2};t.SpreadMode=s;t.CursorTool={SELECT:0,HAND:1,ZOOM:2};t.AutoPrintRegExp=/\bprint\s*\(/;t.OutputScale=class{constructor(){const e=window.devicePixelRatio||1;this.sx=e,this.sy=e}get scaled(){return 1!==this.sx||1!==this.sy}};const o=/[\x01-\x1F]/g;function a(e,t,i=0){let n=i,s=e.length-1;if(s<0||!t(e[s]))return e.length;if(t(e[n]))return n;for(;n<s;){const i=n+s>>1;t(e[i])?s=i:n=i+1}return n}function r(e,t,i){if(e<2)return e;let n=t[e].div,s=n.offsetTop+n.clientTop;s>=i&&(n=t[e-1].div,s=n.offsetTop+n.clientTop);for(let i=e-2;i>=0&&(n=t[i].div,!(n.offsetTop+n.clientTop+n.clientHeight<=s));--i)e=i;return e}function l(e){let t=Math.hypot(e.deltaX,e.deltaY);const i=Math.atan2(e.deltaY,e.deltaX);return-.25*Math.PI<i&&i<.75*Math.PI&&(t=-t),t}const d=new Promise((function(e){window.requestAnimationFrame(e)}));t.animationStarted=d;const h=document.documentElement.style;t.docStyle=h;t.ProgressBar=class{#e=null;#t=null;#i=0;#n=null;#s=!0;constructor(e){this.#e=e.classList,this.#n=e.style}get percent(){return this.#i}set percent(e){var t,i,n;this.#i=(t=e,i=0,n=100,Math.min(Math.max(t,i),n)),isNaN(e)?this.#e.add("indeterminate"):(this.#e.remove("indeterminate"),this.#n.setProperty("--progressBar-percent",`${this.#i}%`))}setWidth(e){if(!e)return;const t=e.parentNode.offsetWidth-e.offsetWidth;t>0&&this.#n.setProperty("--progressBar-end-offset",`${t}px`)}setDisableAutoFetch(e=5e3){isNaN(this.#i)||(this.#t&&clearTimeout(this.#t),this.show(),this.#t=setTimeout((()=>{this.#t=null,this.hide()}),e))}hide(){this.#s&&(this.#s=!1,this.#e.add("hidden"))}show(){this.#s||(this.#s=!0,this.#e.remove("hidden"))}}},e=>{e.exports=globalThis.pdfjsLib},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.compatibilityParams=t.OptionKind=t.AppOptions=void 0;const i=Object.create(null);t.compatibilityParams=i;{const e=navigator.userAgent||"",t=navigator.platform||"",n=navigator.maxTouchPoints||1,s=/Android/.test(e);(/\b(iPad|iPhone|iPod)(?=;)/.test(e)||"MacIntel"===t&&n>1||s)&&(i.maxCanvasPixels=5242880)}const n={VIEWER:2,API:4,WORKER:8,PREFERENCE:128};t.OptionKind=n;const s={annotationEditorMode:{value:0,kind:n.VIEWER+n.PREFERENCE},annotationMode:{value:2,kind:n.VIEWER+n.PREFERENCE},cursorToolOnLoad:{value:0,kind:n.VIEWER+n.PREFERENCE},defaultZoomDelay:{value:400,kind:n.VIEWER+n.PREFERENCE},defaultZoomValue:{value:"",kind:n.VIEWER+n.PREFERENCE},disableHistory:{value:!1,kind:n.VIEWER},disablePageLabels:{value:!1,kind:n.VIEWER+n.PREFERENCE},enablePermissions:{value:!1,kind:n.VIEWER+n.PREFERENCE},enablePrintAutoRotate:{value:!0,kind:n.VIEWER+n.PREFERENCE},enableScripting:{value:!0,kind:n.VIEWER+n.PREFERENCE},enableStampEditor:{value:!0,kind:n.VIEWER+n.PREFERENCE},externalLinkRel:{value:"noopener noreferrer nofollow",kind:n.VIEWER},externalLinkTarget:{value:0,kind:n.VIEWER+n.PREFERENCE},historyUpdateUrl:{value:!1,kind:n.VIEWER+n.PREFERENCE},ignoreDestinationZoom:{value:!1,kind:n.VIEWER+n.PREFERENCE},imageResourcesPath:{value:"./images/",kind:n.VIEWER},maxCanvasPixels:{value:16777216,kind:n.VIEWER},forcePageColors:{value:!1,kind:n.VIEWER+n.PREFERENCE},pageColorsBackground:{value:"Canvas",kind:n.VIEWER+n.PREFERENCE},pageColorsForeground:{value:"CanvasText",kind:n.VIEWER+n.PREFERENCE},pdfBugEnabled:{value:!1,kind:n.VIEWER+n.PREFERENCE},printResolution:{value:150,kind:n.VIEWER},sidebarViewOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},scrollModeOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},spreadModeOnLoad:{value:-1,kind:n.VIEWER+n.PREFERENCE},textLayerMode:{value:1,kind:n.VIEWER+n.PREFERENCE},viewerCssTheme:{value:0,kind:n.VIEWER+n.PREFERENCE},viewOnLoad:{value:0,kind:n.VIEWER+n.PREFERENCE},cMapPacked:{value:!0,kind:n.API},cMapUrl:{value:"../web/cmaps/",kind:n.API},disableAutoFetch:{value:!1,kind:n.API+n.PREFERENCE},disableFontFace:{value:!1,kind:n.API+n.PREFERENCE},disableRange:{value:!1,kind:n.API+n.PREFERENCE},disableStream:{value:!1,kind:n.API+n.PREFERENCE},docBaseUrl:{value:"",kind:n.API},enableXfa:{value:!0,kind:n.API+n.PREFERENCE},fontExtraProperties:{value:!1,kind:n.API},isEvalSupported:{value:!0,kind:n.API},isOffscreenCanvasSupported:{value:!0,kind:n.API},maxImageSize:{value:-1,kind:n.API},pdfBug:{value:!1,kind:n.API},standardFontDataUrl:{value:"../web/standard_fonts/",kind:n.API},verbosity:{value:1,kind:n.API},workerPort:{value:null,kind:n.WORKER},workerSrc:{value:"pdf.worker.js",kind:n.WORKER}};s.defaultUrl={value:"compressed.tracemonkey-pldi-09.pdf",kind:n.VIEWER},s.disablePreferences={value:!1,kind:n.VIEWER},s.locale={value:navigator.language||"en-US",kind:n.VIEWER},s.sandboxBundleSrc={value:"../build/pdf.sandbox.js",kind:n.VIEWER};const o=Object.create(null);class a{constructor(){throw new Error("Cannot initialize AppOptions.")}static get(e){const t=o[e];if(void 0!==t)return t;const n=s[e];return void 0!==n?i[e]??n.value:void 0}static getAll(e=null){const t=Object.create(null);for(const a in s){const r=s[a];if(e){if(0==(e&r.kind))continue;if(e===n.PREFERENCE){const e=r.value,i=typeof e;if("boolean"===i||"string"===i||"number"===i&&Number.isInteger(e)){t[a]=e;continue}throw new Error(`Invalid type for preference: ${a}`)}}const l=o[a];t[a]=void 0!==l?l:i[a]??r.value}return t}static set(e,t){o[e]=t}static setAll(e){for(const t in e)o[t]=e[t]}static remove(e){delete o[e]}}t.AppOptions=a,a._hasUserOptions=function(){return Object.keys(o).length>0}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.WaitOnType=t.EventBus=t.AutomationEventBus=void 0,t.waitOnEventOrTimeout=function({target:e,name:t,delay:s=0}){return new Promise((function(o,a){if("object"!=typeof e||!t||"string"!=typeof t||!(Number.isInteger(s)&&s>=0))throw new Error("waitOnEventOrTimeout - invalid parameters.");function r(i){e instanceof n?e._off(t,l):e.removeEventListener(t,l),h&&clearTimeout(h),o(i)}const l=r.bind(null,i.EVENT);e instanceof n?e._on(t,l):e.addEventListener(t,l);const d=r.bind(null,i.TIMEOUT),h=setTimeout(d,s)}))};const i={EVENT:"event",TIMEOUT:"timeout"};t.WaitOnType=i;class n{#o=Object.create(null);on(e,t,i=null){this._on(e,t,{external:!0,once:i?.once})}off(e,t,i=null){this._off(e,t,{external:!0,once:i?.once})}dispatch(e,t){const i=this.#o[e];if(!i||0===i.length)return;let n;for(const{listener:s,external:o,once:a}of i.slice(0))a&&this._off(e,s),o?(n||=[]).push(s):s(t);if(n){for(const e of n)e(t);n=null}}_on(e,t,i=null){(this.#o[e]||=[]).push({listener:t,external:!0===i?.external,once:!0===i?.once})}_off(e,t,i=null){const n=this.#o[e];if(n)for(let e=0,i=n.length;e<i;e++)if(n[e].listener===t)return void n.splice(e,1)}}t.EventBus=n;t.AutomationEventBus=class extends n{dispatch(e,t){throw new Error("Not implemented: AutomationEventBus.dispatch")}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.SimpleLinkService=t.PDFLinkService=t.LinkTarget=void 0;var n=i(3);const s={NONE:0,SELF:1,BLANK:2,PARENT:3,TOP:4};function o(e,{url:t,target:i,rel:n,enabled:o=!0}={}){if(!t||"string"!=typeof t)throw new Error('A valid "url" parameter must provided.');o?e.href=e.title=t:(e.href="",e.title=`Disabled: ${t}`,e.onclick=()=>!1);let a="";switch(i){case s.NONE:break;case s.SELF:a="_self";break;case s.BLANK:a="_blank";break;case s.PARENT:a="_parent";break;case s.TOP:a="_top"}e.target=a,e.rel="string"==typeof n?n:"noopener noreferrer nofollow"}t.LinkTarget=s;class a{#a=new Map;constructor({eventBus:e,externalLinkTarget:t=null,externalLinkRel:i=null,ignoreDestinationZoom:n=!1}={}){this.eventBus=e,this.externalLinkTarget=t,this.externalLinkRel=i,this.externalLinkEnabled=!0,this._ignoreDestinationZoom=n,this.baseUrl=null,this.pdfDocument=null,this.pdfViewer=null,this.pdfHistory=null}setDocument(e,t=null){this.baseUrl=t,this.pdfDocument=e,this.#a.clear()}setViewer(e){this.pdfViewer=e}setHistory(e){this.pdfHistory=e}get pagesCount(){return this.pdfDocument?this.pdfDocument.numPages:0}get page(){return this.pdfViewer.currentPageNumber}set page(e){this.pdfViewer.currentPageNumber=e}get rotation(){return this.pdfViewer.pagesRotation}set rotation(e){this.pdfViewer.pagesRotation=e}get isInPresentationMode(){return this.pdfViewer.isInPresentationMode}#r(e,t=null,i){const n=i[0];let s;if("object"==typeof n&&null!==n){if(s=this._cachedPageNumber(n),!s)return void this.pdfDocument.getPageIndex(n).then((s=>{this.cachePageRef(s+1,n),this.#r(e,t,i)})).catch((()=>{console.error(`PDFLinkService.#goToDestinationHelper: "${n}" is not a valid page reference, for dest="${e}".`)}))}else{if(!Number.isInteger(n))return void console.error(`PDFLinkService.#goToDestinationHelper: "${n}" is not a valid destination reference, for dest="${e}".`);s=n+1}!s||s<1||s>this.pagesCount?console.error(`PDFLinkService.#goToDestinationHelper: "${s}" is not a valid page number, for dest="${e}".`):(this.pdfHistory&&(this.pdfHistory.pushCurrentPosition(),this.pdfHistory.push({namedDest:t,explicitDest:i,pageNumber:s})),this.pdfViewer.scrollPageIntoView({pageNumber:s,destArray:i,ignoreDestinationZoom:this._ignoreDestinationZoom}))}async goToDestination(e){if(!this.pdfDocument)return;let t,i;"string"==typeof e?(t=e,i=await this.pdfDocument.getDestination(e)):(t=null,i=await e),Array.isArray(i)?this.#r(e,t,i):console.error(`PDFLinkService.goToDestination: "${i}" is not a valid destination array, for dest="${e}".`)}goToPage(e){if(!this.pdfDocument)return;const t="string"==typeof e&&this.pdfViewer.pageLabelToPageNumber(e)||0|e;Number.isInteger(t)&&t>0&&t<=this.pagesCount?(this.pdfHistory&&(this.pdfHistory.pushCurrentPosition(),this.pdfHistory.pushPage(t)),this.pdfViewer.scrollPageIntoView({pageNumber:t})):console.error(`PDFLinkService.goToPage: "${e}" is not a valid page.`)}addLinkAttributes(e,t,i=!1){o(e,{url:t,target:i?s.BLANK:this.externalLinkTarget,rel:this.externalLinkRel,enabled:this.externalLinkEnabled})}getDestinationHash(e){if("string"==typeof e){if(e.length>0)return this.getAnchorUrl("#"+escape(e))}else if(Array.isArray(e)){const t=JSON.stringify(e);if(t.length>0)return this.getAnchorUrl("#"+escape(t))}return this.getAnchorUrl("")}getAnchorUrl(e){return this.baseUrl?this.baseUrl+e:e}setHash(e){if(!this.pdfDocument)return;let t,i;if(e.includes("=")){const s=(0,n.parseQueryString)(e);if(s.has("search")){const e=s.get("search").replaceAll('"',""),t="true"===s.get("phrase");this.eventBus.dispatch("findfromurlhash",{source:this,query:t?e:e.match(/\S+/g)})}if(s.has("page")&&(t=0|s.get("page")||1),s.has("zoom")){const e=s.get("zoom").split(","),t=e[0],n=parseFloat(t);t.includes("Fit")?"Fit"===t||"FitB"===t?i=[null,{name:t}]:"FitH"===t||"FitBH"===t||"FitV"===t||"FitBV"===t?i=[null,{name:t},e.length>1?0|e[1]:null]:"FitR"===t?5!==e.length?console.error('PDFLinkService.setHash: Not enough parameters for "FitR".'):i=[null,{name:t},0|e[1],0|e[2],0|e[3],0|e[4]]:console.error(`PDFLinkService.setHash: "${t}" is not a valid zoom value.`):i=[null,{name:"XYZ"},e.length>1?0|e[1]:null,e.length>2?0|e[2]:null,n?n/100:t]}i?this.pdfViewer.scrollPageIntoView({pageNumber:t||this.page,destArray:i,allowNegativeOffset:!0}):t&&(this.page=t),s.has("pagemode")&&this.eventBus.dispatch("pagemode",{source:this,mode:s.get("pagemode")}),s.has("nameddest")&&this.goToDestination(s.get("nameddest"))}else{i=unescape(e);try{i=JSON.parse(i),Array.isArray(i)||(i=i.toString())}catch{}if("string"==typeof i||a.#l(i))return void this.goToDestination(i);console.error(`PDFLinkService.setHash: "${unescape(e)}" is not a valid destination.`)}}executeNamedAction(e){switch(e){case"GoBack":this.pdfHistory?.back();break;case"GoForward":this.pdfHistory?.forward();break;case"NextPage":this.pdfViewer.nextPage();break;case"PrevPage":this.pdfViewer.previousPage();break;case"LastPage":this.page=this.pagesCount;break;case"FirstPage":this.page=1}this.eventBus.dispatch("namedaction",{source:this,action:e})}async executeSetOCGState(e){const t=this.pdfDocument,i=await this.pdfViewer.optionalContentConfigPromise;if(t!==this.pdfDocument)return;let n;for(const t of e.state){switch(t){case"ON":case"OFF":case"Toggle":n=t;continue}switch(n){case"ON":i.setVisibility(t,!0);break;case"OFF":i.setVisibility(t,!1);break;case"Toggle":const e=i.getGroup(t);e&&i.setVisibility(t,!e.visible)}}this.pdfViewer.optionalContentConfigPromise=Promise.resolve(i)}cachePageRef(e,t){if(!t)return;const i=0===t.gen?`${t.num}R`:`${t.num}R${t.gen}`;this.#a.set(i,e)}_cachedPageNumber(e){if(!e)return null;const t=0===e.gen?`${e.num}R`:`${e.num}R${e.gen}`;return this.#a.get(t)||null}static#l(e){if(!Array.isArray(e))return!1;const t=e.length;if(t<2)return!1;const i=e[0];if(!("object"==typeof i&&Number.isInteger(i.num)&&Number.isInteger(i.gen)||Number.isInteger(i)&&i>=0))return!1;const n=e[1];if("object"!=typeof n||"string"!=typeof n.name)return!1;let s=!0;switch(n.name){case"XYZ":if(5!==t)return!1;break;case"Fit":case"FitB":return 2===t;case"FitH":case"FitBH":case"FitV":case"FitBV":if(3!==t)return!1;break;case"FitR":if(6!==t)return!1;s=!1;break;default:return!1}for(let i=2;i<t;i++){const t=e[i];if(!("number"==typeof t||s&&null===t))return!1}return!0}}t.PDFLinkService=a;t.SimpleLinkService=class{constructor(){this.externalLinkEnabled=!0}get pagesCount(){return 0}get page(){return 0}set page(e){}get rotation(){return 0}set rotation(e){}get isInPresentationMode(){return!1}async goToDestination(e){}goToPage(e){}addLinkAttributes(e,t,i=!1){o(e,{url:t,enabled:this.externalLinkEnabled})}getDestinationHash(e){return"#"}getAnchorUrl(e){return"#"}setHash(e){}executeNamedAction(e){}executeSetOCGState(e){}cachePageRef(e,t){}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.AltTextManager=void 0;var n=i(4);t.AltTextManager=class{#d=this.#h.bind(this);#c=this.#u.bind(this);#p=this.#g.bind(this);#m=null;#f;#v;#w;#b=!1;#_;#y;#P;#E;#S;#C;#L=null;#T=null;#M=null;#I;#A=null;constructor({dialog:e,optionDescription:t,optionDecorative:i,textarea:n,cancelButton:s,saveButton:o},a,r,l){this.#v=e,this.#_=t,this.#y=i,this.#S=n,this.#f=s,this.#E=o,this.#P=r,this.#w=l,this.#I=a,e.addEventListener("close",this.#x.bind(this)),e.addEventListener("contextmenu",(e=>{e.target!==this.#S&&e.preventDefault()})),s.addEventListener("click",this.#D.bind(this)),o.addEventListener("click",this.#N.bind(this)),t.addEventListener("change",this.#d),i.addEventListener("change",this.#d),this.#P.register(e)}get _elements(){return(0,n.shadow)(this,"_elements",[this.#_,this.#y,this.#S,this.#E,this.#f])}#B(){if(this.#T)return;const e=new n.DOMSVGFactory,t=this.#T=e.createElement("svg");t.setAttribute("width","0"),t.setAttribute("height","0");const i=e.createElement("defs");t.append(i);const s=e.createElement("mask");i.append(s),s.setAttribute("id","alttext-manager-mask"),s.setAttribute("maskContentUnits","objectBoundingBox");let o=e.createElement("rect");s.append(o),o.setAttribute("fill","white"),o.setAttribute("width","1"),o.setAttribute("height","1"),o.setAttribute("x","0"),o.setAttribute("y","0"),o=this.#M=e.createElement("rect"),s.append(o),o.setAttribute("fill","black"),this.#v.append(t)}async editAltText(e,t){if(this.#m||!t)return;this.#B(),this.#b=!1;for(const e of this._elements)e.addEventListener("click",this.#p);const{altText:i,decorative:n}=t.altTextData;!0===n?(this.#y.checked=!0,this.#_.checked=!1):(this.#y.checked=!1,this.#_.checked=!0),this.#L=this.#S.value=i?.trim()||"",this.#h(),this.#m=t,this.#C=e,this.#C.removeEditListeners(),this.#w._on("resize",this.#c);try{await this.#P.open(this.#v),this.#u()}catch(e){throw this.#x(),e}}#u(){if(!this.#m)return;const e=this.#v,{style:t}=e,{x:i,y:n,width:s,height:o}=this.#I.getBoundingClientRect(),{innerWidth:a,innerHeight:r}=window,{width:l,height:d}=e.getBoundingClientRect(),{x:h,y:c,width:u,height:p}=this.#m.getClientDimensions(),g=10,m="ltr"===this.#C.direction,f=Math.max(h,i),v=Math.min(h+u,i+s),w=Math.max(c,n),b=Math.min(c+p,n+o);this.#M.setAttribute("width",""+(v-f)/a),this.#M.setAttribute("height",""+(b-w)/r),this.#M.setAttribute("x",""+f/a),this.#M.setAttribute("y",""+w/r);let _=null,y=Math.max(c,0);y+=Math.min(r-(y+d),0),m?h+u+g+l<a?_=h+u+g:h>l+g&&(_=h-l-g):h>l+g?_=h-l-g:h+u+g+l<a&&(_=h+u+g),null===_&&(y=null,_=Math.max(h,0),_+=Math.min(a-(_+l),0),c>d+g?y=c-d-g:c+p+g+d<r&&(y=c+p+g)),null!==y?(e.classList.add("positioned"),m?t.left=`${_}px`:t.right=a-_-l+"px",t.top=`${y}px`):(e.classList.remove("positioned"),t.left="",t.top="")}#D(){this.#P.active===this.#v&&this.#P.close(this.#v)}#x(){this.#w.dispatch("reporttelemetry",{source:this,details:{type:"editing",subtype:this.#m.editorType,data:this.#A||{action:"alt_text_cancel",alt_text_keyboard:!this.#b}}}),this.#A=null,this.#k(),this.#C?.addEditListeners(),this.#w._off("resize",this.#c),this.#m=null,this.#C=null}#h(){this.#S.disabled=this.#y.checked}#N(){const e=this.#S.value.trim(),t=this.#y.checked;this.#m.altTextData={altText:e,decorative:t},this.#A={action:"alt_text_save",alt_text_description:!!e,alt_text_edit:!!this.#L&&this.#L!==e,alt_text_decorative:t,alt_text_keyboard:!this.#b},this.#D()}#g(e){0!==e.detail&&(this.#b=!0,this.#k())}#k(){for(const e of this._elements)e.removeEventListener("click",this.#p)}destroy(){this.#C=null,this.#D(),this.#T?.remove(),this.#T=this.#M=null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.AnnotationEditorParams=void 0;var n=i(4);t.AnnotationEditorParams=class{constructor(e,t){this.eventBus=t,this.#O(e)}#O({editorFreeTextFontSize:e,editorFreeTextColor:t,editorInkColor:i,editorInkThickness:s,editorInkOpacity:o,editorStampAddImage:a}){const r=(e,t)=>{this.eventBus.dispatch("switchannotationeditorparams",{source:this,type:n.AnnotationEditorParamsType[e],value:t})};e.addEventListener("input",(function(){r("FREETEXT_SIZE",this.valueAsNumber)})),t.addEventListener("input",(function(){r("FREETEXT_COLOR",this.value)})),i.addEventListener("input",(function(){r("INK_COLOR",this.value)})),s.addEventListener("input",(function(){r("INK_THICKNESS",this.valueAsNumber)})),o.addEventListener("input",(function(){r("INK_OPACITY",this.valueAsNumber)})),a.addEventListener("click",(()=>{r("CREATE")})),this.eventBus._on("annotationeditorparamschanged",(a=>{for(const[r,l]of a.details)switch(r){case n.AnnotationEditorParamsType.FREETEXT_SIZE:e.value=l;break;case n.AnnotationEditorParamsType.FREETEXT_COLOR:t.value=l;break;case n.AnnotationEditorParamsType.INK_COLOR:i.value=l;break;case n.AnnotationEditorParamsType.INK_THICKNESS:s.value=l;break;case n.AnnotationEditorParamsType.INK_OPACITY:o.value=l}}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.OverlayManager=void 0;t.OverlayManager=class{#V=new WeakMap;#R=null;get active(){return this.#R}async register(e,t=!1){if("object"!=typeof e)throw new Error("Not enough parameters.");if(this.#V.has(e))throw new Error("The overlay is already registered.");this.#V.set(e,{canForceClose:t}),e.addEventListener("cancel",(e=>{this.#R=null}))}async open(e){if(!this.#V.has(e))throw new Error("The overlay does not exist.");if(this.#R){if(this.#R===e)throw new Error("The overlay is already active.");if(!this.#V.get(e).canForceClose)throw new Error("Another overlay is currently active.");await this.close()}this.#R=e,e.showModal()}async close(e=this.#R){if(!this.#V.has(e))throw new Error("The overlay does not exist.");if(!this.#R)throw new Error("The overlay is currently not active.");if(this.#R!==e)throw new Error("Another overlay is currently active.");e.close(),this.#R=null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PasswordPrompt=void 0;var n=i(4);t.PasswordPrompt=class{#F=null;#U=null;#z=null;constructor(e,t,i,n=!1){this.dialog=e.dialog,this.label=e.label,this.input=e.input,this.submitButton=e.submitButton,this.cancelButton=e.cancelButton,this.overlayManager=t,this.l10n=i,this._isViewerEmbedded=n,this.submitButton.addEventListener("click",this.#H.bind(this)),this.cancelButton.addEventListener("click",this.close.bind(this)),this.input.addEventListener("keydown",(e=>{13===e.keyCode&&this.#H()})),this.overlayManager.register(this.dialog,!0),this.dialog.addEventListener("close",this.#W.bind(this))}async open(){this.#F&&await this.#F.promise,this.#F=new n.PromiseCapability;try{await this.overlayManager.open(this.dialog)}catch(e){throw this.#F.resolve(),e}const e=this.#z===n.PasswordResponses.INCORRECT_PASSWORD;this._isViewerEmbedded&&!e||this.input.focus(),this.label.textContent=await this.l10n.get("password_"+(e?"invalid":"label"))}async close(){this.overlayManager.active===this.dialog&&this.overlayManager.close(this.dialog)}#H(){const e=this.input.value;e?.length>0&&this.#$(e)}#W(){this.#$(new Error("PasswordPrompt cancelled.")),this.#F.resolve()}#$(e){this.#U&&(this.close(),this.input.value="",this.#U(e),this.#U=null)}async setUpdateCallback(e,t){this.#F&&await this.#F.promise,this.#U=e,this.#z=t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFAttachmentViewer=void 0;var n=i(4),s=i(13),o=i(6);class a extends s.BaseTreeViewer{constructor(e){super(e),this.downloadManager=e.downloadManager,this.eventBus._on("fileattachmentannotation",this.#j.bind(this))}reset(e=!1){super.reset(),this._attachments=null,e||(this._renderedCapability=new n.PromiseCapability),this._pendingDispatchEvent=!1}async _dispatchEvent(e){this._renderedCapability.resolve(),(0!==e||this._pendingDispatchEvent||(this._pendingDispatchEvent=!0,await(0,o.waitOnEventOrTimeout)({target:this.eventBus,name:"annotationlayerrendered",delay:1e3}),this._pendingDispatchEvent))&&(this._pendingDispatchEvent=!1,this.eventBus.dispatch("attachmentsloaded",{source:this,attachmentsCount:e}))}_bindLink(e,{content:t,filename:i}){e.onclick=()=>(this.downloadManager.openOrDownloadData(e,t,i),!1)}render({attachments:e,keepRenderedCapability:t=!1}){if(this._attachments&&this.reset(t),this._attachments=e||null,!e)return void this._dispatchEvent(0);const i=document.createDocumentFragment();let s=0;for(const t in e){const o=e[t],a=o.content,r=(0,n.getFilenameFromUrl)(o.filename,!0),l=document.createElement("div");l.className="treeItem";const d=document.createElement("a");this._bindLink(d,{content:a,filename:r}),d.textContent=this._normalizeTextContent(r),l.append(d),i.append(l),s++}this._finishRendering(i,s)}#j({filename:e,content:t}){const i=this._renderedCapability.promise;i.then((()=>{if(i!==this._renderedCapability.promise)return;const n=this._attachments||Object.create(null);for(const t in n)if(e===t)return;n[e]={filename:e,content:t},this.render({attachments:n,keepRenderedCapability:!0})}))}}t.PDFAttachmentViewer=a},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BaseTreeViewer=void 0;var n=i(3);const s="selected";class o{constructor(e){if(this.constructor===o)throw new Error("Cannot initialize BaseTreeViewer.");this.container=e.container,this.eventBus=e.eventBus,this.reset()}reset(){this._pdfDocument=null,this._lastToggleIsShow=!0,this._currentTreeItem=null,this.container.textContent="",this.container.classList.remove("treeWithDeepNesting")}_dispatchEvent(e){throw new Error("Not implemented: _dispatchEvent")}_bindLink(e,t){throw new Error("Not implemented: _bindLink")}_normalizeTextContent(e){return(0,n.removeNullCharacters)(e,!0)||"–"}_addToggleButton(e,t=!1){const i=document.createElement("div");i.className="treeItemToggler",t&&i.classList.add("treeItemsHidden"),i.onclick=t=>{if(t.stopPropagation(),i.classList.toggle("treeItemsHidden"),t.shiftKey){const t=!i.classList.contains("treeItemsHidden");this._toggleTreeItem(e,t)}},e.prepend(i)}_toggleTreeItem(e,t=!1){this._lastToggleIsShow=t;for(const i of e.querySelectorAll(".treeItemToggler"))i.classList.toggle("treeItemsHidden",!t)}_toggleAllTreeItems(){this._toggleTreeItem(this.container,!this._lastToggleIsShow)}_finishRendering(e,t,i=!1){i&&(this.container.classList.add("treeWithDeepNesting"),this._lastToggleIsShow=!e.querySelector(".treeItemsHidden")),this.container.append(e),this._dispatchEvent(t)}render(e){throw new Error("Not implemented: render")}_updateCurrentTreeItem(e=null){this._currentTreeItem&&(this._currentTreeItem.classList.remove(s),this._currentTreeItem=null),e&&(e.classList.add(s),this._currentTreeItem=e)}_scrollToCurrentTreeItem(e){if(!e)return;let t=e.parentNode;for(;t&&t!==this.container;){if(t.classList.contains("treeItem")){const e=t.firstElementChild;e?.classList.remove("treeItemsHidden")}t=t.parentNode}this._updateCurrentTreeItem(e),this.container.scrollTo(e.offsetLeft,e.offsetTop+-100)}}t.BaseTreeViewer=o},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFCursorTools=void 0;var n=i(4),s=i(3),o=i(15);t.PDFCursorTools=class{#R=s.CursorTool.SELECT;#G=null;constructor({container:e,eventBus:t,cursorToolOnLoad:i=s.CursorTool.SELECT}){this.container=e,this.eventBus=t,this.#X(),Promise.resolve().then((()=>{this.switchTool(i)}))}get activeTool(){return this.#R}switchTool(e){if(null!==this.#G)return;if(e===this.#R)return;const t=()=>{switch(this.#R){case s.CursorTool.SELECT:break;case s.CursorTool.HAND:this._handTool.deactivate();case s.CursorTool.ZOOM:}};switch(e){case s.CursorTool.SELECT:t();break;case s.CursorTool.HAND:t(),this._handTool.activate();break;case s.CursorTool.ZOOM:default:return void console.error(`switchTool: "${e}" is an unsupported value.`)}this.#R=e,this.eventBus.dispatch("cursortoolchanged",{source:this,tool:e})}#X(){this.eventBus._on("switchcursortool",(e=>{this.switchTool(e.tool)}));let e=n.AnnotationEditorType.NONE,t=s.PresentationModeState.NORMAL;const i=()=>{const e=this.#R;this.switchTool(s.CursorTool.SELECT),this.#G??=e},o=()=>{const i=this.#G;null!==i&&e===n.AnnotationEditorType.NONE&&t===s.PresentationModeState.NORMAL&&(this.#G=null,this.switchTool(i))};this.eventBus._on("secondarytoolbarreset",(i=>{null!==this.#G&&(e=n.AnnotationEditorType.NONE,t=s.PresentationModeState.NORMAL,o())})),this.eventBus._on("annotationeditormodechanged",(({mode:t})=>{e=t,t===n.AnnotationEditorType.NONE?o():i()})),this.eventBus._on("presentationmodechanged",(({state:e})=>{t=e,e===s.PresentationModeState.NORMAL?o():e===s.PresentationModeState.FULLSCREEN&&i()}))}get _handTool(){return(0,n.shadow)(this,"_handTool",new o.GrabToPan({element:this.container}))}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GrabToPan=void 0;const i="grab-to-pan-grab";t.GrabToPan=class{constructor({element:e}){this.element=e,this.document=e.ownerDocument,this.activate=this.activate.bind(this),this.deactivate=this.deactivate.bind(this),this.toggle=this.toggle.bind(this),this._onMouseDown=this.#K.bind(this),this._onMouseMove=this.#Z.bind(this),this._endPan=this.#Q.bind(this);(this.overlay=document.createElement("div")).className="grab-to-pan-grabbing"}activate(){this.active||(this.active=!0,this.element.addEventListener("mousedown",this._onMouseDown,!0),this.element.classList.add(i))}deactivate(){this.active&&(this.active=!1,this.element.removeEventListener("mousedown",this._onMouseDown,!0),this._endPan(),this.element.classList.remove(i))}toggle(){this.active?this.deactivate():this.activate()}ignoreTarget(e){return e.matches("a[href], a[href] *, input, textarea, button, button *, select, option")}#K(e){if(0!==e.button||this.ignoreTarget(e.target))return;if(e.originalTarget)try{e.originalTarget.tagName}catch{return}this.scrollLeftStart=this.element.scrollLeft,this.scrollTopStart=this.element.scrollTop,this.clientXStart=e.clientX,this.clientYStart=e.clientY,this.document.addEventListener("mousemove",this._onMouseMove,!0),this.document.addEventListener("mouseup",this._endPan,!0),this.element.addEventListener("scroll",this._endPan,!0),e.preventDefault(),e.stopPropagation();const t=document.activeElement;t&&!t.contains(e.target)&&t.blur()}#Z(e){if(this.element.removeEventListener("scroll",this._endPan,!0),!(1&e.buttons))return void this._endPan();const t=e.clientX-this.clientXStart,i=e.clientY-this.clientYStart;this.element.scrollTo({top:this.scrollTopStart-i,left:this.scrollLeftStart-t,behavior:"instant"}),this.overlay.parentNode||document.body.append(this.overlay)}#Q(){this.element.removeEventListener("scroll",this._endPan,!0),this.document.removeEventListener("mousemove",this._onMouseMove,!0),this.document.removeEventListener("mouseup",this._endPan,!0),this.overlay.remove()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFDocumentProperties=void 0;var n=i(3),s=i(4);const o=["en-us","en-lr","my"],a={"8.5x11":"Letter","8.5x14":"Legal"},r={"297x420":"A3","210x297":"A4"};function l(e,t,i){return i[`${t?e.width:e.height}x${t?e.height:e.width}`]}t.PDFDocumentProperties=class{#q=null;constructor({dialog:e,fields:t,closeButton:i},n,s,a,r){this.dialog=e,this.fields=t,this.overlayManager=n,this.l10n=a,this._fileNameLookup=r,this.#Y(),i.addEventListener("click",this.close.bind(this)),this.overlayManager.register(this.dialog),s._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber})),s._on("rotationchanging",(e=>{this._pagesRotation=e.pagesRotation})),this._isNonMetricLocale=!0,a.getLanguage().then((e=>{this._isNonMetricLocale=o.includes(e)}))}async open(){await Promise.all([this.overlayManager.open(this.dialog),this._dataAvailableCapability.promise]);const e=this._currentPageNumber,t=this._pagesRotation;if(this.#q&&e===this.#q._currentPageNumber&&t===this.#q._pagesRotation)return void this.#J();const{info:i,contentLength:s}=await this.pdfDocument.getMetadata(),[o,a,r,l,d,h]=await Promise.all([this._fileNameLookup(),this.#ee(s),this.#te(i.CreationDate),this.#te(i.ModDate),this.pdfDocument.getPage(e).then((e=>this.#ie((0,n.getPageSizeInches)(e),t))),this.#ne(i.IsLinearized)]);this.#q=Object.freeze({fileName:o,fileSize:a,title:i.Title,author:i.Author,subject:i.Subject,keywords:i.Keywords,creationDate:r,modificationDate:l,creator:i.Creator,producer:i.Producer,version:i.PDFFormatVersion,pageCount:this.pdfDocument.numPages,pageSize:d,linearized:h,_currentPageNumber:e,_pagesRotation:t}),this.#J();const{length:c}=await this.pdfDocument.getDownloadInfo();if(s===c)return;const u=Object.assign(Object.create(null),this.#q);u.fileSize=await this.#ee(c),this.#q=Object.freeze(u),this.#J()}async close(){this.overlayManager.close(this.dialog)}setDocument(e){this.pdfDocument&&(this.#Y(),this.#J(!0)),e&&(this.pdfDocument=e,this._dataAvailableCapability.resolve())}#Y(){this.pdfDocument=null,this.#q=null,this._dataAvailableCapability=new s.PromiseCapability,this._currentPageNumber=1,this._pagesRotation=0}#J(e=!1){if(!e&&this.#q){if(this.overlayManager.active===this.dialog)for(const e in this.fields){const t=this.#q[e];this.fields[e].textContent=t||0===t?t:"-"}}else for(const e in this.fields)this.fields[e].textContent="-"}async#ee(e=0){const t=e/1024,i=t/1024;if(t)return this.l10n.get("document_properties_"+(i>=1?"mb":"kb"),{size_mb:i>=1&&(+i.toPrecision(3)).toLocaleString(),size_kb:i<1&&(+t.toPrecision(3)).toLocaleString(),size_b:e.toLocaleString()})}async#ie(e,t){if(!e)return;t%180!=0&&(e={width:e.height,height:e.width});const i=(0,n.isPortraitOrientation)(e);let s={width:Math.round(100*e.width)/100,height:Math.round(100*e.height)/100},o={width:Math.round(25.4*e.width*10)/10,height:Math.round(25.4*e.height*10)/10},d=l(s,i,a)||l(o,i,r);if(!(d||Number.isInteger(o.width)&&Number.isInteger(o.height))){const t={width:25.4*e.width,height:25.4*e.height},n={width:Math.round(o.width),height:Math.round(o.height)};Math.abs(t.width-n.width)<.1&&Math.abs(t.height-n.height)<.1&&(d=l(n,i,r),d&&(s={width:Math.round(n.width/25.4*100)/100,height:Math.round(n.height/25.4*100)/100},o=n))}const[{width:h,height:c},u,p,g]=await Promise.all([this._isNonMetricLocale?s:o,this.l10n.get("document_properties_page_size_unit_"+(this._isNonMetricLocale?"inches":"millimeters")),d&&this.l10n.get(`document_properties_page_size_name_${d.toLowerCase()}`),this.l10n.get("document_properties_page_size_orientation_"+(i?"portrait":"landscape"))]);return this.l10n.get(`document_properties_page_size_dimension_${p?"name_":""}string`,{width:h.toLocaleString(),height:c.toLocaleString(),unit:u,name:p,orientation:g})}async#te(e){const t=s.PDFDateString.toDateObject(e);if(t)return this.l10n.get("document_properties_date_string",{date:t.toLocaleDateString(),time:t.toLocaleTimeString()})}#ne(e){return this.l10n.get("document_properties_linearized_"+(e?"yes":"no"))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFFindBar=void 0;var n=i(18),s=i(3);t.PDFFindBar=class{constructor(e,t,i){this.opened=!1,this.bar=e.bar,this.toggleButton=e.toggleButton,this.findField=e.findField,this.highlightAll=e.highlightAllCheckbox,this.caseSensitive=e.caseSensitiveCheckbox,this.matchDiacritics=e.matchDiacriticsCheckbox,this.entireWord=e.entireWordCheckbox,this.findMsg=e.findMsg,this.findResultsCount=e.findResultsCount,this.findPreviousButton=e.findPreviousButton,this.findNextButton=e.findNextButton,this.eventBus=t,this.l10n=i,this.toggleButton.addEventListener("click",(()=>{this.toggle()})),this.findField.addEventListener("input",(()=>{this.dispatchEvent("")})),this.bar.addEventListener("keydown",(e=>{switch(e.keyCode){case 13:e.target===this.findField&&this.dispatchEvent("again",e.shiftKey);break;case 27:this.close()}})),this.findPreviousButton.addEventListener("click",(()=>{this.dispatchEvent("again",!0)})),this.findNextButton.addEventListener("click",(()=>{this.dispatchEvent("again",!1)})),this.highlightAll.addEventListener("click",(()=>{this.dispatchEvent("highlightallchange")})),this.caseSensitive.addEventListener("click",(()=>{this.dispatchEvent("casesensitivitychange")})),this.entireWord.addEventListener("click",(()=>{this.dispatchEvent("entirewordchange")})),this.matchDiacritics.addEventListener("click",(()=>{this.dispatchEvent("diacriticmatchingchange")})),this.eventBus._on("resize",this.#se.bind(this))}reset(){this.updateUIState()}dispatchEvent(e,t=!1){this.eventBus.dispatch("find",{source:this,type:e,query:this.findField.value,caseSensitive:this.caseSensitive.checked,entireWord:this.entireWord.checked,highlightAll:this.highlightAll.checked,findPrevious:t,matchDiacritics:this.matchDiacritics.checked})}updateUIState(e,t,i){let s=Promise.resolve(""),o="";switch(e){case n.FindState.FOUND:break;case n.FindState.PENDING:o="pending";break;case n.FindState.NOT_FOUND:s=this.l10n.get("find_not_found"),o="notFound";break;case n.FindState.WRAPPED:s=this.l10n.get("find_reached_"+(t?"top":"bottom"))}this.findField.setAttribute("data-status",o),this.findField.setAttribute("aria-invalid",e===n.FindState.NOT_FOUND),s.then((e=>{this.findMsg.setAttribute("data-status",o),this.findMsg.textContent=e,this.#se()})),this.updateResultsCount(i)}updateResultsCount({current:e=0,total:t=0}={}){let i=Promise.resolve("");if(t>0)if(t>1e3){let e="find_match_count_limit";i=this.l10n.get(e,{limit:1e3})}else{let n="find_match_count";i=this.l10n.get(n,{current:e,total:t})}i.then((e=>{this.findResultsCount.textContent=e,this.#se()}))}open(){this.opened||(this.opened=!0,(0,s.toggleExpandedBtn)(this.toggleButton,!0,this.bar)),this.findField.select(),this.findField.focus(),this.#se()}close(){this.opened&&(this.opened=!1,(0,s.toggleExpandedBtn)(this.toggleButton,!1,this.bar),this.eventBus.dispatch("findbarclose",{source:this}))}toggle(){this.opened?this.close():this.open()}#se(){if(!this.opened)return;this.bar.classList.remove("wrapContainers");this.bar.clientHeight>this.bar.firstElementChild.clientHeight&&this.bar.classList.add("wrapContainers")}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFFindController=t.FindState=void 0;var n=i(3),s=i(19),o=i(4);const a={FOUND:0,NOT_FOUND:1,WRAPPED:2,PENDING:3};t.FindState=a;const r={"‐":"-","‘":"'","’":"'","‚":"'","‛":"'","“":'"',"”":'"',"„":'"',"‟":'"',"¼":"1/4","½":"1/2","¾":"3/4"},l=new Set([12441,12442,2381,2509,2637,2765,2893,3021,3149,3277,3387,3388,3405,3530,3642,3770,3972,4153,4154,5908,5940,6098,6752,6980,7082,7083,7154,7155,11647,43014,43052,43204,43347,43456,43766,44013,3158,3953,3954,3962,3963,3964,3965,3968,3956]);let d;const h=/\p{M}+/gu,c=/([.*+?^${}()|[\]\\])|(\p{P})|(\s+)|(\p{M})|(\p{L})/gu,u=/([^\p{M}])\p{M}*$/u,p=/^\p{M}*([^\p{M}])/u,g=/[\uAC00-\uD7AF\uFA6C\uFACF-\uFAD1\uFAD5-\uFAD7]+/g,m=new Map,f=new Map;let v=null,w=null;function b(e){const t=[];let i,n;for(;null!==(i=g.exec(e));){let{index:e}=i;for(const n of i[0]){let i=m.get(n);i||(i=n.normalize("NFD").length,m.set(n,i)),t.push([i,e++])}}if(0===t.length&&v)n=v;else if(t.length>0&&w)n=w;else{const e=`([${Object.keys(r).join("")}])|([${(0,s.getNormalizeWithNFKC)()}])|(${"(?:゙|゚)"}\\n)|(\\p{M}+(?:-\\n)?)|(\\S-\\n)|(${"(?:\\p{Ideographic}|[぀-ヿ])"}\\n)|(\\n)`;n=0===t.length?v=new RegExp(e+"|(\\u0000)","gum"):w=new RegExp(e+"|([\\u1100-\\u1112\\ud7a4-\\ud7af\\ud84a\\ud84c\\ud850\\ud854\\ud857\\ud85f])","gum")}const o=[];for(;null!==(i=h.exec(e));)o.push([i[0].length,i.index]);let a=e.normalize("NFD");const l=[[0,0]];let d=0,c=0,u=0,p=0,b=0,_=!1;return a=a.replace(n,((e,i,n,s,a,h,g,m,v,w)=>{if(w-=p,i){const e=r[i],t=e.length;for(let e=1;e<t;e++)l.push([w-u+e,u-e]);return u-=t-1,e}if(n){let e=f.get(n);e||(e=n.normalize("NFKC"),f.set(n,e));const t=e.length;for(let e=1;e<t;e++)l.push([w-u+e,u-e]);return u-=t-1,e}if(s)return _=!0,w+b===o[d]?.[1]?++d:(l.push([w-1-u+1,u-1]),u-=1,p+=1),l.push([w-u+1,u]),p+=1,b+=1,s.charAt(0);if(a){const e=a.endsWith("\n"),t=e?a.length-2:a.length;_=!0;let i=t;w+b===o[d]?.[1]&&(i-=o[d][0],++d);for(let e=1;e<=i;e++)l.push([w-1-u+e,u-e]);return u-=i,p+=i,e?(w+=t-1,l.push([w-u+1,1+u]),u+=1,p+=1,b+=1,a.slice(0,t)):a}if(h){const e=h.length-2;return l.push([w-u+e,1+u]),u+=1,p+=1,b+=1,h.slice(0,-2)}if(g){const e=g.length-1;return l.push([w-u+e,u]),p+=1,b+=1,g.slice(0,-1)}if(m)return l.push([w-u+1,u-1]),u-=1,p+=1,b+=1," ";if(w+b===t[c]?.[1]){const e=t[c][0]-1;++c;for(let t=1;t<=e;t++)l.push([w-(u-t),u-t]);u-=e,p+=e}return v})),l.push([a.length,u]),[a,l,_]}function _(e,t,i){if(!e)return[t,i];const s=t,o=t+i-1;let a=(0,n.binarySearchFirstItem)(e,(e=>e[0]>=s));e[a][0]>s&&--a;let r=(0,n.binarySearchFirstItem)(e,(e=>e[0]>=o),a);e[r][0]>o&&--r;const l=s+e[a][1];return[l,o+e[r][1]+1-l]}t.PDFFindController=class{#oe=null;#ae=!0;#re=0;constructor({linkService:e,eventBus:t,updateMatchesCountOnProgress:i=!0}){this._linkService=e,this._eventBus=t,this.#ae=i,this.onIsPageVisible=null,this.#Y(),t._on("find",this.#le.bind(this)),t._on("findbarclose",this.#de.bind(this))}get highlightMatches(){return this._highlightMatches}get pageMatches(){return this._pageMatches}get pageMatchesLength(){return this._pageMatchesLength}get selected(){return this._selected}get state(){return this.#oe}setDocument(e){this._pdfDocument&&this.#Y(),e&&(this._pdfDocument=e,this._firstPageCapability.resolve())}#le(e){if(!e)return;!1===e.phraseSearch&&(console.error("The `phraseSearch`-parameter was removed, please provide an Array of strings in the `query`-parameter instead."),"string"==typeof e.query&&(e.query=e.query.match(/\S+/g)));const t=this._pdfDocument,{type:i}=e;(null===this.#oe||this.#he(e))&&(this._dirtyMatch=!0),this.#oe=e,"highlightallchange"!==i&&this.#h(a.PENDING),this._firstPageCapability.promise.then((()=>{if(!this._pdfDocument||t&&this._pdfDocument!==t)return;this.#ce();const e=!this._highlightMatches,n=!!this._findTimeout;this._findTimeout&&(clearTimeout(this._findTimeout),this._findTimeout=null),i?this._dirtyMatch?this.#ue():"again"===i?(this.#ue(),e&&this.#oe.highlightAll&&this.#pe()):"highlightallchange"===i?(n?this.#ue():this._highlightMatches=!0,this.#pe()):this.#ue():this._findTimeout=setTimeout((()=>{this.#ue(),this._findTimeout=null}),250)}))}scrollMatchIntoView({element:e=null,selectedLeft:t=0,pageIndex:i=-1,matchIndex:s=-1}){if(!this._scrollMatches||!e)return;if(-1===s||s!==this._selected.matchIdx)return;if(-1===i||i!==this._selected.pageIdx)return;this._scrollMatches=!1;const o={top:-50,left:t+-400};(0,n.scrollIntoView)(e,o,!0)}#Y(){this._highlightMatches=!1,this._scrollMatches=!1,this._pdfDocument=null,this._pageMatches=[],this._pageMatchesLength=[],this.#re=0,this.#oe=null,this._selected={pageIdx:-1,matchIdx:-1},this._offset={pageIdx:null,matchIdx:null,wrapped:!1},this._extractTextPromises=[],this._pageContents=[],this._pageDiffs=[],this._hasDiacritics=[],this._matchesCountTotal=0,this._pagesToSearch=null,this._pendingFindMatches=new Set,this._resumePageIdx=null,this._dirtyMatch=!1,clearTimeout(this._findTimeout),this._findTimeout=null,this._firstPageCapability=new o.PromiseCapability}get#ge(){const{query:e}=this.#oe;return"string"==typeof e?(e!==this._rawQuery&&(this._rawQuery=e,[this._normalizedQuery]=b(e)),this._normalizedQuery):(e||[]).filter((e=>!!e)).map((e=>b(e)[0]))}#he(e){const t=e.query,i=this.#oe.query,n=typeof t;if(n!==typeof i)return!0;if("string"===n){if(t!==i)return!0}else if(JSON.stringify(t)!==JSON.stringify(i))return!0;switch(e.type){case"again":const e=this._selected.pageIdx+1,t=this._linkService;return e>=1&&e<=t.pagesCount&&e!==t.page&&!(this.onIsPageVisible?.(e)??1);case"highlightallchange":return!1}return!0}#me(e,t,i){let n=e.slice(0,t).match(u);if(n){const i=e.charCodeAt(t),o=n[1].charCodeAt(0);if((0,s.getCharacterType)(i)===(0,s.getCharacterType)(o))return!1}if(n=e.slice(t+i).match(p),n){const o=e.charCodeAt(t+i-1),a=n[1].charCodeAt(0);if((0,s.getCharacterType)(o)===(0,s.getCharacterType)(a))return!1}return!0}#fe(e,t,i,n){const s=this._pageMatches[i]=[],o=this._pageMatchesLength[i]=[];if(!e)return;const a=this._pageDiffs[i];let r;for(;null!==(r=e.exec(n));){if(t&&!this.#me(n,r.index,r[0].length))continue;const[e,i]=_(a,r.index,r[0].length);i&&(s.push(e),o.push(i))}}#ve(e,t){const{matchDiacritics:i}=this.#oe;let n=!1;const s="[ ]*";return(e=e.replaceAll(c,((e,s,o,a,r,d)=>s?`[ ]*\\${s}[ ]*`:o?`[ ]*${o}[ ]*`:a?"[ ]+":i?r||d:r?l.has(r.charCodeAt(0))?r:"":t?(n=!0,`${d}\\p{M}*`):d))).endsWith(s)&&(e=e.slice(0,e.length-4)),i&&t&&(d||=String.fromCharCode(...l),n=!0,e=`${e}(?=[${d}]|[^\\p{M}]|$)`),[n,e]}#we(e){let t=this.#ge;if(0===t.length)return;const{caseSensitive:i,entireWord:n}=this.#oe,s=this._pageContents[e],o=this._hasDiacritics[e];let a=!1;"string"==typeof t?[a,t]=this.#ve(t,o):t=t.sort().reverse().map((e=>{const[t,i]=this.#ve(e,o);return a||=t,`(${i})`})).join("|");t=t?new RegExp(t,`g${a?"u":""}${i?"":"i"}`):null,this.#fe(t,n,e,s),this.#oe.highlightAll&&this.#be(e),this._resumePageIdx===e&&(this._resumePageIdx=null,this.#_e());const r=this._pageMatches[e].length;this._matchesCountTotal+=r,this.#ae?r>0&&this.#ye():++this.#re===this._linkService.pagesCount&&this.#ye()}#ce(){if(this._extractTextPromises.length>0)return;let e=Promise.resolve();const t={disableNormalization:!0};for(let i=0,n=this._linkService.pagesCount;i<n;i++){const n=new o.PromiseCapability;this._extractTextPromises[i]=n.promise,e=e.then((()=>this._pdfDocument.getPage(i+1).then((e=>e.getTextContent(t))).then((e=>{const t=[];for(const i of e.items)t.push(i.str),i.hasEOL&&t.push("\n");[this._pageContents[i],this._pageDiffs[i],this._hasDiacritics[i]]=b(t.join("")),n.resolve()}),(e=>{console.error(`Unable to get text content for page ${i+1}`,e),this._pageContents[i]="",this._pageDiffs[i]=null,this._hasDiacritics[i]=!1,n.resolve()}))))}}#be(e){this._scrollMatches&&this._selected.pageIdx===e&&(this._linkService.page=e+1),this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:e})}#pe(){this._eventBus.dispatch("updatetextlayermatches",{source:this,pageIndex:-1})}#ue(){const e=this.#oe.findPrevious,t=this._linkService.page-1,i=this._linkService.pagesCount;if(this._highlightMatches=!0,this._dirtyMatch){this._dirtyMatch=!1,this._selected.pageIdx=this._selected.matchIdx=-1,this._offset.pageIdx=t,this._offset.matchIdx=null,this._offset.wrapped=!1,this._resumePageIdx=null,this._pageMatches.length=0,this._pageMatchesLength.length=0,this.#re=0,this._matchesCountTotal=0,this.#pe();for(let e=0;e<i;e++)this._pendingFindMatches.has(e)||(this._pendingFindMatches.add(e),this._extractTextPromises[e].then((()=>{this._pendingFindMatches.delete(e),this.#we(e)})))}if(0===this.#ge.length)return void this.#h(a.FOUND);if(this._resumePageIdx)return;const n=this._offset;if(this._pagesToSearch=i,null!==n.matchIdx){const t=this._pageMatches[n.pageIdx].length;if(!e&&n.matchIdx+1<t||e&&n.matchIdx>0)return n.matchIdx=e?n.matchIdx-1:n.matchIdx+1,void this.#Pe(!0);this.#Ee(e)}this.#_e()}#Se(e){const t=this._offset,i=e.length,n=this.#oe.findPrevious;return i?(t.matchIdx=n?i-1:0,this.#Pe(!0),!0):(this.#Ee(n),!!(t.wrapped&&(t.matchIdx=null,this._pagesToSearch<0))&&(this.#Pe(!1),!0))}#_e(){null!==this._resumePageIdx&&console.error("There can only be one pending page.");let e=null;do{const t=this._offset.pageIdx;if(e=this._pageMatches[t],!e){this._resumePageIdx=t;break}}while(!this.#Se(e))}#Ee(e){const t=this._offset,i=this._linkService.pagesCount;t.pageIdx=e?t.pageIdx-1:t.pageIdx+1,t.matchIdx=null,this._pagesToSearch--,(t.pageIdx>=i||t.pageIdx<0)&&(t.pageIdx=e?i-1:0,t.wrapped=!0)}#Pe(e=!1){let t=a.NOT_FOUND;const i=this._offset.wrapped;if(this._offset.wrapped=!1,e){const e=this._selected.pageIdx;this._selected.pageIdx=this._offset.pageIdx,this._selected.matchIdx=this._offset.matchIdx,t=i?a.WRAPPED:a.FOUND,-1!==e&&e!==this._selected.pageIdx&&this.#be(e)}this.#h(t,this.#oe.findPrevious),-1!==this._selected.pageIdx&&(this._scrollMatches=!0,this.#be(this._selected.pageIdx))}#de(e){const t=this._pdfDocument;this._firstPageCapability.promise.then((()=>{!this._pdfDocument||t&&this._pdfDocument!==t||(this._findTimeout&&(clearTimeout(this._findTimeout),this._findTimeout=null),this._resumePageIdx&&(this._resumePageIdx=null,this._dirtyMatch=!0),this.#h(a.FOUND),this._highlightMatches=!1,this.#pe())}))}#Ce(){const{pageIdx:e,matchIdx:t}=this._selected;let i=0,n=this._matchesCountTotal;if(-1!==t){for(let t=0;t<e;t++)i+=this._pageMatches[t]?.length||0;i+=t+1}return(i<1||i>n)&&(i=n=0),{current:i,total:n}}#ye(){this._eventBus.dispatch("updatefindmatchescount",{source:this,matchesCount:this.#Ce()})}#h(e,t=!1){(this.#ae||this.#re===this._linkService.pagesCount&&e!==a.PENDING)&&this._eventBus.dispatch("updatefindcontrolstate",{source:this,state:e,previous:t,matchesCount:this.#Ce(),rawQuery:this.#oe?.query??null})}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.CharacterType=void 0,t.getCharacterType=function(e){if(function(e){return e<11904}(e))return function(e){return 0==(65408&e)}(e)?function(e){return 32===e||9===e||13===e||10===e}(e)?i.SPACE:function(e){return e>=97&&e<=122||e>=65&&e<=90}(e)||function(e){return e>=48&&e<=57}(e)||95===e?i.ALPHA_LETTER:i.PUNCT:function(e){return 3584==(65408&e)}(e)?i.THAI_LETTER:160===e?i.SPACE:i.ALPHA_LETTER;if(function(e){return e>=13312&&e<=40959||e>=63744&&e<=64255}(e))return i.HAN_LETTER;if(function(e){return e>=12448&&e<=12543}(e))return i.KATAKANA_LETTER;if(function(e){return e>=12352&&e<=12447}(e))return i.HIRAGANA_LETTER;if(function(e){return e>=65376&&e<=65439}(e))return i.HALFWIDTH_KATAKANA_LETTER;return i.ALPHA_LETTER},t.getNormalizeWithNFKC=function(){return n||=" ¨ª¯²-µ¸-º¼-¾Ĳ-ĳĿ-ŀŉſǄ-ǌǱ-ǳʰ-ʸ˘-˝ˠ-ˤʹͺ;΄-΅·ϐ-ϖϰ-ϲϴ-ϵϹևٵ-ٸक़-य़ড়-ঢ়য়ਲ਼ਸ਼ਖ਼-ਜ਼ਫ਼ଡ଼-ଢ଼ำຳໜ-ໝ༌གྷཌྷདྷབྷཛྷཀྵჼᴬ-ᴮᴰ-ᴺᴼ-ᵍᵏ-ᵪᵸᶛ-ᶿẚ-ẛάέήίόύώΆ᾽-῁ΈΉ῍-῏ΐΊ῝-῟ΰΎ῭-`ΌΏ´-῾ - ‑‗․-… ″-‴‶-‷‼‾⁇-⁉⁗ ⁰-ⁱ⁴-₎ₐ-ₜ₨℀-℃℅-ℇ℉-ℓℕ-№ℙ-ℝ℠-™ℤΩℨK-ℭℯ-ℱℳ-ℹ℻-⅀ⅅ-ⅉ⅐-ⅿ↉∬-∭∯-∰〈-〉①-⓪⨌⩴-⩶⫝̸ⱼ-ⱽⵯ⺟⻳⼀-⿕　〶〸-〺゛-゜ゟヿㄱ-ㆎ㆒-㆟㈀-㈞㈠-㉇㉐-㉾㊀-㏿ꚜ-ꚝꝰꟲ-ꟴꟸ-ꟹꭜ-ꭟꭩ豈-嗀塚晴凞-羽蘒諸逸-都飯-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-זּטּ-לּמּנּ-סּףּ-פּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-﷼︐-︙︰-﹄﹇-﹒﹔-﹦﹨-﹫ﹰ-ﹲﹴﹶ-ﻼ！-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ￠-￦",n};const i={SPACE:0,ALPHA_LETTER:1,PUNCT:2,HAN_LETTER:3,KATAKANA_LETTER:4,HIRAGANA_LETTER:5,HALFWIDTH_KATAKANA_LETTER:6,THAI_LETTER:7};let n;t.CharacterType=i},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFHistory=void 0,t.isDestArraysEqual=r,t.isDestHashesEqual=a;var n=i(3),s=i(6);function o(){return document.location.hash}function a(e,t){if("string"!=typeof e||"string"!=typeof t)return!1;if(e===t)return!0;return(0,n.parseQueryString)(e).get("nameddest")===t}function r(e,t){function i(e,t){if(typeof e!=typeof t)return!1;if(Array.isArray(e)||Array.isArray(t))return!1;if(null!==e&&"object"==typeof e&&null!==t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const n in e)if(!i(e[n],t[n]))return!1;return!0}return e===t||Number.isNaN(e)&&Number.isNaN(t)}if(!Array.isArray(e)||!Array.isArray(t))return!1;if(e.length!==t.length)return!1;for(let n=0,s=e.length;n<s;n++)if(!i(e[n],t[n]))return!1;return!0}t.PDFHistory=class{constructor({linkService:e,eventBus:t}){this.linkService=e,this.eventBus=t,this._initialized=!1,this._fingerprint="",this.reset(),this._boundEvents=null,this.eventBus._on("pagesinit",(()=>{this._isPagesLoaded=!1,this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount}),{once:!0})}))}initialize({fingerprint:e,resetHistory:t=!1,updateUrl:i=!1}){if(!e||"string"!=typeof e)return void console.error('PDFHistory.initialize: The "fingerprint" must be a non-empty string.');this._initialized&&this.reset();const n=""!==this._fingerprint&&this._fingerprint!==e;this._fingerprint=e,this._updateUrl=!0===i,this._initialized=!0,this._bindEvents();const s=window.history.state;if(this._popStateInProgress=!1,this._blockHashChange=0,this._currentHash=o(),this._numPositionUpdates=0,this._uid=this._maxUid=0,this._destination=null,this._position=null,!this._isValidState(s,!0)||t){const{hash:e,page:i,rotation:s}=this._parseCurrentHash(!0);return!e||n||t?void this._pushOrReplaceState(null,!0):void this._pushOrReplaceState({hash:e,page:i,rotation:s},!0)}const a=s.destination;this._updateInternalState(a,s.uid,!0),void 0!==a.rotation&&(this._initialRotation=a.rotation),a.dest?(this._initialBookmark=JSON.stringify(a.dest),this._destination.page=null):a.hash?this._initialBookmark=a.hash:a.page&&(this._initialBookmark=`page=${a.page}`)}reset(){this._initialized&&(this._pageHide(),this._initialized=!1,this._unbindEvents()),this._updateViewareaTimeout&&(clearTimeout(this._updateViewareaTimeout),this._updateViewareaTimeout=null),this._initialBookmark=null,this._initialRotation=null}push({namedDest:e=null,explicitDest:t,pageNumber:i}){if(!this._initialized)return;if(e&&"string"!=typeof e)return void console.error(`PDFHistory.push: "${e}" is not a valid namedDest parameter.`);if(!Array.isArray(t))return void console.error(`PDFHistory.push: "${t}" is not a valid explicitDest parameter.`);if(!this._isValidPage(i)&&(null!==i||this._destination))return void console.error(`PDFHistory.push: "${i}" is not a valid pageNumber parameter.`);const n=e||JSON.stringify(t);if(!n)return;let s=!1;if(this._destination&&(a(this._destination.hash,n)||r(this._destination.dest,t))){if(this._destination.page)return;s=!0}this._popStateInProgress&&!s||(this._pushOrReplaceState({dest:t,hash:n,page:i,rotation:this.linkService.rotation},s),this._popStateInProgress||(this._popStateInProgress=!0,Promise.resolve().then((()=>{this._popStateInProgress=!1}))))}pushPage(e){this._initialized&&(this._isValidPage(e)?this._destination?.page!==e&&(this._popStateInProgress||(this._pushOrReplaceState({dest:null,hash:`page=${e}`,page:e,rotation:this.linkService.rotation}),this._popStateInProgress||(this._popStateInProgress=!0,Promise.resolve().then((()=>{this._popStateInProgress=!1}))))):console.error(`PDFHistory.pushPage: "${e}" is not a valid page number.`))}pushCurrentPosition(){this._initialized&&!this._popStateInProgress&&this._tryPushCurrentPosition()}back(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid>0&&window.history.back()}forward(){if(!this._initialized||this._popStateInProgress)return;const e=window.history.state;this._isValidState(e)&&e.uid<this._maxUid&&window.history.forward()}get popStateInProgress(){return this._initialized&&(this._popStateInProgress||this._blockHashChange>0)}get initialBookmark(){return this._initialized?this._initialBookmark:null}get initialRotation(){return this._initialized?this._initialRotation:null}_pushOrReplaceState(e,t=!1){const i=t||!this._destination,n={fingerprint:this._fingerprint,uid:i?this._uid:this._uid+1,destination:e};let s;if(this._updateInternalState(e,n.uid),this._updateUrl&&e?.hash){const t=document.location.href.split("#")[0];t.startsWith("file://")||(s=`${t}#${e.hash}`)}i?window.history.replaceState(n,"",s):window.history.pushState(n,"",s)}_tryPushCurrentPosition(e=!1){if(!this._position)return;let t=this._position;if(e&&(t=Object.assign(Object.create(null),this._position),t.temporary=!0),!this._destination)return void this._pushOrReplaceState(t);if(this._destination.temporary)return void this._pushOrReplaceState(t,!0);if(this._destination.hash===t.hash)return;if(!this._destination.page&&this._numPositionUpdates<=50)return;let i=!1;if(this._destination.page>=t.first&&this._destination.page<=t.page){if(void 0!==this._destination.dest||!this._destination.first)return;i=!0}this._pushOrReplaceState(t,i)}_isValidPage(e){return Number.isInteger(e)&&e>0&&e<=this.linkService.pagesCount}_isValidState(e,t=!1){if(!e)return!1;if(e.fingerprint!==this._fingerprint){if(!t)return!1;{if("string"!=typeof e.fingerprint||e.fingerprint.length!==this._fingerprint.length)return!1;const[t]=performance.getEntriesByType("navigation");if("reload"!==t?.type)return!1}}return!(!Number.isInteger(e.uid)||e.uid<0)&&(null!==e.destination&&"object"==typeof e.destination)}_updateInternalState(e,t,i=!1){this._updateViewareaTimeout&&(clearTimeout(this._updateViewareaTimeout),this._updateViewareaTimeout=null),i&&e?.temporary&&delete e.temporary,this._destination=e,this._uid=t,this._maxUid=Math.max(this._maxUid,t),this._numPositionUpdates=0}_parseCurrentHash(e=!1){const t=unescape(o()).substring(1),i=(0,n.parseQueryString)(t),s=i.get("nameddest")||"";let a=0|i.get("page");return(!this._isValidPage(a)||e&&s.length>0)&&(a=null),{hash:t,page:a,rotation:this.linkService.rotation}}_updateViewarea({location:e}){this._updateViewareaTimeout&&(clearTimeout(this._updateViewareaTimeout),this._updateViewareaTimeout=null),this._position={hash:e.pdfOpenParams.substring(1),page:this.linkService.page,first:e.pageNumber,rotation:e.rotation},this._popStateInProgress||(this._isPagesLoaded&&this._destination&&!this._destination.page&&this._numPositionUpdates++,this._updateViewareaTimeout=setTimeout((()=>{this._popStateInProgress||this._tryPushCurrentPosition(!0),this._updateViewareaTimeout=null}),1e3))}_popState({state:e}){const t=o(),i=this._currentHash!==t;if(this._currentHash=t,!e){this._uid++;const{hash:e,page:t,rotation:i}=this._parseCurrentHash();return void this._pushOrReplaceState({hash:e,page:t,rotation:i},!0)}if(!this._isValidState(e))return;this._popStateInProgress=!0,i&&(this._blockHashChange++,(0,s.waitOnEventOrTimeout)({target:window,name:"hashchange",delay:1e3}).then((()=>{this._blockHashChange--})));const a=e.destination;this._updateInternalState(a,e.uid,!0),(0,n.isValidRotation)(a.rotation)&&(this.linkService.rotation=a.rotation),a.dest?this.linkService.goToDestination(a.dest):a.hash?this.linkService.setHash(a.hash):a.page&&(this.linkService.page=a.page),Promise.resolve().then((()=>{this._popStateInProgress=!1}))}_pageHide(){this._destination&&!this._destination.temporary||this._tryPushCurrentPosition()}_bindEvents(){this._boundEvents||(this._boundEvents={updateViewarea:this._updateViewarea.bind(this),popState:this._popState.bind(this),pageHide:this._pageHide.bind(this)},this.eventBus._on("updateviewarea",this._boundEvents.updateViewarea),window.addEventListener("popstate",this._boundEvents.popState),window.addEventListener("pagehide",this._boundEvents.pageHide))}_unbindEvents(){this._boundEvents&&(this.eventBus._off("updateviewarea",this._boundEvents.updateViewarea),window.removeEventListener("popstate",this._boundEvents.popState),window.removeEventListener("pagehide",this._boundEvents.pageHide),this._boundEvents=null)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFLayerViewer=void 0;var n=i(13);class s extends n.BaseTreeViewer{constructor(e){super(e),this.l10n=e.l10n,this.eventBus._on("optionalcontentconfigchanged",(e=>{this.#Le(e.promise)})),this.eventBus._on("resetlayers",(()=>{this.#Le()})),this.eventBus._on("togglelayerstree",this._toggleAllTreeItems.bind(this))}reset(){super.reset(),this._optionalContentConfig=null,this._optionalContentHash=null}_dispatchEvent(e){this.eventBus.dispatch("layersloaded",{source:this,layersCount:e})}_bindLink(e,{groupId:t,input:i}){const n=()=>{this._optionalContentConfig.setVisibility(t,i.checked),this._optionalContentHash=this._optionalContentConfig.getHash(),this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(this._optionalContentConfig)})};e.onclick=t=>t.target===i?(n(),!0):t.target!==e||(i.checked=!i.checked,n(),!1)}async _setNestedName(e,{name:t=null}){"string"!=typeof t?(e.textContent=await this.l10n.get("additional_layers"),e.style.fontStyle="italic"):e.textContent=this._normalizeTextContent(t)}_addToggleButton(e,{name:t=null}){super._addToggleButton(e,null===t)}_toggleAllTreeItems(){this._optionalContentConfig&&super._toggleAllTreeItems()}render({optionalContentConfig:e,pdfDocument:t}){this._optionalContentConfig&&this.reset(),this._optionalContentConfig=e||null,this._pdfDocument=t||null;const i=e?.getOrder();if(!i)return void this._dispatchEvent(0);this._optionalContentHash=e.getHash();const n=document.createDocumentFragment(),s=[{parent:n,groups:i}];let o=0,a=!1;for(;s.length>0;){const t=s.shift();for(const i of t.groups){const n=document.createElement("div");n.className="treeItem";const r=document.createElement("a");if(n.append(r),"object"==typeof i){a=!0,this._addToggleButton(n,i),this._setNestedName(r,i);const e=document.createElement("div");e.className="treeItems",n.append(e),s.push({parent:e,groups:i.order})}else{const t=e.getGroup(i),n=document.createElement("input");this._bindLink(r,{groupId:i,input:n}),n.type="checkbox",n.checked=t.visible;const s=document.createElement("label");s.textContent=this._normalizeTextContent(t.name),s.append(n),r.append(s),o++}t.parent.append(n)}}this._finishRendering(n,o,a)}async#Le(e=null){if(!this._optionalContentConfig)return;const t=this._pdfDocument,i=await(e||t.getOptionalContentConfig());if(t===this._pdfDocument){if(e){if(i.getHash()===this._optionalContentHash)return}else this.eventBus.dispatch("optionalcontentconfig",{source:this,promise:Promise.resolve(i)});this.render({optionalContentConfig:i,pdfDocument:this._pdfDocument})}}}t.PDFLayerViewer=s},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFOutlineViewer=void 0;var n=i(13),s=i(4),o=i(3);class a extends n.BaseTreeViewer{constructor(e){super(e),this.linkService=e.linkService,this.downloadManager=e.downloadManager,this.eventBus._on("toggleoutlinetree",this._toggleAllTreeItems.bind(this)),this.eventBus._on("currentoutlineitem",this._currentOutlineItem.bind(this)),this.eventBus._on("pagechanging",(e=>{this._currentPageNumber=e.pageNumber})),this.eventBus._on("pagesloaded",(e=>{this._isPagesLoaded=!!e.pagesCount,this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(this._isPagesLoaded)})),this.eventBus._on("sidebarviewchanged",(e=>{this._sidebarView=e.view}))}reset(){super.reset(),this._outline=null,this._pageNumberToDestHashCapability=null,this._currentPageNumber=1,this._isPagesLoaded=null,this._currentOutlineItemCapability&&!this._currentOutlineItemCapability.settled&&this._currentOutlineItemCapability.resolve(!1),this._currentOutlineItemCapability=null}_dispatchEvent(e){this._currentOutlineItemCapability=new s.PromiseCapability,0===e||this._pdfDocument?.loadingParams.disableAutoFetch?this._currentOutlineItemCapability.resolve(!1):null!==this._isPagesLoaded&&this._currentOutlineItemCapability.resolve(this._isPagesLoaded),this.eventBus.dispatch("outlineloaded",{source:this,outlineCount:e,currentOutlineItemPromise:this._currentOutlineItemCapability.promise})}_bindLink(e,{url:t,newWindow:i,action:n,attachment:s,dest:o,setOCGState:a}){const{linkService:r}=this;if(t)r.addLinkAttributes(e,t,i);else{if(n)return e.href=r.getAnchorUrl(""),void(e.onclick=()=>(r.executeNamedAction(n),!1));if(s)return e.href=r.getAnchorUrl(""),void(e.onclick=()=>(this.downloadManager.openOrDownloadData(e,s.content,s.filename),!1));if(a)return e.href=r.getAnchorUrl(""),void(e.onclick=()=>(r.executeSetOCGState(a),!1));e.href=r.getDestinationHash(o),e.onclick=e=>(this._updateCurrentTreeItem(e.target.parentNode),o&&r.goToDestination(o),!1)}}_setStyles(e,{bold:t,italic:i}){t&&(e.style.fontWeight="bold"),i&&(e.style.fontStyle="italic")}_addToggleButton(e,{count:t,items:i}){let n=!1;if(t<0){let e=i.length;if(e>0){const t=[...i];for(;t.length>0;){const{count:i,items:n}=t.shift();i>0&&n.length>0&&(e+=n.length,t.push(...n))}}Math.abs(t)===e&&(n=!0)}super._addToggleButton(e,n)}_toggleAllTreeItems(){this._outline&&super._toggleAllTreeItems()}render({outline:e,pdfDocument:t}){if(this._outline&&this.reset(),this._outline=e||null,this._pdfDocument=t||null,!e)return void this._dispatchEvent(0);const i=document.createDocumentFragment(),n=[{parent:i,items:e}];let s=0,o=!1;for(;n.length>0;){const e=n.shift();for(const t of e.items){const i=document.createElement("div");i.className="treeItem";const a=document.createElement("a");if(this._bindLink(a,t),this._setStyles(a,t),a.textContent=this._normalizeTextContent(t.title),i.append(a),t.items.length>0){o=!0,this._addToggleButton(i,t);const e=document.createElement("div");e.className="treeItems",i.append(e),n.push({parent:e,items:t.items})}e.parent.append(i),s++}}this._finishRendering(i,s,o)}async _currentOutlineItem(){if(!this._isPagesLoaded)throw new Error("_currentOutlineItem: All pages have not been loaded.");if(!this._outline||!this._pdfDocument)return;const e=await this._getPageNumberToDestHash(this._pdfDocument);if(e&&(this._updateCurrentTreeItem(null),this._sidebarView===o.SidebarView.OUTLINE))for(let t=this._currentPageNumber;t>0;t--){const i=e.get(t);if(!i)continue;const n=this.container.querySelector(`a[href="${i}"]`);if(n){this._scrollToCurrentTreeItem(n.parentNode);break}}}async _getPageNumberToDestHash(e){if(this._pageNumberToDestHashCapability)return this._pageNumberToDestHashCapability.promise;this._pageNumberToDestHashCapability=new s.PromiseCapability;const t=new Map,i=new Map,n=[{nesting:0,items:this._outline}];for(;n.length>0;){const s=n.shift(),o=s.nesting;for(const{dest:a,items:r}of s.items){let s,l;if("string"==typeof a){if(s=await e.getDestination(a),e!==this._pdfDocument)return null}else s=a;if(Array.isArray(s)){const[n]=s;if("object"==typeof n&&null!==n){if(l=this.linkService._cachedPageNumber(n),!l)try{if(l=await e.getPageIndex(n)+1,e!==this._pdfDocument)return null;this.linkService.cachePageRef(l,n)}catch{}}else Number.isInteger(n)&&(l=n+1);if(Number.isInteger(l)&&(!t.has(l)||o>i.get(l))){const e=this.linkService.getDestinationHash(a);t.set(l,e),i.set(l,o)}}r.length>0&&n.push({nesting:o+1,items:r})}}return this._pageNumberToDestHashCapability.resolve(t.size>0?t:null),this._pageNumberToDestHashCapability.promise}}t.PDFOutlineViewer=a},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFPresentationMode=void 0;var n=i(3),s=i(4);const o="pdfPresentationMode",a="pdfPresentationModeControls",r=Math.PI/6;t.PDFPresentationMode=class{#oe=n.PresentationModeState.UNKNOWN;#Te=null;constructor({container:e,pdfViewer:t,eventBus:i}){this.container=e,this.pdfViewer=t,this.eventBus=i,this.contextMenuOpen=!1,this.mouseScrollTimeStamp=0,this.mouseScrollDelta=0,this.touchSwipeState=null}async request(){const{container:e,pdfViewer:t}=this;if(this.active||!t.pagesCount||!e.requestFullscreen)return!1;this.#Me(),this.#Ie(n.PresentationModeState.CHANGING);const i=e.requestFullscreen();this.#Te={pageNumber:t.currentPageNumber,scaleValue:t.currentScaleValue,scrollMode:t.scrollMode,spreadMode:null,annotationEditorMode:null},t.spreadMode===n.SpreadMode.NONE||t.pageViewsReady&&t.hasEqualPageSizes||(console.warn("Ignoring Spread modes when entering PresentationMode, since the document may contain varying page sizes."),this.#Te.spreadMode=t.spreadMode),t.annotationEditorMode!==s.AnnotationEditorType.DISABLE&&(this.#Te.annotationEditorMode=t.annotationEditorMode);try{return await i,t.focus(),!0}catch{this.#Ae(),this.#Ie(n.PresentationModeState.NORMAL)}return!1}get active(){return this.#oe===n.PresentationModeState.CHANGING||this.#oe===n.PresentationModeState.FULLSCREEN}#xe(e){if(!this.active)return;e.preventDefault();const t=(0,n.normalizeWheelEventDelta)(e),i=Date.now(),s=this.mouseScrollTimeStamp;if(!(i>s&&i-s<50)&&((this.mouseScrollDelta>0&&t<0||this.mouseScrollDelta<0&&t>0)&&this.#De(),this.mouseScrollDelta+=t,Math.abs(this.mouseScrollDelta)>=.1)){const e=this.mouseScrollDelta;this.#De();(e>0?this.pdfViewer.previousPage():this.pdfViewer.nextPage())&&(this.mouseScrollTimeStamp=i)}}#Ie(e){this.#oe=e,this.eventBus.dispatch("presentationmodechanged",{source:this,state:e})}#Ne(){this.#Ie(n.PresentationModeState.FULLSCREEN),this.container.classList.add(o),setTimeout((()=>{this.pdfViewer.scrollMode=n.ScrollMode.PAGE,null!==this.#Te.spreadMode&&(this.pdfViewer.spreadMode=n.SpreadMode.NONE),this.pdfViewer.currentPageNumber=this.#Te.pageNumber,this.pdfViewer.currentScaleValue="page-fit",null!==this.#Te.annotationEditorMode&&(this.pdfViewer.annotationEditorMode={mode:s.AnnotationEditorType.NONE})}),0),this.#Be(),this.#ke(),this.contextMenuOpen=!1,window.getSelection().removeAllRanges()}#Oe(){const e=this.pdfViewer.currentPageNumber;this.container.classList.remove(o),setTimeout((()=>{this.#Ae(),this.#Ie(n.PresentationModeState.NORMAL),this.pdfViewer.scrollMode=this.#Te.scrollMode,null!==this.#Te.spreadMode&&(this.pdfViewer.spreadMode=this.#Te.spreadMode),this.pdfViewer.currentScaleValue=this.#Te.scaleValue,this.pdfViewer.currentPageNumber=e,null!==this.#Te.annotationEditorMode&&(this.pdfViewer.annotationEditorMode={mode:this.#Te.annotationEditorMode}),this.#Te=null}),0),this.#Ve(),this.#Re(),this.#De(),this.contextMenuOpen=!1}#Fe(e){if(this.contextMenuOpen)return this.contextMenuOpen=!1,void e.preventDefault();0===e.button&&(e.target.href&&e.target.parentNode?.hasAttribute("data-internal-link")||(e.preventDefault(),e.shiftKey?this.pdfViewer.previousPage():this.pdfViewer.nextPage()))}#Ue(){this.contextMenuOpen=!0}#ke(){this.controlsTimeout?clearTimeout(this.controlsTimeout):this.container.classList.add(a),this.controlsTimeout=setTimeout((()=>{this.container.classList.remove(a),delete this.controlsTimeout}),3e3)}#Re(){this.controlsTimeout&&(clearTimeout(this.controlsTimeout),this.container.classList.remove(a),delete this.controlsTimeout)}#De(){this.mouseScrollTimeStamp=0,this.mouseScrollDelta=0}#ze(e){if(this.active)if(e.touches.length>1)this.touchSwipeState=null;else switch(e.type){case"touchstart":this.touchSwipeState={startX:e.touches[0].pageX,startY:e.touches[0].pageY,endX:e.touches[0].pageX,endY:e.touches[0].pageY};break;case"touchmove":if(null===this.touchSwipeState)return;this.touchSwipeState.endX=e.touches[0].pageX,this.touchSwipeState.endY=e.touches[0].pageY,e.preventDefault();break;case"touchend":if(null===this.touchSwipeState)return;let t=0;const i=this.touchSwipeState.endX-this.touchSwipeState.startX,n=this.touchSwipeState.endY-this.touchSwipeState.startY,s=Math.abs(Math.atan2(n,i));Math.abs(i)>50&&(s<=r||s>=Math.PI-r)?t=i:Math.abs(n)>50&&Math.abs(s-Math.PI/2)<=r&&(t=n),t>0?this.pdfViewer.previousPage():t<0&&this.pdfViewer.nextPage()}}#Be(){this.showControlsBind=this.#ke.bind(this),this.mouseDownBind=this.#Fe.bind(this),this.mouseWheelBind=this.#xe.bind(this),this.resetMouseScrollStateBind=this.#De.bind(this),this.contextMenuBind=this.#Ue.bind(this),this.touchSwipeBind=this.#ze.bind(this),window.addEventListener("mousemove",this.showControlsBind),window.addEventListener("mousedown",this.mouseDownBind),window.addEventListener("wheel",this.mouseWheelBind,{passive:!1}),window.addEventListener("keydown",this.resetMouseScrollStateBind),window.addEventListener("contextmenu",this.contextMenuBind),window.addEventListener("touchstart",this.touchSwipeBind),window.addEventListener("touchmove",this.touchSwipeBind),window.addEventListener("touchend",this.touchSwipeBind)}#Ve(){window.removeEventListener("mousemove",this.showControlsBind),window.removeEventListener("mousedown",this.mouseDownBind),window.removeEventListener("wheel",this.mouseWheelBind,{passive:!1}),window.removeEventListener("keydown",this.resetMouseScrollStateBind),window.removeEventListener("contextmenu",this.contextMenuBind),window.removeEventListener("touchstart",this.touchSwipeBind),window.removeEventListener("touchmove",this.touchSwipeBind),window.removeEventListener("touchend",this.touchSwipeBind),delete this.showControlsBind,delete this.mouseDownBind,delete this.mouseWheelBind,delete this.resetMouseScrollStateBind,delete this.contextMenuBind,delete this.touchSwipeBind}#He(){document.fullscreenElement?this.#Ne():this.#Oe()}#Me(){this.fullscreenChangeBind=this.#He.bind(this),window.addEventListener("fullscreenchange",this.fullscreenChangeBind)}#Ae(){window.removeEventListener("fullscreenchange",this.fullscreenChangeBind),delete this.fullscreenChangeBind}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFRenderingQueue=void 0;var n=i(4),s=i(3);t.PDFRenderingQueue=class{constructor(){this.pdfViewer=null,this.pdfThumbnailViewer=null,this.onIdle=null,this.highestPriorityPage=null,this.idleTimeout=null,this.printing=!1,this.isThumbnailViewEnabled=!1,Object.defineProperty(this,"hasViewer",{value:()=>!!this.pdfViewer})}setViewer(e){this.pdfViewer=e}setThumbnailViewer(e){this.pdfThumbnailViewer=e}isHighestPriority(e){return this.highestPriorityPage===e.renderingId}renderHighestPriority(e){this.idleTimeout&&(clearTimeout(this.idleTimeout),this.idleTimeout=null),this.pdfViewer.forceRendering(e)||this.isThumbnailViewEnabled&&this.pdfThumbnailViewer?.forceRendering()||this.printing||this.onIdle&&(this.idleTimeout=setTimeout(this.onIdle.bind(this),3e4))}getHighestPriority(e,t,i,n=!1){const s=e.views,o=s.length;if(0===o)return null;for(let e=0;e<o;e++){const t=s[e].view;if(!this.isViewFinished(t))return t}const a=e.first.id,r=e.last.id;if(r-a+1>o){const n=e.ids;for(let e=1,s=r-a;e<s;e++){const s=i?a+e:r-e;if(n.has(s))continue;const o=t[s-1];if(!this.isViewFinished(o))return o}}let l=i?r:a-2,d=t[l];return d&&!this.isViewFinished(d)||n&&(l+=i?1:-1,d=t[l],d&&!this.isViewFinished(d))?d:null}isViewFinished(e){return e.renderingState===s.RenderingStates.FINISHED}renderView(e){switch(e.renderingState){case s.RenderingStates.FINISHED:return!1;case s.RenderingStates.PAUSED:this.highestPriorityPage=e.renderingId,e.resume();break;case s.RenderingStates.RUNNING:this.highestPriorityPage=e.renderingId;break;case s.RenderingStates.INITIAL:this.highestPriorityPage=e.renderingId,e.draw().finally((()=>{this.renderHighestPriority()})).catch((e=>{e instanceof n.RenderingCancelledException||console.error(`renderView: "${e}"`)}))}return!0}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFScriptingManager=void 0;var n=i(3),s=i(4);t.PDFScriptingManager=class{#We=null;#$e=null;#je=null;#w=null;#Ge=null;#Xe=null;#Ke=null;#Ze=!1;#Qe=null;#qe=null;#Ye=null;constructor({eventBus:e,sandboxBundleSrc:t=null,externalServices:i=null,docProperties:n=null}){this.#w=e,this.#Qe=t,this.#Ge=i,this.#je=n}setViewer(e){this.#Ke=e}async setDocument(e){if(this.#Xe&&await this.#Je(),this.#Xe=e,!e)return;const[t,i,n]=await Promise.all([e.getFieldObjects(),e.getCalculationOrderIds(),e.getJSActions()]);if(t||n){if(e===this.#Xe){try{this.#qe=this.#et()}catch(e){return console.error(`setDocument: "${e.message}".`),void await this.#Je()}this._internalEvents.set("updatefromsandbox",(e=>{e?.source===window&&this.#tt(e.detail)})),this._internalEvents.set("dispatcheventinsandbox",(e=>{this.#qe?.dispatchEventInSandbox(e.detail)})),this._internalEvents.set("pagechanging",(({pageNumber:e,previous:t})=>{e!==t&&(this.#it(t),this.#nt(e))})),this._internalEvents.set("pagerendered",(({pageNumber:e})=>{this._pageOpenPending.has(e)&&e===this.#Ke.currentPageNumber&&this.#nt(e)})),this._internalEvents.set("pagesdestroy",(async()=>{await this.#it(this.#Ke.currentPageNumber),await(this.#qe?.dispatchEventInSandbox({id:"doc",name:"WillClose"})),this.#We?.resolve()}));for(const[e,t]of this._internalEvents)this.#w._on(e,t);try{const s=await this.#je(e);if(e!==this.#Xe)return;await this.#qe.createSandbox({objects:t,calculationOrder:i,appInfo:{platform:navigator.platform,language:navigator.language},docInfo:{...s,actions:n}}),this.#w.dispatch("sandboxcreated",{source:this})}catch(e){return console.error(`setDocument: "${e.message}".`),void await this.#Je()}await(this.#qe?.dispatchEventInSandbox({id:"doc",name:"Open"})),await this.#nt(this.#Ke.currentPageNumber,!0),Promise.resolve().then((()=>{e===this.#Xe&&(this.#Ze=!0)}))}}else await this.#Je()}async dispatchWillSave(){return this.#qe?.dispatchEventInSandbox({id:"doc",name:"WillSave"})}async dispatchDidSave(){return this.#qe?.dispatchEventInSandbox({id:"doc",name:"DidSave"})}async dispatchWillPrint(){if(this.#qe){await(this.#Ye?.promise),this.#Ye=new s.PromiseCapability;try{await this.#qe.dispatchEventInSandbox({id:"doc",name:"WillPrint"})}catch(e){throw this.#Ye.resolve(),this.#Ye=null,e}await this.#Ye.promise}}async dispatchDidPrint(){return this.#qe?.dispatchEventInSandbox({id:"doc",name:"DidPrint"})}get destroyPromise(){return this.#$e?.promise||null}get ready(){return this.#Ze}get _internalEvents(){return(0,s.shadow)(this,"_internalEvents",new Map)}get _pageOpenPending(){return(0,s.shadow)(this,"_pageOpenPending",new Set)}get _visitedPages(){return(0,s.shadow)(this,"_visitedPages",new Map)}async#tt(e){const t=this.#Ke,i=t.isInPresentationMode||t.isChangingPresentationMode,{id:s,siblings:o,command:a,value:r}=e;if(!s){switch(a){case"clear":console.clear();break;case"error":console.error(r);break;case"layout":if(!i){const e=(0,n.apiPageLayoutToViewerModes)(r);t.spreadMode=e.spreadMode}break;case"page-num":t.currentPageNumber=r+1;break;case"print":await t.pagesPromise,this.#w.dispatch("print",{source:this});break;case"println":console.log(r);break;case"zoom":i||(t.currentScaleValue=r);break;case"SaveAs":this.#w.dispatch("download",{source:this});break;case"FirstPage":t.currentPageNumber=1;break;case"LastPage":t.currentPageNumber=t.pagesCount;break;case"NextPage":t.nextPage();break;case"PrevPage":t.previousPage();break;case"ZoomViewIn":i||t.increaseScale();break;case"ZoomViewOut":i||t.decreaseScale();break;case"WillPrintFinished":this.#Ye?.resolve(),this.#Ye=null}return}if(i&&e.focus)return;delete e.id,delete e.siblings;const l=o?[s,...o]:[s];for(const t of l){const i=document.querySelector(`[data-element-id="${t}"]`);i?i.dispatchEvent(new CustomEvent("updatefromsandbox",{detail:e})):this.#Xe?.annotationStorage.setValue(t,e)}}async#nt(e,t=!1){const i=this.#Xe,o=this._visitedPages;if(t&&(this.#We=new s.PromiseCapability),!this.#We)return;const a=this.#Ke.getPageView(e-1);if(a?.renderingState!==n.RenderingStates.FINISHED)return void this._pageOpenPending.add(e);this._pageOpenPending.delete(e);const r=(async()=>{const t=await(o.has(e)?null:a.pdfPage?.getJSActions());i===this.#Xe&&await(this.#qe?.dispatchEventInSandbox({id:"page",name:"PageOpen",pageNumber:e,actions:t}))})();o.set(e,r)}async#it(e){const t=this.#Xe,i=this._visitedPages;if(!this.#We)return;if(this._pageOpenPending.has(e))return;const n=i.get(e);n&&(i.set(e,null),await n,t===this.#Xe&&await(this.#qe?.dispatchEventInSandbox({id:"page",name:"PageClose",pageNumber:e})))}#et(){if(this.#$e=new s.PromiseCapability,this.#qe)throw new Error("#initScripting: Scripting already exists.");return this.#Ge.createScripting({sandboxBundleSrc:this.#Qe})}async#Je(){if(!this.#qe)return this.#Xe=null,void this.#$e?.resolve();this.#We&&(await Promise.race([this.#We.promise,new Promise((e=>{setTimeout(e,1e3)}))]).catch((()=>{})),this.#We=null),this.#Xe=null;try{await this.#qe.destroySandbox()}catch{}this.#Ye?.reject(new Error("Scripting destroyed.")),this.#Ye=null;for(const[e,t]of this._internalEvents)this.#w._off(e,t);this._internalEvents.clear(),this._pageOpenPending.clear(),this._visitedPages.clear(),this.#qe=null,this.#Ze=!1,this.#$e?.resolve()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFSidebar=void 0;var n=i(3);const s="sidebarResizing",o="pdfSidebarNotification";t.PDFSidebar=class{#st=!1;#ot=this.#at.bind(this);#rt=this.#lt.bind(this);#dt=null;#ht=null;constructor({elements:e,eventBus:t,l10n:i}){this.isOpen=!1,this.active=n.SidebarView.THUMBS,this.isInitialViewSet=!1,this.isInitialEventDispatched=!1,this.onToggled=null,this.onUpdateThumbnails=null,this.outerContainer=e.outerContainer,this.sidebarContainer=e.sidebarContainer,this.toggleButton=e.toggleButton,this.resizer=e.resizer,this.thumbnailButton=e.thumbnailButton,this.outlineButton=e.outlineButton,this.attachmentsButton=e.attachmentsButton,this.layersButton=e.layersButton,this.thumbnailView=e.thumbnailView,this.outlineView=e.outlineView,this.attachmentsView=e.attachmentsView,this.layersView=e.layersView,this._outlineOptionsContainer=e.outlineOptionsContainer,this._currentOutlineItemButton=e.currentOutlineItemButton,this.eventBus=t,this.l10n=i,i.getDirection().then((e=>{this.#st="rtl"===e})),this.#X()}reset(){this.isInitialViewSet=!1,this.isInitialEventDispatched=!1,this.#ct(!0),this.switchView(n.SidebarView.THUMBS),this.outlineButton.disabled=!1,this.attachmentsButton.disabled=!1,this.layersButton.disabled=!1,this._currentOutlineItemButton.disabled=!0}get visibleView(){return this.isOpen?this.active:n.SidebarView.NONE}setInitialView(e=n.SidebarView.NONE){this.isInitialViewSet||(this.isInitialViewSet=!0,e!==n.SidebarView.NONE&&e!==n.SidebarView.UNKNOWN?(this.switchView(e,!0),this.isInitialEventDispatched||this.#ut()):this.#ut())}switchView(e,t=!1){const i=e!==this.active;let s=!1;switch(e){case n.SidebarView.NONE:return void(this.isOpen&&this.close());case n.SidebarView.THUMBS:this.isOpen&&i&&(s=!0);break;case n.SidebarView.OUTLINE:if(this.outlineButton.disabled)return;break;case n.SidebarView.ATTACHMENTS:if(this.attachmentsButton.disabled)return;break;case n.SidebarView.LAYERS:if(this.layersButton.disabled)return;break;default:return void console.error(`PDFSidebar.switchView: "${e}" is not a valid view.`)}this.active=e,(0,n.toggleCheckedBtn)(this.thumbnailButton,e===n.SidebarView.THUMBS,this.thumbnailView),(0,n.toggleCheckedBtn)(this.outlineButton,e===n.SidebarView.OUTLINE,this.outlineView),(0,n.toggleCheckedBtn)(this.attachmentsButton,e===n.SidebarView.ATTACHMENTS,this.attachmentsView),(0,n.toggleCheckedBtn)(this.layersButton,e===n.SidebarView.LAYERS,this.layersView),this._outlineOptionsContainer.classList.toggle("hidden",e!==n.SidebarView.OUTLINE),!t||this.isOpen?(s&&(this.onUpdateThumbnails(),this.onToggled()),i&&this.#ut()):this.open()}open(){this.isOpen||(this.isOpen=!0,(0,n.toggleExpandedBtn)(this.toggleButton,!0),this.outerContainer.classList.add("sidebarMoving","sidebarOpen"),this.active===n.SidebarView.THUMBS&&this.onUpdateThumbnails(),this.onToggled(),this.#ut(),this.#ct())}close(){this.isOpen&&(this.isOpen=!1,(0,n.toggleExpandedBtn)(this.toggleButton,!1),this.outerContainer.classList.add("sidebarMoving"),this.outerContainer.classList.remove("sidebarOpen"),this.onToggled(),this.#ut())}toggle(){this.isOpen?this.close():this.open()}#ut(){this.isInitialViewSet&&(this.isInitialEventDispatched||=!0),this.eventBus.dispatch("sidebarviewchanged",{source:this,view:this.visibleView})}#pt(){this.toggleButton.setAttribute("data-l10n-id","toggle_sidebar_notification2"),this.l10n.translate(this.toggleButton),this.isOpen||this.toggleButton.classList.add(o)}#ct(e=!1){(this.isOpen||e)&&this.toggleButton.classList.remove(o),e&&(this.toggleButton.setAttribute("data-l10n-id","toggle_sidebar"),this.l10n.translate(this.toggleButton))}#X(){this.sidebarContainer.addEventListener("transitionend",(e=>{e.target===this.sidebarContainer&&this.outerContainer.classList.remove("sidebarMoving")})),this.toggleButton.addEventListener("click",(()=>{this.toggle()})),this.thumbnailButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.THUMBS)})),this.outlineButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.OUTLINE)})),this.outlineButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("toggleoutlinetree",{source:this})})),this.attachmentsButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.ATTACHMENTS)})),this.layersButton.addEventListener("click",(()=>{this.switchView(n.SidebarView.LAYERS)})),this.layersButton.addEventListener("dblclick",(()=>{this.eventBus.dispatch("resetlayers",{source:this})})),this._currentOutlineItemButton.addEventListener("click",(()=>{this.eventBus.dispatch("currentoutlineitem",{source:this})}));const e=(e,t,i)=>{t.disabled=!e,e?this.#pt():this.active===i&&this.switchView(n.SidebarView.THUMBS)};this.eventBus._on("outlineloaded",(t=>{e(t.outlineCount,this.outlineButton,n.SidebarView.OUTLINE),t.currentOutlineItemPromise.then((e=>{this.isInitialViewSet&&(this._currentOutlineItemButton.disabled=!e)}))})),this.eventBus._on("attachmentsloaded",(t=>{e(t.attachmentsCount,this.attachmentsButton,n.SidebarView.ATTACHMENTS)})),this.eventBus._on("layersloaded",(t=>{e(t.layersCount,this.layersButton,n.SidebarView.LAYERS)})),this.eventBus._on("presentationmodechanged",(e=>{e.state===n.PresentationModeState.NORMAL&&this.visibleView===n.SidebarView.THUMBS&&this.onUpdateThumbnails()})),this.resizer.addEventListener("mousedown",(e=>{0===e.button&&(this.outerContainer.classList.add(s),window.addEventListener("mousemove",this.#ot),window.addEventListener("mouseup",this.#rt))})),this.eventBus._on("resize",(e=>{if(e.source!==window)return;if(this.#dt=null,!this.#ht)return;if(!this.isOpen)return void this.#gt(this.#ht);this.outerContainer.classList.add(s);const t=this.#gt(this.#ht);Promise.resolve().then((()=>{this.outerContainer.classList.remove(s),t&&this.eventBus.dispatch("resize",{source:this})}))}))}get outerContainerWidth(){return this.#dt||=this.outerContainer.clientWidth}#gt(e=0){const t=Math.floor(this.outerContainerWidth/2);return e>t&&(e=t),e<200&&(e=200),e!==this.#ht&&(this.#ht=e,n.docStyle.setProperty("--sidebar-width",`${e}px`),!0)}#at(e){let t=e.clientX;this.#st&&(t=this.outerContainerWidth-t),this.#gt(t)}#lt(e){this.outerContainer.classList.remove(s),this.eventBus.dispatch("resize",{source:this}),window.removeEventListener("mousemove",this.#ot),window.removeEventListener("mouseup",this.#rt)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFThumbnailViewer=void 0;var n=i(3),s=i(28);const o="selected";t.PDFThumbnailViewer=class{constructor({container:e,eventBus:t,linkService:i,renderingQueue:s,l10n:o,pageColors:a}){this.container=e,this.eventBus=t,this.linkService=i,this.renderingQueue=s,this.l10n=o,this.pageColors=a||null,this.scroll=(0,n.watchScroll)(this.container,this._scrollUpdated.bind(this)),this._resetView()}_scrollUpdated(){this.renderingQueue.renderHighestPriority()}getThumbnail(e){return this._thumbnails[e]}_getVisibleThumbs(){return(0,n.getVisibleElements)({scrollEl:this.container,views:this._thumbnails})}scrollThumbnailIntoView(e){if(!this.pdfDocument)return;const t=this._thumbnails[e-1];if(!t)return void console.error('scrollThumbnailIntoView: Invalid "pageNumber" parameter.');if(e!==this._currentPageNumber){this._thumbnails[this._currentPageNumber-1].div.classList.remove(o),t.div.classList.add(o)}const{first:i,last:s,views:a}=this._getVisibleThumbs();if(a.length>0){let o=!1;if(e<=i.id||e>=s.id)o=!0;else for(const{id:t,percent:i}of a)if(t===e){o=i<100;break}o&&(0,n.scrollIntoView)(t.div,{top:-19})}this._currentPageNumber=e}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,n.isValidRotation)(e))throw new Error("Invalid thumbnails rotation angle.");if(!this.pdfDocument)return;if(this._pagesRotation===e)return;this._pagesRotation=e;const t={rotation:e};for(const e of this._thumbnails)e.update(t)}cleanup(){for(const e of this._thumbnails)e.renderingState!==n.RenderingStates.FINISHED&&e.reset();s.TempImageFactory.destroyCanvas()}_resetView(){this._thumbnails=[],this._currentPageNumber=1,this._pageLabels=null,this._pagesRotation=0,this.container.textContent=""}setDocument(e){if(this.pdfDocument&&(this._cancelRendering(),this._resetView()),this.pdfDocument=e,!e)return;const t=e.getPage(1),i=e.getOptionalContentConfig();t.then((t=>{const n=e.numPages,a=t.getViewport({scale:1});for(let e=1;e<=n;++e){const t=new s.PDFThumbnailView({container:this.container,eventBus:this.eventBus,id:e,defaultViewport:a.clone(),optionalContentConfigPromise:i,linkService:this.linkService,renderingQueue:this.renderingQueue,l10n:this.l10n,pageColors:this.pageColors});this._thumbnails.push(t)}this._thumbnails[0]?.setPdfPage(t);this._thumbnails[this._currentPageNumber-1].div.classList.add(o)})).catch((e=>{console.error("Unable to initialize thumbnail viewer",e)}))}_cancelRendering(){for(const e of this._thumbnails)e.cancelRendering()}setPageLabels(e){if(this.pdfDocument){e?Array.isArray(e)&&this.pdfDocument.numPages===e.length?this._pageLabels=e:(this._pageLabels=null,console.error("PDFThumbnailViewer_setPageLabels: Invalid page labels.")):this._pageLabels=null;for(let e=0,t=this._thumbnails.length;e<t;e++)this._thumbnails[e].setPageLabel(this._pageLabels?.[e]??null)}}async#mt(e){if(e.pdfPage)return e.pdfPage;try{const t=await this.pdfDocument.getPage(e.id);return e.pdfPage||e.setPdfPage(t),t}catch(e){return console.error("Unable to get page for thumb view",e),null}}#ft(e){return 1===e.first?.id||e.last?.id!==this._thumbnails.length&&this.scroll.down}forceRendering(){const e=this._getVisibleThumbs(),t=this.#ft(e),i=this.renderingQueue.getHighestPriority(e,this._thumbnails,t);return!!i&&(this.#mt(i).then((()=>{this.renderingQueue.renderView(i)})),!0)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.TempImageFactory=t.PDFThumbnailView=void 0;var n=i(3),s=i(4);class o{static#vt=null;static getCanvas(e,t){const i=this.#vt||=document.createElement("canvas");i.width=e,i.height=t;const n=i.getContext("2d",{alpha:!1});return n.save(),n.fillStyle="rgb(255, 255, 255)",n.fillRect(0,0,e,t),n.restore(),[i,i.getContext("2d")]}static destroyCanvas(){const e=this.#vt;e&&(e.width=0,e.height=0),this.#vt=null}}t.TempImageFactory=o;t.PDFThumbnailView=class{constructor({container:e,eventBus:t,id:i,defaultViewport:s,optionalContentConfigPromise:o,linkService:a,renderingQueue:r,l10n:l,pageColors:d}){this.id=i,this.renderingId="thumbnail"+i,this.pageLabel=null,this.pdfPage=null,this.rotation=0,this.viewport=s,this.pdfPageRotate=s.rotation,this._optionalContentConfigPromise=o||null,this.pageColors=d||null,this.eventBus=t,this.linkService=a,this.renderingQueue=r,this.renderTask=null,this.renderingState=n.RenderingStates.INITIAL,this.resume=null,this.l10n=l;const h=document.createElement("a");h.href=a.getAnchorUrl("#page="+i),this._thumbPageTitle.then((e=>{h.title=e})),h.onclick=function(){return a.goToPage(i),!1},this.anchor=h;const c=document.createElement("div");c.className="thumbnail",c.setAttribute("data-page-number",this.id),this.div=c,this.#wt();const u=document.createElement("div");u.className="thumbnailImage",this._placeholderImg=u,c.append(u),h.append(c),e.append(h)}#wt(){const{width:e,height:t}=this.viewport,i=e/t;this.canvasWidth=98,this.canvasHeight=this.canvasWidth/i|0,this.scale=this.canvasWidth/e;const{style:n}=this.div;n.setProperty("--thumbnail-width",`${this.canvasWidth}px`),n.setProperty("--thumbnail-height",`${this.canvasHeight}px`)}setPdfPage(e){this.pdfPage=e,this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:1,rotation:t}),this.reset()}reset(){this.cancelRendering(),this.renderingState=n.RenderingStates.INITIAL,this.div.removeAttribute("data-loaded"),this.image?.replaceWith(this._placeholderImg),this.#wt(),this.image&&(this.image.removeAttribute("src"),delete this.image)}update({rotation:e=null}){"number"==typeof e&&(this.rotation=e);const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=this.viewport.clone({scale:1,rotation:t}),this.reset()}cancelRendering(){this.renderTask&&(this.renderTask.cancel(),this.renderTask=null),this.resume=null}_getPageDrawContext(e=1){const t=document.createElement("canvas"),i=t.getContext("2d",{alpha:!1}),s=new n.OutputScale;t.width=e*this.canvasWidth*s.sx|0,t.height=e*this.canvasHeight*s.sy|0;return{ctx:i,canvas:t,transform:s.scaled?[s.sx,0,0,s.sy,0,0]:null}}_convertCanvasToImage(e){if(this.renderingState!==n.RenderingStates.FINISHED)throw new Error("_convertCanvasToImage: Rendering has not finished.");const t=this._reduceImage(e),i=document.createElement("img");i.className="thumbnailImage",this._thumbPageCanvas.then((e=>{i.setAttribute("aria-label",e)})),i.src=t.toDataURL(),this.image=i,this.div.setAttribute("data-loaded",!0),this._placeholderImg.replaceWith(i),t.width=0,t.height=0}async#bt(e,t,i=null){if(e===this.renderTask&&(this.renderTask=null),!(i instanceof s.RenderingCancelledException)&&(this.renderingState=n.RenderingStates.FINISHED,this._convertCanvasToImage(t),i))throw i}async draw(){if(this.renderingState!==n.RenderingStates.INITIAL)return void console.error("Must be in new state before drawing");const{pdfPage:e}=this;if(!e)throw this.renderingState=n.RenderingStates.FINISHED,new Error("pdfPage is not loaded");this.renderingState=n.RenderingStates.RUNNING;const{ctx:t,canvas:i,transform:s}=this._getPageDrawContext(2),o={canvasContext:t,transform:s,viewport:this.viewport.clone({scale:2*this.scale}),optionalContentConfigPromise:this._optionalContentConfigPromise,pageColors:this.pageColors},a=this.renderTask=e.render(o);a.onContinue=e=>{if(!this.renderingQueue.isHighestPriority(this))return this.renderingState=n.RenderingStates.PAUSED,void(this.resume=()=>{this.renderingState=n.RenderingStates.RUNNING,e()});e()};const r=a.promise.then((()=>this.#bt(a,i)),(e=>this.#bt(a,i,e)));return r.finally((()=>{i.width=0,i.height=0,this.eventBus.dispatch("thumbnailrendered",{source:this,pageNumber:this.id,pdfPage:this.pdfPage})})),r}setImage(e){if(this.renderingState!==n.RenderingStates.INITIAL)return;const{thumbnailCanvas:t,pdfPage:i,scale:s}=e;t&&(this.pdfPage||this.setPdfPage(i),s<this.scale||(this.renderingState=n.RenderingStates.FINISHED,this._convertCanvasToImage(t)))}_reduceImage(e){const{ctx:t,canvas:i}=this._getPageDrawContext();if(e.width<=2*i.width)return t.drawImage(e,0,0,e.width,e.height,0,0,i.width,i.height),i;let n=i.width<<3,s=i.height<<3;const[a,r]=o.getCanvas(n,s);for(;n>e.width||s>e.height;)n>>=1,s>>=1;for(r.drawImage(e,0,0,e.width,e.height,0,0,n,s);n>2*i.width;)r.drawImage(a,0,0,n,s,0,0,n>>1,s>>1),n>>=1,s>>=1;return t.drawImage(a,0,0,n,s,0,0,i.width,i.height),i}get _thumbPageTitle(){return this.l10n.get("thumb_page_title",{page:this.pageLabel??this.id})}get _thumbPageCanvas(){return this.l10n.get("thumb_page_canvas",{page:this.pageLabel??this.id})}setPageLabel(e){this.pageLabel="string"==typeof e?e:null,this._thumbPageTitle.then((e=>{this.anchor.title=e})),this.renderingState===n.RenderingStates.FINISHED&&this._thumbPageCanvas.then((e=>{this.image?.setAttribute("aria-label",e)}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PagesCountLimit=t.PDFViewer=t.PDFPageViewBuffer=void 0;var n=i(4),s=i(3),o=i(30),a=i(31),r=i(24),l=i(7);const d={FORCE_SCROLL_MODE_PAGE:15e3,FORCE_LAZY_PAGE_INIT:7500,PAUSE_EAGER_PAGE_INIT:250};function h(e){return Object.values(n.AnnotationEditorType).includes(e)&&e!==n.AnnotationEditorType.DISABLE}t.PagesCountLimit=d;class c{#_t=new Set;#yt=0;constructor(e){this.#yt=e}push(e){const t=this.#_t;t.has(e)&&t.delete(e),t.add(e),t.size>this.#yt&&this.#Pt()}resize(e,t=null){this.#yt=e;const i=this.#_t;if(t){const e=i.size;let n=1;for(const s of i)if(t.has(s.id)&&(i.delete(s),i.add(s)),++n>e)break}for(;i.size>this.#yt;)this.#Pt()}has(e){return this.#_t.has(e)}[Symbol.iterator](){return this.#_t.keys()}#Pt(){const e=this.#_t.keys().next().value;e?.destroy(),this.#_t.delete(e)}}t.PDFPageViewBuffer=c;t.PDFViewer=class{#Et=null;#St=null;#Ct=n.AnnotationEditorType.NONE;#Lt=null;#Tt=n.AnnotationMode.ENABLE_FORMS;#Mt=null;#It=null;#At=!1;#xt=!1;#Dt=null;#Nt=!1;#Bt=0;#kt=new ResizeObserver(this.#Ot.bind(this));#Vt=null;#Rt=null;#Ft=null;#Ut=s.TextLayerMode.ENABLE;constructor(e){const t="3.11.174";if(n.version!==t)throw new Error(`The API version "${n.version}" does not match the Viewer version "${t}".`);if(this.container=e.container,this.viewer=e.viewer||e.container.firstElementChild,"DIV"!==this.container?.tagName||"DIV"!==this.viewer?.tagName)throw new Error("Invalid `container` and/or `viewer` option.");if(this.container.offsetParent&&"absolute"!==getComputedStyle(this.container).position)throw new Error("The `container` must be absolutely positioned.");this.#kt.observe(this.container),this.eventBus=e.eventBus,this.linkService=e.linkService||new l.SimpleLinkService,this.downloadManager=e.downloadManager||null,this.findController=e.findController||null,this.#St=e.altTextManager||null,this.findController&&(this.findController.onIsPageVisible=e=>this._getVisiblePages().ids.has(e)),this._scriptingManager=e.scriptingManager||null,this.#Ut=e.textLayerMode??s.TextLayerMode.ENABLE,this.#Tt=e.annotationMode??n.AnnotationMode.ENABLE_FORMS,this.#Ct=e.annotationEditorMode??n.AnnotationEditorType.NONE,this.imageResourcesPath=e.imageResourcesPath||"",this.enablePrintAutoRotate=e.enablePrintAutoRotate||!1,this.removePageBorders=e.removePageBorders||!1,e.useOnlyCssZoom&&(console.error("useOnlyCssZoom was removed, please use `maxCanvasPixels = 0` instead."),e.maxCanvasPixels=0),this.isOffscreenCanvasSupported=e.isOffscreenCanvasSupported??!0,this.maxCanvasPixels=e.maxCanvasPixels,this.l10n=e.l10n||o.NullL10n,this.#At=e.enablePermissions||!1,this.pageColors=e.pageColors||null,this.defaultRenderingQueue=!e.renderingQueue,this.defaultRenderingQueue?(this.renderingQueue=new r.PDFRenderingQueue,this.renderingQueue.setViewer(this)):this.renderingQueue=e.renderingQueue,this.scroll=(0,s.watchScroll)(this.container,this._scrollUpdate.bind(this)),this.presentationModeState=s.PresentationModeState.UNKNOWN,this._onBeforeDraw=this._onAfterDraw=null,this._resetView(),this.removePageBorders&&this.viewer.classList.add("removePageBorders"),this.#zt(),this.eventBus._on("thumbnailrendered",(({pageNumber:e,pdfPage:t})=>{const i=this._pages[e-1];this.#Et.has(i)||t?.cleanup()}))}get pagesCount(){return this._pages.length}getPageView(e){return this._pages[e]}getCachedPageViews(){return new Set(this.#Et)}get pageViewsReady(){return this._pagesCapability.settled&&this._pages.every((e=>e?.pdfPage))}get renderForms(){return this.#Tt===n.AnnotationMode.ENABLE_FORMS}get enableScripting(){return!!this._scriptingManager}get currentPageNumber(){return this._currentPageNumber}set currentPageNumber(e){if(!Number.isInteger(e))throw new Error("Invalid page number.");this.pdfDocument&&(this._setCurrentPageNumber(e,!0)||console.error(`currentPageNumber: "${e}" is not a valid page.`))}_setCurrentPageNumber(e,t=!1){if(this._currentPageNumber===e)return t&&this.#Ht(),!0;if(!(0<e&&e<=this.pagesCount))return!1;const i=this._currentPageNumber;return this._currentPageNumber=e,this.eventBus.dispatch("pagechanging",{source:this,pageNumber:e,pageLabel:this._pageLabels?.[e-1]??null,previous:i}),t&&this.#Ht(),!0}get currentPageLabel(){return this._pageLabels?.[this._currentPageNumber-1]??null}set currentPageLabel(e){if(!this.pdfDocument)return;let t=0|e;if(this._pageLabels){const i=this._pageLabels.indexOf(e);i>=0&&(t=i+1)}this._setCurrentPageNumber(t,!0)||console.error(`currentPageLabel: "${e}" is not a valid page.`)}get currentScale(){return this._currentScale!==s.UNKNOWN_SCALE?this._currentScale:s.DEFAULT_SCALE}set currentScale(e){if(isNaN(e))throw new Error("Invalid numeric scale.");this.pdfDocument&&this.#Wt(e,{noScroll:!1})}get currentScaleValue(){return this._currentScaleValue}set currentScaleValue(e){this.pdfDocument&&this.#Wt(e,{noScroll:!1})}get pagesRotation(){return this._pagesRotation}set pagesRotation(e){if(!(0,s.isValidRotation)(e))throw new Error("Invalid pages rotation angle.");if(!this.pdfDocument)return;if((e%=360)<0&&(e+=360),this._pagesRotation===e)return;this._pagesRotation=e;const t=this._currentPageNumber;this.refresh(!0,{rotation:e}),this._currentScaleValue&&this.#Wt(this._currentScaleValue,{noScroll:!0}),this.eventBus.dispatch("rotationchanging",{source:this,pagesRotation:e,pageNumber:t}),this.defaultRenderingQueue&&this.update()}get firstPagePromise(){return this.pdfDocument?this._firstPageCapability.promise:null}get onePageRendered(){return this.pdfDocument?this._onePageRenderedCapability.promise:null}get pagesPromise(){return this.pdfDocument?this._pagesCapability.promise:null}#$t(){const e=this;return{get annotationEditorUIManager(){return e.#Lt},get annotationStorage(){return e.pdfDocument?.annotationStorage},get downloadManager(){return e.downloadManager},get enableScripting(){return!!e._scriptingManager},get fieldObjectsPromise(){return e.pdfDocument?.getFieldObjects()},get findController(){return e.findController},get hasJSActionsPromise(){return e.pdfDocument?.hasJSActions()},get linkService(){return e.linkService}}}#jt(e){const t={annotationEditorMode:this.#Ct,annotationMode:this.#Tt,textLayerMode:this.#Ut};return e?(e.includes(n.PermissionFlag.COPY)||this.#Ut!==s.TextLayerMode.ENABLE||(t.textLayerMode=s.TextLayerMode.ENABLE_PERMISSIONS),e.includes(n.PermissionFlag.MODIFY_CONTENTS)||(t.annotationEditorMode=n.AnnotationEditorType.DISABLE),e.includes(n.PermissionFlag.MODIFY_ANNOTATIONS)||e.includes(n.PermissionFlag.FILL_INTERACTIVE_FORMS)||this.#Tt!==n.AnnotationMode.ENABLE_FORMS||(t.annotationMode=n.AnnotationMode.ENABLE),t):t}#Gt(){if("hidden"===document.visibilityState||!this.container.offsetParent||0===this._getVisiblePages().views.length)return Promise.resolve();const e=new Promise((e=>{this.#Rt=()=>{"hidden"===document.visibilityState&&(e(),document.removeEventListener("visibilitychange",this.#Rt),this.#Rt=null)},document.addEventListener("visibilitychange",this.#Rt)}));return Promise.race([this._onePageRenderedCapability.promise,e])}async getAllText(){const e=[],t=[];for(let i=1,n=this.pdfDocument.numPages;i<=n;++i){if(this.#Nt)return null;t.length=0;const n=await this.pdfDocument.getPage(i),{items:o}=await n.getTextContent();for(const e of o)e.str&&t.push(e.str),e.hasEOL&&t.push("\n");e.push((0,s.removeNullCharacters)(t.join("")))}return e.join("\n")}#Xt(e,t){const i=document.getSelection(),{focusNode:n,anchorNode:o}=i;if(o&&n&&i.containsNode(this.#Dt)){if(this.#xt||e===s.TextLayerMode.ENABLE_PERMISSIONS)return t.preventDefault(),void t.stopPropagation();this.#xt=!0;const i=this.container.style.cursor;this.container.style.cursor="wait";const n=e=>this.#Nt="Escape"===e.key;window.addEventListener("keydown",n),this.getAllText().then((async e=>{null!==e&&await navigator.clipboard.writeText(e)})).catch((e=>{console.warn(`Something goes wrong when extracting the text: ${e.message}`)})).finally((()=>{this.#xt=!1,this.#Nt=!1,window.removeEventListener("keydown",n),this.container.style.cursor=i})),t.preventDefault(),t.stopPropagation()}}setDocument(e){if(this.pdfDocument&&(this.eventBus.dispatch("pagesdestroy",{source:this}),this._cancelRendering(),this._resetView(),this.findController?.setDocument(null),this._scriptingManager?.setDocument(null),this.#Lt&&(this.#Lt.destroy(),this.#Lt=null)),this.pdfDocument=e,!e)return;const t=e.numPages,i=e.getPage(1),o=e.getOptionalContentConfig(),r=this.#At?e.getPermissions():Promise.resolve();if(t>d.FORCE_SCROLL_MODE_PAGE){console.warn("Forcing PAGE-scrolling for performance reasons, given the length of the document.");const e=this._scrollMode=s.ScrollMode.PAGE;this.eventBus.dispatch("scrollmodechanged",{source:this,mode:e})}this._pagesCapability.promise.then((()=>{this.eventBus.dispatch("pagesloaded",{source:this,pagesCount:t})}),(()=>{})),this._onBeforeDraw=e=>{const t=this._pages[e.pageNumber-1];t&&this.#Et.push(t)},this.eventBus._on("pagerender",this._onBeforeDraw),this._onAfterDraw=e=>{e.cssTransform||this._onePageRenderedCapability.settled||(this._onePageRenderedCapability.resolve({timestamp:e.timestamp}),this.eventBus._off("pagerendered",this._onAfterDraw),this._onAfterDraw=null,this.#Rt&&(document.removeEventListener("visibilitychange",this.#Rt),this.#Rt=null))},this.eventBus._on("pagerendered",this._onAfterDraw),Promise.all([i,r]).then((([i,r])=>{if(e!==this.pdfDocument)return;this._firstPageCapability.resolve(i),this._optionalContentConfigPromise=o;const{annotationEditorMode:l,annotationMode:c,textLayerMode:u}=this.#jt(r);if(u!==s.TextLayerMode.DISABLE){const e=this.#Dt=document.createElement("div");e.id="hiddenCopyElement",this.viewer.before(e)}if(l!==n.AnnotationEditorType.DISABLE){const t=l;e.isPureXfa?console.warn("Warning: XFA-editing is not implemented."):h(t)?(this.#Lt=new n.AnnotationEditorUIManager(this.container,this.viewer,this.#St,this.eventBus,e,this.pageColors),t!==n.AnnotationEditorType.NONE&&this.#Lt.updateMode(t)):console.error(`Invalid AnnotationEditor mode: ${t}`)}const p=this.#$t.bind(this),g=this._scrollMode===s.ScrollMode.PAGE?null:this.viewer,m=this.currentScale,f=i.getViewport({scale:m*n.PixelsPerInch.PDF_TO_CSS_UNITS});this.viewer.style.setProperty("--scale-factor",f.scale),"CanvasText"!==this.pageColors?.foreground&&"Canvas"!==this.pageColors?.background||this.viewer.style.setProperty("--hcm-highligh-filter",e.filterFactory.addHighlightHCMFilter("CanvasText","Canvas","HighlightText","Highlight"));for(let e=1;e<=t;++e){const t=new a.PDFPageView({container:g,eventBus:this.eventBus,id:e,scale:m,defaultViewport:f.clone(),optionalContentConfigPromise:o,renderingQueue:this.renderingQueue,textLayerMode:u,annotationMode:c,imageResourcesPath:this.imageResourcesPath,isOffscreenCanvasSupported:this.isOffscreenCanvasSupported,maxCanvasPixels:this.maxCanvasPixels,pageColors:this.pageColors,l10n:this.l10n,layerProperties:p});this._pages.push(t)}const v=this._pages[0];v&&(v.setPdfPage(i),this.linkService.cachePageRef(1,i.ref)),this._scrollMode===s.ScrollMode.PAGE?this.#Kt():this._spreadMode!==s.SpreadMode.NONE&&this._updateSpreadMode(),this.#Gt().then((async()=>{if(this.findController?.setDocument(e),this._scriptingManager?.setDocument(e),this.#Dt&&(this.#It=this.#Xt.bind(this,u),document.addEventListener("copy",this.#It)),this.#Lt&&this.eventBus.dispatch("annotationeditormodechanged",{source:this,mode:this.#Ct}),e.loadingParams.disableAutoFetch||t>d.FORCE_LAZY_PAGE_INIT)return void this._pagesCapability.resolve();let i=t-1;if(i<=0)this._pagesCapability.resolve();else for(let n=2;n<=t;++n){const t=e.getPage(n).then((e=>{const t=this._pages[n-1];t.pdfPage||t.setPdfPage(e),this.linkService.cachePageRef(n,e.ref),0==--i&&this._pagesCapability.resolve()}),(e=>{console.error(`Unable to get page ${n} to initialize viewer`,e),0==--i&&this._pagesCapability.resolve()}));n%d.PAUSE_EAGER_PAGE_INIT==0&&await t}})),this.eventBus.dispatch("pagesinit",{source:this}),e.getMetadata().then((({info:t})=>{e===this.pdfDocument&&t.Language&&(this.viewer.lang=t.Language)})),this.defaultRenderingQueue&&this.update()})).catch((e=>{console.error("Unable to initialize viewer",e),this._pagesCapability.reject(e)}))}setPageLabels(e){if(this.pdfDocument){e?Array.isArray(e)&&this.pdfDocument.numPages===e.length?this._pageLabels=e:(this._pageLabels=null,console.error("setPageLabels: Invalid page labels.")):this._pageLabels=null;for(let e=0,t=this._pages.length;e<t;e++)this._pages[e].setPageLabel(this._pageLabels?.[e]??null)}}_resetView(){this._pages=[],this._currentPageNumber=1,this._currentScale=s.UNKNOWN_SCALE,this._currentScaleValue=null,this._pageLabels=null,this.#Et=new c(10),this._location=null,this._pagesRotation=0,this._optionalContentConfigPromise=null,this._firstPageCapability=new n.PromiseCapability,this._onePageRenderedCapability=new n.PromiseCapability,this._pagesCapability=new n.PromiseCapability,this._scrollMode=s.ScrollMode.VERTICAL,this._previousScrollMode=s.ScrollMode.UNKNOWN,this._spreadMode=s.SpreadMode.NONE,this.#Vt={previousPageNumber:1,scrollDown:!0,pages:[]},this._onBeforeDraw&&(this.eventBus._off("pagerender",this._onBeforeDraw),this._onBeforeDraw=null),this._onAfterDraw&&(this.eventBus._off("pagerendered",this._onAfterDraw),this._onAfterDraw=null),this.#Rt&&(document.removeEventListener("visibilitychange",this.#Rt),this.#Rt=null),this.viewer.textContent="",this._updateScrollMode(),this.viewer.removeAttribute("lang"),this.#Dt&&(document.removeEventListener("copy",this.#It),this.#It=null,this.#Dt.remove(),this.#Dt=null)}#Kt(){if(this._scrollMode!==s.ScrollMode.PAGE)throw new Error("#ensurePageViewVisible: Invalid scrollMode value.");const e=this._currentPageNumber,t=this.#Vt,i=this.viewer;if(i.textContent="",t.pages.length=0,this._spreadMode!==s.SpreadMode.NONE||this.isInPresentationMode){const n=new Set,s=this._spreadMode-1;-1===s?n.add(e-1):e%2!==s?(n.add(e-1),n.add(e)):(n.add(e-2),n.add(e-1));const o=document.createElement("div");if(o.className="spread",this.isInPresentationMode){const e=document.createElement("div");e.className="dummyPage",o.append(e)}for(const e of n){const i=this._pages[e];i&&(o.append(i.div),t.pages.push(i))}i.append(o)}else{const n=this._pages[e-1];i.append(n.div),t.pages.push(n)}t.scrollDown=e>=t.previousPageNumber,t.previousPageNumber=e}_scrollUpdate(){0!==this.pagesCount&&this.update()}#Zt(e,t=null){const{div:i,id:n}=e;if(this._currentPageNumber!==n&&this._setCurrentPageNumber(n),this._scrollMode===s.ScrollMode.PAGE&&(this.#Kt(),this.update()),!t&&!this.isInPresentationMode){const e=i.offsetLeft+i.clientLeft,n=e+i.clientWidth,{scrollLeft:o,clientWidth:a}=this.container;(this._scrollMode===s.ScrollMode.HORIZONTAL||e<o||n>o+a)&&(t={left:0,top:0})}(0,s.scrollIntoView)(i,t),!this._currentScaleValue&&this._location&&(this._location=null)}#Qt(e){return e===this._currentScale||Math.abs(e-this._currentScale)<1e-15}#qt(e,t,{noScroll:i=!1,preset:s=!1,drawingDelay:o=-1}){if(this._currentScaleValue=t.toString(),this.#Qt(e))return void(s&&this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:t}));this.viewer.style.setProperty("--scale-factor",e*n.PixelsPerInch.PDF_TO_CSS_UNITS);const a=o>=0&&o<1e3;if(this.refresh(!0,{scale:e,drawingDelay:a?o:-1}),a&&(this.#Ft=setTimeout((()=>{this.#Ft=null,this.refresh()}),o)),this._currentScale=e,!i){let e,t=this._currentPageNumber;!this._location||this.isInPresentationMode||this.isChangingPresentationMode||(t=this._location.pageNumber,e=[null,{name:"XYZ"},this._location.left,this._location.top,null]),this.scrollPageIntoView({pageNumber:t,destArray:e,allowNegativeOffset:!0})}this.eventBus.dispatch("scalechanging",{source:this,scale:e,presetValue:s?t:void 0}),this.defaultRenderingQueue&&this.update()}get#Yt(){return this._spreadMode!==s.SpreadMode.NONE&&this._scrollMode!==s.ScrollMode.HORIZONTAL?2:1}#Wt(e,t){let i=parseFloat(e);if(i>0)t.preset=!1,this.#qt(i,e,t);else{const n=this._pages[this._currentPageNumber-1];if(!n)return;let o=s.SCROLLBAR_PADDING,a=s.VERTICAL_PADDING;this.isInPresentationMode?(o=a=4,this._spreadMode!==s.SpreadMode.NONE&&(o*=2)):this.removePageBorders?o=a=0:this._scrollMode===s.ScrollMode.HORIZONTAL&&([o,a]=[a,o]);const r=(this.container.clientWidth-o)/n.width*n.scale/this.#Yt,l=(this.container.clientHeight-a)/n.height*n.scale;switch(e){case"page-actual":i=1;break;case"page-width":i=r;break;case"page-height":i=l;break;case"page-fit":i=Math.min(r,l);break;case"auto":const t=(0,s.isPortraitOrientation)(n)?r:Math.min(l,r);i=Math.min(s.MAX_AUTO_SCALE,t);break;default:return void console.error(`#setScale: "${e}" is an unknown zoom value.`)}t.preset=!0,this.#qt(i,e,t)}}#Ht(){const e=this._pages[this._currentPageNumber-1];this.isInPresentationMode&&this.#Wt(this._currentScaleValue,{noScroll:!0}),this.#Zt(e)}pageLabelToPageNumber(e){if(!this._pageLabels)return null;const t=this._pageLabels.indexOf(e);return t<0?null:t+1}scrollPageIntoView({pageNumber:e,destArray:t=null,allowNegativeOffset:i=!1,ignoreDestinationZoom:o=!1}){if(!this.pdfDocument)return;const a=Number.isInteger(e)&&this._pages[e-1];if(!a)return void console.error(`scrollPageIntoView: "${e}" is not a valid pageNumber parameter.`);if(this.isInPresentationMode||!t)return void this._setCurrentPageNumber(e,!0);let r,l,d=0,h=0,c=0,u=0;const p=a.rotation%180!=0,g=(p?a.height:a.width)/a.scale/n.PixelsPerInch.PDF_TO_CSS_UNITS,m=(p?a.width:a.height)/a.scale/n.PixelsPerInch.PDF_TO_CSS_UNITS;let f=0;switch(t[1].name){case"XYZ":d=t[2],h=t[3],f=t[4],d=null!==d?d:0,h=null!==h?h:m;break;case"Fit":case"FitB":f="page-fit";break;case"FitH":case"FitBH":h=t[2],f="page-width",null===h&&this._location?(d=this._location.left,h=this._location.top):("number"!=typeof h||h<0)&&(h=m);break;case"FitV":case"FitBV":d=t[2],c=g,u=m,f="page-height";break;case"FitR":d=t[2],h=t[3],c=t[4]-d,u=t[5]-h;let e=s.SCROLLBAR_PADDING,i=s.VERTICAL_PADDING;this.removePageBorders&&(e=i=0),r=(this.container.clientWidth-e)/c/n.PixelsPerInch.PDF_TO_CSS_UNITS,l=(this.container.clientHeight-i)/u/n.PixelsPerInch.PDF_TO_CSS_UNITS,f=Math.min(Math.abs(r),Math.abs(l));break;default:return void console.error(`scrollPageIntoView: "${t[1].name}" is not a valid destination type.`)}if(o||(f&&f!==this._currentScale?this.currentScaleValue=f:this._currentScale===s.UNKNOWN_SCALE&&(this.currentScaleValue=s.DEFAULT_SCALE_VALUE)),"page-fit"===f&&!t[4])return void this.#Zt(a);const v=[a.viewport.convertToViewportPoint(d,h),a.viewport.convertToViewportPoint(d+c,h+u)];let w=Math.min(v[0][0],v[1][0]),b=Math.min(v[0][1],v[1][1]);i||(w=Math.max(w,0),b=Math.max(b,0)),this.#Zt(a,{left:w,top:b})}_updateLocation(e){const t=this._currentScale,i=this._currentScaleValue,n=parseFloat(i)===t?Math.round(1e4*t)/100:i,s=e.id,o=this._pages[s-1],a=this.container,r=o.getPagePoint(a.scrollLeft-e.x,a.scrollTop-e.y),l=Math.round(r[0]),d=Math.round(r[1]);let h=`#page=${s}`;this.isInPresentationMode||(h+=`&zoom=${n},${l},${d}`),this._location={pageNumber:s,scale:n,top:d,left:l,rotation:this._pagesRotation,pdfOpenParams:h}}update(){const e=this._getVisiblePages(),t=e.views,i=t.length;if(0===i)return;const n=Math.max(10,2*i+1);this.#Et.resize(n,e.ids),this.renderingQueue.renderHighestPriority(e);const o=this._spreadMode===s.SpreadMode.NONE&&(this._scrollMode===s.ScrollMode.PAGE||this._scrollMode===s.ScrollMode.VERTICAL),a=this._currentPageNumber;let r=!1;for(const e of t){if(e.percent<100)break;if(e.id===a&&o){r=!0;break}}this._setCurrentPageNumber(r?a:t[0].id),this._updateLocation(e.first),this.eventBus.dispatch("updateviewarea",{source:this,location:this._location})}containsElement(e){return this.container.contains(e)}focus(){this.container.focus()}get _isContainerRtl(){return"rtl"===getComputedStyle(this.container).direction}get isInPresentationMode(){return this.presentationModeState===s.PresentationModeState.FULLSCREEN}get isChangingPresentationMode(){return this.presentationModeState===s.PresentationModeState.CHANGING}get isHorizontalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollWidth>this.container.clientWidth}get isVerticalScrollbarEnabled(){return!this.isInPresentationMode&&this.container.scrollHeight>this.container.clientHeight}_getVisiblePages(){const e=this._scrollMode===s.ScrollMode.PAGE?this.#Vt.pages:this._pages,t=this._scrollMode===s.ScrollMode.HORIZONTAL,i=t&&this._isContainerRtl;return(0,s.getVisibleElements)({scrollEl:this.container,views:e,sortByVisibility:!0,horizontal:t,rtl:i})}cleanup(){for(const e of this._pages)e.renderingState!==s.RenderingStates.FINISHED&&e.reset()}_cancelRendering(){for(const e of this._pages)e.cancelRendering()}async#mt(e){if(e.pdfPage)return e.pdfPage;try{const t=await this.pdfDocument.getPage(e.id);return e.pdfPage||e.setPdfPage(t),this.linkService._cachedPageNumber?.(t.ref)||this.linkService.cachePageRef(e.id,t.ref),t}catch(e){return console.error("Unable to get page for page view",e),null}}#ft(e){if(1===e.first?.id)return!0;if(e.last?.id===this.pagesCount)return!1;switch(this._scrollMode){case s.ScrollMode.PAGE:return this.#Vt.scrollDown;case s.ScrollMode.HORIZONTAL:return this.scroll.right}return this.scroll.down}forceRendering(e){const t=e||this._getVisiblePages(),i=this.#ft(t),n=this._spreadMode!==s.SpreadMode.NONE&&this._scrollMode!==s.ScrollMode.HORIZONTAL,o=this.renderingQueue.getHighestPriority(t,this._pages,i,n);return!!o&&(this.#mt(o).then((()=>{this.renderingQueue.renderView(o)})),!0)}get hasEqualPageSizes(){const e=this._pages[0];for(let t=1,i=this._pages.length;t<i;++t){const i=this._pages[t];if(i.width!==e.width||i.height!==e.height)return!1}return!0}getPagesOverview(){let e;return this._pages.map((t=>{const i=t.pdfPage.getViewport({scale:1}),n=(0,s.isPortraitOrientation)(i);if(void 0===e)e=n;else if(this.enablePrintAutoRotate&&n!==e)return{width:i.height,height:i.width,rotation:(i.rotation-90)%360};return{width:i.width,height:i.height,rotation:i.rotation}}))}get optionalContentConfigPromise(){return this.pdfDocument?this._optionalContentConfigPromise?this._optionalContentConfigPromise:(console.error("optionalContentConfigPromise: Not initialized yet."),this.pdfDocument.getOptionalContentConfig()):Promise.resolve(null)}set optionalContentConfigPromise(e){if(!(e instanceof Promise))throw new Error(`Invalid optionalContentConfigPromise: ${e}`);this.pdfDocument&&this._optionalContentConfigPromise&&(this._optionalContentConfigPromise=e,this.refresh(!1,{optionalContentConfigPromise:e}),this.eventBus.dispatch("optionalcontentconfigchanged",{source:this,promise:e}))}get scrollMode(){return this._scrollMode}set scrollMode(e){if(this._scrollMode!==e){if(!(0,s.isValidScrollMode)(e))throw new Error(`Invalid scroll mode: ${e}`);this.pagesCount>d.FORCE_SCROLL_MODE_PAGE||(this._previousScrollMode=this._scrollMode,this._scrollMode=e,this.eventBus.dispatch("scrollmodechanged",{source:this,mode:e}),this._updateScrollMode(this._currentPageNumber))}}_updateScrollMode(e=null){const t=this._scrollMode,i=this.viewer;i.classList.toggle("scrollHorizontal",t===s.ScrollMode.HORIZONTAL),i.classList.toggle("scrollWrapped",t===s.ScrollMode.WRAPPED),this.pdfDocument&&e&&(t===s.ScrollMode.PAGE?this.#Kt():this._previousScrollMode===s.ScrollMode.PAGE&&this._updateSpreadMode(),this._currentScaleValue&&isNaN(this._currentScaleValue)&&this.#Wt(this._currentScaleValue,{noScroll:!0}),this._setCurrentPageNumber(e,!0),this.update())}get spreadMode(){return this._spreadMode}set spreadMode(e){if(this._spreadMode!==e){if(!(0,s.isValidSpreadMode)(e))throw new Error(`Invalid spread mode: ${e}`);this._spreadMode=e,this.eventBus.dispatch("spreadmodechanged",{source:this,mode:e}),this._updateSpreadMode(this._currentPageNumber)}}_updateSpreadMode(e=null){if(!this.pdfDocument)return;const t=this.viewer,i=this._pages;if(this._scrollMode===s.ScrollMode.PAGE)this.#Kt();else if(t.textContent="",this._spreadMode===s.SpreadMode.NONE)for(const e of this._pages)t.append(e.div);else{const e=this._spreadMode-1;let n=null;for(let s=0,o=i.length;s<o;++s)null===n?(n=document.createElement("div"),n.className="spread",t.append(n)):s%2===e&&(n=n.cloneNode(!1),t.append(n)),n.append(i[s].div)}e&&(this._currentScaleValue&&isNaN(this._currentScaleValue)&&this.#Wt(this._currentScaleValue,{noScroll:!0}),this._setCurrentPageNumber(e,!0),this.update())}_getPageAdvance(e,t=!1){switch(this._scrollMode){case s.ScrollMode.WRAPPED:{const{views:i}=this._getVisiblePages(),n=new Map;for(const{id:e,y:t,percent:s,widthPercent:o}of i){if(0===s||o<100)continue;let i=n.get(t);i||n.set(t,i||=[]),i.push(e)}for(const i of n.values()){const n=i.indexOf(e);if(-1===n)continue;const s=i.length;if(1===s)break;if(t)for(let t=n-1,s=0;t>=s;t--){const n=i[t],s=i[t+1]-1;if(n<s)return e-s}else for(let t=n+1,o=s;t<o;t++){const n=i[t],s=i[t-1]+1;if(n>s)return s-e}if(t){const t=i[0];if(t<e)return e-t+1}else{const t=i[s-1];if(t>e)return t-e+1}break}break}case s.ScrollMode.HORIZONTAL:break;case s.ScrollMode.PAGE:case s.ScrollMode.VERTICAL:{if(this._spreadMode===s.SpreadMode.NONE)break;const i=this._spreadMode-1;if(t&&e%2!==i)break;if(!t&&e%2===i)break;const{views:n}=this._getVisiblePages(),o=t?e-1:e+1;for(const{id:e,percent:t,widthPercent:i}of n)if(e===o){if(t>0&&100===i)return 2;break}break}}return 1}nextPage(){const e=this._currentPageNumber,t=this.pagesCount;if(e>=t)return!1;const i=this._getPageAdvance(e,!1)||1;return this.currentPageNumber=Math.min(e+i,t),!0}previousPage(){const e=this._currentPageNumber;if(e<=1)return!1;const t=this._getPageAdvance(e,!0)||1;return this.currentPageNumber=Math.max(e-t,1),!0}increaseScale({drawingDelay:e,scaleFactor:t,steps:i}={}){if(!this.pdfDocument)return;let n=this._currentScale;if(t>1)n=Math.round(n*t*100)/100;else{i??=1;do{n=Math.ceil(10*(n*s.DEFAULT_SCALE_DELTA).toFixed(2))/10}while(--i>0&&n<s.MAX_SCALE)}this.#Wt(Math.min(s.MAX_SCALE,n),{noScroll:!1,drawingDelay:e})}decreaseScale({drawingDelay:e,scaleFactor:t,steps:i}={}){if(!this.pdfDocument)return;let n=this._currentScale;if(t>0&&t<1)n=Math.round(n*t*100)/100;else{i??=1;do{n=Math.floor(10*(n/s.DEFAULT_SCALE_DELTA).toFixed(2))/10}while(--i>0&&n>s.MIN_SCALE)}this.#Wt(Math.max(s.MIN_SCALE,n),{noScroll:!1,drawingDelay:e})}#zt(e=this.container.clientHeight){e!==this.#Bt&&(this.#Bt=e,s.docStyle.setProperty("--viewer-container-height",`${e}px`))}#Ot(e){for(const t of e)if(t.target===this.container){this.#zt(Math.floor(t.borderBoxSize[0].blockSize)),this.#Mt=null;break}}get containerTopLeft(){return this.#Mt||=[this.container.offsetTop,this.container.offsetLeft]}get annotationEditorMode(){return this.#Lt?this.#Ct:n.AnnotationEditorType.DISABLE}set annotationEditorMode({mode:e,editId:t=null}){if(!this.#Lt)throw new Error("The AnnotationEditor is not enabled.");if(this.#Ct!==e){if(!h(e))throw new Error(`Invalid AnnotationEditor mode: ${e}`);this.pdfDocument&&(this.#Ct=e,this.eventBus.dispatch("annotationeditormodechanged",{source:this,mode:e}),this.#Lt.updateMode(e,t))}}set annotationEditorParams({type:e,value:t}){if(!this.#Lt)throw new Error("The AnnotationEditor is not enabled.");this.#Lt.updateParams(e,t)}refresh(e=!1,t=Object.create(null)){if(this.pdfDocument){for(const e of this._pages)e.update(t);null!==this.#Ft&&(clearTimeout(this.#Ft),this.#Ft=null),e||this.update()}}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.NullL10n=void 0,t.getL10nFallback=n;const i={of_pages:"of {{pagesCount}}",page_of_pages:"({{pageNumber}} of {{pagesCount}})",document_properties_kb:"{{size_kb}} KB ({{size_b}} bytes)",document_properties_mb:"{{size_mb}} MB ({{size_b}} bytes)",document_properties_date_string:"{{date}}, {{time}}",document_properties_page_size_unit_inches:"in",document_properties_page_size_unit_millimeters:"mm",document_properties_page_size_orientation_portrait:"portrait",document_properties_page_size_orientation_landscape:"landscape",document_properties_page_size_name_a3:"A3",document_properties_page_size_name_a4:"A4",document_properties_page_size_name_letter:"Letter",document_properties_page_size_name_legal:"Legal",document_properties_page_size_dimension_string:"{{width}} × {{height}} {{unit}} ({{orientation}})",document_properties_page_size_dimension_name_string:"{{width}} × {{height}} {{unit}} ({{name}}, {{orientation}})",document_properties_linearized_yes:"Yes",document_properties_linearized_no:"No",additional_layers:"Additional Layers",page_landmark:"Page {{page}}",thumb_page_title:"Page {{page}}",thumb_page_canvas:"Thumbnail of Page {{page}}",find_reached_top:"Reached top of document, continued from bottom",find_reached_bottom:"Reached end of document, continued from top","find_match_count[one]":"{{current}} of {{total}} match","find_match_count[other]":"{{current}} of {{total}} matches","find_match_count_limit[one]":"More than {{limit}} match","find_match_count_limit[other]":"More than {{limit}} matches",find_not_found:"Phrase not found",page_scale_width:"Page Width",page_scale_fit:"Page Fit",page_scale_auto:"Automatic Zoom",page_scale_actual:"Actual Size",page_scale_percent:"{{scale}}%",loading_error:"An error occurred while loading the PDF.",invalid_file_error:"Invalid or corrupted PDF file.",missing_file_error:"Missing PDF file.",unexpected_response_error:"Unexpected server response.",rendering_error:"An error occurred while rendering the page.",annotation_date_string:"{{date}}, {{time}}",printing_not_supported:"Warning: Printing is not fully supported by this browser.",printing_not_ready:"Warning: The PDF is not fully loaded for printing.",web_fonts_disabled:"Web fonts are disabled: unable to use embedded PDF fonts.",free_text2_default_content:"Start typing…",editor_free_text2_aria_label:"Text Editor",editor_ink2_aria_label:"Draw Editor",editor_ink_canvas_aria_label:"User-created image",editor_alt_text_button_label:"Alt text",editor_alt_text_edit_button_label:"Edit alt text",editor_alt_text_decorative_tooltip:"Marked as decorative"};function n(e,t){switch(e){case"find_match_count":e=`find_match_count[${1===t.total?"one":"other"}]`;break;case"find_match_count_limit":e=`find_match_count_limit[${1===t.limit?"one":"other"}]`}return i[e]||""}i.print_progress_percent="{{progress}}%";const s={getLanguage:async()=>"en-us",getDirection:async()=>"ltr",get:async(e,t=null,i=n(e,t))=>function(e,t){return t?e.replaceAll(/\{\{\s*(\w+)\s*\}\}/g,((e,i)=>i in t?t[i]:"{{"+i+"}}")):e}(i,t),async translate(e){}};t.NullL10n=s},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFPageView=void 0;var n=i(4),s=i(3),o=i(32),a=i(33),r=i(5),l=i(30),d=(i(7),i(34)),h=i(35),c=i(36),u=i(37),p=i(38);const g=r.compatibilityParams.maxCanvasPixels||16777216,m=()=>null;t.PDFPageView=class{#Tt=n.AnnotationMode.ENABLE_FORMS;#Jt=!1;#$t=null;#ei=null;#ti=null;#ii=null;#ni=s.RenderingStates.INITIAL;#Ut=s.TextLayerMode.ENABLE;#si={directDrawing:!0,initialOptionalContent:!0,regularAnnotations:!0};#oi=new WeakMap;constructor(e){const t=e.container,i=e.defaultViewport;this.id=e.id,this.renderingId="page"+this.id,this.#$t=e.layerProperties||m,this.pdfPage=null,this.pageLabel=null,this.rotation=0,this.scale=e.scale||s.DEFAULT_SCALE,this.viewport=i,this.pdfPageRotate=i.rotation,this._optionalContentConfigPromise=e.optionalContentConfigPromise||null,this.#Ut=e.textLayerMode??s.TextLayerMode.ENABLE,this.#Tt=e.annotationMode??n.AnnotationMode.ENABLE_FORMS,this.imageResourcesPath=e.imageResourcesPath||"",this.isOffscreenCanvasSupported=e.isOffscreenCanvasSupported??!0,this.maxCanvasPixels=e.maxCanvasPixels??g,this.pageColors=e.pageColors||null,this.eventBus=e.eventBus,this.renderingQueue=e.renderingQueue,this.l10n=e.l10n||l.NullL10n,this.renderTask=null,this.resume=null,this._isStandalone=!this.renderingQueue?.hasViewer(),this._container=t,e.useOnlyCssZoom&&(console.error("useOnlyCssZoom was removed, please use `maxCanvasPixels = 0` instead."),this.maxCanvasPixels=0),this._annotationCanvasMap=null,this.annotationLayer=null,this.annotationEditorLayer=null,this.textLayer=null,this.zoomLayer=null,this.xfaLayer=null,this.structTreeLayer=null;const o=document.createElement("div");if(o.className="page",o.setAttribute("data-page-number",this.id),o.setAttribute("role","region"),this.l10n.get("page_landmark",{page:this.id}).then((e=>{o.setAttribute("aria-label",e)})),this.div=o,this.#ai(),t?.append(o),this._isStandalone){t?.style.setProperty("--scale-factor",this.scale*n.PixelsPerInch.PDF_TO_CSS_UNITS);const{optionalContentConfigPromise:i}=e;i&&i.then((e=>{i===this._optionalContentConfigPromise&&(this.#si.initialOptionalContent=e.hasInitialVisibility)}))}}get renderingState(){return this.#ni}set renderingState(e){if(e!==this.#ni)switch(this.#ni=e,this.#ei&&(clearTimeout(this.#ei),this.#ei=null),e){case s.RenderingStates.PAUSED:this.div.classList.remove("loading");break;case s.RenderingStates.RUNNING:this.div.classList.add("loadingIcon"),this.#ei=setTimeout((()=>{this.div.classList.add("loading"),this.#ei=null}),0);break;case s.RenderingStates.INITIAL:case s.RenderingStates.FINISHED:this.div.classList.remove("loadingIcon","loading")}}#ai(){const{viewport:e}=this;if(this.pdfPage){if(this.#ti===e.rotation)return;this.#ti=e.rotation}(0,n.setLayerDimensions)(this.div,e,!0,!1)}setPdfPage(e){!this._isStandalone||"CanvasText"!==this.pageColors?.foreground&&"Canvas"!==this.pageColors?.background||this._container?.style.setProperty("--hcm-highligh-filter",e.filterFactory.addHighlightHCMFilter("CanvasText","Canvas","HighlightText","Highlight")),this.pdfPage=e,this.pdfPageRotate=e.rotate;const t=(this.rotation+this.pdfPageRotate)%360;this.viewport=e.getViewport({scale:this.scale*n.PixelsPerInch.PDF_TO_CSS_UNITS,rotation:t}),this.#ai(),this.reset()}destroy(){this.reset(),this.pdfPage?.cleanup()}get _textHighlighter(){return(0,n.shadow)(this,"_textHighlighter",new c.TextHighlighter({pageIndex:this.id-1,eventBus:this.eventBus,findController:this.#$t().findController}))}async#ri(){let e=null;try{await this.annotationLayer.render(this.viewport,"display")}catch(t){console.error(`#renderAnnotationLayer: "${t}".`),e=t}finally{this.eventBus.dispatch("annotationlayerrendered",{source:this,pageNumber:this.id,error:e})}}async#li(){let e=null;try{await this.annotationEditorLayer.render(this.viewport,"display")}catch(t){console.error(`#renderAnnotationEditorLayer: "${t}".`),e=t}finally{this.eventBus.dispatch("annotationeditorlayerrendered",{source:this,pageNumber:this.id,error:e})}}async#di(){let e=null;try{const e=await this.xfaLayer.render(this.viewport,"display");e?.textDivs&&this._textHighlighter&&this.#hi(e.textDivs)}catch(t){console.error(`#renderXfaLayer: "${t}".`),e=t}finally{this.eventBus.dispatch("xfalayerrendered",{source:this,pageNumber:this.id,error:e})}}async#ci(){const{pdfPage:e,textLayer:t,viewport:i}=this;if(!t)return;let s=null;try{if(!t.renderingDone){const i=e.streamTextContent({includeMarkedContent:!0,disableNormalization:!0});t.setTextContentSource(i)}await t.render(i)}catch(e){if(e instanceof n.AbortException)return;console.error(`#renderTextLayer: "${e}".`),s=e}this.eventBus.dispatch("textlayerrendered",{source:this,pageNumber:this.id,numTextDivs:t.numTextDivs,error:s}),this.#ui()}async#ui(){if(!this.textLayer)return;this.structTreeLayer||=new d.StructTreeLayerBuilder;const e=await(this.structTreeLayer.renderingDone?null:this.pdfPage.getStructTree()),t=this.structTreeLayer?.render(e);t&&this.canvas?.append(t),this.structTreeLayer?.show()}async#hi(e){const t=await this.pdfPage.getTextContent(),i=[];for(const e of t.items)i.push(e.str);this._textHighlighter.setTextMapping(e,i),this._textHighlighter.enable()}_resetZoomLayer(e=!1){if(!this.zoomLayer)return;const t=this.zoomLayer.firstChild;this.#oi.delete(t),t.width=0,t.height=0,e&&this.zoomLayer.remove(),this.zoomLayer=null}reset({keepZoomLayer:e=!1,keepAnnotationLayer:t=!1,keepAnnotationEditorLayer:i=!1,keepXfaLayer:n=!1,keepTextLayer:o=!1}={}){this.cancelRendering({keepAnnotationLayer:t,keepAnnotationEditorLayer:i,keepXfaLayer:n,keepTextLayer:o}),this.renderingState=s.RenderingStates.INITIAL;const a=this.div,r=a.childNodes,l=e&&this.zoomLayer||null,d=t&&this.annotationLayer?.div||null,h=i&&this.annotationEditorLayer?.div||null,c=n&&this.xfaLayer?.div||null,u=o&&this.textLayer?.div||null;for(let e=r.length-1;e>=0;e--){const t=r[e];switch(t){case l:case d:case h:case c:case u:continue}t.remove()}a.removeAttribute("data-loaded"),d&&this.annotationLayer.hide(),h&&this.annotationEditorLayer.hide(),c&&this.xfaLayer.hide(),u&&this.textLayer.hide(),this.structTreeLayer?.hide(),l||(this.canvas&&(this.#oi.delete(this.canvas),this.canvas.width=0,this.canvas.height=0,delete this.canvas),this._resetZoomLayer())}update({scale:e=0,rotation:t=null,optionalContentConfigPromise:i=null,drawingDelay:o=-1}){this.scale=e||this.scale,"number"==typeof t&&(this.rotation=t),i instanceof Promise&&(this._optionalContentConfigPromise=i,i.then((e=>{i===this._optionalContentConfigPromise&&(this.#si.initialOptionalContent=e.hasInitialVisibility)}))),this.#si.directDrawing=!0;const a=(this.rotation+this.pdfPageRotate)%360;if(this.viewport=this.viewport.clone({scale:this.scale*n.PixelsPerInch.PDF_TO_CSS_UNITS,rotation:a}),this.#ai(),this._isStandalone&&this._container?.style.setProperty("--scale-factor",this.viewport.scale),this.canvas){let e=!1;if(this.#Jt)if(0===this.maxCanvasPixels)e=!0;else if(this.maxCanvasPixels>0){const{width:t,height:i}=this.viewport,{sx:n,sy:s}=this.outputScale;e=(Math.floor(t)*n|0)*(Math.floor(i)*s|0)>this.maxCanvasPixels}const t=!e&&o>=0&&o<1e3;if(t||e){if(t&&this.renderingState!==s.RenderingStates.FINISHED&&(this.cancelRendering({keepZoomLayer:!0,keepAnnotationLayer:!0,keepAnnotationEditorLayer:!0,keepXfaLayer:!0,keepTextLayer:!0,cancelExtraDelay:o}),this.renderingState=s.RenderingStates.FINISHED,this.#si.directDrawing=!1),this.cssTransform({target:this.canvas,redrawAnnotationLayer:!0,redrawAnnotationEditorLayer:!0,redrawXfaLayer:!0,redrawTextLayer:!t,hideTextLayer:t}),t)return;return void this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!0,timestamp:performance.now(),error:this.#ii})}this.zoomLayer||this.canvas.hidden||(this.zoomLayer=this.canvas.parentNode,this.zoomLayer.style.position="absolute")}this.zoomLayer&&this.cssTransform({target:this.zoomLayer.firstChild}),this.reset({keepZoomLayer:!0,keepAnnotationLayer:!0,keepAnnotationEditorLayer:!0,keepXfaLayer:!0,keepTextLayer:!0})}cancelRendering({keepAnnotationLayer:e=!1,keepAnnotationEditorLayer:t=!1,keepXfaLayer:i=!1,keepTextLayer:n=!1,cancelExtraDelay:s=0}={}){this.renderTask&&(this.renderTask.cancel(s),this.renderTask=null),this.resume=null,!this.textLayer||n&&this.textLayer.div||(this.textLayer.cancel(),this.textLayer=null),this.structTreeLayer&&!this.textLayer&&(this.structTreeLayer=null),!this.annotationLayer||e&&this.annotationLayer.div||(this.annotationLayer.cancel(),this.annotationLayer=null,this._annotationCanvasMap=null),!this.annotationEditorLayer||t&&this.annotationEditorLayer.div||(this.annotationEditorLayer.cancel(),this.annotationEditorLayer=null),!this.xfaLayer||i&&this.xfaLayer.div||(this.xfaLayer.cancel(),this.xfaLayer=null,this._textHighlighter?.disable())}cssTransform({target:e,redrawAnnotationLayer:t=!1,redrawAnnotationEditorLayer:i=!1,redrawXfaLayer:n=!1,redrawTextLayer:s=!1,hideTextLayer:o=!1}){if(!e.hasAttribute("zooming")){e.setAttribute("zooming",!0);const{style:t}=e;t.width=t.height=""}const a=this.#oi.get(e);if(this.viewport!==a){const t=this.viewport.rotation-a.rotation,i=Math.abs(t);let n=1,s=1;if(90===i||270===i){const{width:e,height:t}=this.viewport;n=t/e,s=e/t}e.style.transform=`rotate(${t}deg) scale(${n}, ${s})`}t&&this.annotationLayer&&this.#ri(),i&&this.annotationEditorLayer&&this.#li(),n&&this.xfaLayer&&this.#di(),this.textLayer&&(o?(this.textLayer.hide(),this.structTreeLayer?.hide()):s&&this.#ci())}get width(){return this.viewport.width}get height(){return this.viewport.height}getPagePoint(e,t){return this.viewport.convertToPdfPoint(e,t)}async#bt(e,t=null){if(e===this.renderTask&&(this.renderTask=null),t instanceof n.RenderingCancelledException)this.#ii=null;else if(this.#ii=t,this.renderingState=s.RenderingStates.FINISHED,this._resetZoomLayer(!0),this.#si.regularAnnotations=!e.separateAnnots,this.eventBus.dispatch("pagerendered",{source:this,pageNumber:this.id,cssTransform:!1,timestamp:performance.now(),error:this.#ii}),t)throw t}async draw(){this.renderingState!==s.RenderingStates.INITIAL&&(console.error("Must be in new state before drawing"),this.reset());const{div:e,l10n:t,pageColors:i,pdfPage:r,viewport:l}=this;if(!r)throw this.renderingState=s.RenderingStates.FINISHED,new Error("pdfPage is not loaded");this.renderingState=s.RenderingStates.RUNNING;const d=document.createElement("div");if(d.classList.add("canvasWrapper"),e.append(d),this.textLayer||this.#Ut===s.TextLayerMode.DISABLE||r.isPureXfa||(this._accessibilityManager||=new h.TextAccessibilityManager,this.textLayer=new u.TextLayerBuilder({highlighter:this._textHighlighter,accessibilityManager:this._accessibilityManager,isOffscreenCanvasSupported:this.isOffscreenCanvasSupported,enablePermissions:this.#Ut===s.TextLayerMode.ENABLE_PERMISSIONS}),e.append(this.textLayer.div)),!this.annotationLayer&&this.#Tt!==n.AnnotationMode.DISABLE){const{annotationStorage:i,downloadManager:s,enableScripting:o,fieldObjectsPromise:l,hasJSActionsPromise:d,linkService:h}=this.#$t();this._annotationCanvasMap||=new Map,this.annotationLayer=new a.AnnotationLayerBuilder({pageDiv:e,pdfPage:r,annotationStorage:i,imageResourcesPath:this.imageResourcesPath,renderForms:this.#Tt===n.AnnotationMode.ENABLE_FORMS,linkService:h,downloadManager:s,l10n:t,enableScripting:o,hasJSActionsPromise:d,fieldObjectsPromise:l,annotationCanvasMap:this._annotationCanvasMap,accessibilityManager:this._accessibilityManager})}const{width:c,height:g}=l,m=document.createElement("canvas");m.setAttribute("role","presentation"),m.hidden=!0;const f=!(!i?.background||!i?.foreground);let v=e=>{f&&!e||(m.hidden=!1,v=null)};d.append(m),this.canvas=m;const w=m.getContext("2d",{alpha:!1}),b=this.outputScale=new s.OutputScale;if(0===this.maxCanvasPixels){const e=1/this.scale;b.sx*=e,b.sy*=e,this.#Jt=!0}else if(this.maxCanvasPixels>0){const e=c*g,t=Math.sqrt(this.maxCanvasPixels/e);b.sx>t||b.sy>t?(b.sx=t,b.sy=t,this.#Jt=!0):this.#Jt=!1}const _=(0,s.approximateFraction)(b.sx),y=(0,s.approximateFraction)(b.sy);m.width=(0,s.roundToDivide)(c*b.sx,_[0]),m.height=(0,s.roundToDivide)(g*b.sy,y[0]);const{style:P}=m;P.width=(0,s.roundToDivide)(c,_[1])+"px",P.height=(0,s.roundToDivide)(g,y[1])+"px",this.#oi.set(m,l);const E={canvasContext:w,transform:b.scaled?[b.sx,0,0,b.sy,0,0]:null,viewport:l,annotationMode:this.#Tt,optionalContentConfigPromise:this._optionalContentConfigPromise,annotationCanvasMap:this._annotationCanvasMap,pageColors:i},S=this.renderTask=this.pdfPage.render(E);S.onContinue=e=>{if(v?.(!1),this.renderingQueue&&!this.renderingQueue.isHighestPriority(this))return this.renderingState=s.RenderingStates.PAUSED,void(this.resume=()=>{this.renderingState=s.RenderingStates.RUNNING,e()});e()};const C=S.promise.then((async()=>{if(v?.(!0),await this.#bt(S),this.#ci(),this.annotationLayer&&await this.#ri(),!this.annotationEditorLayer){const{annotationEditorUIManager:i}=this.#$t();if(!i)return;this.annotationEditorLayer=new o.AnnotationEditorLayerBuilder({uiManager:i,pageDiv:e,pdfPage:r,l10n:t,accessibilityManager:this._accessibilityManager,annotationLayer:this.annotationLayer?.annotationLayer})}this.#li()}),(e=>(e instanceof n.RenderingCancelledException||v?.(!0),this.#bt(S,e))));if(r.isPureXfa){if(this.xfaLayer)this.xfaLayer.div&&e.append(this.xfaLayer.div);else{const{annotationStorage:t,linkService:i}=this.#$t();this.xfaLayer=new p.XfaLayerBuilder({pageDiv:e,pdfPage:r,annotationStorage:t,linkService:i})}this.#di()}return e.setAttribute("data-loaded",!0),this.eventBus.dispatch("pagerender",{source:this,pageNumber:this.id}),C}setPageLabel(e){this.pageLabel="string"==typeof e?e:null,null!==this.pageLabel?this.div.setAttribute("data-page-label",this.pageLabel):this.div.removeAttribute("data-page-label")}get thumbnailCanvas(){const{directDrawing:e,initialOptionalContent:t,regularAnnotations:i}=this.#si;return e&&t&&i?this.canvas:null}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.AnnotationEditorLayerBuilder=void 0;var n=i(4),s=i(30);t.AnnotationEditorLayerBuilder=class{#pi=null;#C;constructor(e){this.pageDiv=e.pageDiv,this.pdfPage=e.pdfPage,this.accessibilityManager=e.accessibilityManager,this.l10n=e.l10n||s.NullL10n,this.annotationEditorLayer=null,this.div=null,this._cancelled=!1,this.#C=e.uiManager,this.#pi=e.annotationLayer||null}async render(e,t="display"){if("display"!==t)return;if(this._cancelled)return;const i=e.clone({dontFlip:!0});if(this.div)return this.annotationEditorLayer.update({viewport:i}),void this.show();const s=this.div=document.createElement("div");s.className="annotationEditorLayer",s.tabIndex=0,s.hidden=!0,s.dir=this.#C.direction,this.pageDiv.append(s),this.annotationEditorLayer=new n.AnnotationEditorLayer({uiManager:this.#C,div:s,accessibilityManager:this.accessibilityManager,pageIndex:this.pdfPage.pageNumber-1,l10n:this.l10n,viewport:i,annotationLayer:this.#pi});const o={viewport:i,div:s,annotations:null,intent:t};this.annotationEditorLayer.render(o),this.show()}cancel(){this._cancelled=!0,this.div&&(this.pageDiv=null,this.annotationEditorLayer.destroy(),this.div.remove())}hide(){this.div&&(this.div.hidden=!0)}show(){this.div&&!this.annotationEditorLayer.isEmpty&&(this.div.hidden=!1)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.AnnotationLayerBuilder=void 0;var n=i(4),s=i(30),o=i(3);t.AnnotationLayerBuilder=class{#gi=null;constructor({pageDiv:e,pdfPage:t,linkService:i,downloadManager:n,annotationStorage:o=null,imageResourcesPath:a="",renderForms:r=!0,l10n:l=s.NullL10n,enableScripting:d=!1,hasJSActionsPromise:h=null,fieldObjectsPromise:c=null,annotationCanvasMap:u=null,accessibilityManager:p=null}){this.pageDiv=e,this.pdfPage=t,this.linkService=i,this.downloadManager=n,this.imageResourcesPath=a,this.renderForms=r,this.l10n=l,this.annotationStorage=o,this.enableScripting=d,this._hasJSActionsPromise=h||Promise.resolve(!1),this._fieldObjectsPromise=c||Promise.resolve(null),this._annotationCanvasMap=u,this._accessibilityManager=p,this.annotationLayer=null,this.div=null,this._cancelled=!1,this._eventBus=i.eventBus}async render(e,t="display"){if(this.div){if(this._cancelled||!this.annotationLayer)return;return void this.annotationLayer.update({viewport:e.clone({dontFlip:!0})})}const[i,s,a]=await Promise.all([this.pdfPage.getAnnotations({intent:t}),this._hasJSActionsPromise,this._fieldObjectsPromise]);if(this._cancelled)return;const r=this.div=document.createElement("div");r.className="annotationLayer",this.pageDiv.append(r),0!==i.length?(this.annotationLayer=new n.AnnotationLayer({div:r,accessibilityManager:this._accessibilityManager,annotationCanvasMap:this._annotationCanvasMap,l10n:this.l10n,page:this.pdfPage,viewport:e.clone({dontFlip:!0})}),await this.annotationLayer.render({annotations:i,imageResourcesPath:this.imageResourcesPath,renderForms:this.renderForms,linkService:this.linkService,downloadManager:this.downloadManager,annotationStorage:this.annotationStorage,enableScripting:this.enableScripting,hasJSActions:s,fieldObjects:a}),this.linkService.isInPresentationMode&&this.#mi(o.PresentationModeState.FULLSCREEN),this.#gi||(this.#gi=e=>{this.#mi(e.state)},this._eventBus?._on("presentationmodechanged",this.#gi))):this.hide()}cancel(){this._cancelled=!0,this.#gi&&(this._eventBus?._off("presentationmodechanged",this.#gi),this.#gi=null)}hide(){this.div&&(this.div.hidden=!0)}#mi(e){if(!this.div)return;let t=!1;switch(e){case o.PresentationModeState.FULLSCREEN:t=!0;break;case o.PresentationModeState.NORMAL:break;default:return}for(const e of this.div.childNodes)e.hasAttribute("data-internal-link")||(e.inert=t)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.StructTreeLayerBuilder=void 0;var n=i(3);const s={Document:null,DocumentFragment:null,Part:"group",Sect:"group",Div:"group",Aside:"note",NonStruct:"none",P:null,H:"heading",Title:null,FENote:"note",Sub:"group",Lbl:null,Span:null,Em:null,Strong:null,Link:"link",Annot:"note",Form:"form",Ruby:null,RB:null,RT:null,RP:null,Warichu:null,WT:null,WP:null,L:"list",LI:"listitem",LBody:null,Table:"table",TR:"row",TH:"columnheader",TD:"cell",THead:"columnheader",TBody:null,TFoot:null,Caption:null,Figure:"figure",Formula:null,Artifact:null},o=/^H(\d+)$/;t.StructTreeLayerBuilder=class{#fi=void 0;get renderingDone(){return void 0!==this.#fi}render(e){if(void 0!==this.#fi)return this.#fi;const t=this.#vi(e);return t?.classList.add("structTree"),this.#fi=t}hide(){this.#fi&&!this.#fi.hidden&&(this.#fi.hidden=!0)}show(){this.#fi?.hidden&&(this.#fi.hidden=!1)}#wi(e,t){const{alt:i,id:s,lang:o}=e;void 0!==i&&t.setAttribute("aria-label",(0,n.removeNullCharacters)(i)),void 0!==s&&t.setAttribute("aria-owns",s),void 0!==o&&t.setAttribute("lang",(0,n.removeNullCharacters)(o,!0))}#vi(e){if(!e)return null;const t=document.createElement("span");if("role"in e){const{role:i}=e,n=i.match(o);n?(t.setAttribute("role","heading"),t.setAttribute("aria-level",n[1])):s[i]&&t.setAttribute("role",s[i])}if(this.#wi(e,t),e.children)if(1===e.children.length&&"id"in e.children[0])this.#wi(e.children[0],t);else for(const i of e.children)t.append(this.#vi(i));return t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.TextAccessibilityManager=void 0;var n=i(3);class s{#bi=!1;#_i=null;#yi=new Map;#Pi=new Map;setTextMapping(e){this.#_i=e}static#Ei(e,t){const i=e.getBoundingClientRect(),n=t.getBoundingClientRect();if(0===i.width&&0===i.height)return 1;if(0===n.width&&0===n.height)return-1;const s=i.y,o=i.y+i.height,a=i.y+i.height/2,r=n.y,l=n.y+n.height,d=n.y+n.height/2;if(a<=r&&d>=o)return-1;if(d<=s&&a>=l)return 1;return i.x+i.width/2-(n.x+n.width/2)}enable(){if(this.#bi)throw new Error("TextAccessibilityManager is already enabled.");if(!this.#_i)throw new Error("Text divs and strings have not been set.");if(this.#bi=!0,this.#_i=this.#_i.slice(),this.#_i.sort(s.#Ei),this.#yi.size>0){const e=this.#_i;for(const[t,i]of this.#yi){document.getElementById(t)?this.#Si(t,e[i]):this.#yi.delete(t)}}for(const[e,t]of this.#Pi)this.addPointerInTextLayer(e,t);this.#Pi.clear()}disable(){this.#bi&&(this.#Pi.clear(),this.#_i=null,this.#bi=!1)}removePointerInTextLayer(e){if(!this.#bi)return void this.#Pi.delete(e);const t=this.#_i;if(!t||0===t.length)return;const{id:i}=e,n=this.#yi.get(i);if(void 0===n)return;const s=t[n];this.#yi.delete(i);let o=s.getAttribute("aria-owns");o?.includes(i)&&(o=o.split(" ").filter((e=>e!==i)).join(" "),o?s.setAttribute("aria-owns",o):(s.removeAttribute("aria-owns"),s.setAttribute("role","presentation")))}#Si(e,t){const i=t.getAttribute("aria-owns");i?.includes(e)||t.setAttribute("aria-owns",i?`${i} ${e}`:e),t.removeAttribute("role")}addPointerInTextLayer(e,t){const{id:i}=e;if(!i)return null;if(!this.#bi)return this.#Pi.set(e,t),null;t&&this.removePointerInTextLayer(e);const o=this.#_i;if(!o||0===o.length)return null;const a=(0,n.binarySearchFirstItem)(o,(t=>s.#Ei(e,t)<0)),r=Math.max(0,a-1),l=o[r];this.#Si(i,l),this.#yi.set(i,r);const d=l.parentNode;return d?.classList.contains("markedContent")?d.id:null}moveElementInDOM(e,t,i,o){const a=this.addPointerInTextLayer(i,o);if(!e.hasChildNodes())return e.append(t),a;const r=Array.from(e.childNodes).filter((e=>e!==t));if(0===r.length)return a;const l=i||t,d=(0,n.binarySearchFirstItem)(r,(e=>s.#Ei(l,e)<0));return 0===d?r[0].before(t):r[d-1].after(t),a}}t.TextAccessibilityManager=s},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.TextHighlighter=void 0;t.TextHighlighter=class{constructor({findController:e,eventBus:t,pageIndex:i}){this.findController=e,this.matches=[],this.eventBus=t,this.pageIdx=i,this._onUpdateTextLayerMatches=null,this.textDivs=null,this.textContentItemsStr=null,this.enabled=!1}setTextMapping(e,t){this.textDivs=e,this.textContentItemsStr=t}enable(){if(!this.textDivs||!this.textContentItemsStr)throw new Error("Text divs and strings have not been set.");if(this.enabled)throw new Error("TextHighlighter is already enabled.");this.enabled=!0,this._onUpdateTextLayerMatches||(this._onUpdateTextLayerMatches=e=>{e.pageIndex!==this.pageIdx&&-1!==e.pageIndex||this._updateMatches()},this.eventBus._on("updatetextlayermatches",this._onUpdateTextLayerMatches)),this._updateMatches()}disable(){this.enabled&&(this.enabled=!1,this._onUpdateTextLayerMatches&&(this.eventBus._off("updatetextlayermatches",this._onUpdateTextLayerMatches),this._onUpdateTextLayerMatches=null),this._updateMatches(!0))}_convertMatches(e,t){if(!e)return[];const{textContentItemsStr:i}=this;let n=0,s=0;const o=i.length-1,a=[];for(let r=0,l=e.length;r<l;r++){let l=e[r];for(;n!==o&&l>=s+i[n].length;)s+=i[n].length,n++;n===i.length&&console.error("Could not find a matching mapping");const d={begin:{divIdx:n,offset:l-s}};for(l+=t[r];n!==o&&l>s+i[n].length;)s+=i[n].length,n++;d.end={divIdx:n,offset:l-s},a.push(d)}return a}_renderMatches(e){if(0===e.length)return;const{findController:t,pageIdx:i}=this,{textContentItemsStr:n,textDivs:s}=this,o=i===t.selected.pageIdx,a=t.selected.matchIdx;let r=null;const l={divIdx:-1,offset:void 0};function d(e,t){const i=e.divIdx;return s[i].textContent="",h(i,0,e.offset,t)}function h(e,t,i,o){let a=s[e];if(a.nodeType===Node.TEXT_NODE){const t=document.createElement("span");a.before(t),t.append(a),s[e]=t,a=t}const r=n[e].substring(t,i),l=document.createTextNode(r);if(o){const e=document.createElement("span");return e.className=`${o} appended`,e.append(l),a.append(e),o.includes("selected")?e.offsetLeft:0}return a.append(l),0}let c=a,u=c+1;if(t.state.highlightAll)c=0,u=e.length;else if(!o)return;let p=-1,g=-1;for(let n=c;n<u;n++){const c=e[n],u=c.begin;if(u.divIdx===p&&u.offset===g)continue;p=u.divIdx,g=u.offset;const m=c.end,f=o&&n===a,v=f?" selected":"";let w=0;if(r&&u.divIdx===r.divIdx?h(r.divIdx,r.offset,u.offset):(null!==r&&h(r.divIdx,r.offset,l.offset),d(u)),u.divIdx===m.divIdx)w=h(u.divIdx,u.offset,m.offset,"highlight"+v);else{w=h(u.divIdx,u.offset,l.offset,"highlight begin"+v);for(let e=u.divIdx+1,t=m.divIdx;e<t;e++)s[e].className="highlight middle"+v;d(m,"highlight end"+v)}r=m,f&&t.scrollMatchIntoView({element:s[u.divIdx],selectedLeft:w,pageIndex:i,matchIndex:a})}r&&h(r.divIdx,r.offset,l.offset)}_updateMatches(e=!1){if(!this.enabled&&!e)return;const{findController:t,matches:i,pageIdx:n}=this,{textContentItemsStr:s,textDivs:o}=this;let a=-1;for(const e of i){for(let t=Math.max(a,e.begin.divIdx),i=e.end.divIdx;t<=i;t++){const e=o[t];e.textContent=s[t],e.className=""}a=e.end.divIdx+1}if(!t?.highlightMatches||e)return;const r=t.pageMatches[n]||null,l=t.pageMatchesLength[n]||null;this.matches=this._convertMatches(r,l),this._renderMatches(this.matches)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.TextLayerBuilder=void 0;var n=i(4),s=i(3);t.TextLayerBuilder=class{#At=!1;#Ci=0;#Li=0;#Ti=null;constructor({highlighter:e=null,accessibilityManager:t=null,isOffscreenCanvasSupported:i=!0,enablePermissions:n=!1}){this.textContentItemsStr=[],this.renderingDone=!1,this.textDivs=[],this.textDivProperties=new WeakMap,this.textLayerRenderTask=null,this.highlighter=e,this.accessibilityManager=t,this.isOffscreenCanvasSupported=i,this.#At=!0===n,this.div=document.createElement("div"),this.div.className="textLayer",this.hide()}#Mi(){this.renderingDone=!0;const e=document.createElement("div");e.className="endOfContent",this.div.append(e),this.#Ii()}get numTextDivs(){return this.textDivs.length}async render(e){if(!this.#Ti)throw new Error('No "textContentSource" parameter specified.');const t=e.scale*(globalThis.devicePixelRatio||1),{rotation:i}=e;if(this.renderingDone){const s=i!==this.#Ci,o=t!==this.#Li;return(s||o)&&(this.hide(),(0,n.updateTextLayer)({container:this.div,viewport:e,textDivs:this.textDivs,textDivProperties:this.textDivProperties,isOffscreenCanvasSupported:this.isOffscreenCanvasSupported,mustRescale:o,mustRotate:s}),this.#Li=t,this.#Ci=i),void this.show()}this.cancel(),this.highlighter?.setTextMapping(this.textDivs,this.textContentItemsStr),this.accessibilityManager?.setTextMapping(this.textDivs),this.textLayerRenderTask=(0,n.renderTextLayer)({textContentSource:this.#Ti,container:this.div,viewport:e,textDivs:this.textDivs,textDivProperties:this.textDivProperties,textContentItemsStr:this.textContentItemsStr,isOffscreenCanvasSupported:this.isOffscreenCanvasSupported}),await this.textLayerRenderTask.promise,this.#Mi(),this.#Li=t,this.#Ci=i,this.show(),this.accessibilityManager?.enable()}hide(){this.div.hidden||(this.highlighter?.disable(),this.div.hidden=!0)}show(){this.div.hidden&&this.renderingDone&&(this.div.hidden=!1,this.highlighter?.enable())}cancel(){this.textLayerRenderTask&&(this.textLayerRenderTask.cancel(),this.textLayerRenderTask=null),this.highlighter?.disable(),this.accessibilityManager?.disable(),this.textContentItemsStr.length=0,this.textDivs.length=0,this.textDivProperties=new WeakMap}setTextContentSource(e){this.cancel(),this.#Ti=e}#Ii(){const{div:e}=this;e.addEventListener("mousedown",(t=>{const i=e.querySelector(".endOfContent");if(!i)return;let n=t.target!==e;if(n&&="none"!==getComputedStyle(i).getPropertyValue("-moz-user-select"),n){const n=e.getBoundingClientRect(),s=Math.max(0,(t.pageY-n.top)/n.height);i.style.top=(100*s).toFixed(2)+"%"}i.classList.add("active")})),e.addEventListener("mouseup",(()=>{const t=e.querySelector(".endOfContent");t&&(t.style.top="",t.classList.remove("active"))})),e.addEventListener("copy",(e=>{if(!this.#At){const t=document.getSelection();e.clipboardData.setData("text/plain",(0,s.removeNullCharacters)((0,n.normalizeUnicode)(t.toString())))}e.preventDefault(),e.stopPropagation()}))}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.XfaLayerBuilder=void 0;var n=i(4);t.XfaLayerBuilder=class{constructor({pageDiv:e,pdfPage:t,annotationStorage:i=null,linkService:n,xfaHtml:s=null}){this.pageDiv=e,this.pdfPage=t,this.annotationStorage=i,this.linkService=n,this.xfaHtml=s,this.div=null,this._cancelled=!1}async render(e,t="display"){if("print"===t){const i={viewport:e.clone({dontFlip:!0}),div:this.div,xfaHtml:this.xfaHtml,annotationStorage:this.annotationStorage,linkService:this.linkService,intent:t},s=document.createElement("div");return this.pageDiv.append(s),i.div=s,n.XfaLayer.render(i)}const i=await this.pdfPage.getXfa();if(this._cancelled||!i)return{textDivs:[]};const s={viewport:e.clone({dontFlip:!0}),div:this.div,xfaHtml:i,annotationStorage:this.annotationStorage,linkService:this.linkService,intent:t};return this.div?n.XfaLayer.update(s):(this.div=document.createElement("div"),this.pageDiv.append(this.div),s.div=this.div,n.XfaLayer.render(s))}cancel(){this._cancelled=!0}hide(){this.div&&(this.div.hidden=!0)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.SecondaryToolbar=void 0;var n=i(3),s=i(29);t.SecondaryToolbar=class{constructor(e,t){this.toolbar=e.toolbar,this.toggleButton=e.toggleButton,this.buttons=[{element:e.presentationModeButton,eventName:"presentationmode",close:!0},{element:e.printButton,eventName:"print",close:!0},{element:e.downloadButton,eventName:"download",close:!0},{element:e.viewBookmarkButton,eventName:null,close:!0},{element:e.firstPageButton,eventName:"firstpage",close:!0},{element:e.lastPageButton,eventName:"lastpage",close:!0},{element:e.pageRotateCwButton,eventName:"rotatecw",close:!1},{element:e.pageRotateCcwButton,eventName:"rotateccw",close:!1},{element:e.cursorSelectToolButton,eventName:"switchcursortool",eventDetails:{tool:n.CursorTool.SELECT},close:!0},{element:e.cursorHandToolButton,eventName:"switchcursortool",eventDetails:{tool:n.CursorTool.HAND},close:!0},{element:e.scrollPageButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.PAGE},close:!0},{element:e.scrollVerticalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.VERTICAL},close:!0},{element:e.scrollHorizontalButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.HORIZONTAL},close:!0},{element:e.scrollWrappedButton,eventName:"switchscrollmode",eventDetails:{mode:n.ScrollMode.WRAPPED},close:!0},{element:e.spreadNoneButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.NONE},close:!0},{element:e.spreadOddButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.ODD},close:!0},{element:e.spreadEvenButton,eventName:"switchspreadmode",eventDetails:{mode:n.SpreadMode.EVEN},close:!0},{element:e.documentPropertiesButton,eventName:"documentproperties",close:!0}],this.buttons.push({element:e.openFileButton,eventName:"openfile",close:!0}),this.items={firstPage:e.firstPageButton,lastPage:e.lastPageButton,pageRotateCw:e.pageRotateCwButton,pageRotateCcw:e.pageRotateCcwButton},this.eventBus=t,this.opened=!1,this.#Ai(),this.#xi(e),this.#Di(e),this.#Ni(e),this.reset()}get isOpen(){return this.opened}setPageNumber(e){this.pageNumber=e,this.#h()}setPagesCount(e){this.pagesCount=e,this.#h()}reset(){this.pageNumber=0,this.pagesCount=0,this.#h(),this.eventBus.dispatch("secondarytoolbarreset",{source:this})}#h(){this.items.firstPage.disabled=this.pageNumber<=1,this.items.lastPage.disabled=this.pageNumber>=this.pagesCount,this.items.pageRotateCw.disabled=0===this.pagesCount,this.items.pageRotateCcw.disabled=0===this.pagesCount}#Ai(){this.toggleButton.addEventListener("click",this.toggle.bind(this));for(const{element:e,eventName:t,close:i,eventDetails:n}of this.buttons)e.addEventListener("click",(s=>{null!==t&&this.eventBus.dispatch(t,{source:this,...n}),i&&this.close(),this.eventBus.dispatch("reporttelemetry",{source:this,details:{type:"buttons",data:{id:e.id}}})}))}#xi({cursorSelectToolButton:e,cursorHandToolButton:t}){this.eventBus._on("cursortoolchanged",(({tool:i})=>{(0,n.toggleCheckedBtn)(e,i===n.CursorTool.SELECT),(0,n.toggleCheckedBtn)(t,i===n.CursorTool.HAND)}))}#Di({scrollPageButton:e,scrollVerticalButton:t,scrollHorizontalButton:i,scrollWrappedButton:o,spreadNoneButton:a,spreadOddButton:r,spreadEvenButton:l}){const d=({mode:d})=>{(0,n.toggleCheckedBtn)(e,d===n.ScrollMode.PAGE),(0,n.toggleCheckedBtn)(t,d===n.ScrollMode.VERTICAL),(0,n.toggleCheckedBtn)(i,d===n.ScrollMode.HORIZONTAL),(0,n.toggleCheckedBtn)(o,d===n.ScrollMode.WRAPPED);const h=this.pagesCount>s.PagesCountLimit.FORCE_SCROLL_MODE_PAGE;e.disabled=h,t.disabled=h,i.disabled=h,o.disabled=h;const c=d===n.ScrollMode.HORIZONTAL;a.disabled=c,r.disabled=c,l.disabled=c};this.eventBus._on("scrollmodechanged",d),this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&d({mode:n.ScrollMode.VERTICAL})}))}#Ni({spreadNoneButton:e,spreadOddButton:t,spreadEvenButton:i}){const s=({mode:s})=>{(0,n.toggleCheckedBtn)(e,s===n.SpreadMode.NONE),(0,n.toggleCheckedBtn)(t,s===n.SpreadMode.ODD),(0,n.toggleCheckedBtn)(i,s===n.SpreadMode.EVEN)};this.eventBus._on("spreadmodechanged",s),this.eventBus._on("secondarytoolbarreset",(e=>{e.source===this&&s({mode:n.SpreadMode.NONE})}))}open(){this.opened||(this.opened=!0,(0,n.toggleExpandedBtn)(this.toggleButton,!0,this.toolbar))}close(){this.opened&&(this.opened=!1,(0,n.toggleExpandedBtn)(this.toggleButton,!1,this.toolbar))}toggle(){this.opened?this.close():this.open()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.Toolbar=void 0;var n=i(3),s=i(4);t.Toolbar=class{#Bi=!1;constructor(e,t,i){this.toolbar=e.container,this.eventBus=t,this.l10n=i,this.buttons=[{element:e.previous,eventName:"previouspage"},{element:e.next,eventName:"nextpage"},{element:e.zoomIn,eventName:"zoomin"},{element:e.zoomOut,eventName:"zoomout"},{element:e.print,eventName:"print"},{element:e.download,eventName:"download"},{element:e.editorFreeTextButton,eventName:"switchannotationeditormode",eventDetails:{get mode(){const{classList:t}=e.editorFreeTextButton;return t.contains("toggled")?s.AnnotationEditorType.NONE:s.AnnotationEditorType.FREETEXT}}},{element:e.editorInkButton,eventName:"switchannotationeditormode",eventDetails:{get mode(){const{classList:t}=e.editorInkButton;return t.contains("toggled")?s.AnnotationEditorType.NONE:s.AnnotationEditorType.INK}}},{element:e.editorStampButton,eventName:"switchannotationeditormode",eventDetails:{get mode(){const{classList:t}=e.editorStampButton;return t.contains("toggled")?s.AnnotationEditorType.NONE:s.AnnotationEditorType.STAMP}}}],this.buttons.push({element:e.openFile,eventName:"openfile"}),this.items={numPages:e.numPages,pageNumber:e.pageNumber,scaleSelect:e.scaleSelect,customScaleOption:e.customScaleOption,previous:e.previous,next:e.next,zoomIn:e.zoomIn,zoomOut:e.zoomOut},this.#O(e),this.reset()}setPageNumber(e,t){this.pageNumber=e,this.pageLabel=t,this.#h(!1)}setPagesCount(e,t){this.pagesCount=e,this.hasPageLabels=t,this.#h(!0)}setPageScale(e,t){this.pageScaleValue=(e||t).toString(),this.pageScale=t,this.#h(!1)}reset(){this.pageNumber=0,this.pageLabel=null,this.hasPageLabels=!1,this.pagesCount=0,this.pageScaleValue=n.DEFAULT_SCALE_VALUE,this.pageScale=n.DEFAULT_SCALE,this.#h(!0),this.updateLoadingIndicatorState(),this.eventBus.dispatch("toolbarreset",{source:this})}#O(e){const{pageNumber:t,scaleSelect:i}=this.items,n=this;for(const{element:e,eventName:t,eventDetails:i}of this.buttons)e.addEventListener("click",(e=>{null!==t&&this.eventBus.dispatch(t,{source:this,...i})}));t.addEventListener("click",(function(){this.select()})),t.addEventListener("change",(function(){n.eventBus.dispatch("pagenumberchanged",{source:n,value:this.value})})),i.addEventListener("change",(function(){"custom"!==this.value&&n.eventBus.dispatch("scalechanged",{source:n,value:this.value})})),i.addEventListener("click",(function(e){const t=e.target;this.value===n.pageScaleValue&&"OPTION"===t.tagName.toUpperCase()&&this.blur()})),i.oncontextmenu=s.noContextMenu,this.eventBus._on("localized",(()=>{this.#Bi=!0,this.#ki(),this.#h(!0)})),this.#Oi(e)}#Oi({editorFreeTextButton:e,editorFreeTextParamsToolbar:t,editorInkButton:i,editorInkParamsToolbar:o,editorStampButton:a,editorStampParamsToolbar:r}){const l=({mode:l})=>{(0,n.toggleCheckedBtn)(e,l===s.AnnotationEditorType.FREETEXT,t),(0,n.toggleCheckedBtn)(i,l===s.AnnotationEditorType.INK,o),(0,n.toggleCheckedBtn)(a,l===s.AnnotationEditorType.STAMP,r);const d=l===s.AnnotationEditorType.DISABLE;e.disabled=d,i.disabled=d,a.disabled=d};this.eventBus._on("annotationeditormodechanged",l),this.eventBus._on("toolbarreset",(e=>{e.source===this&&l({mode:s.AnnotationEditorType.DISABLE})}))}#h(e=!1){if(!this.#Bi)return;const{pageNumber:t,pagesCount:i,pageScaleValue:s,pageScale:o,items:a}=this;e&&(this.hasPageLabels?a.pageNumber.type="text":(a.pageNumber.type="number",this.l10n.get("of_pages",{pagesCount:i}).then((e=>{a.numPages.textContent=e}))),a.pageNumber.max=i),this.hasPageLabels?(a.pageNumber.value=this.pageLabel,this.l10n.get("page_of_pages",{pageNumber:t,pagesCount:i}).then((e=>{a.numPages.textContent=e}))):a.pageNumber.value=t,a.previous.disabled=t<=1,a.next.disabled=t>=i,a.zoomOut.disabled=o<=n.MIN_SCALE,a.zoomIn.disabled=o>=n.MAX_SCALE,this.l10n.get("page_scale_percent",{scale:Math.round(1e4*o)/100}).then((e=>{let t=!1;for(const e of a.scaleSelect.options)e.value===s?(e.selected=!0,t=!0):e.selected=!1;t||(a.customScaleOption.textContent=e,a.customScaleOption.selected=!0)}))}updateLoadingIndicatorState(e=!1){const{pageNumber:t}=this.items;t.classList.toggle("visiblePageIsLoading",e)}async#ki(){const{items:e,l10n:t}=this,i=Promise.all([t.get("page_scale_auto"),t.get("page_scale_actual"),t.get("page_scale_fit"),t.get("page_scale_width")]);await n.animationStarted;const s=getComputedStyle(e.scaleSelect),o=parseFloat(s.getPropertyValue("--scale-select-width")),a=document.createElement("canvas"),r=a.getContext("2d",{alpha:!1});r.font=`${s.fontSize} ${s.fontFamily}`;let l=0;for(const e of await i){const{width:t}=r.measureText(e);t>l&&(l=t)}if(l+=.3*o,l>o){e.scaleSelect.parentNode.style.setProperty("--scale-select-width",`${l}px`)}a.width=0,a.height=0}}},(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ViewHistory=void 0;t.ViewHistory=class{constructor(e,t=20){this.fingerprint=e,this.cacheSize=t,this._initializedPromise=this._readFromStorage().then((e=>{const t=JSON.parse(e||"{}");let i=-1;if(Array.isArray(t.files)){for(;t.files.length>=this.cacheSize;)t.files.shift();for(let e=0,n=t.files.length;e<n;e++){if(t.files[e].fingerprint===this.fingerprint){i=e;break}}}else t.files=[];-1===i&&(i=t.files.push({fingerprint:this.fingerprint})-1),this.file=t.files[i],this.database=t}))}async _writeToStorage(){const e=JSON.stringify(this.database);localStorage.setItem("pdfjs.history",e)}async _readFromStorage(){return localStorage.getItem("pdfjs.history")}async set(e,t){return await this._initializedPromise,this.file[e]=t,this._writeToStorage()}async setMultiple(e){await this._initializedPromise;for(const t in e)this.file[t]=e[t];return this._writeToStorage()}async get(e,t){await this._initializedPromise;const i=this.file[e];return void 0!==i?i:t}async getMultiple(e){await this._initializedPromise;const t=Object.create(null);for(const i in e){const n=this.file[i];t[i]=void 0!==n?n:e[i]}return t}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BasePreferences=void 0;i(5);class n{#Vi=Object.freeze({annotationEditorMode:0,annotationMode:2,cursorToolOnLoad:0,defaultZoomDelay:400,defaultZoomValue:"",disablePageLabels:!1,enablePermissions:!1,enablePrintAutoRotate:!0,enableScripting:!0,enableStampEditor:!0,externalLinkTarget:0,historyUpdateUrl:!1,ignoreDestinationZoom:!1,forcePageColors:!1,pageColorsBackground:"Canvas",pageColorsForeground:"CanvasText",pdfBugEnabled:!1,sidebarViewOnLoad:-1,scrollModeOnLoad:-1,spreadModeOnLoad:-1,textLayerMode:1,viewerCssTheme:0,viewOnLoad:0,disableAutoFetch:!1,disableFontFace:!1,disableRange:!1,disableStream:!1,enableXfa:!0});#Ri=Object.create(null);#Fi=null;constructor(){if(this.constructor===n)throw new Error("Cannot initialize BasePreferences.");this.#Fi=this._readFromStorage(this.#Vi).then((e=>{for(const t in this.#Vi){const i=e?.[t];typeof i==typeof this.#Vi[t]&&(this.#Ri[t]=i)}}))}async _writeToStorage(e){throw new Error("Not implemented: _writeToStorage")}async _readFromStorage(e){throw new Error("Not implemented: _readFromStorage")}async reset(){await this.#Fi;const e=this.#Ri;return this.#Ri=Object.create(null),this._writeToStorage(this.#Vi).catch((t=>{throw this.#Ri=e,t}))}async set(e,t){await this.#Fi;const i=this.#Vi[e],n=this.#Ri;if(void 0===i)throw new Error(`Set preference: "${e}" is undefined.`);if(void 0===t)throw new Error("Set preference: no value is specified.");const s=typeof t,o=typeof i;if(s!==o){if("number"!==s||"string"!==o)throw new Error(`Set preference: "${t}" is a ${s}, expected a ${o}.`);t=t.toString()}else if("number"===s&&!Number.isInteger(t))throw new Error(`Set preference: "${t}" must be an integer.`);return this.#Ri[e]=t,this._writeToStorage(this.#Ri).catch((e=>{throw this.#Ri=n,e}))}async get(e){await this.#Fi;const t=this.#Vi[e];if(void 0===t)throw new Error(`Get preference: "${e}" is undefined.`);return this.#Ri[e]??t}async getAll(){await this.#Fi;const e=Object.create(null);for(const t in this.#Vi)e[t]=this.#Ri[t]??this.#Vi[t];return e}}t.BasePreferences=n},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.DownloadManager=void 0;var n=i(4);function s(e,t){const i=document.createElement("a");if(!i.click)throw new Error('DownloadManager: "a.click()" is not supported.');i.href=e,i.target="_parent","download"in i&&(i.download=t),(document.body||document.documentElement).append(i),i.click(),i.remove()}t.DownloadManager=class{#Ui=new WeakMap;downloadUrl(e,t,i){(0,n.createValidAbsoluteUrl)(e,"http://example.com")?s(e+"#pdfjs.action=download",t):console.error(`downloadUrl - not a valid URL: ${e}`)}downloadData(e,t,i){s(URL.createObjectURL(new Blob([e],{type:i})),t)}openOrDownloadData(e,t,i){const s=(0,n.isPdfFile)(i),o=s?"application/pdf":"";if(s){let n,s=this.#Ui.get(e);s||(s=URL.createObjectURL(new Blob([t],{type:o})),this.#Ui.set(e,s)),n="?file="+encodeURIComponent(s+"#"+i);try{return window.open(n),!0}catch(t){console.error(`openOrDownloadData: ${t}`),URL.revokeObjectURL(s),this.#Ui.delete(e)}}return this.downloadData(t,i,o),!1}download(e,t,i,n){s(URL.createObjectURL(e),i)}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GenericL10n=void 0,i(45);var n=i(30);const s={en:"en-US",es:"es-ES",fy:"fy-NL",ga:"ga-IE",gu:"gu-IN",hi:"hi-IN",hy:"hy-AM",nb:"nb-NO",ne:"ne-NP",nn:"nn-NO",pa:"pa-IN",pt:"pt-PT",sv:"sv-SE",zh:"zh-CN"};t.GenericL10n=class{constructor(e){const{webL10n:t}=document;this._lang=e,this._ready=new Promise(((i,n)=>{var o;t.setLanguage((o=e,s[o?.toLowerCase()]||o),(()=>{i(t)}))}))}async getLanguage(){return(await this._ready).getLanguage()}async getDirection(){return(await this._ready).getDirection()}async get(e,t=null,i=(0,n.getL10nFallback)(e,t)){return(await this._ready).get(e,t,i)}async translate(e){return(await this._ready).translate(e)}}},()=>{document.webL10n=function(e,t){var i={},n="",s="textContent",o="",a={},r="loading",l=!0;function d(e,t,i){t=t||function(e){},i=i||function(){};var n=new XMLHttpRequest;n.open("GET",e,l),n.overrideMimeType&&n.overrideMimeType("text/plain; charset=utf-8"),n.onreadystatechange=function(){4==n.readyState&&(200==n.status||0===n.status?t(n.responseText):i())},n.onerror=i,n.ontimeout=i;try{n.send(null)}catch(e){i()}}function h(e,t,o,a){var r=e.replace(/[^\/]*$/,"")||"./";function l(e){return e.lastIndexOf("\\")<0?e:e.replace(/\\\\/g,"\\").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\b/g,"\b").replace(/\\f/g,"\f").replace(/\\{/g,"{").replace(/\\}/g,"}").replace(/\\"/g,'"').replace(/\\'/g,"'")}d(e,(function(e){n+=e,function(e,i){var n={},s=/^\s*|\s*$/,o=/^\s*#|^\s*$/,a=/^\s*\[(.*)\]\s*$/,h=/^\s*@import\s+url\((.*)\)\s*$/i,c=/^([^=\s]*)\s*=\s*(.+)$/;function u(e,i,d){var u=e.replace(s,"").split(/[\r\n]+/),g="*",m=t.split("-",1)[0],f=!1,v="";!function e(){for(;;){if(!u.length)return void d();var s=u.shift();if(!o.test(s)){if(i){if(v=a.exec(s)){g=v[1].toLowerCase(),f="*"!==g&&g!==t&&g!==m;continue}if(f)continue;if(v=h.exec(s))return void p(r+v[1],e)}var w=s.match(c);w&&3==w.length&&(n[w[1]]=l(w[2]))}}}()}function p(e,t){d(e,(function(e){u(e,!1,t)}),(function(){console.warn(e+" not found."),t()}))}u(e,!0,(function(){i(n)}))}(e,(function(e){for(var t in e){var n,a,r=t.lastIndexOf(".");r>0?(n=t.substring(0,r),a=t.substring(r+1)):(n=t,a=s),i[n]||(i[n]={}),i[n][a]=e[t]}o&&o()}))}),a)}function c(e,s){e&&(e=e.toLowerCase()),s=s||function(){},i={},n="",o="",o=e;var a=t.querySelectorAll('link[type="application/l10n"]'),l=a.length;if(0!==l){var d,c,u=0;c=function(){++u>=l&&(s(),r="complete")};for(var p=0;p<l;p++){new v(a[p]).load(e,c)}}else{var g=(d=t.querySelector('script[type="application/l10n"]'))?JSON.parse(d.innerHTML):null;if(g&&g.locales&&g.default_locale){if(console.log("using the embedded JSON directory, early way out"),!(i=g.locales[e])){var m=g.default_locale.toLowerCase();for(var f in g.locales){if((f=f.toLowerCase())===e){i=g.locales[e];break}f===m&&(i=g.locales[m])}}s()}else console.log("no resource to load, early way out");r="complete"}function v(e){var t=e.href;this.load=function(e,i){h(t,e,i,(function(){console.warn(t+" not found."),console.warn('"'+e+'" resource not found'),o="",i()}))}}}function u(e,t,n){var s=i[e];if(!s){if(console.warn("#"+e+" is undefined."),!n)return null;s=n}var o={};for(var a in s){var r=s[a];r=g(r=p(r,t,e,a),t,e),o[a]=r}return o}function p(e,t,n,s){var o=/\{\[\s*([a-zA-Z]+)\(([a-zA-Z]+)\)\s*\]\}/.exec(e);if(!o||!o.length)return e;var r,l=o[1],d=o[2];(t&&d in t?r=t[d]:d in i&&(r=i[d]),l in a)&&(e=(0,a[l])(e,r,n,s));return e}function g(e,t,n){return e.replace(/\{\{\s*(.+?)\s*\}\}/g,(function(e,s){return t&&s in t?t[s]:s in i?i[s]:(console.log("argument {{"+s+"}} for #"+n+" is undefined."),e)}))}function m(e){var i=function(e){if(!e)return{};var t=e.getAttribute("data-l10n-id"),i=e.getAttribute("data-l10n-args"),n={};if(i)try{n=JSON.parse(i)}catch(e){console.warn("could not parse arguments for #"+t)}return{id:t,args:n}}(e);if(i.id){var n=u(i.id,i.args);if(n){if(n[s]){if(0===function(e){if(e.children)return e.children.length;if(void 0!==e.childElementCount)return e.childElementCount;for(var t=0,i=0;i<e.childNodes.length;i++)t+=1===e.nodeType?1:0;return t}(e))e[s]=n[s];else{for(var o=e.childNodes,a=!1,r=0,l=o.length;r<l;r++)3===o[r].nodeType&&/\S/.test(o[r].nodeValue)&&(a?o[r].nodeValue="":(o[r].nodeValue=n[s],a=!0));if(!a){var d=t.createTextNode(n[s]);e.prepend(d)}}delete n[s]}for(var h in n)e[h]=n[h]}else console.warn("#"+i.id+" is undefined.")}}return a.plural=function(e,t,n,r){var l=parseFloat(t);if(isNaN(l))return e;if(r!=s)return e;a._pluralRules||(a._pluralRules=function(e){function t(e,t){return-1!==t.indexOf(e)}function i(e,t,i){return t<=e&&e<=i}var n={0:function(e){return"other"},1:function(e){return i(e%100,3,10)?"few":0===e?"zero":i(e%100,11,99)?"many":2==e?"two":1==e?"one":"other"},2:function(e){return 0!==e&&e%10==0?"many":2==e?"two":1==e?"one":"other"},3:function(e){return 1==e?"one":"other"},4:function(e){return i(e,0,1)?"one":"other"},5:function(e){return i(e,0,2)&&2!=e?"one":"other"},6:function(e){return 0===e?"zero":e%10==1&&e%100!=11?"one":"other"},7:function(e){return 2==e?"two":1==e?"one":"other"},8:function(e){return i(e,3,6)?"few":i(e,7,10)?"many":2==e?"two":1==e?"one":"other"},9:function(e){return 0===e||1!=e&&i(e%100,1,19)?"few":1==e?"one":"other"},10:function(e){return i(e%10,2,9)&&!i(e%100,11,19)?"few":e%10!=1||i(e%100,11,19)?"other":"one"},11:function(e){return i(e%10,2,4)&&!i(e%100,12,14)?"few":e%10==0||i(e%10,5,9)||i(e%100,11,14)?"many":e%10==1&&e%100!=11?"one":"other"},12:function(e){return i(e,2,4)?"few":1==e?"one":"other"},13:function(e){return i(e%10,2,4)&&!i(e%100,12,14)?"few":1!=e&&i(e%10,0,1)||i(e%10,5,9)||i(e%100,12,14)?"many":1==e?"one":"other"},14:function(e){return i(e%100,3,4)?"few":e%100==2?"two":e%100==1?"one":"other"},15:function(e){return 0===e||i(e%100,2,10)?"few":i(e%100,11,19)?"many":1==e?"one":"other"},16:function(e){return e%10==1&&11!=e?"one":"other"},17:function(e){return 3==e?"few":0===e?"zero":6==e?"many":2==e?"two":1==e?"one":"other"},18:function(e){return 0===e?"zero":i(e,0,2)&&0!==e&&2!=e?"one":"other"},19:function(e){return i(e,2,10)?"few":i(e,0,1)?"one":"other"},20:function(e){return!i(e%10,3,4)&&e%10!=9||i(e%100,10,19)||i(e%100,70,79)||i(e%100,90,99)?e%1e6==0&&0!==e?"many":e%10!=2||t(e%100,[12,72,92])?e%10!=1||t(e%100,[11,71,91])?"other":"one":"two":"few"},21:function(e){return 0===e?"zero":1==e?"one":"other"},22:function(e){return i(e,0,1)||i(e,11,99)?"one":"other"},23:function(e){return i(e%10,1,2)||e%20==0?"one":"other"},24:function(e){return i(e,3,10)||i(e,13,19)?"few":t(e,[2,12])?"two":t(e,[1,11])?"one":"other"}},s={af:3,ak:4,am:4,ar:1,asa:3,az:0,be:11,bem:3,bez:3,bg:3,bh:4,bm:0,bn:3,bo:0,br:20,brx:3,bs:11,ca:3,cgg:3,chr:3,cs:12,cy:17,da:3,de:3,dv:3,dz:0,ee:3,el:3,en:3,eo:3,es:3,et:3,eu:3,fa:0,ff:5,fi:3,fil:4,fo:3,fr:5,fur:3,fy:3,ga:8,gd:24,gl:3,gsw:3,gu:3,guw:4,gv:23,ha:3,haw:3,he:2,hi:4,hr:11,hu:0,id:0,ig:0,ii:0,is:3,it:3,iu:7,ja:0,jmc:3,jv:0,ka:0,kab:5,kaj:3,kcg:3,kde:0,kea:0,kk:3,kl:3,km:0,kn:0,ko:0,ksb:3,ksh:21,ku:3,kw:7,lag:18,lb:3,lg:3,ln:4,lo:0,lt:10,lv:6,mas:3,mg:4,mk:16,ml:3,mn:3,mo:9,mr:3,ms:0,mt:15,my:0,nah:3,naq:7,nb:3,nd:3,ne:3,nl:3,nn:3,no:3,nr:3,nso:4,ny:3,nyn:3,om:3,or:3,pa:3,pap:3,pl:13,ps:3,pt:3,rm:3,ro:9,rof:3,ru:11,rwk:3,sah:0,saq:3,se:7,seh:3,ses:0,sg:0,sh:11,shi:19,sk:12,sl:14,sma:7,smi:7,smj:7,smn:7,sms:7,sn:3,so:3,sq:3,sr:11,ss:3,ssy:3,st:3,sv:3,sw:3,syr:3,ta:3,te:3,teo:3,th:0,ti:4,tig:3,tk:3,tl:4,tn:3,to:0,tr:0,ts:3,tzm:22,uk:11,ur:3,ve:3,vi:0,vun:3,wa:4,wae:3,wo:0,xh:3,xog:3,yo:0,zh:0,zu:3}[e.replace(/-.*$/,"")];return s in n?n[s]:(console.warn("plural form unknown for ["+e+"]"),function(){return"other"})}(o));var d="["+a._pluralRules(l)+"]";return 0===l&&n+"[zero]"in i?e=i[n+"[zero]"][r]:1==l&&n+"[one]"in i?e=i[n+"[one]"][r]:2==l&&n+"[two]"in i?e=i[n+"[two]"][r]:n+d in i?e=i[n+d][r]:n+"[other]"in i&&(e=i[n+"[other]"][r]),e},{get:function(e,t,i){var n,o=e.lastIndexOf("."),a=s;o>0&&(a=e.substring(o+1),e=e.substring(0,o)),i&&((n={})[a]=i);var r=u(e,t,n);return r&&a in r?r[a]:"{{"+e+"}}"},getData:function(){return i},getText:function(){return n},getLanguage:function(){return o},setLanguage:function(e,t){c(e,(function(){t&&t()}))},getDirection:function(){var e=o.split("-",1)[0];return["ar","he","fa","ps","ur"].indexOf(e)>=0?"rtl":"ltr"},translate:function(e){for(var i=function(e){return e?e.querySelectorAll("*[data-l10n-id]"):[]}(e=e||t.documentElement),n=i.length,s=0;s<n;s++)m(i[s]);m(e)},getReadyState:function(){return r},ready:function(i){i&&("complete"==r||"interactive"==r?e.setTimeout((function(){i()})):t.addEventListener&&t.addEventListener("localized",(function e(){t.removeEventListener("localized",e),i()})))}}}(window,document)},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GenericScripting=void 0,t.docProperties=async function(e){const t="".split("#")[0];let{info:i,metadata:s,contentDispositionFilename:o,contentLength:a}=await e.getMetadata();if(!a){const{length:t}=await e.getDownloadInfo();a=t}return{...i,baseURL:t,filesize:a,filename:o||(0,n.getPdfFilenameFromUrl)(""),metadata:s?.getRaw(),authors:s?.get("dc:creator"),numPages:e.numPages,URL:""}};var n=i(4);t.GenericScripting=class{constructor(e){this._ready=(0,n.loadScript)(e,!0).then((()=>window.pdfjsSandbox.QuickJSSandbox()))}async createSandbox(e){(await this._ready).create(e)}async dispatchEventInSandbox(e){const t=await this._ready;setTimeout((()=>t.dispatchEvent(e)),0)}async destroySandbox(){(await this._ready).nukeSandbox()}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PDFPrintService=void 0;var n=i(4),s=i(2),o=i(48);let a=null,r=null,l=null;class d{constructor(e,t,i,n,s=null,o=null,a){this.pdfDocument=e,this.pagesOverview=t,this.printContainer=i,this._printResolution=n||150,this._optionalContentConfigPromise=s||e.getOptionalContentConfig(),this._printAnnotationStoragePromise=o||Promise.resolve(),this.l10n=a,this.currentPage=-1,this.scratchCanvas=document.createElement("canvas")}layout(){this.throwIfInactive();const e=document.querySelector("body");e.setAttribute("data-pdfjsprinting",!0);const{width:t,height:i}=this.pagesOverview[0];this.pagesOverview.every((e=>e.width===t&&e.height===i))||console.warn("Not all pages have the same size. The printed result may be incorrect!"),this.pageStyleSheet=document.createElement("style"),this.pageStyleSheet.textContent=`@page { size: ${t}pt ${i}pt;}`,e.append(this.pageStyleSheet)}destroy(){if(a!==this)return;this.printContainer.textContent="";document.querySelector("body").removeAttribute("data-pdfjsprinting"),this.pageStyleSheet&&(this.pageStyleSheet.remove(),this.pageStyleSheet=null),this.scratchCanvas.width=this.scratchCanvas.height=0,this.scratchCanvas=null,a=null,m().then((function(){l.active===r&&l.close(r)}))}renderPages(){if(this.pdfDocument.isPureXfa)return(0,o.getXfaHtmlForPrinting)(this.printContainer,this.pdfDocument),Promise.resolve();const e=this.pagesOverview.length,t=(i,s)=>{if(this.throwIfInactive(),++this.currentPage>=e)return p(e,e,this.l10n),void i();const o=this.currentPage;p(o,e,this.l10n),function(e,t,i,s,o,r,l){const d=a.scratchCanvas,h=o/n.PixelsPerInch.PDF;d.width=Math.floor(s.width*h),d.height=Math.floor(s.height*h);const c=d.getContext("2d");return c.save(),c.fillStyle="rgb(255, 255, 255)",c.fillRect(0,0,d.width,d.height),c.restore(),Promise.all([t.getPage(i),l]).then((function([e,t]){const i={canvasContext:c,transform:[h,0,0,h,0,0],viewport:e.getViewport({scale:1,rotation:s.rotation}),intent:"print",annotationMode:n.AnnotationMode.ENABLE_STORAGE,optionalContentConfigPromise:r,printAnnotationStorage:t};return e.render(i).promise}))}(0,this.pdfDocument,o+1,this.pagesOverview[o],this._printResolution,this._optionalContentConfigPromise,this._printAnnotationStoragePromise).then(this.useRenderedPage.bind(this)).then((function(){t(i,s)}),s)};return new Promise(t)}useRenderedPage(){this.throwIfInactive();const e=document.createElement("img"),t=this.scratchCanvas;"toBlob"in t?t.toBlob((function(t){e.src=URL.createObjectURL(t)})):e.src=t.toDataURL();const i=document.createElement("div");return i.className="printedPage",i.append(e),this.printContainer.append(i),new Promise((function(t,i){e.onload=t,e.onerror=i}))}performPrint(){return this.throwIfInactive(),new Promise((e=>{setTimeout((()=>{this.active?(h.call(window),setTimeout(e,20)):e()}),0)}))}get active(){return this===a}throwIfInactive(){if(!this.active)throw new Error("This print request was cancelled or completed.")}}t.PDFPrintService=d;const h=window.print;function c(e){const t=new CustomEvent(e,{bubbles:!1,cancelable:!1,detail:"custom"});window.dispatchEvent(t)}function u(){a&&(a.destroy(),c("afterprint"))}function p(e,t,i){r||=document.getElementById("printServiceDialog");const n=Math.round(100*e/t),s=r.querySelector("progress"),o=r.querySelector(".relative-progress");s.value=n,i.get("print_progress_percent",{progress:n}).then((e=>{o.textContent=e}))}if(window.print=function(){if(a)console.warn("Ignored window.print() because of a pending print job.");else{m().then((function(){a&&l.open(r)}));try{c("beforeprint")}finally{if(!a)return console.error("Expected print service to be initialized."),void m().then((function(){l.active===r&&l.close(r)}));const e=a;a.renderPages().then((function(){return e.performPrint()})).catch((function(){})).then((function(){e.active&&u()}))}}},window.addEventListener("keydown",(function(e){80!==e.keyCode||!e.ctrlKey&&!e.metaKey||e.altKey||e.shiftKey&&!window.chrome&&!window.opera||(window.print(),e.preventDefault(),e.stopImmediatePropagation())}),!0),"onbeforeprint"in window){const e=function(e){"custom"!==e.detail&&e.stopImmediatePropagation()};window.addEventListener("beforeprint",e),window.addEventListener("afterprint",e)}let g;function m(){if(!g){if(l=s.PDFViewerApplication.overlayManager,!l)throw new Error("The overlay manager has not yet been initialized.");r||=document.getElementById("printServiceDialog"),g=l.register(r,!0),document.getElementById("printCancel").onclick=u,r.addEventListener("close",u)}return g}s.PDFPrintServiceFactory.instance={supportsPrinting:!0,createPrintService(e,t,i,n,s,o,r){if(a)throw new Error("The print service is created and active.");return a=new d(e,t,i,n,s,o,r),a}}},(e,t,i)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.getXfaHtmlForPrinting=function(e,t){const i=t.allXfaHtml,a=new s.SimpleLinkService,r=Math.round(100*n.PixelsPerInch.PDF_TO_CSS_UNITS)/100;for(const s of i.children){const i=document.createElement("div");i.className="xfaPrintedPage",e.append(i);const l=new o.XfaLayerBuilder({pageDiv:i,pdfPage:null,annotationStorage:t.annotationStorage,linkService:a,xfaHtml:s}),d=(0,n.getXfaPageViewport)(s,{scale:r});l.render(d,"print")}};var n=i(4),s=i(7),o=i(38)}],t={};function i(n){var s=t[n];if(void 0!==s)return s.exports;var o=t[n]={exports:{}};return e[n](o,o.exports,i),o.exports}var n={};(()=>{var e=n;Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"PDFViewerApplication",{enumerable:!0,get:function(){return a.PDFViewerApplication}}),e.PDFViewerApplicationConstants=void 0,Object.defineProperty(e,"PDFViewerApplicationOptions",{enumerable:!0,get:function(){return s.AppOptions}}),i(1),i(47);var t=i(3),s=i(5),o=i(7),a=i(2);const r={LinkTarget:o.LinkTarget,RenderingStates:t.RenderingStates,ScrollMode:t.ScrollMode,SpreadMode:t.SpreadMode};function l(){const e={appContainer:document.body,mainContainer:document.getElementById("viewerContainer"),viewerContainer:document.getElementById("viewer"),toolbar:{container:document.getElementById("toolbarViewer"),numPages:document.getElementById("numPages"),pageNumber:document.getElementById("pageNumber"),scaleSelect:document.getElementById("scaleSelect"),customScaleOption:document.getElementById("customScaleOption"),previous:document.getElementById("previous"),next:document.getElementById("next"),zoomIn:document.getElementById("zoomIn"),zoomOut:document.getElementById("zoomOut"),viewFind:document.getElementById("viewFind"),openFile:document.getElementById("openFile"),print:document.getElementById("print"),editorFreeTextButton:document.getElementById("editorFreeText"),editorFreeTextParamsToolbar:document.getElementById("editorFreeTextParamsToolbar"),editorInkButton:document.getElementById("editorInk"),editorInkParamsToolbar:document.getElementById("editorInkParamsToolbar"),editorStampButton:document.getElementById("editorStamp"),editorStampParamsToolbar:document.getElementById("editorStampParamsToolbar"),download:document.getElementById("download")},secondaryToolbar:{toolbar:document.getElementById("secondaryToolbar"),toggleButton:document.getElementById("secondaryToolbarToggle"),presentationModeButton:document.getElementById("presentationMode"),openFileButton:document.getElementById("secondaryOpenFile"),printButton:document.getElementById("secondaryPrint"),downloadButton:document.getElementById("secondaryDownload"),viewBookmarkButton:document.getElementById("viewBookmark"),firstPageButton:document.getElementById("firstPage"),lastPageButton:document.getElementById("lastPage"),pageRotateCwButton:document.getElementById("pageRotateCw"),pageRotateCcwButton:document.getElementById("pageRotateCcw"),cursorSelectToolButton:document.getElementById("cursorSelectTool"),cursorHandToolButton:document.getElementById("cursorHandTool"),scrollPageButton:document.getElementById("scrollPage"),scrollVerticalButton:document.getElementById("scrollVertical"),scrollHorizontalButton:document.getElementById("scrollHorizontal"),scrollWrappedButton:document.getElementById("scrollWrapped"),spreadNoneButton:document.getElementById("spreadNone"),spreadOddButton:document.getElementById("spreadOdd"),spreadEvenButton:document.getElementById("spreadEven"),documentPropertiesButton:document.getElementById("documentProperties")},sidebar:{outerContainer:document.getElementById("outerContainer"),sidebarContainer:document.getElementById("sidebarContainer"),toggleButton:document.getElementById("sidebarToggle"),resizer:document.getElementById("sidebarResizer"),thumbnailButton:document.getElementById("viewThumbnail"),outlineButton:document.getElementById("viewOutline"),attachmentsButton:document.getElementById("viewAttachments"),layersButton:document.getElementById("viewLayers"),thumbnailView:document.getElementById("thumbnailView"),outlineView:document.getElementById("outlineView"),attachmentsView:document.getElementById("attachmentsView"),layersView:document.getElementById("layersView"),outlineOptionsContainer:document.getElementById("outlineOptionsContainer"),currentOutlineItemButton:document.getElementById("currentOutlineItem")},findBar:{bar:document.getElementById("findbar"),toggleButton:document.getElementById("viewFind"),findField:document.getElementById("findInput"),highlightAllCheckbox:document.getElementById("findHighlightAll"),caseSensitiveCheckbox:document.getElementById("findMatchCase"),matchDiacriticsCheckbox:document.getElementById("findMatchDiacritics"),entireWordCheckbox:document.getElementById("findEntireWord"),findMsg:document.getElementById("findMsg"),findResultsCount:document.getElementById("findResultsCount"),findPreviousButton:document.getElementById("findPrevious"),findNextButton:document.getElementById("findNext")},passwordOverlay:{dialog:document.getElementById("passwordDialog"),label:document.getElementById("passwordText"),input:document.getElementById("password"),submitButton:document.getElementById("passwordSubmit"),cancelButton:document.getElementById("passwordCancel")},documentProperties:{dialog:document.getElementById("documentPropertiesDialog"),closeButton:document.getElementById("documentPropertiesClose"),fields:{fileName:document.getElementById("fileNameField"),fileSize:document.getElementById("fileSizeField"),title:document.getElementById("titleField"),author:document.getElementById("authorField"),subject:document.getElementById("subjectField"),keywords:document.getElementById("keywordsField"),creationDate:document.getElementById("creationDateField"),modificationDate:document.getElementById("modificationDateField"),creator:document.getElementById("creatorField"),producer:document.getElementById("producerField"),version:document.getElementById("versionField"),pageCount:document.getElementById("pageCountField"),pageSize:document.getElementById("pageSizeField"),linearized:document.getElementById("linearizedField")}},altTextDialog:{dialog:document.getElementById("altTextDialog"),optionDescription:document.getElementById("descriptionButton"),optionDecorative:document.getElementById("decorativeButton"),textarea:document.getElementById("descriptionTextarea"),cancelButton:document.getElementById("altTextCancel"),saveButton:document.getElementById("altTextSave")},annotationEditorParams:{editorFreeTextFontSize:document.getElementById("editorFreeTextFontSize"),editorFreeTextColor:document.getElementById("editorFreeTextColor"),editorInkColor:document.getElementById("editorInkColor"),editorInkThickness:document.getElementById("editorInkThickness"),editorInkOpacity:document.getElementById("editorInkOpacity"),editorStampAddImage:document.getElementById("editorStampAddImage")},printContainer:document.getElementById("printContainer"),openFileInput:document.getElementById("fileInput"),debuggerScriptPath:"./debugger.js"},t=new CustomEvent("webviewerloaded",{bubbles:!0,cancelable:!0,detail:{source:window}});try{parent.document.dispatchEvent(t)}catch(e){console.error(`webviewerloaded: ${e}`),document.dispatchEvent(t)}a.PDFViewerApplication.run(e)}e.PDFViewerApplicationConstants=r,window.PDFViewerApplication=a.PDFViewerApplication,window.PDFViewerApplicationConstants=r,window.PDFViewerApplicationOptions=s.AppOptions,document.blockUnblockOnload?.(!0),"interactive"===document.readyState||"complete"===document.readyState?l():document.addEventListener("DOMContentLoaded",l,!0)})()})();