/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.attachment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.utils.ImplementationLoader;
import org.eclipse.swt.widgets.Shell;

public abstract class Attachments {
    private static final Attachments IMPL = (Attachments)ImplementationLoader.newInstance(Attachments.class);

    public static void export(Shell shell, Attachment attachment, DialogService dialogService, String exportDir) {
        IMPL.exportInternal(shell, attachment, dialogService, exportDir);
    }

    public static byte[] getContent(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Attachment load(Shell shell, FileKind fileKind, DialogService dialogService, List<ToolboxFileFilter> extensions) throws ToolboxFileFilter.InvalidFilterFilename {
        return IMPL.loadInternal(shell, fileKind, dialogService, extensions);
    }

    abstract void exportInternal(Shell var1, Attachment var2, DialogService var3, String var4);

    abstract Attachment loadInternal(Shell var1, FileKind var2, DialogService var3, List<ToolboxFileFilter> var4) throws ToolboxFileFilter.InvalidFilterFilename;

    static class AttachmentImpl
    implements Attachment {
        private static final String PDF_EXTENSION = "pdf";
        private final byte[] content;
        private FileKind fileKind;
        private final Path filename;
        private final String id;

        public AttachmentImpl(Path filename, FileKind fileKind, byte[] content) {
            this.filename = filename;
            this.content = content;
            this.fileKind = fileKind;
            this.id = Guid.create().toString();
        }

        public String getBaseFilename() {
            return PathExtensions.getBaseFileName((Path)this.filename);
        }

        public byte[] getData() {
            return this.content;
        }

        public String getFileExtension() {
            return PathExtensions.getExtension((Path)this.filename);
        }

        public FileKind getFileKind() {
            return this.fileKind;
        }

        public String getFullFilename() {
            return this.filename.getFileName().toString();
        }

        public String getId() {
            return this.id;
        }

        public Object getOriginal() {
            return null;
        }

        public boolean isPdf() {
            return this.getFileExtension().equalsIgnoreCase(PDF_EXTENSION);
        }

        public void setFileKind(FileKind fileKind) {
            this.fileKind = fileKind;
        }
    }
}

