/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.set.basis.constants.TextType;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.set.utils.ToolboxVersion;
import org.eclipse.swt.widgets.Composite;

public class ToolboxConfiguration {
    private static Path defaultDirectory;

    public static float getDefaultHeight() {
        return Float.parseFloat(System.getProperty("toolbox.default.line.height", Float.toString(0.6f)));
    }

    public static Path getDefaultPath() {
        if (defaultDirectory != null) {
            return defaultDirectory;
        }
        String dir = System.getProperty("toolbox.defaultdir", "$USERPROFILE$\\planpro");
        defaultDirectory = Paths.get(StringExtensions.expandFromEnvironment(dir), new String[0]);
        File file = defaultDirectory.toFile();
        if (file.exists() || file.mkdirs()) {
            return defaultDirectory;
        }
        throw new RuntimeException("Creation of default directory " + String.valueOf(defaultDirectory) + " failed.");
    }

    public static float getTablesScaleFactor() {
        return Float.parseFloat(System.getProperty("toolbox.tables.scale", Float.toString(50.0f)));
    }

    public static String getTextAttribute(TextType type, String defaultDescription, Composite parent) {
        return System.getProperty(type.getProperty(), defaultDescription);
    }

    public static String getTextFont(String defaultDescription) {
        return System.getProperty("toolbox.text.font", defaultDescription);
    }

    public static String getToolboxLogfile() {
        return System.getProperty("toolbox.logfile");
    }

    public static ToolboxVersion getToolboxVersion() {
        return new ToolboxVersion(System.getProperty("toolbox.detailversion"));
    }

    public static int getTableTreeMinimum() {
        String property = System.getProperty("toolbox.table.tree.minimum");
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public static String getShortName() {
        return System.getProperty("toolbox.shortname");
    }

    public static boolean isDevelopmentMode() {
        return Boolean.parseBoolean(System.getProperty("toolbox.development.mode", Boolean.TRUE.toString()));
    }

    public static boolean isPdfExportTestFilling() {
        return Boolean.parseBoolean(System.getProperty("toolbox.export.pdf.test.filling", Boolean.FALSE.toString()));
    }

    public static boolean isDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") > -1;
    }
}

