/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EClassExtensions {
    public static List<List<String>> getAttributePaths(EClass type, boolean nestIntoLists) {
        return EClassExtensions.getAttributePaths(Lists.newLinkedList(), type, nestIntoLists);
    }

    private static List<List<String>> getAttributePaths(final List<String> path, EClass type, final boolean nestIntoLists) {
        final LinkedList results = Lists.newLinkedList();
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature it) {
                boolean _isNestReference = EClassExtensions.isNestReference(it);
                return !_isNestReference;
            }
        };
        Consumer<EStructuralFeature> _function_1 = new Consumer<EStructuralFeature>(){

            @Override
            public void accept(EStructuralFeature it) {
                String _name = it.getName();
                results.add(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)path, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name})))));
            }
        };
        IterableExtensions.filter((Iterable)type.getEAllStructuralFeatures(), (Functions.Function1)_function).forEach(_function_1);
        Consumer<EReference> _function_2 = new Consumer<EReference>(){

            @Override
            public void accept(EReference it) {
                boolean _isContainment = it.isContainment();
                if (_isContainment) {
                    if (nestIntoLists || it.getUpperBound() == 1) {
                        String _name = it.getName();
                        results.addAll(EClassExtensions.getAttributePaths(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)path, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name})))), it.getEReferenceType(), nestIntoLists));
                    } else {
                        String _name_1 = it.getName();
                        results.add(IterableExtensions.toList((Iterable)Iterables.concat((Iterable)path, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name_1})))));
                    }
                }
            }
        };
        type.getEAllReferences().forEach((Consumer)_function_2);
        return results;
    }

    private static boolean isNestReference(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return ((EReference)feature).isContainment();
        }
        return false;
    }
}

