/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.set.ppmodel.extensions.utils.SymbolArrangement;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke;
import org.eclipse.set.toolboxmodel.Geodaten.Strecke_Punkt;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.locationtech.jts.geom.Coordinate;

public class StreckeExtensions
extends BasisObjektExtensions {
    public static Iterable<GEO_Kante> getGeoKanten(final Strecke strecke) {
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante k) {
                String _wert = k.getIDGEOArt().getIdentitaet().getWert();
                String _wert_1 = strecke.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)strecke).getGEOKante(), (Functions.Function1)_function);
    }

    public static Iterable<Strecke_Punkt> getStreckenPunkte(final Strecke strecke) {
        Functions.Function1<Strecke_Punkt, Boolean> _function = new Functions.Function1<Strecke_Punkt, Boolean>(){

            public Boolean apply(Strecke_Punkt k) {
                String _wert = k.getIDStrecke().getIdentitaet().getWert();
                String _wert_1 = strecke.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)strecke).getStreckePunkt(), (Functions.Function1)_function);
    }

    public static SymbolArrangement<Coordinate> getKilometerCoordinate(Strecke strecke, double kilometer) {
        Strecke_Punkt[] startEnd = StreckeExtensions.getStartEnd(strecke);
        if (startEnd == null) {
            return null;
        }
        Strecke_Punkt start = startEnd[0];
        GEO_Knoten _geoKnoten = StreckePunktExtensions.getGeoKnoten(start);
        BigDecimal _wert = start.getStreckeMeter().getWert();
        double _minus = DoubleExtensions.operator_minus((Double)kilometer, (Number)_wert);
        return GeoKnotenExtensions.getCoordinate(_geoKnoten, null, (Basis_Objekt)strecke, _minus, 0.0, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
    }

    public static Strecke_Punkt[] getStartEnd(Strecke strecke) {
        BigDecimal _wert_1;
        boolean _lessThan_1;
        boolean _lessThan;
        Functions.Function1<Strecke_Punkt, Boolean> _function = new Functions.Function1<Strecke_Punkt, Boolean>(){

            public Boolean apply(Strecke_Punkt sp) {
                Iterable<GEO_Kante> edges;
                GEO_Knoten _geoKnoten = null;
                if (sp != null) {
                    _geoKnoten = StreckePunktExtensions.getGeoKnoten(sp);
                }
                Iterable<GEO_Kante> _geoKanten = null;
                if (_geoKnoten != null) {
                    _geoKanten = GeoKnotenExtensions.getGeoKanten(_geoKnoten);
                }
                return (edges = _geoKanten) != null && IterableExtensions.size(edges) == 1;
            }
        };
        Iterable startEnd = IterableExtensions.filter(StreckeExtensions.getStreckenPunkte(strecke), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)startEnd);
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return null;
        }
        Strecke_Punkt pointA = ((Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class))[0];
        Strecke_Punkt pointB = ((Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class))[1];
        BigDecimal _wert = pointA.getStreckeMeter().getWert();
        boolean bl2 = _lessThan_1 = _wert.compareTo(_wert_1 = pointB.getStreckeMeter().getWert()) < 0;
        if (_lessThan_1) {
            return (Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class);
        }
        return new Strecke_Punkt[]{pointB, pointA};
    }
}

