/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.Lists;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoPunktExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.SymbolArrangement;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Koordinatensystem_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoKnotenExtensions
extends BasisObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(GeoKnotenExtensions.class);

    public static List<GEO_Punkt> getGeoPunkte(final GEO_Knoten knoten) {
        Functions.Function1<GEO_Punkt, Boolean> _function = new Functions.Function1<GEO_Punkt, Boolean>(){

            public Boolean apply(GEO_Punkt it) {
                return it.getIDGEOKnoten() != null && Objects.equal((Object)it.getIDGEOKnoten().getIdentitaet().getWert(), (Object)knoten.getIdentitaet().getWert());
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)knoten).getGEOPunkt(), (Functions.Function1)_function));
    }

    public static List<GEO_Kante> getGeoKantenOnTopKante(final GEO_Knoten knoten, final TOP_Kante topKante) {
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante geoKante) {
                return GeoKnotenExtensions.isKnoten(knoten, geoKante) && Objects.equal((Object)GeoKanteExtensions.topKante(geoKante), (Object)topKante);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)knoten).getGEOKante(), (Functions.Function1)_function));
    }

    public static boolean isKnoten(GEO_Knoten knoten, GEO_Kante geoKante) {
        return Objects.equal((Object)GeoKanteExtensions.getGeoKnotenA(geoKante), (Object)knoten) || Objects.equal((Object)GeoKanteExtensions.getGeoKnotenB(geoKante), (Object)knoten);
    }

    public static Coordinate getCoordinate(GEO_Knoten geoKnoten) {
        List<GEO_Punkt> geoPunkte = GeoKnotenExtensions.getGeoPunkte(geoKnoten);
        GeoKnotenExtensions.getGeoPunkt(geoPunkte, geoKnoten);
        GEO_Punkt geoPunkt = GeoKnotenExtensions.getGeoPunkt(geoPunkte, geoKnoten);
        return GeoPunktExtensions.getCoordinate(geoPunkt);
    }

    public static ENUMGEOKoordinatensystem getCRS(GEO_Knoten geoKnoten) {
        Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem> _function = new Functions.Function1<GEO_Punkt, ENUMGEOKoordinatensystem>(){

            public ENUMGEOKoordinatensystem apply(GEO_Punkt it) {
                GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it.getGEOPunktAllg();
                GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
                if (_gEOPunktAllg != null) {
                    _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
                }
                ENUMGEOKoordinatensystem _wert = null;
                if (_gEOKoordinatensystem != null) {
                    _wert = _gEOKoordinatensystem.getWert();
                }
                return _wert;
            }
        };
        ENUMGEOKoordinatensystem crs = (ENUMGEOKoordinatensystem)CollectionExtensions.getUniqueOrNull(IterableExtensions.toSet((Iterable)ListExtensions.map(GeoKnotenExtensions.getGeoPunkte(geoKnoten), (Functions.Function1)_function)));
        ENUMGEOKoordinatensystem _xifexpression = null;
        _xifexpression = crs != null ? crs : ENUMGEOKoordinatensystem.ENUMGEO_KOORDINATENSYSTEM_SONSTIGE;
        return _xifexpression;
    }

    public static GEO_Punkt getGeoPunkt(List<GEO_Punkt> geoPunkte, GEO_Knoten geoKnoten) {
        boolean _notEquals;
        int _size = geoPunkte.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            String _format = String.format("Ambiguous Geo Punkte (%d) for Geo Knoten %s", geoPunkte.size(), geoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        return geoPunkte.get(0);
    }

    static SymbolArrangement<Coordinate> getCoordinate(GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, Basis_Objekt parentEdge, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        List geoKantenOnStart = null;
        geoKantenOnStart = parentEdge instanceof TOP_Kante ? IterableExtensions.toList(GeoKnotenExtensions.getGeoKantenOnTopKante(startGeoKnoten, (TOP_Kante)parentEdge)) : IterableExtensions.toList(GeoKnotenExtensions.getGeoKanten(startGeoKnoten));
        List geoKantenOnStartWithoutLoops = Lists.filter((List)geoKantenOnStart, (Predicate)new Predicate<GEO_Kante>(){

            public boolean apply(GEO_Kante input) {
                boolean isLoop = GeoKanteExtensions.isLoop(input);
                if (isLoop) {
                    logger.error("Ignore GEO Kante Loop {}", (Object)input.getIdentitaet().getWert());
                }
                return !isLoop;
            }
        });
        return GeoKnotenExtensions.getCoordinate(startGeoKnoten, lastGeoKante, geoKantenOnStartWithoutLoops, parentEdge, abstand, seitlicherAbstand, wirkrichtung);
    }

    private static SymbolArrangement<Coordinate> getCoordinate(GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, List<GEO_Kante> geoKantenOnStart, Basis_Objekt parentEdge, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        boolean _notEquals;
        geoKantenOnStart.remove(lastGeoKante);
        int _size = geoKantenOnStart.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            logger.debug("Start GEO Knoten: {}", (Object)Debug.debugString(startGeoKnoten));
            logger.debug("TOP Kante/Strecke: {}", (Object)Debug.debugString(parentEdge));
            logger.debug("Last GEO Kante: {}", (Object)Debug.debugString(lastGeoKante));
            logger.debug("Next GEO Kanten: {}", (Object)Debug.debugString(geoKantenOnStart));
            logger.debug("Abstand: {}", (Object)abstand);
            String _format = String.format("No GEO Kanten continuation at %s", startGeoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        GEO_Kante geoKante = geoKantenOnStart.get(0);
        double geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (abstand <= geoKanteLength) {
            return GeoKanteExtensions.getCoordinate(geoKante, startGeoKnoten, abstand, seitlicherAbstand, wirkrichtung);
        }
        return GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getOpposite(geoKante, startGeoKnoten), geoKante, parentEdge, abstand - geoKanteLength, seitlicherAbstand, wirkrichtung);
    }

    public static Iterable<Pair<GEO_Kante, Double>> getGeoKantenWithDistance(GEO_Knoten startGeoKnoten, final TOP_Kante topKante) {
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante k) {
                TOP_Kante _pKante = GeoKanteExtensions.topKante(k);
                return Objects.equal((Object)_pKante, (Object)topKante);
            }
        };
        List geoKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGEOKante(), (Functions.Function1)_function));
        return GeoKnotenExtensions.getGeoKantenWithDistance(startGeoKnoten, null, geoKanten, 0.0);
    }

    private static Iterable<Pair<GEO_Kante, Double>> getGeoKantenWithDistance(final GEO_Knoten startGeoKnoten, GEO_Kante lastGeoKante, List<GEO_Kante> geoKanten, double distance) {
        boolean _notEquals;
        geoKanten.remove(lastGeoKante);
        boolean _isEmpty = geoKanten.isEmpty();
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante geoKante) {
                return GeoKnotenExtensions.isKnoten(startGeoKnoten, geoKante);
            }
        };
        Iterable edges = IterableExtensions.filter(geoKanten, (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)edges);
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            logger.debug("Start GEO Knoten: {}", (Object)Debug.debugString(startGeoKnoten));
            logger.debug("Last GEO Kante: {}", (Object)Debug.debugString(lastGeoKante));
            logger.debug("Next GEO Kanten: {}", (Object)Debug.debugString(edges));
            String _format = String.format("No GEO Kanten continuation at %s", startGeoKnoten.getIdentitaet().getWert());
            throw new GeometryException(_format);
        }
        GEO_Kante geoKante = ((GEO_Kante[])Conversions.unwrapArray((Object)edges, GEO_Kante.class))[0];
        double geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        Pair _mappedTo = Pair.of((Object)geoKante, (Object)distance);
        Iterable<Pair<GEO_Kante, Double>> _geoKantenWithDistance = GeoKnotenExtensions.getGeoKantenWithDistance(GeoKanteExtensions.getOpposite(geoKante, startGeoKnoten), geoKante, geoKanten, distance + geoKanteLength);
        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo})), _geoKantenWithDistance);
    }

    public static Iterable<GEO_Kante> getGeoKanten(final GEO_Knoten geoKnoten) {
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante kante) {
                return Objects.equal((Object)kante.getIDGEOKnotenA().getIdentitaet().getWert(), (Object)geoKnoten.getIdentitaet().getWert()) || Objects.equal((Object)kante.getIDGEOKnotenB().getIdentitaet().getWert(), (Object)geoKnoten.getIdentitaet().getWert());
            }
        };
        return IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)geoKnoten).getGEOKante(), (Functions.Function1)_function);
    }
}

