/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.set.basis.geometry.Chord;
import org.eclipse.set.basis.geometry.Circle;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CoordinateExtensions;
import org.eclipse.set.ppmodel.extensions.utils.LineStringExtensions;
import org.eclipse.set.ppmodel.extensions.utils.SymbolArrangement;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOForm;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_A_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_B_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.utils.math.Bloss;
import org.eclipse.set.utils.math.Clothoid;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoKanteExtensions
extends BasisObjektExtensions {
    private static int BLOSS_SEGMENTS_MIN = 10;
    private static double BLOSS_SEGMENTS_PER_LENGTH = 0.5;
    private static int BLOSS_PRECISION = 20;
    private static int CLOTHOID_SEGMENTS_MIN = 10;
    private static double CLOTHOID_SEGMENTS_PER_LENGTH = 0.5;
    private static int CLOTHOID_PRECISION = 5;
    private static final Logger logger = LoggerFactory.getLogger(GeoKanteExtensions.class);
    private static final GeometryFactory geoFactory = new GeometryFactory();

    private static LineString arc(GEO_Kante kante) {
        Coordinate[] coordinates = GeoKanteExtensions.getCoordinates(kante);
        double radius = kante.getGEOKanteAllg().getGEORadiusA().getWert().doubleValue();
        GeometryFactory _geometryFactory = GeoKanteExtensions.getGeometryFactory();
        Coordinate _get = coordinates[0];
        Coordinate _get_1 = coordinates[1];
        double _abs = Math.abs(radius);
        Chord.Orientation _xifexpression = null;
        _xifexpression = radius < 0.0 ? Chord.Orientation.ARC_RIGHT : Chord.Orientation.ARC_LEFT;
        Chord _chord = new Chord(_get, _get_1, _abs, _xifexpression);
        return Geometries.createArc((GeometryFactory)_geometryFactory, (Chord)_chord);
    }

    private static LineString clothoid(final Coordinate fromCoordinate, Coordinate toCoordinate, final double radius, double length) {
        double _max = Math.max(length * CLOTHOID_SEGMENTS_PER_LENGTH, (double)CLOTHOID_SEGMENTS_MIN);
        int segmentCount = (int)_max;
        double _abs = Math.abs(radius);
        Clothoid clothoid = new Clothoid(_abs, length, CLOTHOID_PRECISION);
        List clothoidCoordinates = clothoid.getPoints(segmentCount);
        Functions.Function1<double[], Coordinate> _function = new Functions.Function1<double[], Coordinate>(){

            public Coordinate apply(double[] it) {
                double _get = it[0];
                double _get_1 = it[1];
                Coordinate coordinate = new Coordinate(_get, _get_1, 0.0);
                if (radius > 0.0) {
                    return CoordinateExtensions.mirrorY(coordinate);
                }
                return coordinate;
            }
        };
        List coords = ListExtensions.map((List)clothoidCoordinates, (Functions.Function1)_function);
        Functions.Function1<Coordinate, Coordinate> _function_1 = new Functions.Function1<Coordinate, Coordinate>(){

            public Coordinate apply(Coordinate it) {
                return CoordinateExtensions.offsetBy(it, fromCoordinate.x, fromCoordinate.y);
            }
        };
        List coordinates = ListExtensions.map((List)coords, (Functions.Function1)_function_1);
        double angleA = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, toCoordinate);
        double angleB = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, (Coordinate)IterableExtensions.last((Iterable)coordinates));
        final double angleOffset = angleA - angleB;
        Functions.Function1<Coordinate, Coordinate> _function_2 = new Functions.Function1<Coordinate, Coordinate>(){

            public Coordinate apply(Coordinate it) {
                return CoordinateExtensions.rotateAroundPoint(it, angleOffset, fromCoordinate);
            }
        };
        return GeoKanteExtensions.getGeometryFactory().createLineString((Coordinate[])Conversions.unwrapArray((Object)ListExtensions.map((List)coordinates, (Functions.Function1)_function_2), Coordinate.class));
    }

    private static LineString clothoid(GEO_Kante kante) {
        Number _elvis = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = kante.getGEOKanteAllg();
        GEO_Radius_A_TypeClass _gEORadiusA = null;
        if (_gEOKanteAllg != null) {
            _gEORadiusA = _gEOKanteAllg.getGEORadiusA();
        }
        BigDecimal _wert = null;
        if (_gEORadiusA != null) {
            _wert = _gEORadiusA.getWert();
        }
        _elvis = _wert != null ? _wert : Integer.valueOf(0);
        double radiusA = _elvis.doubleValue();
        Number _elvis_1 = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_1 = kante.getGEOKanteAllg();
        GEO_Radius_B_TypeClass _gEORadiusB = null;
        if (_gEOKanteAllg_1 != null) {
            _gEORadiusB = _gEOKanteAllg_1.getGEORadiusB();
        }
        BigDecimal _wert_1 = null;
        if (_gEORadiusB != null) {
            _wert_1 = _gEORadiusB.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : Integer.valueOf(0);
        double radiusB = _elvis_1.doubleValue();
        double angle = kante.getGEOKanteAllg().getGEORichtungswinkel().getWert().doubleValue();
        Coordinate coordinateA = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenA(kante));
        Coordinate coordinateB = GeoKanteExtensions.getCoordinateKnoteB(kante);
        double length = kante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (radiusA != 0.0 && radiusB != 0.0) {
            double _abs = Math.abs(radiusB);
            Clothoid clothoid = new Clothoid(_abs, length, CLOTHOID_PRECISION);
            double angleRad = 0.015707963267948967 * (100.0 - angle);
            double[] point = clothoid.getPoint(length / 2.0);
            double _get = point[0];
            double _get_1 = point[1];
            Coordinate centerCoordinate = new Coordinate(_get, _get_1);
            if (radiusB > 0.0) {
                centerCoordinate = CoordinateExtensions.mirrorY(centerCoordinate);
            }
            Coordinate center = CoordinateExtensions.offsetBy(CoordinateExtensions.rotateAroundOrigin(centerCoordinate, angleRad), coordinateA.x, coordinateA.y);
            Coordinate[] segmentA = GeoKanteExtensions.clothoid(coordinateA, center, radiusB, length / 2.0).getCoordinates();
            Coordinate[] segmentB = GeoKanteExtensions.clothoid(center, coordinateB, radiusA, length / 2.0).getCoordinates();
            GeometryFactory _geometryFactory = GeoKanteExtensions.getGeometryFactory();
            Iterable _plus = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)segmentA)), (Iterable)((Iterable)Conversions.doWrapArray((Object)segmentB)));
            return _geometryFactory.createLineString((Coordinate[])Conversions.unwrapArray((Object)_plus, Coordinate.class));
        }
        if (radiusA == 0.0) {
            return GeoKanteExtensions.clothoid(coordinateA, coordinateB, radiusB, length);
        }
        return GeoKanteExtensions.clothoid(coordinateB, coordinateA, -radiusA, length);
    }

    private static LineString blosscurve(final Coordinate fromCoordinate, Coordinate toCoordinate, final double radius, double length) {
        double _abs = Math.abs(radius);
        Bloss bloss = new Bloss(_abs, length, BLOSS_PRECISION);
        double _max = Math.max(length * BLOSS_SEGMENTS_PER_LENGTH, (double)BLOSS_SEGMENTS_MIN);
        int segmentCount = (int)_max;
        Functions.Function1<double[], Coordinate> _function = new Functions.Function1<double[], Coordinate>(){

            public Coordinate apply(double[] it) {
                double _get = it[0];
                double _get_1 = it[1];
                Coordinate coordinate = new Coordinate(_get, _get_1, 0.0);
                if (radius < 0.0) {
                    return CoordinateExtensions.mirrorY(coordinate);
                }
                return coordinate;
            }
        };
        List coords = ListExtensions.map((List)bloss.calculate(segmentCount), (Functions.Function1)_function);
        Functions.Function1<Coordinate, Coordinate> _function_1 = new Functions.Function1<Coordinate, Coordinate>(){

            public Coordinate apply(Coordinate it) {
                return CoordinateExtensions.offsetBy(it, fromCoordinate.x, fromCoordinate.y);
            }
        };
        List coordinates = ListExtensions.map((List)coords, (Functions.Function1)_function_1);
        double angleA = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, toCoordinate);
        double angleB = CoordinateExtensions.getAngleBetweenPoints(fromCoordinate, (Coordinate)IterableExtensions.last((Iterable)coordinates));
        final double angleOffset = angleA - angleB;
        Functions.Function1<Coordinate, Coordinate> _function_2 = new Functions.Function1<Coordinate, Coordinate>(){

            public Coordinate apply(Coordinate it) {
                return CoordinateExtensions.rotateAroundPoint(it, angleOffset, fromCoordinate);
            }
        };
        return GeoKanteExtensions.getGeometryFactory().createLineString((Coordinate[])Conversions.unwrapArray((Object)ListExtensions.map((List)coordinates, (Functions.Function1)_function_2), Coordinate.class));
    }

    private static LineString blosscurve(GEO_Kante kante) {
        Number _elvis = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = kante.getGEOKanteAllg();
        GEO_Radius_A_TypeClass _gEORadiusA = null;
        if (_gEOKanteAllg != null) {
            _gEORadiusA = _gEOKanteAllg.getGEORadiusA();
        }
        BigDecimal _wert = null;
        if (_gEORadiusA != null) {
            _wert = _gEORadiusA.getWert();
        }
        _elvis = _wert != null ? _wert : Integer.valueOf(0);
        double radiusA = _elvis.doubleValue();
        Number _elvis_1 = null;
        GEO_Kante_Allg_AttributeGroup _gEOKanteAllg_1 = kante.getGEOKanteAllg();
        GEO_Radius_B_TypeClass _gEORadiusB = null;
        if (_gEOKanteAllg_1 != null) {
            _gEORadiusB = _gEOKanteAllg_1.getGEORadiusB();
        }
        BigDecimal _wert_1 = null;
        if (_gEORadiusB != null) {
            _wert_1 = _gEORadiusB.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : Integer.valueOf(0);
        double radiusB = _elvis_1.doubleValue();
        Coordinate coordinateA = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenA(kante));
        Coordinate coordinateB = GeoKanteExtensions.getCoordinateKnoteB(kante);
        double length = kante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
        if (radiusA != 0.0 && radiusB != 0.0) {
            logger.warn("Form Bloss between straight tracks not supported.");
            return GeoKanteExtensions.getGeometryFactory().createLineString(GeoKanteExtensions.getCoordinates(kante));
        }
        if (radiusA == 0.0) {
            return GeoKanteExtensions.blosscurve(coordinateB, coordinateA, radiusB, length);
        }
        return GeoKanteExtensions.blosscurve(coordinateA, coordinateB, -radiusA, length);
    }

    public static SymbolArrangement<Coordinate> getCoordinate(GEO_Kante geoKante, GEO_Knoten startGeoKnoten, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        LineString edgeGeometry = GeoKanteExtensions.getGeometry(geoKante);
        double edgeLength = Math.abs(geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue());
        double distance = abstand;
        double geoLength = edgeGeometry.getLength();
        if (geoLength < edgeLength) {
            distance = abstand * (geoLength / edgeLength);
        }
        SegmentPosition position = Geometries.getSegmentPosition((LineString)edgeGeometry, (Coordinate)GeoKnotenExtensions.getCoordinate(startGeoKnoten), (double)distance);
        LineSegment tangent = GeoKanteExtensions.getTangent(geoKante, position);
        return GeoKanteExtensions.getCoordinate(tangent, position, seitlicherAbstand, wirkrichtung);
    }

    public static SymbolArrangement<Coordinate> getCoordinate(LineSegment tangent, SegmentPosition position, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        LineSegment lateralSegement = Geometries.clone((LineSegment)tangent);
        Geometries.translate((LineSegment)lateralSegement, (Coordinate)lateralSegement.p0, (Coordinate)position.getCoordinate());
        double angle = 0.0;
        angle = seitlicherAbstand < 0.0 ? 90.0 : -90.0;
        Geometries.turn((LineSegment)lateralSegement, (double)angle);
        Geometries.scale((LineSegment)lateralSegement, (double)Math.abs(seitlicherAbstand));
        DirectedElement directedLineSegment = position.getDirectedLineSegment();
        LineSegment direction = Geometries.clone((LineSegment)((LineSegment)directedLineSegment.getElement()));
        double rotation = Geometries.getRotationToVertical((LineSegment)direction);
        boolean _matched = false;
        if (Objects.equal((Object)wirkrichtung, (Object)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)wirkrichtung, (Object)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)wirkrichtung, (Object)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN)) {
            _matched = true;
            rotation += 180.0;
        }
        if (!_matched && Objects.equal((Object)wirkrichtung, null)) {
            _matched = true;
            rotation = 0.0;
        }
        if (!_matched) {
            String _format = String.format("Wirkrichtung = %s", wirkrichtung);
            throw new RuntimeException(_format);
        }
        return new SymbolArrangement<Coordinate>(lateralSegement.p1, rotation);
    }

    private static Coordinate[] getCoordinates(GEO_Kante kante) {
        Coordinate _coordinate = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenA(kante));
        Coordinate _coordinateKnoteB = GeoKanteExtensions.getCoordinateKnoteB(kante);
        return new Coordinate[]{_coordinate, _coordinateKnoteB};
    }

    private static Coordinate getCoordinateKnoteB(GEO_Kante kante) {
        boolean _not;
        GEO_Knoten knotenB = GeoKanteExtensions.getGeoKnotenB(kante);
        Coordinate coordinateB = GeoKnotenExtensions.getCoordinate(knotenB);
        boolean _isCRSConsistent = GeoKanteExtensions.isCRSConsistent(kante);
        boolean bl = _not = !_isCRSConsistent;
        if (_not) {
            coordinateB = CoordinateExtensions.transformCRS(coordinateB, GeoKnotenExtensions.getCRS(knotenB), GeoKanteExtensions.getCRS(kante));
        }
        return coordinateB;
    }

    public static ENUMGEOKoordinatensystem getCRS(GEO_Kante geoKante) {
        return GeoKnotenExtensions.getCRS(GeoKanteExtensions.getGeoKnotenA(geoKante));
    }

    public static boolean isCRSConsistent(GEO_Kante geoKante) {
        ENUMGEOKoordinatensystem crsB;
        ENUMGEOKoordinatensystem crsA = GeoKnotenExtensions.getCRS(GeoKanteExtensions.getGeoKnotenA(geoKante));
        return crsA == (crsB = GeoKnotenExtensions.getCRS(GeoKanteExtensions.getGeoKnotenB(geoKante)));
    }

    public static GEO_Knoten getHead(DirectedElement<GEO_Kante> edge) {
        GEO_Knoten _xifexpression = null;
        boolean _isForwards = edge.isForwards();
        if (_isForwards) {
            GEO_Kante _element = null;
            if (edge != null) {
                _element = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenB = null;
            if (_element != null) {
                _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(_element);
            }
            _xifexpression = _geoKnotenB;
        } else {
            GEO_Kante _element_1 = null;
            if (edge != null) {
                _element_1 = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenA = null;
            if (_element_1 != null) {
                _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(_element_1);
            }
            _xifexpression = _geoKnotenA;
        }
        return _xifexpression;
    }

    public static GEO_Knoten getTail(DirectedElement<GEO_Kante> edge) {
        GEO_Knoten _xifexpression = null;
        boolean _isForwards = edge.isForwards();
        if (_isForwards) {
            GEO_Kante _element = null;
            if (edge != null) {
                _element = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenA = null;
            if (_element != null) {
                _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(_element);
            }
            _xifexpression = _geoKnotenA;
        } else {
            GEO_Kante _element_1 = null;
            if (edge != null) {
                _element_1 = (GEO_Kante)edge.getElement();
            }
            GEO_Knoten _geoKnotenB = null;
            if (_element_1 != null) {
                _geoKnotenB = GeoKanteExtensions.getGeoKnotenB(_element_1);
            }
            _xifexpression = _geoKnotenB;
        }
        return _xifexpression;
    }

    public static GEO_Knoten getGeoKnotenA(GEO_Kante kante) {
        return kante.getIDGEOKnotenA();
    }

    public static GEO_Knoten getGeoKnotenB(GEO_Kante kante) {
        return kante.getIDGEOKnotenB();
    }

    public static boolean isLoop(GEO_Kante kante) {
        String _wert = GeoKanteExtensions.getGeoKnotenA(kante).getIdentitaet().getWert();
        String _wert_1 = GeoKanteExtensions.getGeoKnotenB(kante).getIdentitaet().getWert();
        return Objects.equal((Object)_wert, (Object)_wert_1);
    }

    public static TOP_Kante topKante(GEO_Kante kante) {
        Basis_Objekt result = GeoKanteExtensions.getGeoArt(kante);
        if (result instanceof TOP_Kante) {
            return (TOP_Kante)result;
        }
        return null;
    }

    public static Basis_Objekt getGeoArt(GEO_Kante kante) {
        return kante.getIDGEOArt();
    }

    public static GEO_Knoten getOpposite(GEO_Kante kante, GEO_Knoten geoKnoten) {
        String _wert_3;
        String _wert_1;
        String _wert = GeoKanteExtensions.getGeoKnotenA(kante).getIdentitaet().getWert();
        boolean _equals = Objects.equal((Object)_wert, (Object)(_wert_1 = geoKnoten.getIdentitaet().getWert()));
        if (_equals) {
            return GeoKanteExtensions.getGeoKnotenB(kante);
        }
        String _wert_2 = GeoKanteExtensions.getGeoKnotenB(kante).getIdentitaet().getWert();
        boolean _equals_1 = Objects.equal((Object)_wert_2, (Object)(_wert_3 = geoKnoten.getIdentitaet().getWert()));
        if (_equals_1) {
            return GeoKanteExtensions.getGeoKnotenA(kante);
        }
        String _wert_4 = geoKnoten.getIdentitaet().getWert();
        String _plus = _wert_4 + " is no node of ";
        String _wert_5 = kante.getIdentitaet().getWert();
        String _plus_1 = _plus + _wert_5;
        throw new IllegalArgumentException(_plus_1);
    }

    public static LineSegment getTangent(GEO_Kante geoKante, SegmentPosition position) {
        ENUMGEOForm form = geoKante.getGEOKanteAllg().getGEOForm().getWert();
        if (form != null) {
            switch (form) {
                case ENUMGEO_FORM_BLOSSKURVE: 
                case ENUMGEO_FORM_BLOSS_EINFACH_GESCHWUNGEN: 
                case ENUMGEO_FORM_GERADE: 
                case ENUMGEO_FORM_KLOTHOIDE: 
                case ENUMGEO_FORM_KM_SPRUNG: 
                case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: 
                case ENUMGEO_FORM_SONSTIGE: {
                    return (LineSegment)position.getDirectedLineSegment().getElement();
                }
                case ENUMGEO_FORM_BOGEN: {
                    double radius = geoKante.getGEOKanteAllg().getGEORadiusA().getWert().doubleValue();
                    Coordinate _coordinate = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenA(geoKante));
                    Coordinate _coordinate_1 = GeoKnotenExtensions.getCoordinate(GeoKanteExtensions.getGeoKnotenB(geoKante));
                    double _abs = Math.abs(radius);
                    Chord.Orientation _xifexpression = null;
                    _xifexpression = radius < 0.0 ? Chord.Orientation.ARC_RIGHT : Chord.Orientation.ARC_LEFT;
                    Chord _chord = new Chord(_coordinate, _coordinate_1, _abs, _xifexpression);
                    LineSegment tangent = new Circle(_chord).getTangent(position.getCoordinate());
                    if (radius > 0.0 && position.getDirectedLineSegment().isForwards()) {
                        Geometries.turn((LineSegment)tangent, (double)180.0);
                    }
                    if (radius < 0.0 && !position.getDirectedLineSegment().isForwards()) {
                        Geometries.turn((LineSegment)tangent, (double)180.0);
                    }
                    return tangent;
                }
            }
            logger.warn("Form {} not supported.", (Object)form.getName());
            return (LineSegment)position.getDirectedLineSegment().getElement();
        }
        logger.warn("Form {} not supported.", (Object)form.getName());
        return (LineSegment)position.getDirectedLineSegment().getElement();
    }

    private static GeometryFactory getGeometryFactory() {
        return geoFactory;
    }

    public static LineString getGeometry(GEO_Kante kante) {
        ENUMGEOForm form = kante.getGEOKanteAllg().getGEOForm().getWert();
        if (form != null) {
            switch (form) {
                case ENUMGEO_FORM_GERADE: 
                case ENUMGEO_FORM_KM_SPRUNG: 
                case ENUMGEO_FORM_RICHTGERADE_KNICK_AM_ENDE_200_GON: 
                case ENUMGEO_FORM_SONSTIGE: {
                    return GeoKanteExtensions.getGeometryFactory().createLineString(GeoKanteExtensions.getCoordinates(kante));
                }
                case ENUMGEO_FORM_BOGEN: {
                    return GeoKanteExtensions.arc(kante);
                }
                case ENUMGEO_FORM_KLOTHOIDE: {
                    return GeoKanteExtensions.clothoid(kante);
                }
                case ENUMGEO_FORM_BLOSSKURVE: 
                case ENUMGEO_FORM_BLOSS_EINFACH_GESCHWUNGEN: {
                    return GeoKanteExtensions.blosscurve(kante);
                }
            }
            logger.warn("Form {} not supported.", (Object)form.getName());
            return GeoKanteExtensions.getGeometryFactory().createLineString(GeoKanteExtensions.getCoordinates(kante));
        }
        logger.warn("Form {} not supported.", (Object)form.getName());
        return GeoKanteExtensions.getGeometryFactory().createLineString(GeoKanteExtensions.getCoordinates(kante));
    }

    public static LineString getGeometry(DirectedElement<GEO_Kante> directedEdge) {
        LineString geometry = GeoKanteExtensions.getGeometry((GEO_Kante)directedEdge.getElement());
        boolean _isForwards = directedEdge.isForwards();
        if (_isForwards) {
            return geometry;
        }
        return geometry.reverse();
    }

    public static LineSegment getSegmentWith(GEO_Kante edge, Coordinate coordinate, double tolerance) {
        try {
            return GeoKanteExtensions.getSegmentWith(LineStringExtensions.getSegments(GeoKanteExtensions.getGeometry(edge)), coordinate, tolerance);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static LineSegment getSegmentWith(DirectedElement<GEO_Kante> directedEdge, Coordinate coordinate, double tolerance) {
        try {
            return GeoKanteExtensions.getSegmentWith(LineStringExtensions.getSegments(GeoKanteExtensions.getGeometry(directedEdge)), coordinate, tolerance);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static LineSegment getSegmentWith(List<LineSegment> segments, Coordinate coordinate, double tolerance) {
        for (LineSegment segment : segments) {
            boolean _lessEqualsThan;
            PointPairDistance result = new PointPairDistance();
            DistanceToPoint.computeDistance((LineSegment)segment, (Coordinate)coordinate, (PointPairDistance)result);
            double _distance = result.getDistance();
            boolean bl = _lessEqualsThan = _distance <= tolerance;
            if (!_lessEqualsThan) continue;
            return segment;
        }
        return null;
    }

    public static Iterable<Pair<Coordinate, Double>> getCoordinatesWithDistances(GEO_Kante geoKante) {
        ArrayList<Pair<Coordinate, Double>> result = new ArrayList<Pair<Coordinate, Double>>();
        Coordinate[] coordinates = GeoKanteExtensions.getGeometry(geoKante).getCoordinates();
        Coordinate lastCoordinate = (Coordinate)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)coordinates)));
        double distance = 0.0;
        Pair _mappedTo = Pair.of((Object)lastCoordinate, (Object)distance);
        result.add(_mappedTo);
        Iterable _tail = IterableExtensions.tail((Iterable)((Iterable)Conversions.doWrapArray((Object)coordinates)));
        for (Coordinate coordinate : _tail) {
            double _distance = distance;
            double _distance_1 = lastCoordinate.distance(coordinate);
            distance = _distance + _distance_1;
            lastCoordinate = coordinate;
            Pair _mappedTo_1 = Pair.of((Object)lastCoordinate, (Object)distance);
            result.add((Pair<Coordinate, Double>)_mappedTo_1);
        }
        return result;
    }
}

