/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdgePathExtension;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.basis.graph.Routing;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BueAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.ENUMWirkrichtungExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.MarkanterPunktExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CacheUtils;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CrossingRoute;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.GestellteWeiche;
import org.eclipse.set.ppmodel.extensions.utils.TeilFahrweg;
import org.eclipse.set.ppmodel.extensions.utils.TopRouting;
import org.eclipse.set.ppmodel.extensions.utils.WeichenSchenkel;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Gleisbezogener_Gefahrraum;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Umfahrpunkt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Gleis.ENUMGleisart;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Abschnitt;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Art;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Kreuzung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.utils.graph.DirectedEdgeExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FahrwegExtensions
extends BereichObjektExtensions {
    private static final Logger logger = LoggerFactory.getLogger(FahrwegExtensions.class);
    private static final double DISTANCE_TOLERANCE = 1.0E-6;
    private static Cache cache;

    public static Signal getStart(Fstr_Fahrweg fahrweg) {
        return fahrweg.getIDStart();
    }

    public static Basis_Objekt getZielObjekt(Fstr_Fahrweg fahrweg) {
        return fahrweg.getIDZiel();
    }

    public static Markanter_Punkt getZielPunkt(Fstr_Fahrweg fahrweg) {
        Basis_Objekt _iDZiel = fahrweg.getIDZiel();
        return (Markanter_Punkt)_iDZiel;
    }

    public static Punkt_Objekt getZielPunktObjekt(Fstr_Fahrweg fahrweg) {
        return FahrwegExtensions.getZielPunktObjektDispatch(FahrwegExtensions.getZielObjekt(fahrweg));
    }

    private static Punkt_Objekt _getZielPunktObjektDispatch(Basis_Objekt ziel) {
        return null;
    }

    private static Punkt_Objekt _getZielPunktObjektDispatch(Signal ziel) {
        return ziel;
    }

    private static Punkt_Objekt _getZielPunktObjektDispatch(Markanter_Punkt ziel) {
        return MarkanterPunktExtensions.getMarkanteStelle(ziel);
    }

    public static Signal getZielSignal(Fstr_Fahrweg fahrweg) {
        Basis_Objekt _iDZiel = fahrweg.getIDZiel();
        return (Signal)_iDZiel;
    }

    public static List<Fstr_Abhaengigkeit> getAbhaengigkeiten(Fstr_Fahrweg fahrweg) {
        LinkedList<Fstr_Abhaengigkeit> result = new LinkedList<Fstr_Abhaengigkeit>();
        Iterable _fstrAbhaengigkeit = BasisAttributExtensions.getContainer((EObject)fahrweg).getFstrAbhaengigkeit();
        for (Fstr_Abhaengigkeit abhaengigkeit : _fstrAbhaengigkeit) {
            String _wert_1;
            boolean _equals;
            Identitaet_TypeClass _identitaet = abhaengigkeit.getIDFstrFahrweg().getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (!(_equals = Objects.equal((Object)_wert, (Object)(_wert_1 = fahrweg.getIdentitaet().getWert())))) continue;
            result.add(abhaengigkeit);
        }
        return result;
    }

    public static TeilFahrweg getTeilFahrweg(Fstr_Fahrweg fahrweg, Punkt_Objekt start, Punkt_Objekt end) {
        return new TeilFahrweg(fahrweg, start, end);
    }

    public static GestellteWeiche getGestellteWeiche(Fstr_Fahrweg fahrweg, W_Kr_Gsp_Komponente komponente) {
        TOP_Knoten weichenKnoten;
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path = FahrwegExtensions.getPath(fahrweg);
        TOP_Kante schenkel = (TOP_Kante)path.getEdgeForTail((Object)(weichenKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)komponente))).getElement();
        ENUMTOPAnschluss anschluss = TopKanteExtensions.getTOPAnschluss(schenkel, weichenKnoten);
        boolean _equals = Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
        if (_equals) {
            W_Kr_Gsp_Element _wKrGspElement = WKrGspKomponenteExtensions.getWKrGspElement(komponente);
            return new GestellteWeiche(_wKrGspElement, GestellteWeiche.Lage.L);
        }
        boolean _equals_1 = Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
        if (_equals_1) {
            W_Kr_Gsp_Element _wKrGspElement_1 = WKrGspKomponenteExtensions.getWKrGspElement(komponente);
            return new GestellteWeiche(_wKrGspElement_1, GestellteWeiche.Lage.R);
        }
        return null;
    }

    public static WeichenSchenkel getWeichenSchenkel(Fstr_Fahrweg fahrweg, W_Kr_Gsp_Komponente komponente) {
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path = FahrwegExtensions.getPath(fahrweg);
        final TOP_Knoten weichenKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)komponente);
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it.getElement(), weichenKnoten);
                return !Objects.equal((Object)_tOPAnschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_SPITZE);
            }
        };
        Iterable schenkels = IterableExtensions.filter((Iterable)DirectedEdgePathExtension.getEdges(path, (Object)weichenKnoten), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)schenkels);
        boolean _equals = _size == 1;
        Assert.isTrue((boolean)_equals);
        DirectedEdge schenkel = ((DirectedEdge[])Conversions.unwrapArray((Object)schenkels, DirectedEdge.class))[0];
        ENUMTOPAnschluss anschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)schenkel.getElement(), weichenKnoten);
        if (anschluss == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS) {
            return new WeichenSchenkel((DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)schenkel, WeichenSchenkel.Lage.L);
        }
        if (anschluss == ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS) {
            return new WeichenSchenkel((DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)schenkel, WeichenSchenkel.Lage.R);
        }
        String _wert = komponente.getIdentitaet().getWert();
        throw new IllegalArgumentException(_wert);
    }

    public static GestellteWeiche getEntscheidungsweiche(final Fstr_Fahrweg fahrweg, W_Kr_Gsp_Komponente komponente, final List<ENUMGleisart> notUsable) {
        boolean _isDebugEnabled_2;
        boolean _equals_1;
        boolean _lessThan;
        boolean _isDebugEnabled = logger.isDebugEnabled();
        if (_isDebugEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("fahrweg=");
            String _debugName = Debug.debugName(fahrweg);
            _builder.append(_debugName);
            _builder.append(" komponente=");
            String _debugName_1 = Debug.debugName(komponente);
            _builder.append(_debugName_1);
            logger.debug(_builder.toString());
        }
        FahrwegExtensions.createCache();
        MissingSupplier<List<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>> _function = new MissingSupplier<List<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>>(){

            public List<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> get() {
                return FahrwegExtensions.routes(fahrweg, notUsable);
            }
        };
        List routes = (List)cache.get(CacheUtils.getCacheKey((Ur_Objekt)fahrweg, notUsable), (MissingSupplier)_function);
        int _size = routes.size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return null;
        }
        final Digraph routesGraph = Digraphs.toDigraph((Collection)routes);
        final TOP_Knoten weichenKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)komponente);
        Set nodesAfterWeiche = routesGraph.getDirectSuccessors((Object)weichenKnoten);
        Functions.Function1<TOP_Knoten, Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>> _function_1 = new Functions.Function1<TOP_Knoten, Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>>(){

            public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> apply(TOP_Knoten it) {
                return routesGraph.getEdges((Object)weichenKnoten, (Object)it);
            }
        };
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, String> _function_2 = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, String>(){

            public String apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                StringConcatenation _builder = new StringConcatenation();
                String _wert = ((TOP_Kante)it.getElement()).getIdentitaet().getWert();
                _builder.append(_wert);
                _builder.append(",");
                boolean _isForwards = it.isForwards();
                _builder.append((Object)_isForwards);
                return _builder.toString();
            }
        };
        Set edgesAfterWeiche = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)nodesAfterWeiche, (Functions.Function1)_function_1)), (Functions.Function1)_function_2));
        int numberOfEdgesAfterWeiche = edgesAfterWeiche.size();
        boolean _isDebugEnabled_1 = logger.isDebugEnabled();
        if (_isDebugEnabled_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("numberOfEdgesAfterWeiche=");
            _builder_1.append((Object)numberOfEdgesAfterWeiche);
            logger.debug(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("edgesAfterWeiche=");
            boolean _hasElements = false;
            for (String e : edgesAfterWeiche) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)", ", "");
                }
                _builder_2.append(e);
            }
            logger.debug(_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("routes=");
            boolean _hasElements_1 = false;
            for (DirectedEdgePath r : routes) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_3.appendImmediate((Object)", ", "");
                }
                String _debugName_2 = Debug.debugName(r);
                _builder_3.append(_debugName_2);
            }
            logger.debug(_builder_3.toString());
        }
        if (numberOfEdgesAfterWeiche == 0) {
            return null;
        }
        if (numberOfEdgesAfterWeiche == 1) {
            return null;
        }
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> fahrwegPath = FahrwegExtensions.getPath(fahrweg);
        DirectedEdge fahrwegEdgeAfterWeiche = fahrwegPath.getEdgeForTail((Object)weichenKnoten);
        Assert.isNotNull((Object)fahrwegEdgeAfterWeiche);
        ENUMTOPAnschluss anschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)fahrwegEdgeAfterWeiche.getElement(), weichenKnoten);
        GestellteWeiche entscheidungsweiche = null;
        boolean _equals = Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
        if (_equals) {
            GestellteWeiche _gestellteWeiche;
            W_Kr_Gsp_Element _wKrGspElement = WKrGspKomponenteExtensions.getWKrGspElement(komponente);
            entscheidungsweiche = _gestellteWeiche = new GestellteWeiche(_wKrGspElement, GestellteWeiche.Lage.L);
        }
        if (_equals_1 = Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS)) {
            GestellteWeiche _gestellteWeiche_1;
            W_Kr_Gsp_Element _wKrGspElement_1 = WKrGspKomponenteExtensions.getWKrGspElement(komponente);
            entscheidungsweiche = _gestellteWeiche_1 = new GestellteWeiche(_wKrGspElement_1, GestellteWeiche.Lage.R);
        }
        if (_isDebugEnabled_2 = logger.isDebugEnabled()) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("Entscheidungsweiche=");
            String _bezeichnung = null;
            if (entscheidungsweiche != null) {
                _bezeichnung = entscheidungsweiche.getBezeichnung();
            }
            _builder_4.append(_bezeichnung);
            logger.debug(_builder_4.toString());
        }
        return entscheidungsweiche;
    }

    private static void createCache() {
        if (cache == null) {
            cache = Services.getCacheService().getCache("toolbox.cache.fahrweg-key-to-fahrweg-routes");
        }
    }

    private static List<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> routes(Fstr_Fahrweg fahrweg, final List<ENUMGleisart> notUsable) {
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> fahrwegPath = FahrwegExtensions.getPath(fahrweg);
        DirectedEdge startEdge = (DirectedEdge)fahrwegPath.getEdgeList().get(0);
        Functions.Function1<Gleis_Art, Boolean> _function = new Functions.Function1<Gleis_Art, Boolean>(){

            public Boolean apply(Gleis_Art it) {
                return notUsable.contains(it.getGleisart().getWert());
            }
        };
        final Iterable notUsableGleisArt = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fahrweg).getGleisArt(), (Functions.Function1)_function);
        TopRouting _topRouting = new TopRouting();
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function_1 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(final DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> r) {
                Functions.Function1<Gleis_Art, Boolean> _function = new Functions.Function1<Gleis_Art, Boolean>(){

                    public Boolean apply(Gleis_Art it) {
                        boolean _areaIntersects = BereichObjektExtensions.areaIntersects((Bereich_Objekt)it, (DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)r);
                        return !_areaIntersects;
                    }
                };
                return IterableExtensions.forall((Iterable)notUsableGleisArt, (Functions.Function1)_function);
            }
        };
        List routes = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)DirectedEdgeExtensions.getPaths((DirectedEdge)startEdge, (Routing)_topRouting, (Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)fahrwegPath.getStart()), (Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)fahrwegPath.getEnd())), (Functions.Function1)_function_1));
        return routes;
    }

    public static DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getPath(Fstr_Fahrweg fahrweg) {
        return BereichObjektExtensions.getPath((Bereich_Objekt)fahrweg, (Punkt_Objekt)FahrwegExtensions.getStart(fahrweg), FahrwegExtensions.getZielPunktObjekt(fahrweg));
    }

    public static Set<Gleis_Abschnitt> getGleisabschnitte(final Fstr_Fahrweg fahrweg) {
        Functions.Function1<Gleis_Abschnitt, Boolean> _function = new Functions.Function1<Gleis_Abschnitt, Boolean>(){

            public Boolean apply(Gleis_Abschnitt it) {
                return BereichObjektExtensions.intersects((Bereich_Objekt)it, (Bereich_Objekt)fahrweg);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fahrweg).getGleisAbschnitt(), (Functions.Function1)_function));
    }

    public static Set<Signal_Signalbegriff> getSignalbegriffeImFahrweg(final Fstr_Fahrweg fahrweg) {
        final Signal startSignal = FahrwegExtensions.getStart(fahrweg);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                String _wert_1;
                String _wert = it.getIdentitaet().getWert();
                return !Objects.equal((Object)_wert, (Object)(_wert_1 = startSignal.getIdentitaet().getWert()));
            }
        };
        Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return FahrwegExtensions.containsInWirkrichtung(fahrweg, (Punkt_Objekt)it);
            }
        };
        Iterable signale = IterableExtensions.filter((Iterable)IterableExtensions.filter(BereichObjektExtensions.filterContained((Bereich_Objekt)fahrweg, BasisAttributExtensions.getContainer((EObject)fahrweg).getSignal()), (Functions.Function1)_function), (Functions.Function1)_function_1);
        boolean _isTraceEnabled = logger.isTraceEnabled();
        if (_isTraceEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("fahrweg=");
            String _debugString = Debug.debugString(FahrwegExtensions.getPath(fahrweg));
            _builder.append(_debugString);
            logger.trace(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("signale=");
            String _debugString_1 = Debug.debugString(IterableExtensions.toList((Iterable)signale));
            _builder_1.append(_debugString_1);
            logger.trace(_builder_1.toString());
        }
        Functions.Function1<Signal, Set<Signal_Signalbegriff>> _function_2 = new Functions.Function1<Signal, Set<Signal_Signalbegriff>>(){

            public Set<Signal_Signalbegriff> apply(Signal it) {
                return SignalExtensions.getSignalbegriffe(it);
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)signale, (Functions.Function1)_function_2)));
    }

    public static boolean containsInWirkrichtung(Fstr_Fahrweg fahrweg, Punkt_Objekt punktObjekt) {
        ENUMWirkrichtung wirkrichtung = FahrwegExtensions.getWirkrichtung(fahrweg, punktObjekt);
        if (wirkrichtung == null) {
            return false;
        }
        return !Objects.equal((Object)wirkrichtung, (Object)ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN);
    }

    public static ENUMWirkrichtung getWirkrichtung(Fstr_Fahrweg fahrweg, Punkt_Objekt punktObjekt) {
        boolean _equals;
        final Punkt_Objekt_TOP_Kante_AttributeGroup p = CollectionExtensions.getUnique(BereichObjektExtensions.intersection((Bereich_Objekt)fahrweg, punktObjekt));
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.contains((Object)p);
            }
        };
        Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, ENUMWirkrichtung> _function_1 = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, ENUMWirkrichtung>(){

            public ENUMWirkrichtung apply(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return FahrwegExtensions.getWirkrichtung(it, p);
            }
        };
        List directions = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)FahrwegExtensions.getPath(fahrweg).getEdgeList(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        int _size = directions.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return (ENUMWirkrichtung)directions.get(0);
        }
        String _wert = punktObjekt.getIdentitaet().getWert();
        throw new IllegalArgumentException(_wert);
    }

    public static Set<BUE_Anlage> getBUes(final Fstr_Fahrweg fahrweg) {
        Functions.Function1<BUE_Anlage, Boolean> _function = new Functions.Function1<BUE_Anlage, Boolean>(){

            public Boolean apply(BUE_Anlage it) {
                Functions.Function1<BUE_Gleisbezogener_Gefahrraum, Boolean> _function = new Functions.Function1<BUE_Gleisbezogener_Gefahrraum, Boolean>(){

                    public Boolean apply(BUE_Gleisbezogener_Gefahrraum it_1) {
                        return BereichObjektExtensions.intersects((Bereich_Objekt)it_1, (Bereich_Objekt)fahrweg);
                    }
                };
                return IterableExtensions.exists(BueAnlageExtensions.getGleisbezogeneGefahrraeume(it), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fahrweg).getBUEAnlage(), (Functions.Function1)_function));
    }

    public static List<Fstr_Umfahrpunkt> getUmfahrpunkte(final Fstr_Fahrweg fahrweg) {
        Functions.Function1<Fstr_Umfahrpunkt, Boolean> _function = new Functions.Function1<Fstr_Umfahrpunkt, Boolean>(){

            public Boolean apply(Fstr_Umfahrpunkt it) {
                Fstr_Fahrweg _iDFstrFahrweg = it.getIDFstrFahrweg();
                Identitaet_TypeClass _identitaet = null;
                if (_iDFstrFahrweg != null) {
                    _identitaet = _iDFstrFahrweg.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                String _wert_1 = fahrweg.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fahrweg).getFstrUmfahrpunkt(), (Functions.Function1)_function));
    }

    public static CrossingRoute getCrossingRoute(Fstr_Fahrweg fahrweg, Kreuzung_AttributeGroup kreuzung) {
        EObject _eContainer = kreuzung.eContainer();
        final Punkt_Objekt center = (Punkt_Objekt)_eContainer;
        try {
            boolean _lessThan;
            final Coordinate centerCoordinate = PunktObjektExtensions.getCoordinate(center);
            List<TOP_Kante> topKanten = PunktObjektExtensions.getTopKanten(center);
            int _size = topKanten.size();
            boolean _equals = _size == 2;
            Assert.isTrue((boolean)_equals);
            Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function = new Functions.Function1<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

                public Boolean apply(final DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
                    Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

                        public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                            return edge.contains((Object)it);
                        }
                    };
                    return IterableExtensions.exists(PunktObjektExtensions.getSinglePoints(center), (Functions.Function1)_function);
                }
            };
            final DirectedEdge fwEdge = (DirectedEdge)IterableExtensions.findFirst((Iterable)FahrwegExtensions.getPath(fahrweg).getEdgeList(), (Functions.Function1)_function);
            if (fwEdge == null) {
                return CrossingRoute.NO_CROSSING;
            }
            Assert.isTrue((boolean)topKanten.contains(fwEdge.getElement()));
            Functions.Function1<TOP_Kante, Boolean> _function_1 = new Functions.Function1<TOP_Kante, Boolean>(){

                public Boolean apply(TOP_Kante it) {
                    TOP_Kante _element = (TOP_Kante)fwEdge.getElement();
                    return it != _element;
                }
            };
            TOP_Kante topKanteCr = ((TOP_Kante[])Conversions.unwrapArray((Object)IterableExtensions.filter(topKanten, (Functions.Function1)_function_1), TOP_Kante.class))[0];
            Functions.Function1<DirectedElement<GEO_Kante>, LineSegment> _function_2 = new Functions.Function1<DirectedElement<GEO_Kante>, LineSegment>(){

                public LineSegment apply(DirectedElement<GEO_Kante> it) {
                    return GeoKanteExtensions.getSegmentWith(it, centerCoordinate, 1.0E-6);
                }
            };
            LineSegment tangentFw = (LineSegment)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(TopKanteExtensions.getGeoKanten((DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)fwEdge), (Functions.Function1)_function_2))));
            Functions.Function1<GEO_Kante, LineSegment> _function_3 = new Functions.Function1<GEO_Kante, LineSegment>(){

                public LineSegment apply(GEO_Kante it) {
                    return GeoKanteExtensions.getSegmentWith(it, centerCoordinate, 1.0E-6);
                }
            };
            LineSegment tangentCr = (LineSegment)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(TopKanteExtensions.getGeoKanten(topKanteCr), (Functions.Function1)_function_3))));
            Coordinate tipFw = tangentFw.p1;
            Coordinate tipCr0 = tangentCr.p0;
            Coordinate tipCr1 = tangentCr.p1;
            Coordinate tipCr = null;
            boolean _isAcute = Angle.isAcute((Coordinate)tipFw, (Coordinate)centerCoordinate, (Coordinate)tipCr0);
            if (_isAcute) {
                tipCr = tipCr0;
            } else {
                boolean _isAcute_1 = Angle.isAcute((Coordinate)tipFw, (Coordinate)centerCoordinate, (Coordinate)tipCr1);
                if (_isAcute_1) {
                    tipCr = tipCr1;
                } else {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Orthogonal crossings are not supported.");
                    throw new RuntimeException(_builder.toString());
                }
            }
            double _angleBetweenOriented = Angle.angleBetweenOriented((Coordinate)tipFw, (Coordinate)centerCoordinate, (Coordinate)tipCr);
            boolean bl = _lessThan = _angleBetweenOriented < 0.0;
            if (_lessThan) {
                return CrossingRoute.LEFT;
            }
            return CrossingRoute.RIGHT;
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static ENUMWirkrichtung getWirkrichtung(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        String _wert_2;
        ENUMWirkrichtung wirkrichtung;
        Wirkrichtung_TypeClass _wirkrichtung = null;
        if (singlePoint != null) {
            _wirkrichtung = singlePoint.getWirkrichtung();
        }
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        if ((wirkrichtung = _wert) == null) {
            wirkrichtung = ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE;
        }
        TOP_Kante topKante = (TOP_Kante)edge.getElement();
        String _wert_1 = ((TOP_Knoten)edge.getTail()).getIdentitaet().getWert();
        boolean _equals = Objects.equal((Object)_wert_1, (Object)(_wert_2 = TopKanteExtensions.getTOPKnotenA(topKante).getIdentitaet().getWert()));
        if (_equals) {
            return wirkrichtung;
        }
        return ENUMWirkrichtungExtensions.getInverted(wirkrichtung);
    }

    private static Punkt_Objekt getZielPunktObjektDispatch(Basis_Objekt ziel) {
        if (ziel instanceof Signal) {
            return FahrwegExtensions._getZielPunktObjektDispatch((Signal)ziel);
        }
        if (ziel instanceof Markanter_Punkt) {
            return FahrwegExtensions._getZielPunktObjektDispatch((Markanter_Punkt)ziel);
        }
        if (ziel != null) {
            return FahrwegExtensions._getZielPunktObjektDispatch(ziel);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ziel).toString());
    }
}

