/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.Routing;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.ppmodel.extensions.BankRouting;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.ValueInterval;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMUeberhoehungslinieForm;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Form_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Laenge_TypeClass;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankingInterval
extends ValueInterval<BigDecimal, BigDecimal> {
    private final boolean isPoint;
    private final DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path;
    private Ueberhoehungslinie bankingLine;
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingInterval.class);

    private BankingInterval(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, Ueberhoehungslinie bankingLine) {
        super(BankingInterval.getLeft(path), BankingInterval.getRight(path), BankingInterval.getBankingLength(path, bankingLine), BigDecimalExtensions.toBigDecimal((Number)path.distance((Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart()), (Object)singlePoint)), BigDecimalExtensions.toBigDecimal((Number)path.distance((Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd()), (Object)singlePoint)));
        this.bankingLine = bankingLine;
        this.path = path;
        this.isPoint = false;
    }

    private BankingInterval(BigDecimal bankingValue) {
        super(bankingValue, bankingValue, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        this.path = null;
        this.isPoint = true;
    }

    public String getCacheKey() {
        String _string = Boolean.valueOf(this.isPoint).toString();
        String _cacheKey = this.path.getCacheKey();
        return _string + _cacheKey;
    }

    private static BigDecimal getLeft(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        Punkt_Objekt _punktObjekt = PunktObjektTopKanteExtensions.getPunktObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)path.getStart());
        Ueberhoehung start = (Ueberhoehung)_punktObjekt;
        return start.getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
    }

    private static BigDecimal getRight(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path) {
        Punkt_Objekt _punktObjekt = PunktObjektTopKanteExtensions.getPunktObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)path.getEnd());
        Ueberhoehung end = (Ueberhoehung)_punktObjekt;
        return end.getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
    }

    private static BigDecimal getBankingLength(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path, Ueberhoehungslinie bankingLine) {
        BigDecimal length;
        Ueberhoehungslinie_Allg_AttributeGroup _ueberhoehungslinieAllg = null;
        if (bankingLine != null) {
            _ueberhoehungslinieAllg = bankingLine.getUeberhoehungslinieAllg();
        }
        Ueberhoehungslinie_Laenge_TypeClass _ueberhoehungslinieLaenge = null;
        if (_ueberhoehungslinieAllg != null) {
            _ueberhoehungslinieLaenge = _ueberhoehungslinieAllg.getUeberhoehungslinieLaenge();
        }
        BigDecimal _wert = null;
        if (_ueberhoehungslinieLaenge != null) {
            _wert = _ueberhoehungslinieLaenge.getWert();
        }
        if ((length = _wert) != null) {
            return length;
        }
        return BigDecimal.valueOf(path.getLength());
    }

    public static BankingInterval createInterval(final Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, Digraph<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> digraph) {
        boolean _tripleEquals;
        boolean _greaterThan;
        int noOfBankings = IterableExtensions.size((Iterable)BasisAttributExtensions.getContainer((EObject)singlePoint).getUeberhoehung());
        if (noOfBankings == 0) {
            return null;
        }
        Cache storedBankingIntervals = Services.getCacheService().getCache("toolbox.cache.banking-interval");
        Functions.Function1<BankingInterval, Boolean> _function = new Functions.Function1<BankingInterval, Boolean>(){

            public Boolean apply(BankingInterval it) {
                return it.contains(singlePoint);
            }
        };
        Iterable foundIntervals = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)storedBankingIntervals.values(), BankingInterval.class), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)foundIntervals);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            String _string = Integer.valueOf(IterableExtensions.size((Iterable)foundIntervals)).toString();
            throw new IllegalArgumentException(_string);
        }
        int _size_1 = IterableExtensions.size((Iterable)foundIntervals);
        boolean bl2 = _tripleEquals = _size_1 == 1;
        if (_tripleEquals) {
            return ((BankingInterval[])Conversions.unwrapArray((Object)foundIntervals, BankingInterval.class))[0];
        }
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        DirectedTopKante forward = new DirectedTopKante(topKante, true);
        DirectedTopKante backward = new DirectedTopKante(topKante, false);
        BankRouting bankRouting = new BankRouting(digraph, singlePoint);
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function_1 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.getLength();
            }
        };
        DirectedEdgePath pathToStartBanking = (DirectedEdgePath)IterableExtensions.sortBy((Iterable)Digraphs.getPaths((DirectedEdge)forward, (Routing)bankRouting), (Functions.Function1)_function_1).get(0);
        Ueberhoehung startBanking = BankingInterval.getFirstBankingAfter((DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)pathToStartBanking, singlePoint);
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function_2 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.getLength();
            }
        };
        DirectedEdgePath pathToEndBanking = (DirectedEdgePath)IterableExtensions.sortBy((Iterable)Digraphs.getPaths((DirectedEdge)backward, (Routing)bankRouting), (Functions.Function1)_function_2).get(0);
        Ueberhoehung endBanking = BankingInterval.getFirstBankingAfter((DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)pathToEndBanking, singlePoint);
        if (startBanking == null && endBanking == null) {
            return null;
        }
        if (startBanking == null) {
            BigDecimal _wert = endBanking.getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
            return new BankingInterval(_wert);
        }
        if (endBanking == null) {
            BigDecimal _wert_1 = startBanking.getUeberhoehungAllg().getUeberhoehungHoehe().getWert();
            return new BankingInterval(_wert_1);
        }
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean> _function_3 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Boolean>(){

            public Boolean apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return IteratorExtensions.toList((Iterator)it.getPointIterator()).contains(singlePoint);
            }
        };
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function_4 = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.getLength();
            }
        };
        List intervals = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)Digraphs.getPaths(digraph, PunktObjektExtensions.getSinglePoints((Punkt_Objekt)startBanking), PunktObjektExtensions.getSinglePoints((Punkt_Objekt)endBanking)), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        boolean _isEmpty = intervals.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("pathToStartBanking=");
            String _debugString = Debug.debugString(pathToStartBanking);
            _builder.append(_debugString);
            LOGGER.error(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("pathToEndBanking=");
            String _debugString_1 = Debug.debugString(pathToEndBanking);
            _builder_1.append(_debugString_1);
            LOGGER.error(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("pathToStartBankingEdgeList=");
            List _edgeList = pathToStartBanking.getEdgeList();
            for (DirectedEdge e : _edgeList) {
                Object _element = null;
                if (e != null) {
                    _element = (TOP_Kante)e.getElement();
                }
                Identitaet_TypeClass _identitaet = null;
                if (_element != null) {
                    _identitaet = _element.getIdentitaet();
                }
                String _wert_2 = null;
                if (_identitaet != null) {
                    _wert_2 = _identitaet.getWert();
                }
                _builder_2.append(_wert_2);
            }
            LOGGER.error(_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("pathToEndBankingEdgeList=");
            List _edgeList_1 = pathToEndBanking.getEdgeList();
            for (DirectedEdge e_1 : _edgeList_1) {
                Object _element_1 = null;
                if (e_1 != null) {
                    _element_1 = (TOP_Kante)e_1.getElement();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (_element_1 != null) {
                    _identitaet_1 = _element_1.getIdentitaet();
                }
                String _wert_3 = null;
                if (_identitaet_1 != null) {
                    _wert_3 = _identitaet_1.getWert();
                }
                _builder_3.append(_wert_3);
            }
            LOGGER.error(_builder_3.toString());
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("startBankingTopKanten=");
            List<TOP_Kante> _topKanten = PunktObjektExtensions.getTopKanten((Punkt_Objekt)startBanking);
            for (TOP_Kante e_2 : _topKanten) {
                Object _identitaet_2 = null;
                if (e_2 != null) {
                    _identitaet_2 = e_2.getIdentitaet();
                }
                String _wert_4 = null;
                if (_identitaet_2 != null) {
                    _wert_4 = _identitaet_2.getWert();
                }
                _builder_4.append(_wert_4);
            }
            LOGGER.error(_builder_4.toString());
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("endBankingTopKanten=");
            List<TOP_Kante> _topKanten_1 = PunktObjektExtensions.getTopKanten((Punkt_Objekt)endBanking);
            for (TOP_Kante e_3 : _topKanten_1) {
                Identitaet_TypeClass _identitaet_3 = null;
                if (e_3 != null) {
                    _identitaet_3 = e_3.getIdentitaet();
                }
                String _wert_5 = null;
                if (_identitaet_3 != null) {
                    _wert_5 = _identitaet_3.getWert();
                }
                _builder_5.append(_wert_5);
            }
            LOGGER.error(_builder_5.toString());
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("No path from ");
            String _debugString_2 = Debug.debugString(startBanking);
            _builder_6.append(_debugString_2);
            _builder_6.append(" to ");
            String _debugString_3 = Debug.debugString(endBanking);
            _builder_6.append(_debugString_3);
            _builder_6.append(" for ");
            String _debugString_4 = Debug.debugString(singlePoint);
            _builder_6.append(_debugString_4);
            _builder_6.append(".");
            throw new IllegalArgumentException(_builder_6.toString());
        }
        DirectedEdgePath interval = (DirectedEdgePath)intervals.get(0);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("Created Banking interval [");
        String _debugString_5 = Debug.debugString(interval.getStart());
        _builder_7.append(_debugString_5);
        _builder_7.append(", ");
        String _debugString_6 = Debug.debugString(interval.getEnd());
        _builder_7.append(_debugString_6);
        _builder_7.append("].");
        LOGGER.debug(_builder_7.toString());
        Ueberhoehungslinie bankingLine = BankingInterval.getBankingLine(startBanking, endBanking);
        BankingInterval newInterval = new BankingInterval((DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)interval, singlePoint, bankingLine);
        storedBankingIntervals.set(newInterval.getCacheKey(), (Object)newInterval);
        return newInterval;
    }

    public static Ueberhoehungslinie getBankingLine(final Ueberhoehung start, final Ueberhoehung end) {
        Functions.Function1<Ueberhoehungslinie, Boolean> _function = new Functions.Function1<Ueberhoehungslinie, Boolean>(){

            public Boolean apply(Ueberhoehungslinie it) {
                return it.getIDUeberhoehungA() == start && it.getIDUeberhoehungB() == end;
            }
        };
        Iterable lines = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)start).getUeberhoehungslinie(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)lines);
        if (_isEmpty) {
            return null;
        }
        return ((Ueberhoehungslinie[])Conversions.unwrapArray((Object)lines, Ueberhoehungslinie.class))[0];
    }

    public BigDecimal getBanking() {
        if (this.isPoint) {
            return (BigDecimal)this.getLeft();
        }
        BigDecimal h_start = (BigDecimal)this.getLeft();
        BigDecimal h_end = (BigDecimal)this.getRight();
        BigDecimal h_between = h_end.subtract(h_start);
        BigDecimal result = BigDecimal.ZERO;
        Ueberhoehungslinie_Allg_AttributeGroup _ueberhoehungslinieAllg = null;
        if (this.bankingLine != null) {
            _ueberhoehungslinieAllg = this.bankingLine.getUeberhoehungslinieAllg();
        }
        Ueberhoehungslinie_Form_TypeClass _ueberhoehungslinieForm = null;
        if (_ueberhoehungslinieAllg != null) {
            _ueberhoehungslinieForm = _ueberhoehungslinieAllg.getUeberhoehungslinieForm();
        }
        ENUMUeberhoehungslinieForm _wert = null;
        if (_ueberhoehungslinieForm != null) {
            _wert = _ueberhoehungslinieForm.getWert();
        }
        if (_wert != null) {
            switch (_wert) {
                case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_BLOSS: {
                    result = this.bankingOfRampeBloss(h_between);
                    break;
                }
                case ENUM_UEBERHOEHUNGSLINIE_FORM_RAMPE_S: {
                    result = this.bankingOfRampeS(h_between);
                    break;
                }
                default: {
                    result = this.bankingDefault(h_between);
                    break;
                }
            }
        } else {
            result = this.bankingDefault(h_between);
        }
        return result.add(h_start);
    }

    private BigDecimal bankingOfRampeBloss(BigDecimal h_between) {
        boolean _greaterThan;
        int _compareTo = ((BigDecimal)this.getDistanceFromLeft()).compareTo(BigDecimalExtensions.divideValue((BigDecimal)((BigDecimal)this.getLength()), (Number)2));
        boolean bl = _greaterThan = _compareTo > 0;
        if (_greaterThan) {
            return this.bankingDefault(h_between);
        }
        BigDecimal a = BigDecimalExtensions.divideValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)h_between, (Number)3), (Number)((BigDecimal)this.getLength()).pow(2)).multiply(((BigDecimal)this.getDistanceFromLeft()).pow(2));
        BigDecimal b = BigDecimalExtensions.divideValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)h_between, (Number)2), (Number)((BigDecimal)this.getLength()).pow(3)).multiply(((BigDecimal)this.getDistanceFromLeft()).pow(3));
        return a.add(b.negate());
    }

    private BigDecimal bankingOfRampeS(BigDecimal h_between) {
        boolean _lessThan;
        int _compareTo = ((BigDecimal)this.getDistanceFromLeft()).compareTo(BigDecimalExtensions.divideValue((BigDecimal)((BigDecimal)this.getLength()), (Number)2));
        boolean bl = _lessThan = _compareTo < 1;
        if (_lessThan) {
            return BigDecimalExtensions.divideValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)h_between, (Number)2), (Number)((BigDecimal)this.getDistanceFromLeft()).pow(2)), (Number)((BigDecimal)this.getLength()).pow(2));
        }
        return h_between.add(BigDecimalExtensions.divideValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)h_between, (Number)2), (Number)((BigDecimal)this.getDistanceFromRight()).pow(2)), (Number)((BigDecimal)this.getLength()).pow(2)).negate());
    }

    private BigDecimal bankingDefault(BigDecimal h_between) {
        return BigDecimalExtensions.divideValue((BigDecimal)BigDecimalExtensions.multiplyValue((BigDecimal)h_between, (Number)((BigDecimal)this.getDistanceFromLeft())), (Number)((BigDecimal)this.getLength()));
    }

    public boolean contains(final Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        if (this.path == null) {
            return false;
        }
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return it == singlePoint;
            }
        };
        return IteratorExtensions.exists((Iterator)this.path.getPointIterator(), (Functions.Function1)_function);
    }

    private static Ueberhoehung getFirstBankingAfter(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _not;
        List singlePoints = IteratorExtensions.toList((Iterator)path.getPointIterator());
        int index = singlePoints.indexOf(singlePoint);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        List pointsAfterPunkt = singlePoints.subList(index, singlePoints.size());
        Assert.isNotNull(pointsAfterPunkt);
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Punkt_Objekt>(){

            public Punkt_Objekt apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getPunktObjekt(it);
            }
        };
        List bankings = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map(pointsAfterPunkt, (Functions.Function1)_function), Ueberhoehung.class));
        boolean _isEmpty = bankings.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return (Ueberhoehung)bankings.get(0);
        }
        return null;
    }
}

