/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.Routing;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.TopKantePath;
import org.eclipse.set.ppmodel.extensions.utils.TopRouting;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class BankRouting
implements Routing<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> {
    private final Digraph<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> graph;
    private final Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint;
    private final TopRouting topRouting;

    public BankRouting(Digraph<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> graph, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        TopRouting _topRouting;
        this.graph = graph;
        this.singlePoint = singlePoint;
        this.topRouting = _topRouting = new TopRouting();
    }

    public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> getDirectPredecessors(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedEdge) {
        boolean _bankingFound = this.bankingFound(directedEdge, false);
        if (_bankingFound) {
            return Collections.emptySet();
        }
        return this.topRouting.getDirectPredecessors(directedEdge);
    }

    public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> getDirectSuccessors(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedEdge) {
        boolean _bankingFound = this.bankingFound(directedEdge, true);
        if (_bankingFound) {
            return Collections.emptySet();
        }
        return this.topRouting.getDirectSuccessors(directedEdge);
    }

    public Comparator<Double> getDistanceComparator() {
        return new Comparator<Double>(){

            @Override
            public int compare(Double d1, Double d2) {
                return Distance.compare(d1, d2);
            }
        };
    }

    public DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getEdge(TOP_Knoten tail, TOP_Knoten head) {
        return this.graph.getEdge((Object)tail, (Object)head);
    }

    public Set<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> getEdges(TOP_Knoten tail, TOP_Knoten head) {
        return this.graph.getEdges((Object)tail, (Object)head);
    }

    public DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getEmptyPath() {
        return new TopKantePath();
    }

    private boolean bankingFound(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedEdge, boolean afterPunkt) {
        List singlePoints = IteratorExtensions.toList((Iterator)directedEdge.getIterator());
        int index = singlePoints.indexOf(this.singlePoint);
        if (index < 0) {
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)singlePoints, Ueberhoehung.class));
            return !_isEmpty;
        }
        if (afterPunkt) {
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)Iterables.filter(singlePoints.subList(index, singlePoints.size()), Ueberhoehung.class));
            return !_isEmpty_1;
        }
        boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)Iterables.filter(singlePoints.subList(0, index), Ueberhoehung.class));
        return !_isEmpty_2;
    }

    public String getCacheKey() {
        StringConcatenation _builder = new StringConcatenation();
        String _cacheKey = this.graph.getCacheKey();
        _builder.append(_cacheKey);
        _builder.append("/singlePoint.cacheKey");
        return _builder.toString();
    }
}

