/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.validationreport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ObjectState implements Enumerator
{
    INITIAL(0, "INITIAL", "Start"),
    FINAL(1, "FINAL", "Ziel"),
    LAYOUT(2, "LAYOUT", "Layoutinformationen"),
    INFO(3, "INFO", "Information");

    public static final int INITIAL_VALUE = 0;
    public static final int FINAL_VALUE = 1;
    public static final int LAYOUT_VALUE = 2;
    public static final int INFO_VALUE = 3;
    private static final ObjectState[] VALUES_ARRAY;
    public static final List<ObjectState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectState[]{INITIAL, FINAL, LAYOUT, INFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectState get(int value) {
        switch (value) {
            case 0: {
                return INITIAL;
            }
            case 1: {
                return FINAL;
            }
            case 2: {
                return LAYOUT;
            }
            case 3: {
                return INFO;
            }
        }
        return null;
    }

    private ObjectState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

