/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.overview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.messages.MessagesWrapper;
import org.eclipse.set.feature.table.overview.TableErrorTableView;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.EventHandler;

public class TableOverviewPart
extends BasePart {
    private static final String TABLE_PART_ID_PREFIX = "org.eclipse.set.feature.table.";
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    private ToolboxPartService toolboxPartService;
    @Inject
    private IEventBroker broker;
    @Inject
    private TableService tableService;
    @Inject
    MessagesWrapper wrapper;
    private Label completenessHint;
    private Text missingTablesText;
    private Button calculateMissing;
    private Text withErrorsText;
    private Button openAllWithErrors;
    private TableErrorTableView tableErrorTableView;
    private final EventHandler tableErrorsChangeEventHandler = event -> this.onTableErrorsChange();
    private boolean ignoreChangeEvent = false;

    protected void createView(Composite parent) {
        this.completenessHint = new Label(parent, 0);
        this.completenessHint.setText(this.messages.TableOverviewPart_CompletenessHint);
        Color red = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.completenessHint.addDisposeListener(e -> red.dispose());
        this.completenessHint.setForeground(red);
        Group section = new Group(parent, 16);
        section.setText(this.messages.TableOverviewPart_TableSectionHeader);
        section.setLayoutData((Object)new GridData(4, 128, true, false));
        section.setLayout((Layout)new GridLayout(3, false));
        Label missingTablesDesc = new Label((Composite)section, 0);
        missingTablesDesc.setText(this.messages.TableOverviewPart_MissingTablesDesc);
        this.missingTablesText = new Text((Composite)section, 2048);
        this.missingTablesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.missingTablesText.setEnabled(false);
        this.calculateMissing = new Button((Composite)section, 0);
        this.calculateMissing.setText(this.messages.TableOverviewPart_CalculateMissing);
        this.calculateMissing.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableOverviewPart.this.calculateAllMissingTablesEvent();
            }

            public void widgetSelected(SelectionEvent e) {
                TableOverviewPart.this.calculateAllMissingTablesEvent();
            }
        });
        Label withErrorsDesc = new Label((Composite)section, 0);
        withErrorsDesc.setText(this.messages.TableOverviewPart_WithErrorsDesc);
        this.withErrorsText = new Text((Composite)section, 2048);
        this.withErrorsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.withErrorsText.setEnabled(false);
        this.openAllWithErrors = new Button((Composite)section, 0);
        this.openAllWithErrors.setText(this.messages.TableOverviewPart_OpenAllWithErrors);
        this.openAllWithErrors.setEnabled(false);
        this.openAllWithErrors.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableOverviewPart.this.openAllTablesWithErrors();
            }

            public void widgetSelected(SelectionEvent e) {
                TableOverviewPart.this.openAllTablesWithErrors();
            }
        });
        this.tableErrorTableView = new TableErrorTableView(this.messages, this.getBroker(), this.toolboxPartService);
        this.tableErrorTableView.create(parent);
        this.getBroker().subscribe("modelsession/change/tableerror", this.tableErrorsChangeEventHandler);
        this.update();
    }

    private void onTableErrorsChange() {
        if (!this.ignoreChangeEvent) {
            this.update();
        }
    }

    private void calculateAllMissingTablesEvent() {
        this.ignoreChangeEvent = true;
        try {
            this.getDialogService().showProgress(this.getToolboxShell(), this::calculateAllMissingTables);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.getDialogService().error(this.getToolboxShell(), e);
        }
        this.ignoreChangeEvent = false;
        this.update();
    }

    private void calculateAllMissingTables(IProgressMonitor monitor) {
        Collection<String> missingTables = this.getMissingTables();
        monitor.beginTask(this.messages.TableOverviewPart_CalculateMissingTask, missingTables.size());
        TableType tableType = this.getModelSession().isSingleState() ? TableType.SINGLE : TableType.DIFF;
        for (String table : missingTables) {
            TableNameInfo info = this.tableService.getTableNameInfo(table);
            monitor.subTask(info.getFullDisplayName());
            this.tableService.transformToTable(table, tableType, this.getModelSession());
            monitor.worked(1);
        }
    }

    private void openAllTablesWithErrors() {
        Collection<String> tablesWithErrors = this.getTablesContainingErrors();
        for (String shortCut : tablesWithErrors) {
            String partDescriptionId = TABLE_PART_ID_PREFIX + shortCut;
            this.toolboxPartService.showPart(partDescriptionId);
        }
    }

    private void update() {
        Collection<String> missingTables = this.getMissingTables();
        this.missingTablesText.setText(this.tableList2DisplayString(missingTables));
        this.completenessHint.setVisible(!missingTables.isEmpty());
        this.calculateMissing.setEnabled(!missingTables.isEmpty());
        Collection<String> tablesWithErrors = this.getTablesContainingErrors();
        this.withErrorsText.setText(this.tableList2DisplayString(tablesWithErrors));
        this.openAllWithErrors.setEnabled(!tablesWithErrors.isEmpty());
        ArrayList<TableError> allErrors = new ArrayList<TableError>();
        this.tableService.getTableErrors().values().forEach(allErrors::addAll);
        this.tableErrorTableView.updateView(allErrors);
    }

    private Collection<String> getMissingTables() {
        Map<String, Collection<TableError>> computedErrors = this.tableService.getTableErrors();
        Collection<String> allTableInfos = this.tableService.getAvailableTables();
        ArrayList<String> missingTables = new ArrayList<String>();
        missingTables.addAll(allTableInfos);
        missingTables.removeAll(computedErrors.keySet());
        return missingTables;
    }

    private Collection<String> getTablesContainingErrors() {
        Map<String, Collection<TableError>> computedErrors = this.tableService.getTableErrors();
        ArrayList<String> tablesWithErrors = new ArrayList<String>();
        for (Map.Entry<String, Collection<TableError>> entry : computedErrors.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            tablesWithErrors.add(entry.getKey());
        }
        return tablesWithErrors;
    }

    private String tableList2DisplayString(Collection<String> tables) {
        if (tables.isEmpty()) {
            return this.messages.TableOverviewPart_EmptyListText;
        }
        ArrayList<String> shortNames = new ArrayList<String>(tables.stream().map(shortCut -> this.tableService.getTableNameInfo((String)shortCut).getShortName()).toList());
        Collections.sort(shortNames);
        return shortNames.stream().collect(Collectors.joining(", "));
    }

    @PreDestroy
    private void unsubscribe() {
        this.broker.unsubscribe(this.tableErrorsChangeEventHandler);
    }

    @Inject
    public TableOverviewPart() {
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.update();
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.update();
    }
}

