/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public final class NIOUtil {
    private NIOUtil() {
    }

    public static void copyFile(File source, File target) {
        FileChannel sourceChannel = null;
        FileChannel targetChannel = null;
        try {
            try {
                if (!target.getParentFile().exists()) {
                    target.getParentFile().mkdirs();
                }
                if (!target.exists()) {
                    target.createNewFile();
                }
                sourceChannel = new FileInputStream(source).getChannel();
                targetChannel = new FileOutputStream(target).getChannel();
                long size = sourceChannel.size();
                long transfered = sourceChannel.transferTo(0L, size, targetChannel);
                if (transfered != size) {
                    throw new ImplementationError("Seems as if a loop must be implemented here");
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(sourceChannel);
            IOUtil.closeSilent(targetChannel);
            throw throwable;
        }
        IOUtil.closeSilent(sourceChannel);
        IOUtil.closeSilent(targetChannel);
    }

    private static void copy(File src, File dst, boolean overwrite) throws IOException {
        File dstParent;
        if (!src.isFile() || !src.exists()) {
            throw new IllegalArgumentException("Source file '" + src.getAbsolutePath() + "' not found!");
        }
        if (dst.exists()) {
            if (dst.isDirectory()) {
                dst = new File(dst, src.getName());
            } else if (dst.isFile()) {
                if (!overwrite) {
                    throw new IllegalArgumentException("Destination file '" + dst.getAbsolutePath() + "' already exists!");
                }
            } else {
                throw new IllegalArgumentException("Invalid destination object '" + dst.getAbsolutePath() + "'!");
            }
        }
        if (!(dstParent = dst.getParentFile()).exists() && !dstParent.mkdirs()) {
            throw new IOException("Failed to create directory " + dstParent.getAbsolutePath());
        }
        long fileSize = src.length();
        if (fileSize > 0x1400000L) {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            try {
                int doneCnt = -1;
                int bufSize = 32768;
                byte[] buf = new byte[bufSize];
                while ((doneCnt = in.read(buf, 0, bufSize)) >= 0) {
                    if (doneCnt == 0) {
                        Thread.yield();
                        continue;
                    }
                    out.write(buf, 0, doneCnt);
                }
                out.flush();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dst);
        FileChannel in = fis.getChannel();
        FileChannel out = fos.getChannel();
        try {
            long offs = 0L;
            long doneCnt = 0L;
            long copyCnt = Math.min(65536L, fileSize);
            do {
                doneCnt = in.transferTo(offs, copyCnt, out);
                offs += doneCnt;
            } while ((fileSize -= doneCnt) > 0L);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                fis.close();
            }
            catch (IOException iOException) {}
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

