/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.annotations.EcoreReferenceInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreTypeInfo;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;

public class EcoreReferenceSerializer
extends JsonSerializer<EObject> {
    private final EcoreReferenceInfo info;
    private final EcoreTypeInfo typeInfo;
    private final URIHandler handler;

    public EcoreReferenceSerializer(EcoreReferenceInfo info, EcoreTypeInfo typeInfo) {
        this.info = info;
        this.typeInfo = typeInfo;
        this.handler = info.getHandler();
    }

    public void serialize(EObject value, JsonGenerator jg, SerializerProvider serializers) throws IOException {
        EObject parent = EMFContext.getParent((DatabindContext)serializers);
        String href = this.getHRef(serializers, parent, value);
        jg.writeStartObject();
        jg.writeStringField(this.typeInfo.getProperty(), this.typeInfo.getValueWriter().writeValue(value.eClass(), serializers));
        if (href == null) {
            jg.writeNullField(this.info.getProperty());
        } else {
            jg.writeStringField(this.info.getProperty(), href);
        }
        jg.writeEndObject();
    }

    private boolean isExternal(DatabindContext ctxt, EObject source, EObject target) {
        Resource sourceResource = EMFContext.getResource(ctxt, source);
        if (target.eIsProxy() && target instanceof InternalEObject) {
            URI uri = ((InternalEObject)target).eProxyURI();
            return sourceResource != null && sourceResource.getURI() != null && !sourceResource.getURI().equals(uri.trimFragment());
        }
        return sourceResource == null || sourceResource != EMFContext.getResource(ctxt, target);
    }

    private String getHRef(SerializerProvider ctxt, EObject parent, EObject value) {
        if (this.isExternal((DatabindContext)ctxt, parent, value)) {
            URI targetURI = EMFContext.getURI((DatabindContext)ctxt, value);
            URI sourceURI = EMFContext.getURI((DatabindContext)ctxt, parent);
            URI deresolved = this.handler != null ? this.handler.deresolve(sourceURI, targetURI) : targetURI;
            return deresolved == null ? null : deresolved.toString();
        }
        Resource resource = EMFContext.getResource((DatabindContext)ctxt, value);
        if (resource != null) {
            return resource.getURIFragment(value);
        }
        return null;
    }
}

