/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskp;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.constants.ToolboxConstants;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.PZBElementExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.ENUMUnterbringungBefestigung;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung_Befestigung_TypeClass;
import org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Kante;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Spezifisches_Signal;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Kurztext_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Markanter_Punkt_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Markanter_Punkt_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Massgebende_Neigung_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.PZB.ENUMGUEAnordnung;
import org.eclipse.set.toolboxmodel.PZB.ENUMGUEBauart;
import org.eclipse.set.toolboxmodel.PZB.ENUMGUEEnergieversorgung;
import org.eclipse.set.toolboxmodel.PZB.ENUMMessfehler;
import org.eclipse.set.toolboxmodel.PZB.ENUMPZBArt;
import org.eclipse.set.toolboxmodel.PZB.ENUMWirksamkeit;
import org.eclipse.set.toolboxmodel.PZB.ENUMWirksamkeitFstr;
import org.eclipse.set.toolboxmodel.PZB.GUE_Anordnung_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.GUE_Bauart_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.GUE_Energieversorgung_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.INA_Gefahrstelle_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.Messfehler_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.PZB_Art_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_GUE_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_Zuordnung_BP_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_Zuordnung_Fstr_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Element_Zuordnung_INA_AttributeGroup;
import org.eclipse.set.toolboxmodel.PZB.PZB_Zuordnung_Signal;
import org.eclipse.set.toolboxmodel.PZB.Prioritaet_Gefahrstelle_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.Pruefgeschwindigkeit_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.Pruefzeit_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.Wirksamkeit_Fstr_TypeClass;
import org.eclipse.set.toolboxmodel.PZB.Wirksamkeit_TypeClass;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Ne5;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalArt;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalFunktion;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Funktion_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.utils.math.AgateRounding;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.eclipse.set.utils.math.BigIntegerExtensions;
import org.eclipse.set.utils.math.DoubleExtensions;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SskpTransformator
extends AbstractPlanPro2TableModelTransformator {
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_60 = 450.0;
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_40_60 = 350.0;
    private static final double ADDITION_SCHUTZSTRECKE_SOLL_40 = 210.0;

    public SskpTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService) {
        super(cols, enumTranslationService);
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory) {
        Iterable _tOPKante = container.getTOPKante();
        final TopGraph topGraph = new TopGraph(_tOPKante);
        Iterable _pZBElement = container.getPZBElement();
        for (final PZB_Element pzb : _pZBElement) {
            boolean _tripleNotEquals;
            boolean _tripleEquals;
            boolean _isInterrupted = Thread.currentThread().isInterrupted();
            if (_isInterrupted) {
                return null;
            }
            TableRow instance = factory.newTableRow((Ur_Objekt)pzb);
            Functions.Function1<PZB_Element, Iterable<String>> _function = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<Basis_Objekt, String> _function = new Functions.Function1<Basis_Objekt, String>(){

                        public String apply(Basis_Objekt it_1) {
                            return SskpTransformator.this.fillBezugsElement(it_1);
                        }
                    };
                    return ListExtensions.map((List)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it), (Functions.Function1)_function);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "A"), pzb, (Functions.Function1)_function, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<PZB_Element, String> _function_1 = new Functions.Function1<PZB_Element, String>(){

                public String apply(PZB_Element it) {
                    PZB_Art_TypeClass _pZBArt = it.getPZBArt();
                    ENUMPZBArt _wert = null;
                    if (_pZBArt != null) {
                        _wert = _pZBArt.getWert();
                    }
                    String _translate = null;
                    if (_wert != null) {
                        _translate = SskpTransformator.this.translate((Enumerator)_wert);
                    }
                    return _translate;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "B"), pzb, (Functions.Function1)_function_1);
            boolean _or = false;
            PZB_Art_TypeClass _pZBArt = pzb.getPZBArt();
            ENUMPZBArt _wert = null;
            if (_pZBArt != null) {
                _wert = _pZBArt.getWert();
            }
            boolean bl = _tripleEquals = _wert == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
            if (_tripleEquals) {
                _or = true;
            } else {
                boolean _tripleEquals_1;
                PZB_Art_TypeClass _pZBArt_1 = pzb.getPZBArt();
                ENUMPZBArt _wert_1 = null;
                if (_pZBArt_1 != null) {
                    _wert_1 = _pZBArt_1.getWert();
                }
                _or = _tripleEquals_1 = _wert_1 == ENUMPZBArt.ENUMPZB_ART_1000_2000_HZ;
            }
            final boolean isPZB2000 = _or;
            Functions.Function1<PZB_Element, Boolean> _function_2 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    return isPZB2000;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_3 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Iterable _fstrDWegs = PZBElementExtensions.getFstrDWegs((PZB_Element)it);
                    Iterable _map = null;
                    if (_fstrDWegs != null) {
                        Functions.Function1<Fstr_DWeg, Markanter_Punkt> _function = new Functions.Function1<Fstr_DWeg, Markanter_Punkt>(){

                            public Markanter_Punkt apply(Fstr_DWeg it_1) {
                                return it_1.getIDPZBGefahrpunkt();
                            }
                        };
                        _map = IterableExtensions.map((Iterable)_fstrDWegs, (Functions.Function1)_function);
                    }
                    Iterable _filterNull = null;
                    if (_map != null) {
                        _filterNull = IterableExtensions.filterNull(_map);
                    }
                    Functions.Function1<Markanter_Punkt, String> _function_1 = new Functions.Function1<Markanter_Punkt, String>(){

                        public String apply(Markanter_Punkt it_1) {
                            Markanter_Punkt_Bezeichnung_AttributeGroup _bezeichnung = it_1.getBezeichnung();
                            Bezeichnung_Markanter_Punkt_TypeClass _bezeichnungMarkanterPunkt = null;
                            if (_bezeichnung != null) {
                                _bezeichnungMarkanterPunkt = _bezeichnung.getBezeichnungMarkanterPunkt();
                            }
                            String _wert = null;
                            if (_bezeichnungMarkanterPunkt != null) {
                                _wert = _bezeichnungMarkanterPunkt.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.map((Iterable)_filterNull, (Functions.Function1)_function_1);
                }
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "C"), pzb, (Functions.Function1)_function_2, (Functions.Function1)_function_3, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1<PZB_Element, Boolean> _function_4 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    return isPZB2000;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_5 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Iterable _fstrDWegs = PZBElementExtensions.getFstrDWegs((PZB_Element)it);
                    Iterable _filter = null;
                    if (_fstrDWegs != null) {
                        Functions.Function1<Fstr_DWeg, Boolean> _function = new Functions.Function1<Fstr_DWeg, Boolean>(){

                            public Boolean apply(Fstr_DWeg it_1) {
                                Markanter_Punkt _iDPZBGefahrpunkt = it_1.getIDPZBGefahrpunkt();
                                return _iDPZBGefahrpunkt != null;
                            }
                        };
                        _filter = IterableExtensions.filter((Iterable)_fstrDWegs, (Functions.Function1)_function);
                    }
                    Iterable _map = null;
                    if (_filter != null) {
                        Functions.Function1<Fstr_DWeg, String> _function_1 = new Functions.Function1<Fstr_DWeg, String>(){

                            public String apply(Fstr_DWeg it_1) {
                                int dwegV;
                                Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = it_1.getFstrDWegSpezifisch();
                                DWeg_V_TypeClass _dWegV = null;
                                if (_fstrDWegSpezifisch != null) {
                                    _dWegV = _fstrDWegSpezifisch.getDWegV();
                                }
                                BigInteger _wert = null;
                                if (_dWegV != null) {
                                    _wert = _dWegV.getWert();
                                }
                                if ((dwegV = BigIntegerExtensions.toInteger(_wert)) == 0) {
                                    return "";
                                }
                                if (dwegV > 60) {
                                    return "v > 60";
                                }
                                if (dwegV <= 60 && dwegV > 40) {
                                    return "40 < v \u2264 60";
                                }
                                if (dwegV <= 40) {
                                    return "v \u2264 40";
                                }
                                return "";
                            }
                        };
                        _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                    }
                    return _map;
                }
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "D"), pzb, (Functions.Function1)_function_4, (Functions.Function1)_function_5, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1<PZB_Element, Boolean> _function_6 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    return isPZB2000;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_7 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Iterable _fstrDWegs = PZBElementExtensions.getFstrDWegs((PZB_Element)it);
                    Iterable _filter = null;
                    if (_fstrDWegs != null) {
                        Functions.Function1<Fstr_DWeg, Boolean> _function = new Functions.Function1<Fstr_DWeg, Boolean>(){

                            public Boolean apply(Fstr_DWeg it_1) {
                                Markanter_Punkt _iDPZBGefahrpunkt = it_1.getIDPZBGefahrpunkt();
                                return _iDPZBGefahrpunkt != null;
                            }
                        };
                        _filter = IterableExtensions.filter((Iterable)_fstrDWegs, (Functions.Function1)_function);
                    }
                    Iterable _map = null;
                    if (_filter != null) {
                        Functions.Function1<Fstr_DWeg, String> _function_1 = new Functions.Function1<Fstr_DWeg, String>(){

                            public String apply(Fstr_DWeg it_1) {
                                Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = it_1.getFstrDWegSpezifisch();
                                DWeg_V_TypeClass _dWegV = null;
                                if (_fstrDWegSpezifisch != null) {
                                    _dWegV = _fstrDWegSpezifisch.getDWegV();
                                }
                                BigInteger _wert = null;
                                if (_dWegV != null) {
                                    _wert = _dWegV.getWert();
                                }
                                int dwegV = BigIntegerExtensions.toInteger(_wert);
                                Fstr_DWeg_Allg_AttributeGroup _fstrDWegAllg = it_1.getFstrDWegAllg();
                                Massgebende_Neigung_TypeClass _massgebendeNeigung = null;
                                if (_fstrDWegAllg != null) {
                                    _massgebendeNeigung = _fstrDWegAllg.getMassgebendeNeigung();
                                }
                                BigDecimal _wert_1 = null;
                                if (_massgebendeNeigung != null) {
                                    _wert_1 = _massgebendeNeigung.getWert();
                                }
                                double inclination = BigDecimalExtensions.toDouble(_wert_1);
                                double _xifexpression = 0.0;
                                _xifexpression = inclination < 0.0 ? 0.05 : 0.1;
                                double multipleValue = _xifexpression;
                                if (dwegV == 0) {
                                    return "";
                                }
                                if (dwegV > 60) {
                                    StringConcatenation _builder = new StringConcatenation();
                                    _builder.append((Object)(inclination * multipleValue * 200.0 + 450.0));
                                    return _builder.toString();
                                }
                                if (dwegV <= 60 && dwegV > 40) {
                                    StringConcatenation _builder_1 = new StringConcatenation();
                                    _builder_1.append((Object)(inclination * multipleValue * 100.0 + 350.0));
                                    return _builder_1.toString();
                                }
                                if (dwegV <= 40) {
                                    StringConcatenation _builder_2 = new StringConcatenation();
                                    _builder_2.append((Object)(inclination * multipleValue * 50.0 + 210.0));
                                    return _builder_2.toString();
                                }
                                return "";
                            }
                        };
                        _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                    }
                    return _map;
                }
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "E"), pzb, (Functions.Function1)_function_6, (Functions.Function1)_function_7, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1<PZB_Element, Boolean> _function_8 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    Functions.Function1<Fstr_DWeg, Markanter_Punkt> _function = new Functions.Function1<Fstr_DWeg, Markanter_Punkt>(){

                        public Markanter_Punkt apply(Fstr_DWeg it_1) {
                            return it_1.getIDPZBGefahrpunkt();
                        }
                    };
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.map((Iterable)PZBElementExtensions.getFstrDWegs((PZB_Element)it), (Functions.Function1)_function));
                    return !_isEmpty;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_9 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(final PZB_Element it) {
                    Functions.Function1<Signal, String> _function = new Functions.Function1<Signal, String>(){

                        public String apply(Signal signal) {
                            Functions.Function1<Fstr_DWeg, Basis_Objekt> _function = new Functions.Function1<Fstr_DWeg, Basis_Objekt>(){

                                public Basis_Objekt apply(Fstr_DWeg dweg) {
                                    Markanter_Punkt _iDPZBGefahrpunkt = null;
                                    if (dweg != null) {
                                        _iDPZBGefahrpunkt = dweg.getIDPZBGefahrpunkt();
                                    }
                                    Basis_Objekt _iDMarkanteStelle = null;
                                    if (_iDPZBGefahrpunkt != null) {
                                        _iDMarkanteStelle = _iDPZBGefahrpunkt.getIDMarkanteStelle();
                                    }
                                    return _iDMarkanteStelle;
                                }
                            };
                            Iterable markantePunkts = Iterables.filter((Iterable)IterableExtensions.map((Iterable)PZBElementExtensions.getFstrDWegs((PZB_Element)it), (Functions.Function1)_function), Punkt_Objekt.class);
                            return SskpTransformator.this.getDistanceOfPoinst(topGraph, markantePunkts, (Punkt_Objekt)signal);
                        }
                    };
                    return IterableExtensions.map((Iterable)Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it), Signal.class), (Functions.Function1)_function);
                }
            };
            this.fillIterableWithConditional(instance, this.getColumn(this.cols, "F"), pzb, (Functions.Function1)_function_8, (Functions.Function1)_function_9, null, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            Functions.Function1<PZB_Element, Iterable<String>> _function_10 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, String> _function = new Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, String>(){

                        public String apply(PZB_Element_Zuordnung_BP_AttributeGroup it_1) {
                            Wirksamkeit_TypeClass _wirksamkeit = it_1.getWirksamkeit();
                            ENUMWirksamkeit _wert = null;
                            if (_wirksamkeit != null) {
                                _wert = _wirksamkeit.getWert();
                            }
                            String _translate = null;
                            if (_wert != null) {
                                _translate = SskpTransformator.this.translate((Enumerator)_wert);
                            }
                            return _translate;
                        }
                    };
                    return IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)it), (Functions.Function1)_function);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "G"), pzb, (Functions.Function1)_function_10, null);
            Functions.Function1<BUE_Spezifisches_Signal, Boolean> _function_11 = new Functions.Function1<BUE_Spezifisches_Signal, Boolean>(){

                public Boolean apply(final BUE_Spezifisches_Signal it) {
                    Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                        public Boolean apply(Signal it_1) {
                            ENUMSignalFunktion _wert = it_1.getSignalReal().getSignalFunktion().getWert();
                            return _wert == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
                        }
                    };
                    Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

                        public Boolean apply(Signal signal) {
                            Signal _iDSignal = it.getIDSignal();
                            return signal == _iDSignal;
                        }
                    };
                    return IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)pzb), Signal.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
                }
            };
            final Iterable bueSpezifischeSignals = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)pzb).getBUESpezifischesSignal(), (Functions.Function1)_function_11);
            ColumnDescriptor _column = this.getColumn(this.cols, "H");
            Functions.Function1<PZB_Element, Boolean> _function_12 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    return !IterableExtensions.isEmpty((Iterable)IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)new Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, Fstr_Zug_Rangier>(){

                        public Fstr_Zug_Rangier apply(PZB_Element_Zuordnung_Fstr_AttributeGroup it_1) {
                            return it_1.getIDFstrZugRangier();
                        }
                    })) || it.getPZBElementGUE() != null && IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)new Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, Boolean>(){

                        public Boolean apply(PZB_Element_Zuordnung_Fstr_AttributeGroup it_1) {
                            Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
                            ENUMWirksamkeitFstr _wert = null;
                            if (_wirksamkeitFstr != null) {
                                _wert = _wirksamkeitFstr.getWert();
                            }
                            return _wert == ENUMWirksamkeitFstr.ENUM_WIRKSAMKEIT_FSTR_STAENDIG_WIRKSAM_WENN_FAHRSTRASSE_EINGESTELLT;
                        }
                    });
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_13 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, String> _function = new Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, String>(){

                        public String apply(PZB_Element_Zuordnung_Fstr_AttributeGroup it_1) {
                            Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
                            ENUMWirksamkeitFstr _wert = null;
                            if (_wirksamkeitFstr != null) {
                                _wert = _wirksamkeitFstr.getWert();
                            }
                            String _translate = null;
                            if (_wert != null) {
                                _translate = SskpTransformator.this.translate((Enumerator)_wert);
                            }
                            String wirksamKeit = _translate;
                            Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean> _function = new Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean>(){

                                public Boolean apply(Fstr_Zug_Art_TypeClass art) {
                                    return FstrZugRangierExtensions.isZ((Fstr_Zug_Art_TypeClass)art);
                                }
                            };
                            String fstrZugRangier = FstrZugRangierExtensions.getZugFstrBezeichnung((Fstr_Zug_Rangier)it_1.getIDFstrZugRangier(), (Functions.Function1)_function);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(wirksamKeit);
                            _builder.append(" ");
                            _builder.append(fstrZugRangier);
                            return _builder.toString();
                        }
                    };
                    return IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)_function);
                }
            };
            Case _case = new Case((Functions.Function1)_function_12, (Functions.Function1)_function_13, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, null);
            Functions.Function1<PZB_Element, Boolean> _function_14 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, Boolean> _function = new Functions.Function1<PZB_Element_Zuordnung_Fstr_AttributeGroup, Boolean>(){

                        public Boolean apply(PZB_Element_Zuordnung_Fstr_AttributeGroup it_1) {
                            Wirksamkeit_Fstr_TypeClass _wirksamkeitFstr = it_1.getWirksamkeitFstr();
                            ENUMWirksamkeitFstr _wert = null;
                            if (_wirksamkeitFstr != null) {
                                _wert = _wirksamkeitFstr.getWert();
                            }
                            return Objects.equal((Object)_wert, (Object)ENUMWirksamkeitFstr.ENUM_WIRKSAMKEIT_FSTR_SONSTIGE);
                        }
                    };
                    return IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungFstr((PZB_Element)it), (Functions.Function1)_function);
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_15 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<Bearbeitungsvermerk, String> _function = new Functions.Function1<Bearbeitungsvermerk, String>(){

                        public String apply(Bearbeitungsvermerk it_1) {
                            Bearbeitungsvermerk_Allg_AttributeGroup _bearbeitungsvermerkAllg = it_1.getBearbeitungsvermerkAllg();
                            Kurztext_TypeClass _kurztext = null;
                            if (_bearbeitungsvermerkAllg != null) {
                                _kurztext = _bearbeitungsvermerkAllg.getKurztext();
                            }
                            String _wert = null;
                            if (_kurztext != null) {
                                _wert = _kurztext.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.map((Iterable)BasisObjektExtensions.getBearbeitungsvermerk((Basis_Objekt)it.getIDPZBElementZuordnung()), (Functions.Function1)_function);
                }
            };
            Case _case_1 = new Case((Functions.Function1)_function_14, (Functions.Function1)_function_15, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<PZB_Element, Boolean> _function_16 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)bueSpezifischeSignals);
                    return !_isEmpty;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_17 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<BUE_Spezifisches_Signal, String> _function = new Functions.Function1<BUE_Spezifisches_Signal, String>(){

                        public String apply(BUE_Spezifisches_Signal it_1) {
                            BUE_Anlage _iDBUEAnlage = it_1.getIDBUEAnlage();
                            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                            if (_iDBUEAnlage != null) {
                                _bezeichnung = _iDBUEAnlage.getBezeichnung();
                            }
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.map((Iterable)bueSpezifischeSignals, (Functions.Function1)_function);
                }
            };
            Case _case_2 = new Case((Functions.Function1)_function_16, (Functions.Function1)_function_17, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            this.fillSwitch(instance, _column, pzb, new Case[]{_case, _case_1, _case_2});
            Functions.Function1<PZB_Element, Iterable<String>> _function_18 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Functions.Function1<Basis_Objekt, String> _function = new Functions.Function1<Basis_Objekt, String>(){

                        public String apply(Basis_Objekt it_1) {
                            return SskpTransformator.this.getDistanceSignalTrackSwtich(topGraph, pzb, it_1);
                        }
                    };
                    return ListExtensions.map((List)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it), (Functions.Function1)_function);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "I"), pzb, (Functions.Function1)_function_18, null);
            ColumnDescriptor _column_1 = this.getColumn(this.cols, "J");
            Functions.Function1<PZB_Element, Boolean> _function_19 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    PZB_Art_TypeClass _pZBArt = it.getPZBArt();
                    ENUMPZBArt _wert = null;
                    if (_pZBArt != null) {
                        _wert = _pZBArt.getWert();
                    }
                    return _wert == ENUMPZBArt.ENUMPZB_ART_500_HZ;
                }
            };
            Functions.Function1<PZB_Element, String> _function_20 = new Functions.Function1<PZB_Element, String>(){

                public String apply(PZB_Element it) {
                    return "";
                }
            };
            Case _case_3 = new Case((Functions.Function1)_function_19, (Functions.Function1)_function_20);
            Functions.Function1<PZB_Element, Boolean> _function_21 = new Functions.Function1<PZB_Element, Boolean>(){

                public Boolean apply(PZB_Element it) {
                    PZB_Art_TypeClass _pZBArt = it.getPZBArt();
                    ENUMPZBArt _wert = null;
                    if (_pZBArt != null) {
                        _wert = _pZBArt.getWert();
                    }
                    return _wert == ENUMPZBArt.ENUMPZB_ART_1000_HZ;
                }
            };
            Functions.Function1<PZB_Element, Iterable<String>> _function_22 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                public Iterable<String> apply(PZB_Element it) {
                    Iterable bezugspunktSignals = Iterables.filter((Iterable)PZBElementExtensions.getPZBElementBezugspunkt((PZB_Element)it), Signal.class);
                    Functions.Function1<PZB_Zuordnung_Signal, Signal> _function = new Functions.Function1<PZB_Zuordnung_Signal, Signal>(){

                        public Signal apply(PZB_Zuordnung_Signal it_1) {
                            return it_1.getIDSignal();
                        }
                    };
                    final Iterable pzbZuordnungSignals = IterableExtensions.map((Iterable)PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it), (Functions.Function1)_function);
                    Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

                        public Boolean apply(Signal it_1) {
                            return IterableExtensions.contains((Iterable)pzbZuordnungSignals, (Object)it_1);
                        }
                    };
                    Functions.Function1<Signal, Long> _function_2 = new Functions.Function1<Signal, Long>(){

                        public Long apply(Signal it_1) {
                            return AgateRounding.roundDown((double)((Double)IterableExtensions.min(SskpTransformator.this.getPointsDistance(topGraph, (Punkt_Objekt)pzb, (Punkt_Objekt)it_1))));
                        }
                    };
                    Functions.Function1<Long, Boolean> _function_3 = new Functions.Function1<Long, Boolean>(){

                        public Boolean apply(Long it_1) {
                            return it_1 != 0L;
                        }
                    };
                    Iterable distance = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)bezugspunktSignals, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                    Functions.Function1<Long, String> _function_4 = new Functions.Function1<Long, String>(){

                        public String apply(Long it_1) {
                            return it_1.toString();
                        }
                    };
                    return IterableExtensions.map((Iterable)distance, (Functions.Function1)_function_4);
                }
            };
            Case _case_4 = new Case((Functions.Function1)_function_21, (Functions.Function1)_function_22, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, (Comparator)ToolboxConstants.NUMERIC_COMPARATOR);
            this.fillSwitch(instance, _column_1, pzb, new Case[]{_case_3, _case_4});
            boolean _and = false;
            Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, Boolean> _function_23 = new Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, Boolean>(){

                public Boolean apply(PZB_Element_Zuordnung_BP_AttributeGroup it) {
                    PZB_Element_Zuordnung_INA_AttributeGroup _pZBElementZuordnungINA = it.getPZBElementZuordnungINA();
                    return _pZBElementZuordnungINA != null;
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb), (Functions.Function1)_function_23);
            if (!_exists) {
                _and = false;
            } else {
                boolean _tripleEquals_2;
                boolean _or_1 = false;
                PZB_Art_TypeClass _pZBArt_2 = pzb.getPZBArt();
                ENUMPZBArt _wert_2 = null;
                if (_pZBArt_2 != null) {
                    _wert_2 = _pZBArt_2.getWert();
                }
                boolean bl2 = _tripleEquals_2 = _wert_2 == ENUMPZBArt.ENUMPZB_ART_2000_HZ;
                if (_tripleEquals_2) {
                    _or_1 = true;
                } else {
                    boolean _tripleEquals_3;
                    PZB_Art_TypeClass _pZBArt_3 = pzb.getPZBArt();
                    ENUMPZBArt _wert_3 = null;
                    if (_pZBArt_3 != null) {
                        _wert_3 = _pZBArt_3.getWert();
                    }
                    _or_1 = _tripleEquals_3 = _wert_3 == ENUMPZBArt.ENUMPZB_ART_1000_2000_HZ;
                }
                _and = _or_1;
            }
            if (_and) {
                Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, EList<INA_Gefahrstelle_AttributeGroup>> _function_24 = new Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, EList<INA_Gefahrstelle_AttributeGroup>>(){

                    public EList<INA_Gefahrstelle_AttributeGroup> apply(PZB_Element_Zuordnung_BP_AttributeGroup it) {
                        return it.getINAGefahrstelle();
                    }
                };
                final Iterable inaGefahrstelles = Iterables.concat((Iterable)IterableExtensions.map((Iterable)PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb), (Functions.Function1)_function_24));
                final boolean isGefahrstelle = IterableExtensions.exists((Iterable)inaGefahrstelles, (Functions.Function1)new Functions.Function1<INA_Gefahrstelle_AttributeGroup, Boolean>(){

                    public Boolean apply(INA_Gefahrstelle_AttributeGroup it) {
                        int _intValue;
                        Prioritaet_Gefahrstelle_TypeClass _prioritaetGefahrstelle = it.getPrioritaetGefahrstelle();
                        BigInteger _wert = null;
                        if (_prioritaetGefahrstelle != null) {
                            _wert = _prioritaetGefahrstelle.getWert();
                        }
                        return (_intValue = _wert.intValue()) == 1;
                    }
                }) && !IterableExtensions.isEmpty((Iterable)IterableExtensions.map((Iterable)inaGefahrstelles, (Functions.Function1)new Functions.Function1<INA_Gefahrstelle_AttributeGroup, Markanter_Punkt>(){

                    public Markanter_Punkt apply(INA_Gefahrstelle_AttributeGroup it) {
                        return it.getIDMarkanterPunkt();
                    }
                }));
                Functions.Function1<PZB_Element, Boolean> _function_25 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        return isGefahrstelle;
                    }
                };
                Functions.Function1<PZB_Element, Iterable<String>> _function_26 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                    public Iterable<String> apply(PZB_Element it) {
                        Functions.Function1<INA_Gefahrstelle_AttributeGroup, String> _function = new Functions.Function1<INA_Gefahrstelle_AttributeGroup, String>(){

                            public String apply(INA_Gefahrstelle_AttributeGroup it_1) {
                                Markanter_Punkt _iDMarkanterPunkt = it_1.getIDMarkanterPunkt();
                                Markanter_Punkt_Bezeichnung_AttributeGroup _bezeichnung = null;
                                if (_iDMarkanterPunkt != null) {
                                    _bezeichnung = _iDMarkanterPunkt.getBezeichnung();
                                }
                                Bezeichnung_Markanter_Punkt_TypeClass _bezeichnungMarkanterPunkt = null;
                                if (_bezeichnung != null) {
                                    _bezeichnungMarkanterPunkt = _bezeichnung.getBezeichnungMarkanterPunkt();
                                }
                                String _wert = null;
                                if (_bezeichnungMarkanterPunkt != null) {
                                    _wert = _bezeichnungMarkanterPunkt.getWert();
                                }
                                return _wert;
                            }
                        };
                        return IterableExtensions.map((Iterable)inaGefahrstelles, (Functions.Function1)_function);
                    }
                };
                this.fillIterableWithConditional(instance, this.getColumn(this.cols, "K"), pzb, (Functions.Function1)_function_25, (Functions.Function1)_function_26, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
                Functions.Function1<PZB_Element, Boolean> _function_27 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        return isGefahrstelle;
                    }
                };
                Functions.Function1<PZB_Element, String> _function_28 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        Functions.Function1<INA_Gefahrstelle_AttributeGroup, Basis_Objekt> _function = new Functions.Function1<INA_Gefahrstelle_AttributeGroup, Basis_Objekt>(){

                            public Basis_Objekt apply(INA_Gefahrstelle_AttributeGroup it_1) {
                                Markanter_Punkt _iDMarkanterPunkt = it_1.getIDMarkanterPunkt();
                                Basis_Objekt _iDMarkanteStelle = null;
                                if (_iDMarkanterPunkt != null) {
                                    _iDMarkanteStelle = _iDMarkanterPunkt.getIDMarkanteStelle();
                                }
                                return _iDMarkanteStelle;
                            }
                        };
                        Iterable markanteStelle = Iterables.filter((Iterable)IterableExtensions.map((Iterable)inaGefahrstelles, (Functions.Function1)_function), Punkt_Objekt.class);
                        return SskpTransformator.this.getDistanceOfPoinst(topGraph, markanteStelle, (Punkt_Objekt)it);
                    }
                };
                this.fillConditional(instance, this.getColumn(this.cols, "L"), pzb, (Functions.Function1)_function_27, (Functions.Function1)_function_28);
                Iterable _pZBElementZuordnungBP = null;
                if (pzb != null) {
                    _pZBElementZuordnungBP = PZBElementExtensions.getPZBElementZuordnungBP((PZB_Element)pzb);
                }
                Iterable _map = null;
                if (_pZBElementZuordnungBP != null) {
                    Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, PZB_Element_Zuordnung_INA_AttributeGroup> _function_29 = new Functions.Function1<PZB_Element_Zuordnung_BP_AttributeGroup, PZB_Element_Zuordnung_INA_AttributeGroup>(){

                        public PZB_Element_Zuordnung_INA_AttributeGroup apply(PZB_Element_Zuordnung_BP_AttributeGroup it) {
                            return it.getPZBElementZuordnungINA();
                        }
                    };
                    _map = IterableExtensions.map((Iterable)_pZBElementZuordnungBP, (Functions.Function1)_function_29);
                }
                Iterable _map_1 = null;
                if (_map != null) {
                    Functions.Function1<PZB_Element_Zuordnung_INA_AttributeGroup, Bahnsteig_Kante> _function_30 = new Functions.Function1<PZB_Element_Zuordnung_INA_AttributeGroup, Bahnsteig_Kante>(){

                        public Bahnsteig_Kante apply(PZB_Element_Zuordnung_INA_AttributeGroup it) {
                            return it.getIDBahnsteigKante();
                        }
                    };
                    _map_1 = IterableExtensions.map((Iterable)_map, (Functions.Function1)_function_30);
                }
                final Iterable bahnSteigKantes = _map_1;
                Functions.Function1<Bahnsteig_Kante, Iterable<Double>> _function_31 = new Functions.Function1<Bahnsteig_Kante, Iterable<Double>>(){

                    public Iterable<Double> apply(Bahnsteig_Kante it) {
                        return SskpTransformator.this.getBahnsteigAbstand(pzb, it);
                    }
                };
                final Iterable bahnSteigAbstand = Iterables.concat((Iterable)IterableExtensions.map((Iterable)bahnSteigKantes, (Functions.Function1)_function_31));
                Functions.Function1<PZB_Element, Boolean> _function_32 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)bahnSteigKantes);
                        return !_isEmpty;
                    }
                };
                Functions.Function1<PZB_Element, String> _function_33 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        return DoubleExtensions.toTableInteger((Double)((Double)IterableExtensions.max((Iterable)bahnSteigAbstand)));
                    }
                };
                this.fillConditional(instance, this.getColumn(this.cols, "M"), pzb, (Functions.Function1)_function_32, (Functions.Function1)_function_33);
                Functions.Function1<PZB_Element, Boolean> _function_34 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)bahnSteigKantes);
                        return !_isEmpty;
                    }
                };
                Functions.Function1<PZB_Element, String> _function_35 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        return DoubleExtensions.toTableInteger((Double)((Double)IterableExtensions.min((Iterable)bahnSteigAbstand)));
                    }
                };
                this.fillConditional(instance, this.getColumn(this.cols, "N"), pzb, (Functions.Function1)_function_34, (Functions.Function1)_function_35);
                Functions.Function1<PZB_Element, Boolean> _function_36 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                        Iterable _map = null;
                        if (_pZBZuordnungSignal != null) {
                            Functions.Function1<PZB_Zuordnung_Signal, List<Signal_Rahmen>> _function = new Functions.Function1<PZB_Zuordnung_Signal, List<Signal_Rahmen>>(){

                                public List<Signal_Rahmen> apply(PZB_Zuordnung_Signal it_1) {
                                    Signal _iDSignal = it_1.getIDSignal();
                                    List _signalRahmen = null;
                                    if (_iDSignal != null) {
                                        _signalRahmen = SignalExtensions.signalRahmen((Signal)_iDSignal);
                                    }
                                    return _signalRahmen;
                                }
                            };
                            _map = IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function);
                        }
                        Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>> _function_1 = new Functions.Function1<Signal_Rahmen, List<Signal_Signalbegriff>>(){

                            public List<Signal_Signalbegriff> apply(Signal_Rahmen it_1) {
                                return SignalRahmenExtensions.getSignalbegriffe((Signal_Rahmen)it_1);
                            }
                        };
                        Functions.Function1<Signal_Signalbegriff, Boolean> _function_2 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                            public Boolean apply(Signal_Signalbegriff it_1) {
                                return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Ne5.class);
                            }
                        };
                        return IterableExtensions.exists((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)_map), (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
                    }
                };
                Functions.Function1<PZB_Element, Iterable<String>> _function_37 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                    public Iterable<String> apply(PZB_Element it) {
                        Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                        Iterable _map = null;
                        if (_pZBZuordnungSignal != null) {
                            Functions.Function1<PZB_Zuordnung_Signal, Signal> _function = new Functions.Function1<PZB_Zuordnung_Signal, Signal>(){

                                public Signal apply(PZB_Zuordnung_Signal it_1) {
                                    return it_1.getIDSignal();
                                }
                            };
                            _map = IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function);
                        }
                        Functions.Function1<Signal, Double> _function_1 = new Functions.Function1<Signal, Double>(){

                            public Double apply(Signal signal) {
                                return (Double)IterableExtensions.min(SskpTransformator.this.getPointsDistance(topGraph, (Punkt_Objekt)pzb, (Punkt_Objekt)signal));
                            }
                        };
                        Functions.Function1<Double, Boolean> _function_2 = new Functions.Function1<Double, Boolean>(){

                            public Boolean apply(Double it_1) {
                                double _doubleValue = it_1;
                                return _doubleValue == 0.0;
                            }
                        };
                        Functions.Function1<Double, String> _function_3 = new Functions.Function1<Double, String>(){

                            public String apply(Double it_1) {
                                return Long.valueOf(AgateRounding.roundDown((double)it_1)).toString();
                            }
                        };
                        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)_map, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                    }
                };
                this.fillIterableWithConditional(instance, this.getColumn(this.cols, "O"), pzb, (Functions.Function1)_function_36, (Functions.Function1)_function_37, (Comparator)ToolboxConstants.NUMERIC_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
                Functions.Function1<PZB_Element, Boolean> _function_38 = new Functions.Function1<PZB_Element, Boolean>(){

                    public Boolean apply(PZB_Element it) {
                        Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                        Iterable _map = null;
                        if (_pZBZuordnungSignal != null) {
                            Functions.Function1<PZB_Zuordnung_Signal, Signal> _function = new Functions.Function1<PZB_Zuordnung_Signal, Signal>(){

                                public Signal apply(PZB_Zuordnung_Signal it_1) {
                                    return it_1.getIDSignal();
                                }
                            };
                            _map = IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function);
                        }
                        Functions.Function1<Signal, Boolean> _function_1 = new Functions.Function1<Signal, Boolean>(){

                            public Boolean apply(Signal it_1) {
                                Signal_Real_AttributeGroup _signalReal = it_1.getSignalReal();
                                Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
                                if (_signalReal != null) {
                                    _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
                                }
                                Signal_Art_TypeClass _signalArt = null;
                                if (_signalRealAktivSchirm != null) {
                                    _signalArt = _signalRealAktivSchirm.getSignalArt();
                                }
                                ENUMSignalArt _wert = null;
                                if (_signalArt != null) {
                                    _wert = _signalArt.getWert();
                                }
                                return _wert == ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNALWIEDERHOLER;
                            }
                        };
                        return IterableExtensions.exists(_map, (Functions.Function1)_function_1);
                    }
                };
                Functions.Function1<PZB_Element, Iterable<String>> _function_39 = new Functions.Function1<PZB_Element, Iterable<String>>(){

                    public Iterable<String> apply(PZB_Element it) {
                        Iterable _pZBZuordnungSignal = PZBElementExtensions.getPZBZuordnungSignal((PZB_Element)it);
                        Iterable _map = null;
                        if (_pZBZuordnungSignal != null) {
                            Functions.Function1<PZB_Zuordnung_Signal, Signal> _function = new Functions.Function1<PZB_Zuordnung_Signal, Signal>(){

                                public Signal apply(PZB_Zuordnung_Signal it_1) {
                                    return it_1.getIDSignal();
                                }
                            };
                            _map = IterableExtensions.map((Iterable)_pZBZuordnungSignal, (Functions.Function1)_function);
                        }
                        Functions.Function1<Signal, Double> _function_1 = new Functions.Function1<Signal, Double>(){

                            public Double apply(Signal signal) {
                                return (Double)IterableExtensions.min(SskpTransformator.this.getPointsDistance(topGraph, (Punkt_Objekt)pzb, (Punkt_Objekt)signal));
                            }
                        };
                        Functions.Function1<Double, Boolean> _function_2 = new Functions.Function1<Double, Boolean>(){

                            public Boolean apply(Double it_1) {
                                double _doubleValue = it_1;
                                return _doubleValue == 0.0;
                            }
                        };
                        Functions.Function1<Double, String> _function_3 = new Functions.Function1<Double, String>(){

                            public String apply(Double it_1) {
                                return Long.valueOf(AgateRounding.roundDown((double)it_1)).toString();
                            }
                        };
                        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)_map, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                    }
                };
                this.fillIterableWithConditional(instance, this.getColumn(this.cols, "P"), pzb, (Functions.Function1)_function_38, (Functions.Function1)_function_39, (Comparator)ToolboxConstants.NUMERIC_COMPARATOR, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
                Functions.Function1<PZB_Element, String> _function_40 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        return "";
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "Q"), pzb, (Functions.Function1)_function_40);
            } else {
                int i = 9;
                while (i < 15) {
                    this.fillBlank(instance, i);
                    ++i;
                }
            }
            PZB_Element_GUE_AttributeGroup _pZBElementGUE = pzb.getPZBElementGUE();
            boolean bl3 = _tripleNotEquals = _pZBElementGUE != null;
            if (_tripleNotEquals) {
                Functions.Function1<PZB_Element, String> _function_41 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        Pruefgeschwindigkeit_TypeClass _pruefgeschwindigkeit = it.getPZBElementGUE().getPruefgeschwindigkeit();
                        BigInteger _wert = null;
                        if (_pruefgeschwindigkeit != null) {
                            _wert = _pruefgeschwindigkeit.getWert();
                        }
                        return Integer.valueOf(_wert.intValue()).toString();
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "R"), pzb, (Functions.Function1)_function_41);
                Functions.Function1<PZB_Element, String> _function_42 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        Pruefzeit_TypeClass _pruefzeit = it.getPZBElementGUE().getPruefzeit();
                        BigDecimal _wert = null;
                        if (_pruefzeit != null) {
                            _wert = _pruefzeit.getWert();
                        }
                        return BigDecimalExtensions.toTableInteger(_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "S"), pzb, (Functions.Function1)_function_42);
                Functions.Function1<PZB_Element, String> _function_43 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        Messfehler_TypeClass _messfehler = it.getPZBElementGUE().getMessfehler();
                        ENUMMessfehler _wert = null;
                        if (_messfehler != null) {
                            _wert = _messfehler.getWert();
                        }
                        return SskpTransformator.this.translate((Enumerator)_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "T"), pzb, (Functions.Function1)_function_43);
                Functions.Function1<PZB_Element, String> _function_44 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        GUE_Anordnung_TypeClass _gUEAnordnung = it.getPZBElementGUE().getGUEAnordnung();
                        ENUMGUEAnordnung _wert = null;
                        if (_gUEAnordnung != null) {
                            _wert = _gUEAnordnung.getWert();
                        }
                        return SskpTransformator.this.translate((Enumerator)_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "U"), pzb, (Functions.Function1)_function_44);
                Functions.Function1<PZB_Element, String> _function_45 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        GUE_Bauart_TypeClass _gUEBauart = it.getPZBElementGUE().getGUEBauart();
                        ENUMGUEBauart _wert = null;
                        if (_gUEBauart != null) {
                            _wert = _gUEBauart.getWert();
                        }
                        return SskpTransformator.this.translate((Enumerator)_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "V"), pzb, (Functions.Function1)_function_45);
                Functions.Function1<PZB_Element, String> _function_46 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        return "";
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "W"), pzb, (Functions.Function1)_function_46);
                Functions.Function1<PZB_Element, String> _function_47 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        Unterbringung _iDUnterbringung = it.getIDUnterbringung();
                        Unterbringung_Allg_AttributeGroup _unterbringungAllg = null;
                        if (_iDUnterbringung != null) {
                            _unterbringungAllg = _iDUnterbringung.getUnterbringungAllg();
                        }
                        Unterbringung_Befestigung_TypeClass _unterbringungBefestigung = null;
                        if (_unterbringungAllg != null) {
                            _unterbringungBefestigung = _unterbringungAllg.getUnterbringungBefestigung();
                        }
                        ENUMUnterbringungBefestigung _wert = null;
                        if (_unterbringungBefestigung != null) {
                            _wert = _unterbringungBefestigung.getWert();
                        }
                        return SskpTransformator.this.translate((Enumerator)_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "X"), pzb, (Functions.Function1)_function_47);
                Functions.Function1<PZB_Element, String> _function_48 = new Functions.Function1<PZB_Element, String>(){

                    public String apply(PZB_Element it) {
                        GUE_Energieversorgung_TypeClass _gUEEnergieversorgung = it.getPZBElementGUE().getGUEEnergieversorgung();
                        ENUMGUEEnergieversorgung _wert = null;
                        if (_gUEEnergieversorgung != null) {
                            _wert = _gUEEnergieversorgung.getWert();
                        }
                        return SskpTransformator.this.translate((Enumerator)_wert);
                    }
                };
                this.fill(instance, this.getColumn(this.cols, "Y"), pzb, (Functions.Function1)_function_48);
            } else {
                int i = 15;
                while (i < 23) {
                    this.fillBlank(instance, i);
                    ++i;
                }
            }
            Functions.Function1<PZB_Element, String> _function_49 = new Functions.Function1<PZB_Element, String>(){

                public String apply(PZB_Element it) {
                    return null;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "Z"), pzb, (Functions.Function1)_function_49);
        }
        return factory.getTable();
    }

    private String _fillBezugsElement(Basis_Objekt object) {
        String _simpleName = object.getClass().getSimpleName();
        throw new IllegalArgumentException(_simpleName);
    }

    private String _fillBezugsElement(W_Kr_Gsp_Element object) {
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (object != null) {
            _bezeichnung = object.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        return _wert;
    }

    private String _fillBezugsElement(Signal object) {
        boolean _tripleEquals;
        String _xifexpression = null;
        ENUMSignalFunktion _wert = object.getSignalReal().getSignalFunktion().getWert();
        boolean bl = _tripleEquals = _wert == ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("B\u00dc-K ");
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (object != null) {
                _bezeichnung = object.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
            if (_bezeichnung != null) {
                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            }
            String _wert_1 = null;
            if (_bezeichnungTabelle != null) {
                _wert_1 = _bezeichnungTabelle.getWert();
            }
            _builder.append(_wert_1);
            _xifexpression = _builder.toString();
        } else {
            Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
            if (object != null) {
                _bezeichnung_1 = object.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
            if (_bezeichnung_1 != null) {
                _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
            }
            String _wert_2 = null;
            if (_bezeichnungTabelle_1 != null) {
                _wert_2 = _bezeichnungTabelle_1.getWert();
            }
            _xifexpression = _wert_2;
        }
        return _xifexpression;
    }

    private String _getDistanceSignalTrackSwtich(TopGraph topGraph, PZB_Element pzb, Basis_Objekt object) {
        String _simpleName = object.getClass().getSimpleName();
        throw new IllegalArgumentException(_simpleName);
    }

    private String _getDistanceSignalTrackSwtich(TopGraph topGraph, PZB_Element pzb, final Signal signal) {
        boolean _tripleNotEquals;
        Signal_Real_AttributeGroup _signalReal = null;
        if (signal != null) {
            _signalReal = signal.getSignalReal();
        }
        Signal_Funktion_TypeClass _signalFunktion = null;
        if (_signalReal != null) {
            _signalFunktion = _signalReal.getSignalFunktion();
        }
        ENUMSignalFunktion _wert = null;
        if (_signalFunktion != null) {
            _wert = _signalFunktion.getWert();
        }
        boolean bl = _tripleNotEquals = _wert != ENUMSignalFunktion.ENUM_SIGNAL_FUNKTION_BUE_UEBERWACHUNGSSIGNAL;
        if (_tripleNotEquals) {
            long distance = AgateRounding.roundDown((double)((Double)IterableExtensions.min(this.getPointsDistance(topGraph, (Punkt_Objekt)pzb, (Punkt_Objekt)signal))));
            String _xifexpression = null;
            boolean _isInWirkrichtungOfSignal = SignalExtensions.isInWirkrichtungOfSignal((TopGraph)topGraph, (Signal)signal, (Punkt_Objekt)pzb);
            _xifexpression = _isInWirkrichtungOfSignal ? "+" : "-";
            String directionSign = _xifexpression;
            String _xifexpression_1 = null;
            if (distance > 0L) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(directionSign);
                String _string = Long.valueOf(distance).toString();
                _builder.append(_string);
                _xifexpression_1 = _builder.toString();
            } else {
                _xifexpression_1 = "";
            }
            return _xifexpression_1;
        }
        Functions.Function1<BUE_Spezifisches_Signal, Boolean> _function = new Functions.Function1<BUE_Spezifisches_Signal, Boolean>(){

            public Boolean apply(BUE_Spezifisches_Signal it) {
                Signal _iDSignal = it.getIDSignal();
                return _iDSignal == signal;
            }
        };
        final Iterable bueSpezifischesSignal = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getBUESpezifischesSignal(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)bueSpezifischesSignal);
        if (_isEmpty) {
            return "";
        }
        Functions.Function1<BUE_Kante, Boolean> _function_1 = new Functions.Function1<BUE_Kante, Boolean>(){

            public Boolean apply(final BUE_Kante kante) {
                Functions.Function1<BUE_Spezifisches_Signal, BUE_Anlage> _function = new Functions.Function1<BUE_Spezifisches_Signal, BUE_Anlage>(){

                    public BUE_Anlage apply(BUE_Spezifisches_Signal it) {
                        return it.getIDBUEAnlage();
                    }
                };
                Functions.Function1<BUE_Anlage, Boolean> _function_1 = new Functions.Function1<BUE_Anlage, Boolean>(){

                    public Boolean apply(BUE_Anlage it) {
                        BUE_Anlage _iDBUEAnlage = kante.getIDBUEAnlage();
                        return it == _iDBUEAnlage;
                    }
                };
                return IterableExtensions.exists((Iterable)IterableExtensions.map((Iterable)bueSpezifischesSignal, (Functions.Function1)_function), (Functions.Function1)_function_1);
            }
        };
        Iterable bueKantens = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signal).getBUEKante(), (Functions.Function1)_function_1);
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)bueKantens);
        if (_isEmpty_1) {
            return "";
        }
        return this.getDistanceOfPoinst(topGraph, bueKantens, (Punkt_Objekt)pzb);
    }

    private String _getDistanceSignalTrackSwtich(TopGraph topGraph, PZB_Element pzb, W_Kr_Gsp_Element gspElement) {
        Functions.Function1<W_Kr_Gsp_Komponente, Boolean> _function = new Functions.Function1<W_Kr_Gsp_Komponente, Boolean>(){

            public Boolean apply(W_Kr_Gsp_Komponente it) {
                Zungenpaar_AttributeGroup _zungenpaar = it.getZungenpaar();
                return _zungenpaar != null;
            }
        };
        Iterable gspKomponent = IterableExtensions.filter((Iterable)WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)gspElement), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)gspKomponent);
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
            if (gspElement != null) {
                _bezeichnung = gspElement.getBezeichnung();
            }
            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
            String _wert = null;
            if (_bezeichnungTabelle != null) {
                _wert = _bezeichnungTabelle.getWert();
            }
            _builder.append(_wert);
            _builder.append(" hast no Zungenpaar");
            throw new IllegalArgumentException(_builder.toString());
        }
        return this.getDistanceOfPoinst(topGraph, gspKomponent, (Punkt_Objekt)pzb);
    }

    private String getDistanceOfPoinst(final TopGraph topGraph, Iterable<? extends Punkt_Objekt> p1s, final Punkt_Objekt p2) {
        Double distance;
        double _doubleValue;
        boolean _tripleEquals;
        Double _fold = null;
        if (p1s != null) {
            Functions.Function2<Double, Punkt_Objekt, Double> _function = new Functions.Function2<Double, Punkt_Objekt, Double>(){

                public Double apply(Double current, Punkt_Objekt p1) {
                    return Math.min(current, (Double)IterableExtensions.min(SskpTransformator.this.getPointsDistance(topGraph, p1, p2)));
                }
            };
            _fold = (Double)IterableExtensions.fold(p1s, (Object)Double.MAX_VALUE, (Functions.Function2)_function);
        }
        boolean bl = _tripleEquals = (_doubleValue = (distance = _fold).doubleValue()) == 0.0;
        if (_tripleEquals) {
            return "";
        }
        return Long.valueOf(AgateRounding.roundDown((double)distance)).toString();
    }

    private Iterable<Double> getPointsDistance(TopGraph topGraph, Punkt_Objekt p1, Punkt_Objekt p2) {
        Set distances = Digraphs.getPaths((Digraph)topGraph, (Collection)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p1), (Collection)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)p2));
        Iterable<Double> _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)distances);
        if (_isNullOrEmpty) {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        } else {
            Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

                public Double apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                    return it.getLength();
                }
            };
            _xifexpression = IterableExtensions.map((Iterable)distances, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    private Iterable<Double> getBahnsteigAbstand(final PZB_Element pzb, Bahnsteig_Kante bahnsteigKaten) {
        Functions.Function1<TOP_Kante, List<Double>> _function = new Functions.Function1<TOP_Kante, List<Double>>(){

            public List<Double> apply(TOP_Kante it) {
                double _abstandDispatch = TopKanteExtensions.getAbstandDispatch((TOP_Kante)it, (Basis_Objekt)pzb, (Basis_Objekt)TopKanteExtensions.getTOPKnotenA((TOP_Kante)it));
                double _abstandDispatch_1 = TopKanteExtensions.getAbstandDispatch((TOP_Kante)it, (Basis_Objekt)pzb, (Basis_Objekt)TopKanteExtensions.getTOPKnotenB((TOP_Kante)it));
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Double[]{_abstandDispatch, _abstandDispatch_1}));
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map((Iterable)BereichObjektExtensions.getTopKanten((Bereich_Objekt)bahnsteigKaten), (Functions.Function1)_function));
    }

    private String fillBezugsElement(Basis_Objekt object) {
        if (object instanceof Signal) {
            return this._fillBezugsElement((Signal)object);
        }
        if (object instanceof W_Kr_Gsp_Element) {
            return this._fillBezugsElement((W_Kr_Gsp_Element)object);
        }
        if (object != null) {
            return this._fillBezugsElement(object);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object).toString());
    }

    private String getDistanceSignalTrackSwtich(TopGraph topGraph, PZB_Element pzb, Basis_Objekt signal) {
        if (signal instanceof Signal) {
            return this._getDistanceSignalTrackSwtich(topGraph, pzb, (Signal)signal);
        }
        if (signal instanceof W_Kr_Gsp_Element) {
            return this._getDistanceSignalTrackSwtich(topGraph, pzb, (W_Kr_Gsp_Element)signal);
        }
        if (signal != null) {
            return this._getDistanceSignalTrackSwtich(topGraph, pzb, signal);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(topGraph, pzb, signal).toString());
    }
}

