/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.TablemodelPackage;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.tablemodel.extensions.internal.TableToFootnoteText;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TableExtensions {
    public static Table create(String root, String ... columnLabels) {
        Table newTable = TablemodelFactory.eINSTANCE.createTable();
        TableContent newTableContent = TablemodelFactory.eINSTANCE.createTableContent();
        newTable.setTablecontent(newTableContent);
        final ColumnDescriptor rootDescriptor = TableExtensions.toDescriptor(root, null);
        newTable.getColumndescriptors().add((Object)rootDescriptor);
        Functions.Function1<String, ColumnDescriptor> _function = new Functions.Function1<String, ColumnDescriptor>(){

            public ColumnDescriptor apply(String it) {
                return TableExtensions.toDescriptor(it, rootDescriptor);
            }
        };
        newTable.getColumndescriptors().addAll((Collection)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)columnLabels)), (Functions.Function1)_function));
        return newTable;
    }

    private static ColumnDescriptor toDescriptor(String columnLabel, ColumnDescriptor parent) {
        ColumnDescriptor descriptor = TablemodelFactory.eINSTANCE.createColumnDescriptor();
        descriptor.setLabel(columnLabel);
        descriptor.setParent(parent);
        return descriptor;
    }

    public static List<ColumnDescriptor> getColumns(Table table) {
        EList descriptors = table.getColumndescriptors();
        boolean _isEmpty = descriptors.isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.newLinkedList();
        }
        return (List)Conversions.doWrapArray((Object)ColumnDescriptorExtensions.getColumns((ColumnDescriptor)descriptors.get(0)));
    }

    public static List<TableRow> getTableRows(Table table) {
        TableContent content = table.getTablecontent();
        LinkedList rows = CollectionLiterals.newLinkedList();
        EList _rowgroups = content.getRowgroups();
        for (RowGroup rowgroup : _rowgroups) {
            rows.addAll(rowgroup.getRows());
        }
        return rows;
    }

    public static int getPropertyCount(Table table) {
        return TableExtensions.getColumns(table).size();
    }

    public static ColumnDescriptor getRootDescriptor(Table table) {
        boolean _isEmpty = table.getColumndescriptors().isEmpty();
        if (_isEmpty) {
            return null;
        }
        return ColumnDescriptorExtensions.getRoot((ColumnDescriptor)table.getColumndescriptors().get(0));
    }

    public static TableRow addRow(Ur_Objekt leadingObject, Table table, String ... values) {
        return TableExtensions.addRow(leadingObject, 0, table, values);
    }

    public static TableRow addRow(Ur_Objekt leadingObject, int leadingObjectIndex, Table table, String ... values) {
        RowGroup newRowGroup = TablemodelFactory.eINSTANCE.createRowGroup();
        final TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
        newRowGroup.getRows().add((Object)newRow);
        newRowGroup.setLeadingObject(leadingObject);
        newRowGroup.setLeadingObjectIndex(leadingObjectIndex);
        table.getTablecontent().getRowgroups().add((Object)newRowGroup);
        Consumer<ColumnDescriptor> _function = new Consumer<ColumnDescriptor>(){

            @Override
            public void accept(ColumnDescriptor it) {
                newRow.getCells().add((Object)ColumnDescriptorExtensions.createTableCell(it));
            }
        };
        TableExtensions.getColumns(table).forEach(_function);
        Consumer<Pair<Integer, String>> _function_1 = new Consumer<Pair<Integer, String>>(){

            @Override
            public void accept(Pair<Integer, String> it) {
                TableRowExtensions.set(newRow, (Integer)it.getKey(), (String)it.getValue());
            }
        };
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)values))).forEach(_function_1);
        return newRow;
    }

    public static TableRow addRow(Table table, String ... values) {
        RowGroup newRowGroup = TablemodelFactory.eINSTANCE.createRowGroup();
        final TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
        newRowGroup.getRows().add((Object)newRow);
        table.getTablecontent().getRowgroups().add((Object)newRowGroup);
        Consumer<ColumnDescriptor> _function = new Consumer<ColumnDescriptor>(){

            @Override
            public void accept(ColumnDescriptor it) {
                newRow.getCells().add((Object)ColumnDescriptorExtensions.createTableCell(it));
            }
        };
        TableExtensions.getColumns(table).forEach(_function);
        Consumer<Pair<Integer, String>> _function_1 = new Consumer<Pair<Integer, String>>(){

            @Override
            public void accept(Pair<Integer, String> it) {
                TableRowExtensions.set(newRow, (Integer)it.getKey(), (String)it.getValue());
            }
        };
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)values))).forEach(_function_1);
        return newRow;
    }

    public static void set(Table table, int row, String columnLabel, String value) {
        TableRowExtensions.set(TableExtensions.getTableRows(table).get(row), columnLabel, value);
    }

    public static String getPlainStringValue(Table table, int row, String columnLabel) {
        return TableRowExtensions.getPlainStringValue(TableExtensions.getTableRows(table).get(row), columnLabel);
    }

    public static String getPlainStringValue(Table table, int row, int column) {
        return TableRowExtensions.getPlainStringValue(TableExtensions.getTableRows(table).get(row), column);
    }

    public static String toDebugString(Table table, int columnWidth) {
        StringConcatenation _builder = new StringConcatenation();
        String _paddedString = StringExtensions.toPaddedString((String)"Row", (int)3);
        _builder.append(_paddedString);
        _builder.append(" ");
        String _paddedString_1 = StringExtensions.toPaddedString((String)"Id", (int)columnWidth);
        _builder.append(_paddedString_1);
        _builder.append(" ");
        String _simpleString = TableExtensions.toSimpleString(TableExtensions.getColumns(table), columnWidth);
        _builder.append(_simpleString);
        _builder.newLineIfNotEmpty();
        List<TableRow> rows = TableExtensions.getTableRows(table);
        _builder.newLineIfNotEmpty();
        for (TableRow row : rows) {
            int _indexOf = rows.indexOf(row);
            int _plus = _indexOf + 1;
            String _debugString = TableRowExtensions.toDebugString(row, _plus, columnWidth);
            _builder.append(_debugString);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public static boolean isEqual(Table table, Table other) {
        return TableExtensions.hasEqualDescriptors(table, other) && TableContentExtensions.isEqual(table.getTablecontent(), other.getTablecontent());
    }

    public static boolean hasEqualDescriptors(Table table, final Table other) {
        int _size_1;
        boolean _notEquals;
        int _size = table.getColumndescriptors().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getColumndescriptors().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1<Pair<Integer, ColumnDescriptor>, Boolean> _function = new Functions.Function1<Pair<Integer, ColumnDescriptor>, Boolean>(){

            public Boolean apply(Pair<Integer, ColumnDescriptor> it) {
                return ColumnDescriptorExtensions.isEqual((ColumnDescriptor)it.getValue(), (ColumnDescriptor)other.getColumndescriptors().get(((Integer)it.getKey()).intValue()));
            }
        };
        return IterableExtensions.forall((Iterable)IterableExtensions.indexed((Iterable)table.getColumndescriptors()), (Functions.Function1)_function);
    }

    public static TableRow getMatchingRow(Table table, TableRow row) {
        RowGroup group = TableRowExtensions.getGroup(row);
        int rowIndex = group.getRows().indexOf((Object)row);
        RowGroup _groupByLeadingObject = TableExtensions.getGroupByLeadingObject(table, group.getLeadingObject(), group.getLeadingObjectIndex());
        EList _rows = null;
        if (_groupByLeadingObject != null) {
            _rows = _groupByLeadingObject.getRows();
        }
        TableRow _get = null;
        if (_rows != null) {
            _get = (TableRow)_rows.get(rowIndex);
        }
        return _get;
    }

    public static RowGroup getGroupByLeadingObject(Table table, final Ur_Objekt object, final int index) {
        Functions.Function1<RowGroup, Boolean> _function = new Functions.Function1<RowGroup, Boolean>(){

            public Boolean apply(RowGroup it) {
                int _leadingObjectIndex;
                boolean _tripleEquals;
                boolean _equals;
                boolean _and = false;
                Ur_Objekt _leadingObject = it.getLeadingObject();
                Identitaet_TypeClass _identitaet = null;
                if (_leadingObject != null) {
                    _identitaet = _leadingObject.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (object != null) {
                    _identitaet_1 = object.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                _and = !(_equals = Objects.equal((Object)_wert, (Object)_wert_1)) ? false : (_tripleEquals = (_leadingObjectIndex = it.getLeadingObjectIndex()) == index);
                return _and;
            }
        };
        return (RowGroup)IterableExtensions.findFirst((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function);
    }

    public static RowGroup getGroupById(Table table, final String groupId, final int index) {
        Functions.Function1<RowGroup, Boolean> _function = new Functions.Function1<RowGroup, Boolean>(){

            public Boolean apply(RowGroup it) {
                int _leadingObjectIndex;
                boolean _tripleEquals;
                boolean _equals;
                boolean _and = false;
                Ur_Objekt _leadingObject = it.getLeadingObject();
                Identitaet_TypeClass _identitaet = null;
                if (_leadingObject != null) {
                    _identitaet = _leadingObject.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                _and = !(_equals = Objects.equal((Object)_wert, (Object)groupId)) ? false : (_tripleEquals = (_leadingObjectIndex = it.getLeadingObjectIndex()) == index);
                return _and;
            }
        };
        return (RowGroup)IterableExtensions.findFirst((Iterable)table.getTablecontent().getRowgroups(), (Functions.Function1)_function);
    }

    public static void setTextAlignment(Table table, final int columnIdx, final TextAlignment textAlignment) {
        Consumer<RowGroup> _function = new Consumer<RowGroup>(){

            @Override
            public void accept(RowGroup it) {
                RowGroupExtensions.setTextAlignment(it, columnIdx, textAlignment);
            }
        };
        table.getTablecontent().getRowgroups().forEach((Consumer)_function);
    }

    public static void save(Table table, Path filepath) throws IOException {
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        extensionToFactoryMap.put("tm", _xMIResourceFactoryImpl);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)filepath.toString()));
        resource.getContents().add((Object)table);
        resource.save(Collections.EMPTY_MAP);
    }

    public static int getNextFootnoteNumber(Table table) {
        int _maxFootnoteNumber = TableExtensions.getMaxFootnoteNumber(table);
        return _maxFootnoteNumber + 1;
    }

    public static int getMaxFootnoteNumber(Table table) {
        Functions.Function2<Integer, RowGroup, Integer> _function = new Functions.Function2<Integer, RowGroup, Integer>(){

            public Integer apply(Integer n, RowGroup g) {
                return Math.max(n, RowGroupExtensions.getMaxFootnoteNumber(g));
            }
        };
        return (Integer)IterableExtensions.fold((Iterable)table.getTablecontent().getRowgroups(), (Object)0, (Functions.Function2)_function);
    }

    public static Table load(Path filepath) {
        TablemodelPackage.eINSTANCE.eClass();
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        extensionToFactoryMap.put("tm", _xMIResourceFactoryImpl);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createURI((String)filepath.toString()), true);
        EObject _get = (EObject)resource.getContents().get(0);
        return (Table)_get;
    }

    public static String getFootnotesText(Table table) {
        TableToFootnoteText tranformation = new TableToFootnoteText();
        return tranformation.transform(table);
    }

    private static String toSimpleString(List<ColumnDescriptor> descriptors, int columnWidth) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (ColumnDescriptor descriptor : descriptors) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _paddedString = StringExtensions.toPaddedString((String)descriptor.getLabel(), (int)columnWidth);
            _builder.append(_paddedString);
        }
        return _builder.toString();
    }

    public static int getLeadingObjectRowIndexByGUID(Table table, String guid) {
        int rowIndex = 0;
        EList _rowgroups = table.getTablecontent().getRowgroups();
        for (RowGroup rowGroup : _rowgroups) {
            boolean _equals;
            Ur_Objekt _leadingObject = rowGroup.getLeadingObject();
            Identitaet_TypeClass _identitaet = null;
            if (_leadingObject != null) {
                _identitaet = _leadingObject.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (_equals = Objects.equal((Object)_wert, (Object)guid)) {
                return rowIndex;
            }
            int _rowIndex = rowIndex;
            int _size = rowGroup.getRows().size();
            rowIndex = _rowIndex + _size;
        }
        return -1;
    }
}

