/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class RowGroupExtensions {
    public static TableRow addRow(RowGroup group, String ... values) {
        final TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
        group.getRows().add((Object)newRow);
        Table table = RowGroupExtensions.getTable(group);
        Consumer<ColumnDescriptor> _function = new Consumer<ColumnDescriptor>(){

            @Override
            public void accept(ColumnDescriptor it) {
                newRow.getCells().add((Object)ColumnDescriptorExtensions.createTableCell(it));
            }
        };
        TableExtensions.getColumns(table).forEach(_function);
        Consumer<Pair<Integer, String>> _function_1 = new Consumer<Pair<Integer, String>>(){

            @Override
            public void accept(Pair<Integer, String> it) {
                TableRowExtensions.set(newRow, (Integer)it.getKey(), (String)it.getValue());
            }
        };
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray((Object)values))).forEach(_function_1);
        return newRow;
    }

    public static Table getTable(RowGroup group) {
        return TableContentExtensions.getTable(RowGroupExtensions.getContent(group));
    }

    public static TableContent getContent(RowGroup group) {
        EObject _eContainer = group.eContainer();
        return (TableContent)_eContainer;
    }

    public static boolean isEqual(RowGroup group, final RowGroup other) {
        int _size_1;
        boolean _notEquals;
        int _size = group.getRows().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getRows().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1<Pair<Integer, TableRow>, Boolean> _function = new Functions.Function1<Pair<Integer, TableRow>, Boolean>(){

            public Boolean apply(Pair<Integer, TableRow> it) {
                return TableRowExtensions.isEqual((TableRow)it.getValue(), (TableRow)other.getRows().get(((Integer)it.getKey()).intValue()));
            }
        };
        return IterableExtensions.forall((Iterable)IterableExtensions.indexed((Iterable)group.getRows()), (Functions.Function1)_function);
    }

    public static List<TableCell> getColumnCells(RowGroup group, final ColumnDescriptor descriptor) {
        Functions.Function1<TableRow, TableCell> _function = new Functions.Function1<TableRow, TableCell>(){

            public TableCell apply(TableRow it) {
                return TableRowExtensions.getCell(it, descriptor);
            }
        };
        return ListExtensions.map((List)group.getRows(), (Functions.Function1)_function);
    }

    public static void setTextAlignment(RowGroup group, final int columnIdx, final TextAlignment textAlignment) {
        Consumer<TableRow> _function = new Consumer<TableRow>(){

            @Override
            public void accept(TableRow it) {
                TableCell _get = (TableCell)it.getCells().get(columnIdx);
                TableCellExtensions.setTextAlignment(_get, textAlignment);
            }
        };
        group.getRows().forEach((Consumer)_function);
    }

    public static int getMaxFootnoteNumber(RowGroup group) {
        Functions.Function2<Integer, TableRow, Integer> _function = new Functions.Function2<Integer, TableRow, Integer>(){

            public Integer apply(Integer n, TableRow r) {
                return Math.max(n, TableRowExtensions.getMaxFootnoteNumber(r));
            }
        };
        return (Integer)IterableExtensions.fold((Iterable)group.getRows(), (Object)0, (Functions.Function2)_function);
    }

    public static RowGroup findRowGroup(Table table, final TableRow row, final List<ColumnDescriptor> excludeCols) {
        EList groups = table.getTablecontent().getRowgroups();
        Functions.Function1<ColumnDescriptor, Boolean> _function = new Functions.Function1<ColumnDescriptor, Boolean>(){

            public Boolean apply(ColumnDescriptor it) {
                boolean _contains = excludeCols.contains(it);
                return !_contains;
            }
        };
        final Iterable sameValueCols = IterableExtensions.filter(TableExtensions.getColumns(table), (Functions.Function1)_function);
        Functions.Function1<RowGroup, Boolean> _function_1 = new Functions.Function1<RowGroup, Boolean>(){

            public Boolean apply(RowGroup group) {
                boolean _xblockexpression = false;
                TableRow firstRowInGroup = (TableRow)group.getRows().get(0);
                Functions.Function1<TableCell, Boolean> _function = new Functions.Function1<TableCell, Boolean>(){

                    public Boolean apply(TableCell it) {
                        return IterableExtensions.contains((Iterable)sameValueCols, (Object)it.getColumndescriptor());
                    }
                };
                Functions.Function1<TableCell, Boolean> _function_1 = new Functions.Function1<TableCell, Boolean>(){

                    public Boolean apply(TableCell it) {
                        String groupValue = CellContentExtensions.getPlainStringValue(it.getContent());
                        String rowValue = TableRowExtensions.getPlainStringValue(row, it.getColumndescriptor());
                        return groupValue.equals(rowValue);
                    }
                };
                _xblockexpression = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)firstRowInGroup.getCells(), (Functions.Function1)_function), (Functions.Function1)_function_1);
                return _xblockexpression;
            }
        };
        return (RowGroup)IterableExtensions.findFirst((Iterable)groups, (Functions.Function1)_function_1);
    }
}

