/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.exportservice;

import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.services.export.TableExport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ExportServiceImpl
implements ExportService {
    private static final Logger logger = LoggerFactory.getLogger(ExportServiceImpl.class);
    private final List<TableExport> builders = new LinkedList<TableExport>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addTableExportBuilder(TableExport builder) {
        this.builders.add(builder);
    }

    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling, Consumer<Exception> errorHandler) {
        if (this.builders.isEmpty()) {
            logger.warn("There are no builders registered at the export service.");
        }
        for (TableExport builder : this.builders) {
            try {
                builder.export(tables, exportType, titlebox, freeFieldInfo, shortcut, outputDir, toolboxPaths, tableType, overwriteHandling);
            }
            catch (Exception e) {
                errorHandler.accept(e);
            }
        }
    }

    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling, Consumer<Exception> errorHandler) {
        for (TableExport builder : this.builders) {
            try {
                builder.exportTitleboxImage(titlebox, imagePath, overwriteHandling);
            }
            catch (Exception e) {
                errorHandler.accept(e);
            }
        }
    }

    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling, Consumer<Exception> errorHandler) {
        for (TableExport builder : this.builders) {
            try {
                builder.exportTitleboxPdf(titlebox, pdfPath, overwriteHandling);
            }
            catch (Exception e) {
                errorHandler.accept(e);
            }
        }
    }

    public void removeTableExportBuilder(TableExport builder) {
        this.builders.remove(builder);
    }
}

