/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.utils.table.sorting.AbstractCellComparator;
import org.eclipse.set.utils.table.sorting.LexicographicalCellComparator;
import org.eclipse.set.utils.table.sorting.MixedStringCellComparator;
import org.eclipse.set.utils.table.sorting.TableRowGroupComparator;

public class ComparatorBuilder {
    private final TableRowGroupComparator tableRowGroupComparator;

    public ComparatorBuilder(TableRowGroupComparator tableRowGroupComparator) {
        this.tableRowGroupComparator = tableRowGroupComparator;
    }

    public Comparator<RowGroup> build() {
        return this.tableRowGroupComparator;
    }

    public ComparatorBuilder sort(Class<?> ... types) {
        this.tableRowGroupComparator.addCriterion(List.of(types));
        return this;
    }

    public ComparatorBuilder sort(String columnId, CellComparatorType cellComparatorType, SortDirectionEnum direction) {
        AbstractCellComparator cellComparator = switch (cellComparatorType) {
            case CellComparatorType.LEXICOGRAPHICAL -> new LexicographicalCellComparator(direction);
            case CellComparatorType.MIXED_STRING -> new MixedStringCellComparator(direction);
            default -> throw new IllegalArgumentException(cellComparatorType.toString());
        };
        try {
            int index = Integer.parseInt(columnId);
            this.tableRowGroupComparator.addCriterion(index, (Comparator<TableCell>)cellComparator);
        }
        catch (NumberFormatException e) {
            this.tableRowGroupComparator.addCriterion(columnId, (Comparator<TableCell>)cellComparator);
        }
        return this;
    }

    public ComparatorBuilder sort(String columnId, Comparator<TableCell> cellComparator) {
        this.tableRowGroupComparator.addCriterion(columnId, cellComparator);
        return this;
    }

    public static enum CellComparatorType {
        LEXICOGRAPHICAL,
        MIXED_STRING;

    }
}

