/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.extensions.SourceExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class PlanProSchemaDir {
    private static final String PLANPRO_SCHEMA_NAME = "PlanPro.xsd";
    private static final String SCHEMA_DIR = "schema-planpro";
    private static final String SCHEMA_PATTERN = "*.xsd";
    private static final String SEPARATOR = "/";

    private static boolean isPlanProPath(Path path) {
        return path.getFileName().toString().equalsIgnoreCase(PLANPRO_SCHEMA_NAME);
    }

    public static Optional<Path> getPlanProSchemaPath() {
        return PlanProSchemaDir.getSchemaPaths().stream().filter(PlanProSchemaDir::isPlanProPath).findFirst();
    }

    public static LSResourceResolver getResourceResolver() {
        return new ResourceResolver();
    }

    public static List<Path> getSchemaPaths() {
        LinkedList<Path> result = new LinkedList<Path>();
        Bundle bundle = FrameworkUtil.getBundle(PlanPro_Schnittstelle.class);
        Enumeration entries = bundle.findEntries(SCHEMA_DIR, SCHEMA_PATTERN, true);
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            result.add(Paths.get(url.getFile(), new String[0]));
        }
        return result;
    }

    public static Source[] getSchemas() {
        LinkedList<StreamSource> result = new LinkedList<StreamSource>();
        for (Path schemaPath : PlanProSchemaDir.getSchemaPaths()) {
            String pathString = PathExtensions.toString(schemaPath, SEPARATOR);
            StreamSource source = SourceExtensions.getResourceAsSource(PlanPro_Schnittstelle.class, pathString);
            result.add(source);
        }
        return result.toArray(new Source[0]);
    }

    private static class LSInputImpl
    implements LSInput {
        private final String baseURI;
        private final String publicId;
        private final String systemId;
        private final Bundle bundle = FrameworkUtil.getBundle(PlanPro_Schnittstelle.class);

        LSInputImpl(String publicId, String systemId, String baseURI) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return PlanPro_Schnittstelle.class.getResourceAsStream(this.getSchemaPath());
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPublicId(String publicId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSystemId(String systemId) {
            throw new UnsupportedOperationException();
        }

        private String getSchemaPath() {
            Enumeration entries = this.bundle.findEntries(PlanProSchemaDir.SCHEMA_DIR, this.getSystemId(), true);
            URL element = (URL)entries.nextElement();
            Assert.isTrue((!entries.hasMoreElements() ? 1 : 0) != 0);
            return element.getFile();
        }
    }

    private static class ResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return new LSInputImpl(publicId, systemId, baseURI);
        }
    }
}

