/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.tabletype;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTypeSelectionControl {
    static final Logger LOGGER = LoggerFactory.getLogger(TableTypeSelectionControl.class);
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    private Combo combo;
    @Inject
    private EnumTranslationService enumTranslationService;
    @Inject
    @Translation
    private Messages messages;
    private IModelSession oldSession;
    @Inject
    ToolboxPartService partService;

    private static boolean isPlanning(IModelSession session) {
        return PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)session.getPlanProSchnittstelle());
    }

    private String getMaxLengthItem() {
        LinkedList<String> items = new LinkedList<String>();
        items.add(this.messages.TableTypeSelectionControl_noSession);
        items.add(this.enumTranslationService.translate((Translateable)TableType.INITIAL).getPresentation());
        items.add(this.enumTranslationService.translate((Translateable)TableType.FINAL).getPresentation());
        items.add(this.enumTranslationService.translate((Translateable)TableType.SINGLE).getPresentation());
        Collections.sort(items, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o2.length() > o1.length()) {
                    return 1;
                }
                return 0;
            }
        });
        return (String)items.getFirst();
    }

    private IModelSession getSession() {
        return (IModelSession)this.application.getContext().get(IModelSession.class);
    }

    private TableType getTableType() {
        if (this.isStart()) {
            return TableType.INITIAL;
        }
        if (this.isZiel()) {
            return TableType.FINAL;
        }
        if (this.isZustand()) {
            return TableType.SINGLE;
        }
        if (this.isStartZielVergleich()) {
            return TableType.DIFF;
        }
        throw new IllegalStateException();
    }

    private void initCombo() {
        this.combo.removeAll();
        this.combo.add(this.messages.TableTypeSelectionControl_noSession);
        this.combo.add(this.getMaxLengthItem());
        this.combo.select(0);
        this.combo.setEnabled(false);
    }

    private boolean isStart() {
        String text = this.combo.getText();
        return this.enumTranslationService.translate((Translateable)TableType.INITIAL).getPresentation().equals(text);
    }

    private boolean isStartZielVergleich() {
        String text = this.combo.getText();
        return this.enumTranslationService.translate((Translateable)TableType.DIFF).getPresentation().equals(text);
    }

    private boolean isZiel() {
        String text = this.combo.getText();
        return this.enumTranslationService.translate((Translateable)TableType.FINAL).getPresentation().equals(text);
    }

    private boolean isZustand() {
        String text = this.combo.getText();
        return this.enumTranslationService.translate((Translateable)TableType.SINGLE).getPresentation().equals(text);
    }

    @PostConstruct
    private void postConstruct(Composite parent) {
        this.combo = new Combo(parent, 12);
        this.initCombo();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableTypeSelectionControl.this.selectTableType();
            }

            public void widgetSelected(SelectionEvent e) {
                TableTypeSelectionControl.this.selectTableType();
            }
        });
        this.setCombo(this.getSession());
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                TableTypeSelectionControl.this.setCombo((IModelSession)context.get(IModelSession.class));
                return true;
            }
        });
    }

    void selectTableType() {
        ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new NewTableTypeEvent(this.getTableType()));
    }

    void setCombo(IModelSession session) {
        if (session == this.oldSession) {
            return;
        }
        this.oldSession = session;
        if (session == null) {
            this.initCombo();
        } else if (TableTypeSelectionControl.isPlanning(session)) {
            this.combo.removeAll();
            this.combo.add(this.enumTranslationService.translate((Translateable)TableType.DIFF).getPresentation());
            this.combo.add(this.enumTranslationService.translate((Translateable)TableType.INITIAL).getPresentation());
            this.combo.add(this.enumTranslationService.translate((Translateable)TableType.FINAL).getPresentation());
            this.combo.select(0);
            this.combo.setEnabled(true);
        } else {
            this.combo.removeAll();
            this.combo.add(this.enumTranslationService.translate((Translateable)TableType.SINGLE).getPresentation());
            this.combo.select(0);
            this.combo.setEnabled(false);
        }
    }
}

