/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.handler;

import java.nio.file.Path;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.InitializationData;
import org.eclipse.set.basis.ProjectInitializationData;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.utils.handler.AbstractNewHandler;
import org.eclipse.swt.widgets.Shell;

public class NewProjectHandler
extends AbstractNewHandler<ProjectInitializationData> {
    @Inject
    @Translation
    Messages messages;

    public IModelSession createNewSession(ProjectInitializationData initializationData) {
        IModelSession newSession = this.sessionService.initModelSession((InitializationData)initializationData);
        newSession.init();
        return newSession;
    }

    public String getErrorCauseMessage() {
        return this.messages.Common_InfoErrorCause;
    }

    public String getErrorMessage() {
        return this.messages.NewProjectHandler_SavingPlanProModelFileErrorMessage;
    }

    public String getErrorTitleMessage() {
        return this.messages.NewProjectHandler_SavingPlanProModelFileErrorTitle;
    }

    public String getSuccessMessage(Path file) {
        return String.format(this.messages.NewProjectHandler_SuccessMessage, file);
    }

    public String getSuccessTitleMessage() {
        return this.messages.NewProjectHandler_SuccessMessage_Title;
    }

    public String getTaskMessage() {
        return this.messages.NewProjectHandler_CreatingPlanProModelFile;
    }

    public int openDialog(Shell shell, final MApplication application) {
        return this.getDialogService().projectInitialization(shell, (BiPredicate)new BiPredicate<Shell, ProjectInitializationData>(){

            @Override
            public boolean test(Shell parent, ProjectInitializationData initializationData) {
                return NewProjectHandler.this.save((InitializationData)initializationData, parent, application);
            }
        });
    }

    public void showInitPart(ToolboxPartService toolboxViewService) {
        toolboxViewService.showPart("org.eclipse.set.feature.projectdata.edit.ProjectPart");
    }
}

