/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.table;

import java.util.List;
import org.eclipse.set.feature.validation.table.ValidationTableColumns;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.utils.table.tree.AbstractValidationProblemTransformator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;

public class ValidationReportTableTransformator
extends AbstractValidationProblemTransformator<ValidationReport> {
    private ValidationTableColumns columns;
    protected final List<ColumnDescriptor> excludeColumns;

    public ValidationReportTableTransformator(ValidationTableColumns columns) {
        this.columns = columns;
        this.excludeColumns = CollectionLiterals.newArrayList((Object[])new ColumnDescriptor[]{columns.RowIndex, columns.Message, columns.LineNumber});
    }

    public List<ValidationProblem> getProblems(ValidationReport report) {
        return report.getProblems();
    }

    public void fillProblem(TableRow instance, final ValidationProblem problem) {
        boolean _notEquals;
        Functions.Function1<ValidationProblem, String> _function = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return Integer.valueOf(problem.getId()).toString();
            }
        };
        this.fill(instance, this.columns.RowIndex, problem, (Functions.Function1)_function);
        Functions.Function1<ValidationProblem, String> _function_1 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return it.getSeverityText();
            }
        };
        this.fill(instance, this.columns.Severity, problem, (Functions.Function1)_function_1);
        Functions.Function1<ValidationProblem, String> _function_2 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return it.getType();
            }
        };
        this.fill(instance, this.columns.ProblemType, problem, (Functions.Function1)_function_2);
        int _lineNumber = problem.getLineNumber();
        boolean bl = _notEquals = _lineNumber != 0;
        if (_notEquals) {
            Functions.Function1<ValidationProblem, Number> _function_3 = new Functions.Function1<ValidationProblem, Number>(){

                public Number apply(ValidationProblem it) {
                    return it.getLineNumber();
                }
            };
            this.fillNumeric(instance, this.columns.LineNumber, problem, (Functions.Function1)_function_3);
        }
        Functions.Function1<ValidationProblem, String> _function_4 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return it.getObjectArt();
            }
        };
        this.fill(instance, this.columns.ObjectType, problem, (Functions.Function1)_function_4);
        Functions.Function1<ValidationProblem, String> _function_5 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return it.getAttributeName();
            }
        };
        this.fill(instance, this.columns.AttributeGroup, problem, (Functions.Function1)_function_5);
        Functions.Function1<ValidationProblem, String> _function_6 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                ObjectScope _objectScope = it.getObjectScope();
                String _string = null;
                if (_objectScope != null) {
                    _string = _objectScope.toString();
                }
                return _string;
            }
        };
        this.fill(instance, this.columns.ObjectScope, problem, (Functions.Function1)_function_6);
        Functions.Function1<ValidationProblem, String> _function_7 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                ObjectState _objectState = it.getObjectState();
                String _literal = null;
                if (_objectState != null) {
                    _literal = _objectState.getLiteral();
                }
                return _literal;
            }
        };
        this.fill(instance, this.columns.ObjectState, problem, (Functions.Function1)_function_7);
        Functions.Function1<ValidationProblem, String> _function_8 = new Functions.Function1<ValidationProblem, String>(){

            public String apply(ValidationProblem it) {
                return it.getMessage();
            }
        };
        this.fill(instance, this.columns.Message, problem, (Functions.Function1)_function_8);
    }

    public List<ColumnDescriptor> getExcludeColumns() {
        return this.excludeColumns;
    }

    public ColumnDescriptor getIndexColumn() {
        return this.columns.RowIndex;
    }

    public ColumnDescriptor getMessagesColumn() {
        return this.columns.Message;
    }
}

