/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.xml;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.feature.validation.utils.ObjectMetadataXMLReader;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ObjectState;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EObjectXMLFinder {
    private Document document = null;

    public EObjectXMLFinder(ToolboxFile toolboxFile, Path docPath) throws XmlParseException {
        try {
            this.document = ObjectMetadataXMLReader.read((ToolboxFile)toolboxFile, (Path)docPath);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException || _t instanceof SAXException || _t instanceof ParserConfigurationException) {
                Exception e = (Exception)_t;
                throw new XmlParseException("The given XML document could not be parsed", e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Node find(EObject object) {
        if (object == null) {
            return null;
        }
        EObject parent = object.eContainer();
        EReference feature = object.eContainmentFeature();
        String name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)feature);
        Node _xifexpression = null;
        EObject _eContainer = null;
        if (parent != null) {
            _eContainer = parent.eContainer();
        }
        boolean _tripleEquals = _eContainer == null;
        _xifexpression = _tripleEquals ? this.document : this.find(parent);
        Node parentNode = _xifexpression;
        boolean _isMany = feature.isMany();
        if (_isMany) {
            Object _eGet = object.eContainer().eGet((EStructuralFeature)feature);
            List list = (List)_eGet;
            return this.getNthChildByName(parentNode, name, list.indexOf(object));
        }
        return this.getFirstChildByName(parentNode, name);
    }

    private Node getFirstChildByName(Node node, String name) {
        return this.getNthChildByName(node, name, 0);
    }

    private Node getNthChildByName(Node node, final String name, int n) {
        if (node == null) {
            return null;
        }
        final NodeList children = node.getChildNodes();
        IntFunction<Node> _function = new IntFunction<Node>(){

            @Override
            public Node apply(int i) {
                return children.item(i);
            }
        };
        Stream<Node> childrenStream = IntStream.range(0, children.getLength()).mapToObj(_function);
        Predicate<Node> _function_1 = new Predicate<Node>(){

            @Override
            public boolean test(Node it) {
                return EObjectXMLFinder.this.getSanetizedName(it).equals(name);
            }
        };
        return childrenStream.filter(_function_1).skip(n).findFirst().orElse(null);
    }

    private String getSanetizedName(Node node) {
        return (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)node.getNodeName().split(":"))));
    }

    public int getLineNumber(Node node) throws LineNotFoundException {
        String lineNum;
        Object _userData = null;
        if (node != null) {
            _userData = node.getUserData("lineNumber");
        }
        if ((lineNum = (String)_userData) == null) {
            throw new LineNotFoundException();
        }
        return Integer.parseInt(lineNum);
    }

    public String getObjectType(Node node) {
        return ObjectMetadataXMLReader.getObjectType((Node)node);
    }

    public ObjectState getObjectState(Node node) {
        return ObjectMetadataXMLReader.getObjectState((Node)node);
    }

    public String getAttributeName(Node node) {
        return ObjectMetadataXMLReader.getAttributeName((Node)node);
    }

    public ObjectScope getObjectScope(Node node) {
        return ObjectMetadataXMLReader.getObjectScope((Node)node);
    }

    public static class LineNotFoundException
    extends Exception {
        public LineNotFoundException() {
            super("No line for given EObject found");
        }
    }

    public static class XmlParseException
    extends Exception {
        public XmlParseException(String m, Throwable e) {
            super(m, e);
        }
    }
}

