/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.PlanPro.LST_Zustand;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class GuidOrder
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        HashMap objectMap = CollectionLiterals.newHashMap();
        ArrayList errors = CollectionLiterals.newArrayList();
        Iterable _urObjekt = container.getUrObjekt();
        for (Ur_Objekt object : _urObjekt) {
            boolean _tripleEquals;
            String newGuid;
            Identitaet_TypeClass _identitaet = object.getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if ((newGuid = _wert) == null) continue;
            Ur_Objekt oldObject = (Ur_Objekt)objectMap.get(object.eClass());
            boolean _and = false;
            LST_Zustand _lSTZustand = null;
            if (object != null) {
                _lSTZustand = UrObjectExtensions.getLSTZustand((Ur_Objekt)object);
            }
            LST_Zustand _lSTZustand_1 = null;
            if (oldObject != null) {
                _lSTZustand_1 = UrObjectExtensions.getLSTZustand((Ur_Objekt)oldObject);
            }
            boolean bl = _tripleEquals = _lSTZustand == _lSTZustand_1;
            if (!_tripleEquals) {
                _and = false;
            } else {
                boolean _lessThan;
                Identitaet_TypeClass _identitaet_1 = null;
                if (oldObject != null) {
                    _identitaet_1 = oldObject.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                _and = _lessThan = newGuid.compareTo(_wert_1) < 0;
            }
            if (_and) {
                errors.add(object);
            }
            objectMap.put(object.eClass(), object);
        }
        Functions.Function1<Ur_Objekt, EClass> _function = new Functions.Function1<Ur_Objekt, EClass>(){

            public EClass apply(Ur_Objekt it) {
                return it.eClass();
            }
        };
        Functions.Function1<Ur_Objekt, PlazError> _function_1 = new Functions.Function1<Ur_Objekt, PlazError>(){

            public PlazError apply(Ur_Objekt it) {
                PlazError err = PlazFactory.eINSTANCE.createPlazError();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Die Elemente des Objekttyps ");
                String _name = it.eClass().getName();
                _builder.append(_name);
                _builder.append(" sind nicht sortiert.");
                err.setMessage(_builder.toString());
                err.setMessage(GuidOrder.this.transformErroMsg(Map.of("Objekttyp", it.eClass().getName())));
                err.setType(GuidOrder.this.checkType());
                err.setSeverity(ValidationSeverity.WARNING);
                err.setObject((EObject)it);
                return err;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)org.eclipse.set.ppmodel.extensions.utils.IterableExtensions.distinctBy((Iterable)errors, (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    @Override
    public String checkType() {
        return "GUID-Sortierung";
    }

    @Override
    public String getDescription() {
        return "Objekte vom gleichen Typ sind anhand ihrer GUID sortiert.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die Elemente des Objekttyps {Objekttyp} sind nicht sortiert.";
    }

    @Override
    public String transformErroMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

