/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.basisattribute;

import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.emfforms.RendererContext;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.helpmessage.HelpMessageService;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeBinding;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeRenderer;
import org.eclipse.set.emfforms.basisattribute.BasisAttributeSetting;
import org.eclipse.set.emfforms.utils.RendererContextImpl;
import org.eclipse.set.utils.ButtonAction;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.set.utils.emfforms.Renderers;
import org.eclipse.set.utils.emfforms.ToolboxRenderer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasisAttributeTextRenderer
extends TextControlSWTRenderer
implements BasisAttributeRenderer<String>,
ToolboxRenderer {
    private static final String DEFAULT_TEXT = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasisAttributeTextRenderer.class);
    private final BasisAttributeSetting<String> basisAttributeSetting;
    private final BasisAttributeBinding<String> binding;
    private final HelpMessageService helpMessageService;
    private Optional<Consumer<Text>> optionalTextConsumer;
    private final RendererContextImpl rendererContextImpl;
    final ButtonAction buttonAction;
    final EObject parent;
    Text textWidget;

    public static boolean isApplicable(EClassifier type) {
        return BasisAttributeSetting.isWertFeatureTypeAssignableTo(type, String.class);
    }

    private static Text getTextWidget(Control textBox) {
        return (Text)((Composite)textBox).getChildren()[0];
    }

    @Inject
    public BasisAttributeTextRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        LOGGER.debug("Render {}", (Object)vElement);
        this.rendererContextImpl = new RendererContextImpl();
        this.rendererContextImpl.put(VControl.class, (VControl)this.getVElement());
        this.basisAttributeSetting = new BasisAttributeSetting<String>(String.class, vElement, viewContext);
        this.parent = this.basisAttributeSetting.getParent();
        this.rendererContextImpl.put(EObject.class, this.parent);
        this.rendererContextImpl.put(EditingDomain.class, this.basisAttributeSetting.getEditingDomain());
        EStructuralFeature basisAttributeFeature = this.basisAttributeSetting.getBasisAttributeFeature();
        this.rendererContextImpl.put(EStructuralFeature.class, basisAttributeFeature);
        this.binding = new BasisAttributeBinding<String>(this);
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        this.helpMessageService = (HelpMessageService)toolboxViewModelService.get(HelpMessageService.class);
        String textConsumerName = Annotations.getViewModelValue((VElement)vElement, (String)"textConsumer");
        if (textConsumerName != null) {
            Consumer consumer = (Consumer)toolboxViewModelService.get(textConsumerName);
            this.optionalTextConsumer = Optional.of(consumer);
        } else {
            this.optionalTextConsumer = Optional.empty();
        }
        String buttonActionKey = Annotations.getViewModelValue((VElement)vElement, (String)"buttonActionKey");
        this.buttonAction = (ButtonAction)toolboxViewModelService.get(buttonActionKey);
    }

    public void checkToolboxRenderer() {
        this.checkRenderer();
    }

    @Override
    public BasisAttributeSetting<String> getBasisAttributeSetting() {
        return this.basisAttributeSetting;
    }

    @Override
    public Control getControl() {
        return this.textWidget;
    }

    @Override
    public EObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isDisposed() {
        return Renderers.isDisposed((ToolboxRenderer)this);
    }

    @Override
    public void updateControl() {
        String text = this.getText();
        if (!text.equals(this.textWidget.getText())) {
            this.textWidget.setText(text);
        }
    }

    @Override
    public void updateModel() {
        String text = this.textWidget.getText();
        if (this.isRemoveable(text)) {
            this.basisAttributeSetting.removeBasisAttribute();
        } else {
            this.updateBasisAttributeWert(text);
        }
    }

    @Override
    public Optional<String> valueOf(String representation) {
        return Optional.ofNullable(representation);
    }

    private boolean isRemoveable(String text) {
        return text.isEmpty() && !this.basisAttributeSetting.hasContents();
    }

    private void updateBasisAttributeWert(String text) {
        if (this.basisAttributeSetting.updateValue(text)) {
            this.binding.unbind();
            this.binding.bind();
            this.textWidget.setSelection(text.length());
        }
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        this.textWidget = BasisAttributeTextRenderer.getTextWidget(control);
        this.binding.bind();
        if (this.optionalTextConsumer.isPresent()) {
            Consumer<Text> textConsumer = this.optionalTextConsumer.get();
            textConsumer.accept(this.textWidget);
        }
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parentComposite) {
        if (this.buttonAction == null) {
            return super.createSWTControl(parentComposite);
        }
        Composite textWithButtonComposite = new Composite(parentComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textWithButtonComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)textWithButtonComposite);
        Control textBox = super.createSWTControl(textWithButtonComposite);
        this.rendererContextImpl.put(Text.class, BasisAttributeTextRenderer.getTextWidget(textBox));
        String buttonText = this.buttonAction.getText();
        int buttonWidth = this.buttonAction.getWidth();
        Button button = new Button(textWithButtonComposite, 8);
        this.rendererContextImpl.put(Button.class, button);
        button.setText(buttonText);
        GridDataFactory.swtDefaults().minSize(buttonWidth, 0).hint(buttonWidth, -1).applyTo((Control)button);
        this.buttonAction.register((RendererContext)this.rendererContextImpl);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BasisAttributeTextRenderer.this.buttonAction.selected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                BasisAttributeTextRenderer.this.buttonAction.selected(e);
            }
        });
        return textBox;
    }

    protected String getTextMessage() {
        String message = this.helpMessageService.getMessage((RendererContext)this.rendererContextImpl);
        if (message != null) {
            return message;
        }
        return super.getTextMessage();
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        super.rootDomainModelChanged();
        this.binding.unbind();
    }

    String getText() {
        return this.basisAttributeSetting.getWertValue().orElse(DEFAULT_TEXT);
    }
}

