/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Bahnsteig.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Bahnsteig.util.BahnsteigAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BahnsteigItemProviderAdapterFactory extends BahnsteigAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BahnsteigItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_AnlageItemProvider bahnsteig_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_AnlageAdapter() {
		if (bahnsteig_AnlageItemProvider == null) {
			bahnsteig_AnlageItemProvider = new Bahnsteig_AnlageItemProvider(this);
		}

		return bahnsteig_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Anlage_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_Anlage_Bezeichnung_AttributeGroupAdapter() {
		if (bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider == null) {
			bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider = new Bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Dach} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_DachItemProvider bahnsteig_DachItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Dach}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_DachAdapter() {
		if (bahnsteig_DachItemProvider == null) {
			bahnsteig_DachItemProvider = new Bahnsteig_DachItemProvider(this);
		}

		return bahnsteig_DachItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_KanteItemProvider bahnsteig_KanteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_KanteAdapter() {
		if (bahnsteig_KanteItemProvider == null) {
			bahnsteig_KanteItemProvider = new Bahnsteig_KanteItemProvider(this);
		}

		return bahnsteig_KanteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_Kante_Allg_AttributeGroupItemProvider bahnsteig_Kante_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_Kante_Allg_AttributeGroupAdapter() {
		if (bahnsteig_Kante_Allg_AttributeGroupItemProvider == null) {
			bahnsteig_Kante_Allg_AttributeGroupItemProvider = new Bahnsteig_Kante_Allg_AttributeGroupItemProvider(this);
		}

		return bahnsteig_Kante_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Kante_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_Kante_Bezeichnung_AttributeGroupAdapter() {
		if (bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider == null) {
			bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider = new Bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_ZugangItemProvider bahnsteig_ZugangItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_ZugangAdapter() {
		if (bahnsteig_ZugangItemProvider == null) {
			bahnsteig_ZugangItemProvider = new Bahnsteig_ZugangItemProvider(this);
		}

		return bahnsteig_ZugangItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_Zugang_Allg_AttributeGroupItemProvider bahnsteig_Zugang_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_Zugang_Allg_AttributeGroupAdapter() {
		if (bahnsteig_Zugang_Allg_AttributeGroupItemProvider == null) {
			bahnsteig_Zugang_Allg_AttributeGroupItemProvider = new Bahnsteig_Zugang_Allg_AttributeGroupItemProvider(this);
		}

		return bahnsteig_Zugang_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bahnsteig_Zugang_Art_TypeClassItemProvider bahnsteig_Zugang_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bahnsteig_Zugang_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBahnsteig_Zugang_Art_TypeClassAdapter() {
		if (bahnsteig_Zugang_Art_TypeClassItemProvider == null) {
			bahnsteig_Zugang_Art_TypeClassItemProvider = new Bahnsteig_Zugang_Art_TypeClassItemProvider(this);
		}

		return bahnsteig_Zugang_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Bahnsteig_Anlage_TypeClassAdapter() {
		if (bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider == null) {
			bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider = new Bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider(this);
		}

		return bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Kante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Bahnsteig_Kante_TypeClassItemProvider bezeichnung_Bahnsteig_Kante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Bezeichnung_Bahnsteig_Kante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Bahnsteig_Kante_TypeClassAdapter() {
		if (bezeichnung_Bahnsteig_Kante_TypeClassItemProvider == null) {
			bezeichnung_Bahnsteig_Kante_TypeClassItemProvider = new Bezeichnung_Bahnsteig_Kante_TypeClassItemProvider(this);
		}

		return bezeichnung_Bahnsteig_Kante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Hauptzugang_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hauptzugang_TypeClassItemProvider hauptzugang_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Hauptzugang_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHauptzugang_TypeClassAdapter() {
		if (hauptzugang_TypeClassItemProvider == null) {
			hauptzugang_TypeClassItemProvider = new Hauptzugang_TypeClassItemProvider(this);
		}

		return hauptzugang_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Lage_Zum_Gleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Lage_Zum_Gleis_TypeClassItemProvider lage_Zum_Gleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Lage_Zum_Gleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLage_Zum_Gleis_TypeClassAdapter() {
		if (lage_Zum_Gleis_TypeClassItemProvider == null) {
			lage_Zum_Gleis_TypeClassItemProvider = new Lage_Zum_Gleis_TypeClassItemProvider(this);
		}

		return lage_Zum_Gleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Bahnsteig.Systemhoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Systemhoehe_TypeClassItemProvider systemhoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Bahnsteig.Systemhoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemhoehe_TypeClassAdapter() {
		if (systemhoehe_TypeClassItemProvider == null) {
			systemhoehe_TypeClassItemProvider = new Systemhoehe_TypeClassItemProvider(this);
		}

		return systemhoehe_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (bahnsteig_AnlageItemProvider != null) bahnsteig_AnlageItemProvider.dispose();
		if (bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider != null) bahnsteig_Anlage_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bahnsteig_DachItemProvider != null) bahnsteig_DachItemProvider.dispose();
		if (bahnsteig_KanteItemProvider != null) bahnsteig_KanteItemProvider.dispose();
		if (bahnsteig_Kante_Allg_AttributeGroupItemProvider != null) bahnsteig_Kante_Allg_AttributeGroupItemProvider.dispose();
		if (bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider != null) bahnsteig_Kante_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (bahnsteig_ZugangItemProvider != null) bahnsteig_ZugangItemProvider.dispose();
		if (bahnsteig_Zugang_Allg_AttributeGroupItemProvider != null) bahnsteig_Zugang_Allg_AttributeGroupItemProvider.dispose();
		if (bahnsteig_Zugang_Art_TypeClassItemProvider != null) bahnsteig_Zugang_Art_TypeClassItemProvider.dispose();
		if (bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider != null) bezeichnung_Bahnsteig_Anlage_TypeClassItemProvider.dispose();
		if (bezeichnung_Bahnsteig_Kante_TypeClassItemProvider != null) bezeichnung_Bahnsteig_Kante_TypeClassItemProvider.dispose();
		if (hauptzugang_TypeClassItemProvider != null) hauptzugang_TypeClassItemProvider.dispose();
		if (lage_Zum_Gleis_TypeClassItemProvider != null) lage_Zum_Gleis_TypeClassItemProvider.dispose();
		if (systemhoehe_TypeClassItemProvider != null) systemhoehe_TypeClassItemProvider.dispose();
	}

}
