/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class Unknown
extends Attribute {
    private static final long serialVersionUID = -4152422704743201314L;
    private byte[] bytes;
    private String name;
    private static final Map<String, Unknown> unknown_attributes = new HashMap<String, Unknown>();

    public Unknown(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = ((ConstantUtf8)constant_pool.getConstant(name_index, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            file.readFully(this.bytes);
        }
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.length > 0) {
            file.write(this.bytes, 0, this.length);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String toString() {
        String hex;
        if (this.length == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (this.length > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = String.valueOf(Utility.toHexString(tmp)) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Unknown c = (Unknown)this.clone();
        if (this.bytes != null) {
            c.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c.bytes, 0, this.bytes.length);
        }
        c.constant_pool = _constant_pool;
        return c;
    }
}

