/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.startup.AbsoluteOrderingRule;
import org.apache.catalina.startup.CallMethodMultiRule;
import org.apache.catalina.startup.CallParamMultiRule;
import org.apache.catalina.startup.IgnoreAnnotationsRule;
import org.apache.catalina.startup.RelativeOrderingRule;
import org.apache.catalina.startup.ServiceQnameRule;
import org.apache.catalina.startup.ServletDefCreateRule;
import org.apache.catalina.startup.SetAuthConstraintRule;
import org.apache.catalina.startup.SetDistributableRule;
import org.apache.catalina.startup.SetJspConfig;
import org.apache.catalina.startup.SetLoginConfig;
import org.apache.catalina.startup.SetPublicIdRule;
import org.apache.catalina.startup.SetSessionConfig;
import org.apache.catalina.startup.SoapHeaderRule;
import org.apache.catalina.startup.TaglibLocationRule;
import org.apache.catalina.startup.VersionRule;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSetBase;
import org.apache.tomcat.util.digester.SetNextRule;
import org.apache.tomcat.util.res.StringManager;

public class WebRuleSet
extends RuleSetBase {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected String prefix = null;
    protected String fullPrefix = null;
    protected boolean fragment = false;
    protected SetSessionConfig sessionConfig;
    protected SetLoginConfig loginConfig;
    protected SetJspConfig jspConfig;

    public WebRuleSet() {
        this("", false);
    }

    public WebRuleSet(boolean fragment) {
        this("", fragment);
    }

    public WebRuleSet(String prefix, boolean fragment) {
        this.namespaceURI = null;
        this.prefix = prefix;
        this.fragment = fragment;
        this.fullPrefix = fragment ? String.valueOf(prefix) + "web-fragment" : String.valueOf(prefix) + "web-app";
    }

    @Override
    public void addRuleInstances(Digester digester) {
        this.sessionConfig = new SetSessionConfig();
        this.jspConfig = new SetJspConfig();
        this.loginConfig = new SetLoginConfig();
        digester.addRule(this.fullPrefix, new SetPublicIdRule("setPublicId"));
        digester.addRule(this.fullPrefix, new IgnoreAnnotationsRule());
        digester.addRule(this.fullPrefix, new VersionRule());
        if (this.fragment) {
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/name", "setName", 0);
            digester.addRule(String.valueOf(this.fullPrefix) + "/absolute-ordering", new AbsoluteOrderingRule());
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ordering/after/name", "addAfterOrdering", 0);
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ordering/after/others", "addAfterOrderingOthers");
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ordering/before/name", "addBeforeOrdering", 0);
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ordering/before/others", "addBeforeOrderingOthers");
        } else {
            digester.addRule(String.valueOf(this.fullPrefix) + "/ordering", new RelativeOrderingRule());
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/absolute-ordering/name", "addAbsoluteOrdering", 0);
            digester.addCallMethod(String.valueOf(this.fullPrefix) + "/absolute-ordering/name/others", "addAbsoluteOrderingOthers");
        }
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/context-param", "addContextParam", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/context-param/param-name", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/context-param/param-value", 1);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/display-name", "setDisplayName", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/distributable", new SetDistributableRule());
        this.configureNamingRules(digester);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/error-page", "org.apache.catalina.deploy.ErrorPage");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/error-page", "addErrorPage", "org.apache.catalina.deploy.ErrorPage");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/error-page/error-code", "setErrorCode", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/error-page/exception-type", "setExceptionType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/error-page/location", "setLocation", 0);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/filter", "org.apache.catalina.deploy.FilterDef");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/filter", "addFilter", "org.apache.catalina.deploy.FilterDef");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/display-name", "setDisplayName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/filter-class", "setFilterClass", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/filter-name", "setFilterName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/icon/large-icon", "setLargeIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/icon/small-icon", "setSmallIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/async-supported", "setAsyncSupported", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter/init-param", "addInitParameter", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/filter/init-param/param-name", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/filter/init-param/param-value", 1);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/filter-mapping", "org.apache.catalina.deploy.FilterMap");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/filter-mapping", "addFilterMapping", "org.apache.catalina.deploy.FilterMap");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter-mapping/filter-name", "setFilterName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter-mapping/servlet-name", "addServletName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter-mapping/url-pattern", "addURLPattern", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/filter-mapping/dispatcher", "setDispatcher", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/listener/listener-class", "addListener", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/jsp-config", this.jspConfig);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group", "org.apache.catalina.deploy.JspPropertyGroup");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group", "addJspPropertyGroup", "org.apache.catalina.deploy.JspPropertyGroup");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/deferred-syntax-allowed-as-literal", "setDeferredSyntax", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/el-ignored", "setElIgnored", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/include-coda", "addIncludeCoda", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/include-prelude", "addIncludePrelude", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/is-xml", "setIsXml", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/page-encoding", "setPageEncoding", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/scripting-invalid", "setScriptingInvalid", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/trim-directive-whitespaces", "setTrimWhitespace", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/url-pattern", "setUrlPattern", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/default-content-type", "setDefaultContentType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/buffer", "setBuffer", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/jsp-property-group/error-on-undeclared-namespace", "setErrorOnUndeclaredNamespace", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/login-config", this.loginConfig);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/login-config", "org.apache.catalina.deploy.LoginConfig");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/login-config", "setLoginConfig", "org.apache.catalina.deploy.LoginConfig");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/login-config/auth-method", "setAuthMethod", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/login-config/realm-name", "setRealmName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/login-config/form-login-config/form-error-page", "setErrorPage", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/login-config/form-login-config/form-login-page", "setLoginPage", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/mime-mapping", "addMimeMapping", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/mime-mapping/extension", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/mime-mapping/mime-type", 1);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/security-constraint", "org.apache.catalina.deploy.SecurityConstraint");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/security-constraint", "addSecurityConstraint", "org.apache.catalina.deploy.SecurityConstraint");
        digester.addRule(String.valueOf(this.fullPrefix) + "/security-constraint/auth-constraint", new SetAuthConstraintRule());
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/auth-constraint/role-name", "addAuthRole", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/display-name", "setDisplayName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/user-data-constraint/transport-guarantee", "setUserConstraint", 0);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection", "org.apache.catalina.deploy.SecurityCollection");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection", "addCollection", "org.apache.catalina.deploy.SecurityCollection");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection/http-method", "addMethod", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection/http-method-omission", "addOmittedMethod", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection/url-pattern", "addPattern", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-constraint/web-resource-collection/web-resource-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/security-role/role-name", "addSecurityRole", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/servlet", new ServletDefCreateRule());
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/servlet", "addServlet", "org.apache.catalina.deploy.ServletDef");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/init-param", "addInitParameter", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/servlet/init-param/param-name", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/servlet/init-param/param-value", 1);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/jsp-file", "setJspFile", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/load-on-startup", "setLoadOnStartup", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/run-as/role-name", "setRunAs", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/security-role-ref", "addSecurityRoleRef", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/servlet/security-role-ref/role-link", 1);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/servlet/security-role-ref/role-name", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/servlet-class", "setServletClass", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/servlet-name", "setServletName", 0);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/servlet/multipart-config", "org.apache.catalina.deploy.MultipartDef");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/servlet/multipart-config", "setMultipartDef", "org.apache.catalina.deploy.MultipartDef");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/multipart-config/location", "setLocation", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/multipart-config/max-file-size", "setMaxFileSize", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/multipart-config/max-request-size", "setMaxRequestSize", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/multipart-config/file-size-threshold", "setFileSizeThreshold", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/async-supported", "setAsyncSupported", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/servlet/enabled", "setEnabled", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/servlet-mapping", new CallMethodMultiRule("addServletMapping", 2, 0));
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/servlet-mapping/servlet-name", 1);
        digester.addRule(String.valueOf(this.fullPrefix) + "/servlet-mapping/url-pattern", new CallParamMultiRule(0));
        digester.addRule(String.valueOf(this.fullPrefix) + "/session-config", this.sessionConfig);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/session-config", "org.apache.catalina.deploy.SessionConfig");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/session-config", "setSessionConfig", "org.apache.catalina.deploy.SessionConfig");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/session-timeout", "setSessionTimeout", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/name", "setCookieName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/domain", "setCookieDomain", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/path", "setCookiePath", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/comment", "setCookieComment", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/http-only", "setCookieHttpOnly", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/secure", "setCookieSecure", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/cookie-config/max-age", "setCookieMaxAge", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/session-config/tracking-mode", "addSessionTrackingMode", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/taglib", new TaglibLocationRule(false));
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/taglib", "addTaglib", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/taglib/taglib-location", 1);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/taglib/taglib-uri", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/jsp-config/taglib", new TaglibLocationRule(true));
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/jsp-config/taglib", "addTaglib", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/jsp-config/taglib/taglib-location", 1);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/jsp-config/taglib/taglib-uri", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/welcome-file-list/welcome-file", "addWelcomeFile", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/locale-encoding-mapping-list/locale-encoding-mapping", "addLocaleEncodingMapping", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/locale-encoding-mapping-list/locale-encoding-mapping/locale", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/locale-encoding-mapping-list/locale-encoding-mapping/encoding", 1);
    }

    protected void configureNamingRules(Digester digester) {
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/ejb-local-ref", "org.apache.catalina.deploy.ContextLocalEjb");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/ejb-local-ref", "addEjbLocalRef", "org.apache.catalina.deploy.ContextLocalEjb");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/ejb-link", "setLink", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/ejb-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/ejb-ref-type", "setType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/local", "setLocal", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-local-ref/local-home", "setHome", 0);
        this.configureInjectionRules(digester, "web-app/ejb-local-ref/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/ejb-ref", "org.apache.catalina.deploy.ContextEjb");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/ejb-ref", "addEjbRef", "org.apache.catalina.deploy.ContextEjb");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/ejb-link", "setLink", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/ejb-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/ejb-ref-type", "setType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/home", "setHome", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/ejb-ref/remote", "setRemote", 0);
        this.configureInjectionRules(digester, "web-app/ejb-ref/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/env-entry", "org.apache.catalina.deploy.ContextEnvironment");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/env-entry", "addEnvEntry", "org.apache.catalina.deploy.ContextEnvironment");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/env-entry/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/env-entry/env-entry-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/env-entry/env-entry-type", "setType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/env-entry/env-entry-value", "setValue", 0);
        this.configureInjectionRules(digester, "web-app/env-entry/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/resource-env-ref", "org.apache.catalina.deploy.ContextResourceEnvRef");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/resource-env-ref", "addResourceEnvRef", "org.apache.catalina.deploy.ContextResourceEnvRef");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-env-ref/resource-env-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-env-ref/resource-env-ref-type", "setType", 0);
        this.configureInjectionRules(digester, "web-app/resource-env-ref/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/message-destination", "org.apache.catalina.deploy.MessageDestination");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/message-destination", "addMessageDestination", "org.apache.catalina.deploy.MessageDestination");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination/display-name", "setDisplayName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination/icon/large-icon", "setLargeIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination/icon/small-icon", "setSmallIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination/message-destination-name", "setName", 0);
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/message-destination-ref", "org.apache.catalina.deploy.MessageDestinationRef");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/message-destination-ref", "addMessageDestinationRef", "org.apache.catalina.deploy.MessageDestinationRef");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination-ref/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination-ref/message-destination-link", "setLink", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination-ref/message-destination-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination-ref/message-destination-type", "setType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/message-destination-ref/message-destination-usage", "setUsage", 0);
        this.configureInjectionRules(digester, "web-app/message-destination-ref/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/resource-ref", "org.apache.catalina.deploy.ContextResource");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/resource-ref", "addResourceRef", "org.apache.catalina.deploy.ContextResource");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-ref/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-ref/res-auth", "setAuth", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-ref/res-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-ref/res-sharing-scope", "setScope", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/resource-ref/res-type", "setType", 0);
        this.configureInjectionRules(digester, "web-app/resource-ref/");
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/service-ref", "org.apache.catalina.deploy.ContextService");
        digester.addSetNext(String.valueOf(this.fullPrefix) + "/service-ref", "addServiceRef", "org.apache.catalina.deploy.ContextService");
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/description", "setDescription", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/display-name", "setDisplayname", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/icon/large-icon", "setLargeIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/icon/small-icon", "setSmallIcon", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/service-ref-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/service-interface", "setInterface", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/service-ref-type", "setType", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/wsdl-file", "setWsdlfile", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/jaxrpc-mapping-file", "setJaxrpcmappingfile", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/service-ref/service-qname", new ServiceQnameRule());
        digester.addRule(String.valueOf(this.fullPrefix) + "/service-ref/port-component-ref", new CallMethodMultiRule("addPortcomponent", 2, 1));
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/service-ref/port-component-ref/service-endpoint-interface", 0);
        digester.addRule(String.valueOf(this.fullPrefix) + "/service-ref/port-component-ref/port-component-link", new CallParamMultiRule(1));
        digester.addObjectCreate(String.valueOf(this.fullPrefix) + "/service-ref/handler", "org.apache.catalina.deploy.ContextHandler");
        digester.addRule(String.valueOf(this.fullPrefix) + "/service-ref/handler", new SetNextRule("addHandler", "org.apache.catalina.deploy.ContextHandler"));
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/handler/handler-name", "setName", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/handler/handler-class", "setHandlerclass", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/handler/init-param", "setProperty", 2);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/service-ref/handler/init-param/param-name", 0);
        digester.addCallParam(String.valueOf(this.fullPrefix) + "/service-ref/handler/init-param/param-value", 1);
        digester.addRule(String.valueOf(this.fullPrefix) + "/service-ref/handler/soap-header", new SoapHeaderRule());
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/handler/soap-role", "addSoapRole", 0);
        digester.addCallMethod(String.valueOf(this.fullPrefix) + "/service-ref/handler/port-name", "addPortName", 0);
        this.configureInjectionRules(digester, "web-app/service-ref/");
    }

    protected void configureInjectionRules(Digester digester, String base) {
        digester.addCallMethod(String.valueOf(this.prefix) + base + "injection-target", "addInjectionTarget", 2);
        digester.addCallParam(String.valueOf(this.prefix) + base + "injection-target/injection-target-class", 0);
        digester.addCallParam(String.valueOf(this.prefix) + base + "injection-target/injection-target-name", 1);
    }

    public void recycle() {
        this.jspConfig.isJspConfigSet = false;
        this.sessionConfig.isSessionConfigSet = false;
        this.loginConfig.isLoginConfigSet = false;
    }
}

