/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;

public class SSIEcho
implements SSICommand {
    protected static final String DEFAULT_ENCODING = "entity";
    protected static final String MISSING_VARIABLE_VALUE = "(none)";

    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        String encoding = DEFAULT_ENCODING;
        String originalValue = null;
        String errorMessage = ssiMediator.getConfigErrMsg();
        int i = 0;
        while (i < paramNames.length) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            if (paramName.equalsIgnoreCase("var")) {
                originalValue = paramValue;
            } else if (paramName.equalsIgnoreCase("encoding")) {
                if (this.isValidEncoding(paramValue)) {
                    encoding = paramValue;
                } else {
                    ssiMediator.log("#echo--Invalid encoding: " + paramValue);
                    writer.write(errorMessage);
                }
            } else {
                ssiMediator.log("#echo--Invalid attribute: " + paramName);
                writer.write(errorMessage);
            }
            ++i;
        }
        String variableValue = ssiMediator.getVariableValue(originalValue, encoding);
        if (variableValue == null) {
            variableValue = MISSING_VARIABLE_VALUE;
        }
        writer.write(variableValue);
        return System.currentTimeMillis();
    }

    protected boolean isValidEncoding(String encoding) {
        return encoding.equalsIgnoreCase("url") || encoding.equalsIgnoreCase(DEFAULT_ENCODING) || encoding.equalsIgnoreCase("none");
    }
}

