/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.env.emf;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.eclipse.emf.ecore.xml.type.impl.XMLTypeDocumentRootImpl;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.CORECONTENTType;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.DocumentRoot;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.MyreqifPackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.REQIF;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.REQIFTOOLEXTENSION;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.TOOLEXTENSIONSType;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.util.MyreqifResourceFactoryImpl;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFDeserializationTests {
    public static final String DATA_BASEDIR = "resources/input/org.eclipse.rmf.tests.serialization.env/data/";
    public static final String MODEL_BASEDIR = "resources/model/";
    private static HashMap<String, Object> backupRegistry = new HashMap();

    @BeforeClass
    public static void setupOnce() {
        backupRegistry = new HashMap();
        backupRegistry.putAll((Map<String, Object>)EPackage.Registry.INSTANCE);
    }

    @Before
    public void setUp() {
        EPackage.Registry.INSTANCE.clear();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
    }

    @AfterClass
    public static void tearDownOnce() {
        EPackage.Registry.INSTANCE.clear();
        EPackage.Registry.INSTANCE.putAll(backupRegistry);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredGeneratedPackage() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithGeneratedPackage(resource);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredGeneratedPackageAndNestedAnyTypesWithRedefinedNsPrefix() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple_toolExtensions_redefinedNsPrefix.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithGeneratedPackage(resource);
        this.validateAnyTypeInGeneratedPackage(resource, 1);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredGeneratedPackageAndNestedAnyAndEcoreTypes() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare_toolExtensions_AnyTypeAndEcoreType.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithGeneratedPackage(resource);
        this.validateAnyTypeInGeneratedPackage(resource, 2);
        this.validateEcoreInGeneratedPackage(resource, 2);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredGeneratedPackageCheckOptionsSideEffects() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
        xmlOptions.setProcessAnyXML(true);
        xmlOptions.setProcessSchemaLocations(true);
        options.put("XML_OPTIONS", xmlOptions);
        this.enableNewMethods(options);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithGeneratedPackage(resource);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredPackageInEcoreFile() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource ecoreResource = resourceSet.createResource(URI.createURI((String)"resources/model/myreqif.ecore", (boolean)true));
        ecoreResource.load(null);
        EPackage reqifPackage = (EPackage)ecoreResource.getContents().get(0);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)reqifPackage);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithDynamicEcore(resource, reqifPackage);
    }

    @Test
    public void testPositiveloadResourceWithPreregisteredPackageInXSDFile() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        XSDEcoreBuilder xsdEcoreBuilder = new XSDEcoreBuilder();
        Collection reqifPackages = xsdEcoreBuilder.generate(URI.createFileURI((String)"resources/model/myreqif.xsd"));
        EPackage reqifPackage = (EPackage)reqifPackages.iterator().next();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)reqifPackage);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resource.load(options);
        this.validateLoadErrors(resource);
        this.validateBareDataWithDynamicEcore(resource, reqifPackage);
    }

    @Test
    public void testPositiveloadResourceWithoutPackageInfo() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
        xmlOptions.setProcessAnyXML(true);
        options.put("XML_OPTIONS", xmlOptions);
        resource.load(options);
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject root = (EObject)resource.getContents().get(0);
        Assert.assertTrue((boolean)(root instanceof XMLTypeDocumentRootImpl));
        XMLTypeDocumentRootImpl documentRoot = (XMLTypeDocumentRootImpl)root;
        FeatureMap.Entry reqIFEntry = (FeatureMap.Entry)documentRoot.getMixed().get(0);
        Assert.assertEquals((Object)"REQ-IF", (Object)reqIFEntry.getEStructuralFeature().getName());
        Object reqifObject = reqIFEntry.getValue();
        Assert.assertTrue((boolean)(reqifObject instanceof AnyTypeImpl));
        AnyTypeImpl reqif = (AnyTypeImpl)reqifObject;
        FeatureMap.Entry coreContentEntry = (FeatureMap.Entry)reqif.getAny().get(0);
        Assert.assertEquals((Object)"CORE-CONTENT", (Object)coreContentEntry.getEStructuralFeature().getName());
        Object coreContentObject = coreContentEntry.getValue();
        Assert.assertTrue((boolean)(coreContentObject instanceof AnyTypeImpl));
        AnyTypeImpl coreContent = (AnyTypeImpl)coreContentObject;
        FeatureMap.Entry reqifCoreContentEntry = (FeatureMap.Entry)coreContent.getAny().get(0);
        Assert.assertEquals((Object)"REQ-IF-CONTENT", (Object)reqifCoreContentEntry.getEStructuralFeature().getName());
        this.validateLoadErrors(resource);
    }

    @Test
    public void testPositiveloadResourceWithLocationHintPackageInEcoreFile() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bareWithEcoreHint.xml";
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/xsd/2002/XSD", (Object)XSDPackage.eINSTANCE);
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        resource.load(options);
        EPackage reqifPackage = resourceSet.getPackageRegistry().getEPackage("http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd");
        this.validateLoadErrors(resource);
        this.validateBareDataWithDynamicEcore(resource, reqifPackage);
    }

    @Test
    public void testPositiveloadResourceWithLocationHintPackageInXSDFile() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bareWithSchemaHint.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableNewMethods(options);
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
        xmlOptions.setProcessSchemaLocations(true);
        options.put("XML_OPTIONS", xmlOptions);
        resource.load(options);
        EPackage reqifPackage = resourceSet.getPackageRegistry().getEPackage("http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd");
        this.validateLoadErrors(resource);
        this.validateBareDataWithDynamicEcore(resource, reqifPackage);
    }

    private void validateBareDataWithDynamicEcore(Resource resource, EPackage reqifPackage) {
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject documentRoot = (EObject)resource.getContents().get(0);
        Assert.assertFalse((boolean)(documentRoot instanceof DocumentRoot));
        EClass documentRootEClass = (EClass)reqifPackage.getEClassifier("DocumentRoot");
        Assert.assertEquals((Object)documentRootEClass, (Object)documentRoot.eClass());
        EStructuralFeature reqifFeature = documentRootEClass.getEStructuralFeature("rEQIF");
        Object reqifObject = documentRoot.eGet(reqifFeature);
        Assert.assertNotNull((Object)reqifObject);
        Assert.assertTrue((boolean)(reqifObject instanceof EObject));
        EObject reqif = (EObject)reqifObject;
        EClass reqifEClass = (EClass)reqifPackage.getEClassifier("REQIF");
        Assert.assertEquals((Object)reqifEClass, (Object)reqif.eClass());
        EStructuralFeature coreContentFeature = reqifEClass.getEStructuralFeature("cORECONTENT");
        Object coreContentObject = reqif.eGet(coreContentFeature);
        Assert.assertNotNull((Object)coreContentObject);
    }

    private void validateBareDataWithGeneratedPackage(Resource resource) {
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject root = (EObject)resource.getContents().get(0);
        Assert.assertTrue((boolean)(root instanceof DocumentRoot));
        DocumentRoot documentRoot = (DocumentRoot)root;
        Assert.assertNotNull((Object)documentRoot.getREQIF());
        REQIF reqif = documentRoot.getREQIF();
        Assert.assertNotNull((Object)reqif.getCORECONTENT());
        CORECONTENTType coreContent = reqif.getCORECONTENT();
        Assert.assertNotNull((Object)coreContent.getREQIFCONTENT());
    }

    private void validateAnyTypeInGeneratedPackage(Resource resource, int expectedExtensionSize) {
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject root = (EObject)resource.getContents().get(0);
        Assert.assertTrue((boolean)(root instanceof DocumentRoot));
        DocumentRoot documentRoot = (DocumentRoot)root;
        Assert.assertNotNull((Object)documentRoot.getREQIF());
        REQIF reqif = documentRoot.getREQIF();
        Assert.assertNotNull((Object)reqif.getTOOLEXTENSIONS());
        TOOLEXTENSIONSType toolExtensions = reqif.getTOOLEXTENSIONS();
        Assert.assertNotNull(toolExtensions.getREQIFTOOLEXTENSION());
        Assert.assertEquals((long)1L, (long)toolExtensions.getREQIFTOOLEXTENSION().size());
        REQIFTOOLEXTENSION reqifToolExtension = (REQIFTOOLEXTENSION)toolExtensions.getREQIFTOOLEXTENSION().get(0);
        Assert.assertNotNull((Object)reqifToolExtension.getAny());
        Assert.assertEquals((long)expectedExtensionSize, (long)reqifToolExtension.getAny().size());
        FeatureMap.Entry myExtensionEntry = (FeatureMap.Entry)reqifToolExtension.getAny().get(0);
        Object myExtensionObject = myExtensionEntry.getValue();
        Assert.assertTrue((boolean)(myExtensionObject instanceof AnyTypeImpl));
        Assert.assertEquals((Object)"myExtension", (Object)myExtensionEntry.getEStructuralFeature().getName());
    }

    private void validateEcoreInGeneratedPackage(Resource resource, int expectedExtensionSize) {
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject root = (EObject)resource.getContents().get(0);
        Assert.assertTrue((boolean)(root instanceof DocumentRoot));
        DocumentRoot documentRoot = (DocumentRoot)root;
        Assert.assertNotNull((Object)documentRoot.getREQIF());
        REQIF reqif = documentRoot.getREQIF();
        Assert.assertNotNull((Object)reqif.getTOOLEXTENSIONS());
        TOOLEXTENSIONSType toolExtensions = reqif.getTOOLEXTENSIONS();
        Assert.assertNotNull(toolExtensions.getREQIFTOOLEXTENSION());
        Assert.assertEquals((long)1L, (long)toolExtensions.getREQIFTOOLEXTENSION().size());
        REQIFTOOLEXTENSION reqifToolExtension = (REQIFTOOLEXTENSION)toolExtensions.getREQIFTOOLEXTENSION().get(0);
        Assert.assertNotNull((Object)reqifToolExtension.getAny());
        Assert.assertEquals((long)expectedExtensionSize, (long)reqifToolExtension.getAny().size());
        FeatureMap.Entry myExtensionEntry = (FeatureMap.Entry)reqifToolExtension.getAny().get(1);
        Object ePackageObject = myExtensionEntry.getValue();
        Assert.assertTrue((boolean)(ePackageObject instanceof EPackage));
        EPackage ePackage = (EPackage)ePackageObject;
        Assert.assertEquals((long)1L, (long)ePackage.getEClassifiers().size());
    }

    private void validateLoadErrors(Resource resource) {
        Assert.assertEquals((long)0L, (long)resource.getErrors().size());
        Assert.assertEquals((long)0L, (long)resource.getWarnings().size());
    }

    protected void enableNewMethods(Map<String, Object> options) {
        HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
        HashMap parserProperties = new HashMap();
        parserFeatures.put("http://xml.org/sax/features/namespaces", true);
        parserFeatures.put("http://xml.org/sax/features/namespace-prefixes", false);
        options.put("PARSER_FEATURES", parserFeatures);
        options.put("PARSER_PROPERTIES", parserProperties);
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
    }
}

