/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.internal.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.rmf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.rmf.serialization.XMLPersistenceMappingExtendedMetaDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersistenceMappingHandler
extends SAXXMLHandler {
    String xsiType;
    XMLPersistenceMappingExtendedMetaData xmlPersistenceMappingExtendedMetaData = null;
    XMLHandler.MyStack<LoadPattern> loadPatternStack = null;
    IProgressMonitor progressMonitor = null;
    int progressMonitorChunksRead = 0;
    int progressMonitorChunkSize = 2048;
    int progressMonitorLastStartInChunk = 0;
    int progressMonitorNumberOfChunksPerUpdate = 500;
    private Set<String> progressReportedNamespaces = new HashSet<String>();

    public XMLPersistenceMappingHandler(XMLResource xmlResource, XMLHelper helper, Map<?, ?> options) {
        super(xmlResource, helper, options);
        Map parserProperties;
        Object bufferSizeObject;
        Object parserPropertiesObject;
        Object extendedMetaDataOption = options.get("EXTENDED_META_DATA");
        if (extendedMetaDataOption != null && extendedMetaDataOption instanceof XMLPersistenceMappingExtendedMetaData) {
            this.xmlPersistenceMappingExtendedMetaData = (XMLPersistenceMappingExtendedMetaData)options.get("EXTENDED_META_DATA");
            this.extendedMetaData = this.xmlPersistenceMappingExtendedMetaData;
        } else {
            this.xmlPersistenceMappingExtendedMetaData = xmlResource == null || xmlResource.getResourceSet() == null ? XMLPersistenceMappingExtendedMetaData.INSTANCE : new XMLPersistenceMappingExtendedMetaDataImpl(xmlResource.getResourceSet().getPackageRegistry());
            this.extendedMetaData = this.xmlPersistenceMappingExtendedMetaData;
        }
        helper.setExtendedMetaData((ExtendedMetaData)this.xmlPersistenceMappingExtendedMetaData);
        Object progressMonitor = options.get("progress monitor");
        if (progressMonitor instanceof IProgressMonitor) {
            this.progressMonitor = (IProgressMonitor)progressMonitor;
        }
        if ((parserPropertiesObject = options.get("PARSER_PROPERTIES")) != null && parserPropertiesObject instanceof Map && (bufferSizeObject = (parserProperties = (Map)parserPropertiesObject).get("http://apache.org/xml/properties/input-buffer-size")) instanceof Integer) {
            this.progressMonitorChunkSize = (Integer)bufferSizeObject;
        }
        this.loadPatternStack = new XMLHandler.MyStack();
        this.xsiType = null;
        this.hrefAttribute = "_href";
        assert (this.xmlPersistenceMappingExtendedMetaData != null);
        assert (this.extendedMetaData != null);
    }

    protected EObject createObjectFromNamespaceAndType(EObject peekObject, EStructuralFeature feature, String namespace, String typeXMLName) {
        assert (this.xmlPersistenceMappingExtendedMetaData != null);
        assert (peekObject != null);
        assert (feature != null);
        assert (namespace != null);
        assert (typeXMLName != null);
        if (this.progressMonitor != null && namespace != null && !this.progressReportedNamespaces.contains(namespace)) {
            this.progressMonitor.subTask("Processing Namespace: " + namespace);
            this.progressReportedNamespaces.add(namespace);
        }
        this.contextFeature = feature;
        EPackage ePackage = this.getPackageForURI(namespace);
        this.contextFeature = null;
        if (ePackage != null) {
            EClassifier eClassifier = this.xmlPersistenceMappingExtendedMetaData.demandedPackages().contains(ePackage) ? this.xmlPersistenceMappingExtendedMetaData.demandType(namespace, typeXMLName) : this.xmlPersistenceMappingExtendedMetaData.getTypeByXMLName(namespace, typeXMLName, feature);
            EFactory eFactory = ePackage.getEFactoryInstance();
            if (eClassifier != null) {
                EObject obj = this.createObject(eFactory, eClassifier, false);
                if ((obj = this.validateCreateObjectFromFactory(eFactory, typeXMLName, obj, feature)) != null) {
                    this.setFeatureValue(peekObject, feature, obj);
                    this.processObject(obj);
                }
                return obj;
            }
            this.error((XMIException)new ClassNotFoundException(typeXMLName, eFactory, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            return null;
        }
        return null;
    }

    protected EObject validateCreateObjectFromFactory(EFactory factory, String typeName, EObject newObject, EStructuralFeature feature) {
        if (newObject != null) {
            Collection demandedPackages;
            if (this.extendedMetaData != null && !(demandedPackages = this.extendedMetaData.demandedPackages()).isEmpty() && demandedPackages.contains(newObject.eClass().getEPackage())) {
                if (this.xmlPersistenceMappingExtendedMetaData.isXMLPersistenceMappingEnabled(feature)) {
                    List wildcards = this.xmlPersistenceMappingExtendedMetaData.getWildcards(feature);
                    if (this.xmlPersistenceMappingExtendedMetaData.matches(wildcards, newObject.eClass().getEPackage().getNsURI())) {
                        return newObject;
                    }
                    return null;
                }
                if (this.recordUnknownFeature) {
                    EObject peekObject = this.objects.peekEObject();
                    if (!(peekObject instanceof AnyType)) {
                        AnyType anyType = this.getExtension(this.objects.peekEObject());
                        EStructuralFeature entryFeature = this.extendedMetaData.demandFeature(this.extendedMetaData.getNamespace(feature), this.extendedMetaData.getName(feature), true);
                        anyType.getAny().add(entryFeature, (Object)newObject);
                        this.contextFeature = entryFeature;
                    }
                    return newObject;
                }
                String namespace = this.extendedMetaData.getNamespace(feature);
                String name = this.extendedMetaData.getName(feature);
                EStructuralFeature wildcardFeature = this.extendedMetaData.getElementWildcardAffiliation(this.objects.peekEObject().eClass(), namespace, name);
                if (wildcardFeature != null) {
                    int processingKind = this.laxWildcardProcessing ? 2 : this.extendedMetaData.getProcessingKind(wildcardFeature);
                    switch (processingKind) {
                        case 2: 
                        case 3: {
                            return newObject;
                        }
                    }
                }
                newObject = null;
            }
        } else if (feature != null && factory != null && this.extendedMetaData != null) {
            if (this.recordUnknownFeature || this.processAnyXML) {
                EObject result = null;
                String namespace = this.extendedMetaData.getNamespace(factory.getEPackage());
                if (namespace == null) {
                    this.usedNullNamespacePackage = true;
                }
                EClassifier type = this.extendedMetaData.demandType(namespace, typeName);
                result = this.createObject(type.getEPackage().getEFactoryInstance(), type, false);
                EObject peekObject = this.objects.peekEObject();
                if (!(peekObject instanceof AnyType)) {
                    AnyType anyType = this.getExtension(peekObject);
                    EStructuralFeature entryFeature = this.extendedMetaData.demandFeature(this.extendedMetaData.getNamespace(feature), this.extendedMetaData.getName(feature), true);
                    anyType.getAny().add(entryFeature, (Object)result);
                    this.contextFeature = entryFeature;
                }
                return result;
            }
            String namespace = this.extendedMetaData.getNamespace(feature);
            String name = this.extendedMetaData.getName(feature);
            EStructuralFeature wildcardFeature = this.extendedMetaData.getElementWildcardAffiliation(this.objects.peekEObject().eClass(), namespace, name);
            if (wildcardFeature != null) {
                int processingKind = this.laxWildcardProcessing ? 2 : this.extendedMetaData.getProcessingKind(wildcardFeature);
                switch (processingKind) {
                    case 2: 
                    case 3: {
                        String factoryNamespace = this.extendedMetaData.getNamespace(factory.getEPackage());
                        if (factoryNamespace == null) {
                            this.usedNullNamespacePackage = true;
                        }
                        EClassifier type = this.extendedMetaData.demandType(factoryNamespace, typeName);
                        return this.createObject(type.getEPackage().getEFactoryInstance(), type, false);
                    }
                }
            }
        }
        this.validateCreateObjectFromFactory(factory, typeName, newObject);
        return newObject;
    }

    public void characters(char[] ch, int start, int length) {
        super.characters(ch, start, length);
        if (this.progressMonitor != null) {
            if (start < this.progressMonitorLastStartInChunk) {
                ++this.progressMonitorChunksRead;
            }
            if (this.progressMonitorChunksRead > this.progressMonitorNumberOfChunksPerUpdate) {
                this.progressMonitor.worked(this.progressMonitorChunksRead);
                this.progressMonitorChunksRead = 0;
            }
            this.progressMonitorLastStartInChunk = start;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.xmlPersistenceMappingExtendedMetaData != null) {
            this.elements.pop();
            this.types.pop();
            this.helper.popContext(this.prefixesToFactories);
            LoadPattern activeDeserializationRule = (LoadPattern)this.loadPatternStack.peek();
            if (activeDeserializationRule != null) {
                activeDeserializationRule.endElement(uri, localName);
                if (activeDeserializationRule.needsDelegateParent()) {
                    this.loadPatternStack.pop();
                    activeDeserializationRule = (LoadPattern)this.loadPatternStack.peek();
                    if (activeDeserializationRule != null) {
                        activeDeserializationRule.endElement(uri, localName);
                    }
                }
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    protected void handleFeature(String prefix, String name) {
        assert (this.useNewMethods);
        EObject peekObject = this.objects.peekEObject();
        if (peekObject == null) {
            this.types.push((Object)"error");
            this.error((XMIException)new FeatureNotFoundException(name, null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            return;
        }
        if (this.xmlPersistenceMappingExtendedMetaData != null) {
            String namespace = this.helper.getNamespaceURI(prefix);
            LoadPattern activeDeserializationRule = (LoadPattern)this.loadPatternStack.peek();
            if (activeDeserializationRule == null) {
                activeDeserializationRule = this.getLoadPattern(peekObject, prefix, name);
                assert (activeDeserializationRule != null) : "getLoadPattern() should never return null";
                this.loadPatternStack.push((Object)activeDeserializationRule);
            }
            if (activeDeserializationRule != null) {
                activeDeserializationRule.startElement(namespace, name);
                if (activeDeserializationRule.needsDelegateChild()) {
                    activeDeserializationRule = this.getLoadPattern(peekObject, prefix, name);
                    assert (activeDeserializationRule != null) : "getLoadPattern() should never return null";
                    this.loadPatternStack.push((Object)activeDeserializationRule);
                    activeDeserializationRule.startElement(namespace, name);
                } else if (activeDeserializationRule.needsDelegateSibling()) {
                    activeDeserializationRule = this.getLoadPattern(peekObject, prefix, name);
                    assert (activeDeserializationRule != null) : "getLoadPattern() should never return null";
                    this.loadPatternStack.pop();
                    this.loadPatternStack.push((Object)activeDeserializationRule);
                    activeDeserializationRule.startElement(namespace, name);
                }
            }
        } else {
            EStructuralFeature feature = this.getFeature(peekObject, prefix, name, true);
            if (feature != null) {
                int kind = this.helper.getFeatureKind(feature);
                if (kind == 1 || kind == 2) {
                    this.objects.push(null);
                    this.mixedTargets.push(null);
                    this.types.push((Object)feature);
                    if (!this.isNull()) {
                        this.text = new StringBuffer();
                    }
                } else if (this.extendedMetaData != null) {
                    EReference eReference = (EReference)feature;
                    boolean isContainment = eReference.isContainment();
                    if (!isContainment && !eReference.isResolveProxies() && this.extendedMetaData.getFeatureKind(feature) != 0) {
                        this.isIDREF = true;
                        this.objects.push(null);
                        this.mixedTargets.push(null);
                        this.types.push((Object)feature);
                        this.text = new StringBuffer();
                    } else {
                        this.createObject(peekObject, feature);
                        EObject childObject = this.objects.peekEObject();
                        if (childObject != null) {
                            if (isContainment) {
                                EStructuralFeature simpleFeature = this.extendedMetaData.getSimpleFeature(childObject.eClass());
                                if (simpleFeature != null) {
                                    this.isSimpleFeature = true;
                                    this.isIDREF = simpleFeature instanceof EReference;
                                    this.objects.push(null);
                                    this.mixedTargets.push(null);
                                    this.types.push((Object)simpleFeature);
                                    this.text = new StringBuffer();
                                }
                            } else if (!childObject.eIsProxy()) {
                                this.text = new StringBuffer();
                            }
                        }
                    }
                } else {
                    this.createObject(peekObject, feature);
                }
            } else if (this.xmlMap != null && (feature = this.getFeature(peekObject, null, "", true)) != null) {
                EFactory eFactory = this.getFactoryForPrefix(prefix);
                if (eFactory == null) {
                    eFactory = feature.getEContainingClass().getEPackage().getEFactoryInstance();
                }
                EObject newObject = null;
                newObject = this.createObject(eFactory, this.helper.getType(eFactory, name), false);
                if ((newObject = this.validateCreateObjectFromFactory(eFactory, name, newObject, feature)) != null) {
                    this.setFeatureValue(peekObject, feature, newObject);
                }
                this.processObject(newObject);
            } else {
                if (this.xmlMap != null) {
                    EFactory eFactory = this.getFactoryForPrefix(prefix);
                    EObject newObject = this.createObjectFromFactory(eFactory, name);
                    this.validateCreateObjectFromFactory(eFactory, name, newObject);
                    if (newObject != null) {
                        for (EReference eReference : peekObject.eClass().getEAllReferences()) {
                            if (!eReference.getEType().isInstance((Object)newObject)) continue;
                            this.setFeatureValue(peekObject, (EStructuralFeature)eReference, newObject);
                            this.processObject(newObject);
                            return;
                        }
                    }
                }
                this.handleUnknownFeature(prefix, name, true, peekObject, null);
            }
        }
    }

    protected LoadPattern getLoadPattern(EObject eObject, String prefix, String name) {
        assert (this.xmlPersistenceMappingExtendedMetaData != null);
        AbstractLoadPatternImpl deserializationRule = null;
        if (eObject instanceof AnyType) {
            EStructuralFeature feature = super.getFeature(eObject, prefix, name, true);
            deserializationRule = new LoadPatternEReferenceContained0100Impl(eObject, feature);
        } else {
            EStructuralFeature feature = this.getFeature(eObject, prefix, name, true);
            if (feature != null) {
                int featureSerializationStructure = this.xmlPersistenceMappingExtendedMetaData.getFeatureSerializationStructure(feature);
                if (feature instanceof EReference) {
                    EReference reference = (EReference)feature;
                    if (reference.isContainment()) {
                        switch (featureSerializationStructure) {
                            case 1: {
                                deserializationRule = new LoadPatternEReferenceContained0001Impl(eObject, feature);
                                break;
                            }
                            case 4: {
                                deserializationRule = new LoadPatternEReferenceContained0100Impl(eObject, feature);
                                break;
                            }
                            case 5: {
                                deserializationRule = new LoadPatternEReferenceContained0101Impl(eObject, feature);
                                break;
                            }
                            case 9: {
                                deserializationRule = new LoadPatternEReferenceContained1001Impl(eObject, feature);
                                break;
                            }
                            case -1: {
                                deserializationRule = new LoadPatternEReferenceContained0100Impl(eObject, feature);
                                break;
                            }
                            default: {
                                deserializationRule = new LoadPatternEReferenceContained1001Impl(eObject, feature);
                                break;
                            }
                        }
                    } else {
                        switch (featureSerializationStructure) {
                            case 4: {
                                deserializationRule = new LoadPatternEReferenceReferenced0100Impl(eObject, feature);
                                break;
                            }
                            case 5: {
                                deserializationRule = new LoadPatternEReferenceReferenced0101Impl(eObject, feature);
                                break;
                            }
                            case 9: {
                                deserializationRule = new LoadPatternEReferenceReferenced1001Impl(eObject, feature);
                                break;
                            }
                            case -1: {
                                deserializationRule = new LoadPatternEReferenceReferenced0100Impl(eObject, feature);
                                break;
                            }
                            default: {
                                deserializationRule = new LoadPatternEReferenceReferenced1001Impl(eObject, feature);
                                break;
                            }
                        }
                    }
                } else {
                    switch (featureSerializationStructure) {
                        case 4: {
                            deserializationRule = new LoadPatternEAttributeContained0100Impl(eObject, feature);
                            break;
                        }
                        case 8: {
                            deserializationRule = new LoadPatternEAttributeContained1000Impl(eObject, feature);
                            break;
                        }
                        case 12: {
                            deserializationRule = new LoadPatternEAttributeContained1100Impl(eObject, feature);
                            break;
                        }
                        case -1: {
                            deserializationRule = new LoadPatternEAttributeContained0100Impl(eObject, feature);
                            break;
                        }
                        default: {
                            deserializationRule = new LoadPatternEAttributeContained0100Impl(eObject, feature);
                            break;
                        }
                    }
                }
            } else {
                deserializationRule = new LoadPatternUnknownImpl(eObject, feature);
            }
        }
        assert (deserializationRule != null) : "getLoadPattern() should always return a LoadPattern (!=null)";
        return deserializationRule;
    }

    protected EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
        assert (object != null);
        assert (name != null);
        EStructuralFeature result = null;
        if (isElement && this.xmlPersistenceMappingExtendedMetaData != null) {
            String namespace = this.helper.getNamespaceURI(prefix);
            result = this.xmlPersistenceMappingExtendedMetaData.getFeatureByXMLElementName(object.eClass(), namespace, name);
        } else {
            result = super.getFeature(object, prefix, name, isElement);
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.loadPatternStack = null;
        this.hrefAttribute = "_href";
    }

    public void prepare(XMLResource resource, XMLHelper helper, Map<?, ?> options) {
        super.prepare(resource, helper, options);
        this.loadPatternStack = new XMLHandler.MyStack();
        this.useNewMethods = true;
        this.xsiType = null;
    }

    protected String getXSIType() {
        if (this.xsiType != null) {
            return this.xsiType;
        }
        return super.getXSIType();
    }

    protected void handleEndCreateObjectElement() {
        if (this.text == null) {
            this.objects.pop();
            this.mixedTargets.pop();
        } else {
            EObject object = this.objects.popEObject();
            if (this.mixedTargets.peek() != null && (object.eContainer() != null || this.suppressDocumentRoot || this.recordUnknownFeature && (this.eObjectToExtensionMap.containsValue(object) || ((InternalEObject)object).eDirectResource() != null))) {
                this.handleMixedText();
                this.mixedTargets.pop();
            }
        }
    }

    public void startDocument() {
        super.startDocument();
        if (this.progressMonitor != null) {
            this.progressMonitorChunksRead = 0;
            this.progressMonitorLastStartInChunk = 0;
            this.progressMonitor.beginTask("Reading resource '" + this.resourceURI + "'", this.getProgressMonitorTotalWork());
        }
    }

    public void endDocument() {
        super.endDocument();
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected int getProgressMonitorTotalWork() {
        int totalWork;
        block14: {
            totalWork = -1;
            URI uri = this.xmlResource.getURI();
            InputStream is = null;
            try {
                try {
                    is = URIConverter.INSTANCE.createInputStream(uri);
                    totalWork = is.available() / this.progressMonitorChunkSize;
                }
                catch (IOException iOException) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return totalWork;
    }

    protected EPackage handleMissingPackage(String uriString) {
        if (this.contextFeature != null && this.xmlPersistenceMappingExtendedMetaData != null && this.xmlPersistenceMappingExtendedMetaData.isXMLPersistenceMappingEnabled(this.contextFeature)) {
            return this.xmlPersistenceMappingExtendedMetaData.demandPackage(uriString);
        }
        return super.handleMissingPackage(uriString);
    }

    abstract class AbstractLoadPatternImpl
    implements LoadPattern {
        final EObject anchorEObject;
        final EStructuralFeature feature;
        int currentState;

        public AbstractLoadPatternImpl(EObject anchorEObject, EStructuralFeature feature) {
            this.anchorEObject = anchorEObject;
            this.feature = feature;
            this.currentState = 0;
        }

        public boolean needsDelegateChild() {
            return -1 == this.currentState;
        }

        public boolean needsDelegateParent() {
            return -2 == this.currentState;
        }

        public boolean needsDelegateSibling() {
            return -3 == this.currentState;
        }
    }

    static interface LoadPattern {
        public static final int STATE_READY = 0;
        public static final int STATE_HAS_SEEN_START_FEATURE_WRAPPER_ELEMENT = 1;
        public static final int STATE_HAS_SEEN_START_FEATURE_ELEMENT = 2;
        public static final int STATE_HAS_SEEN_START_CLASSIFIER_WRAPPER_ELEMENT = 3;
        public static final int STATE_HAS_SEEN_START_CLASSIFIER_ELEMENT = 4;
        public static final int STATE_HAS_SEEN_END_FEATURE_WRAPPER_ELEMENT = 5;
        public static final int STATE_HAS_SEEN_END_FEATURE_ELEMENT = 6;
        public static final int STATE_HAS_SEEN_END_CLASSIFIER_WRAPPER_ELEMENT = 7;
        public static final int STATE_HAS_SEEN_END_CLASSIFIER_ELEMENT = 8;
        public static final int STATE_DELEGATE_CHILD_NEEDED = -1;
        public static final int STATE_DELEGATE_PARENT_NEEDED = -2;
        public static final int STATE_DELEGATE_SIBLING_NEEDED = -3;
        public static final int STATE_UNEXPECTED_ELEMENT = -100;

        public void startElement(String var1, String var2);

        public void endElement(String var1, String var2);

        public boolean needsDelegateChild();

        public boolean needsDelegateSibling();

        public boolean needsDelegateParent();
    }

    class LoadPatternEAttributeContained0100Impl
    extends AbstractLoadPatternImpl {
        String featureName;
        int depthsOfUnknownElements;
        String value;

        public LoadPatternEAttributeContained0100Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureName = null;
            this.depthsOfUnknownElements = 0;
            this.value = null;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = 2;
                    this.featureName = xmlName;
                    XMLPersistenceMappingHandler.this.types.push((Object)this.feature);
                    if (XMLPersistenceMappingHandler.this.isNull()) break;
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 2: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case 6: {
                    if (this.featureName.equals(xmlName)) {
                        XMLPersistenceMappingHandler.this.text = new StringBuffer();
                        this.currentState = 2;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 2: {
                    if (XMLPersistenceMappingHandler.this.isNull()) {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, null);
                    } else {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, XMLPersistenceMappingHandler.this.text == null ? null : XMLPersistenceMappingHandler.this.text.toString());
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 6;
                    break;
                }
                case 6: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 6;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEAttributeContained1000Impl
    extends AbstractLoadPatternImpl {
        String featureWrapperName;
        int depthsOfUnknownElements;

        public LoadPatternEAttributeContained1000Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureWrapperName = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = 1;
                    this.featureWrapperName = xmlName;
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 1: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case 5: {
                    if (this.featureWrapperName.equals(xmlName)) {
                        this.currentState = 1;
                        XMLPersistenceMappingHandler.this.text = new StringBuffer();
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 1: {
                    if (XMLPersistenceMappingHandler.this.text == null) {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, null);
                    } else {
                        String svalues = XMLPersistenceMappingHandler.this.text.toString();
                        StringTokenizer st = new StringTokenizer(svalues);
                        while (st.hasMoreTokens()) {
                            String svalue = st.nextToken();
                            XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, svalue);
                        }
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 5;
                    break;
                }
                case 5: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 5;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEAttributeContained1100Impl
    extends AbstractLoadPatternImpl {
        String featureWrapperName;
        int depthsOfUnknownElements;

        public LoadPatternEAttributeContained1100Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureWrapperName = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureWrapperName = xmlName;
                    this.currentState = 1;
                    break;
                }
                case 1: {
                    this.currentState = 2;
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 2: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case 5: {
                    if (this.featureWrapperName == xmlName) {
                        this.currentState = 1;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case 6: {
                    this.currentState = 2;
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 1: {
                    this.currentState = 0;
                    break;
                }
                case 2: {
                    XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, XMLPersistenceMappingHandler.this.text == null ? null : XMLPersistenceMappingHandler.this.text.toString());
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 0;
                    break;
                }
                case 5: {
                    this.currentState = -2;
                    break;
                }
                case 6: {
                    this.currentState = 5;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 6;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceContained0001Impl
    extends AbstractLoadPatternImpl {
        String classifierName;

        public LoadPatternEReferenceContained0001Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.classifierName = null;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = 4;
                    this.classifierName = xmlName;
                    XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    break;
                }
                case 4: {
                    this.currentState = -1;
                    break;
                }
                case 8: {
                    if (xmlName.equals(this.classifierName)) {
                        this.currentState = 4;
                        XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 4: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case 8: {
                    this.currentState = -2;
                    break;
                }
                case -1: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case -3: 
                case -2: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceContained0100Impl
    extends AbstractLoadPatternImpl {
        String featureName;

        public LoadPatternEReferenceContained0100Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = 2;
                    this.featureName = xmlName;
                    XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                    break;
                }
                case 2: {
                    this.currentState = -1;
                    break;
                }
                case 6: {
                    if (this.featureName.equals(xmlName)) {
                        this.currentState = 2;
                        XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 2: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 6;
                    break;
                }
                case 6: {
                    this.currentState = -2;
                    break;
                }
                case -1: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 6;
                    break;
                }
                case -3: 
                case -2: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceContained0101Impl
    extends AbstractLoadPatternImpl {
        String featureName;

        public LoadPatternEReferenceContained0101Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureName = null;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureName = xmlName;
                    this.currentState = 2;
                    break;
                }
                case 2: {
                    this.currentState = 4;
                    XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    break;
                }
                case 4: {
                    this.currentState = -1;
                    break;
                }
                case 8: {
                    this.currentState = 4;
                    XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    break;
                }
                case 6: {
                    if (this.featureName.equals(xmlName)) {
                        this.currentState = 2;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 2: {
                    if (this.feature.isMany()) {
                        EList values = (EList)this.anchorEObject.eGet(this.feature);
                        values.clear();
                    } else {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, null);
                    }
                    this.currentState = 6;
                    break;
                }
                case 4: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case 8: {
                    this.currentState = 6;
                    break;
                }
                case 6: {
                    this.currentState = -2;
                    break;
                }
                case -1: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case -3: 
                case -2: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceContained1001Impl
    extends AbstractLoadPatternImpl {
        String featureWrapperName;

        public LoadPatternEReferenceContained1001Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureWrapperName = null;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureWrapperName = xmlName;
                    this.currentState = 1;
                    break;
                }
                case 1: {
                    this.currentState = 4;
                    XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    break;
                }
                case 4: {
                    this.currentState = -1;
                    break;
                }
                case 8: {
                    this.currentState = 4;
                    XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    break;
                }
                case 5: {
                    if (this.featureWrapperName.equals(xmlName)) {
                        this.currentState = 1;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 1: {
                    if (this.feature.isMany()) {
                        EList values = (EList)this.anchorEObject.eGet(this.feature);
                        values.clear();
                    } else {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, null);
                    }
                    this.currentState = 5;
                    break;
                }
                case 4: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case 8: {
                    this.currentState = 5;
                    break;
                }
                case 5: {
                    this.currentState = -2;
                    break;
                }
                case -1: {
                    XMLPersistenceMappingHandler.this.handleEndCreateObjectElement();
                    this.currentState = 8;
                    break;
                }
                case -3: 
                case -2: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceReferenced0100Impl
    extends AbstractLoadPatternImpl {
        String featureName;
        InternalEObject proxy;
        int depthsOfUnknownElements;

        public LoadPatternEReferenceReferenced0100Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureName = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = 2;
                    XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                    this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.objects.peekEObject();
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    this.featureName = xmlName;
                    break;
                }
                case 2: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case 6: {
                    if (this.featureName.equals(xmlName)) {
                        this.currentState = 2;
                        XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                        this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.objects.peekEObject();
                        XMLPersistenceMappingHandler.this.text = new StringBuffer();
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 2: {
                    if (this.proxy != null) {
                        XMLPersistenceMappingHandler.this.handleProxy(this.proxy, String.valueOf(XMLPersistenceMappingHandler.this.resourceURI.toString()) + "#" + XMLPersistenceMappingHandler.this.text.toString());
                        XMLPersistenceMappingHandler.this.objects.pop();
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 6;
                    break;
                }
                case 6: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 6;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceReferenced0101Impl
    extends AbstractLoadPatternImpl {
        String featureName;
        InternalEObject proxy;
        int depthsOfUnknownElements;

        public LoadPatternEReferenceReferenced0101Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureName = null;
            this.proxy = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureName = xmlName;
                    this.currentState = 2;
                    break;
                }
                case 2: {
                    this.currentState = 4;
                    this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 4: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case 8: {
                    this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    this.currentState = 4;
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 6: {
                    if (this.featureName.equals(xmlName)) {
                        this.currentState = 2;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 2: {
                    this.currentState = 6;
                    break;
                }
                case 4: {
                    if (this.proxy != null) {
                        XMLPersistenceMappingHandler.this.handleProxy(this.proxy, String.valueOf(XMLPersistenceMappingHandler.this.resourceURI.toString()) + "#" + XMLPersistenceMappingHandler.this.text.toString());
                        XMLPersistenceMappingHandler.this.objects.pop();
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 8;
                    break;
                }
                case 8: {
                    this.currentState = 6;
                    break;
                }
                case 6: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 8;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceReferenced1001Impl
    extends AbstractLoadPatternImpl {
        InternalEObject proxy;
        String featureWrapperName;
        int depthsOfUnknownElements;

        public LoadPatternEReferenceReferenced1001Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.proxy = null;
            this.featureWrapperName = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureWrapperName = xmlName;
                    this.currentState = 1;
                    break;
                }
                case 1: {
                    this.currentState = 4;
                    this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 4: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case 8: {
                    this.currentState = 4;
                    this.proxy = (InternalEObject)XMLPersistenceMappingHandler.this.createObjectFromNamespaceAndType(this.anchorEObject, this.feature, namespace, xmlName);
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 5: {
                    if (this.featureWrapperName.equals(xmlName)) {
                        this.currentState = 1;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 1: {
                    if (this.feature.isMany()) {
                        EList values = (EList)this.anchorEObject.eGet(this.feature);
                        values.clear();
                    } else {
                        XMLPersistenceMappingHandler.this.setFeatureValue(this.anchorEObject, this.feature, null);
                    }
                    this.currentState = 5;
                    break;
                }
                case 4: {
                    if (this.proxy != null) {
                        XMLPersistenceMappingHandler.this.objects.pop();
                        XMLPersistenceMappingHandler.this.handleProxy(this.proxy, String.valueOf(XMLPersistenceMappingHandler.this.resourceURI.toString()) + "#" + XMLPersistenceMappingHandler.this.text.toString());
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 8;
                    break;
                }
                case 8: {
                    this.currentState = 5;
                    break;
                }
                case 5: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 8;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternEReferenceReferenced1100Impl
    extends AbstractLoadPatternImpl {
        String featureWrapperName;
        EObject proxy;
        int depthsOfUnknownElements;

        public LoadPatternEReferenceReferenced1100Impl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.featureWrapperName = null;
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.featureWrapperName = xmlName;
                    this.currentState = 1;
                    break;
                }
                case 1: {
                    this.currentState = 2;
                    XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case 2: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case 5: {
                    if (this.featureWrapperName.equals(xmlName)) {
                        this.currentState = 1;
                        break;
                    }
                    this.currentState = -3;
                    break;
                }
                case 6: {
                    this.currentState = 2;
                    XMLPersistenceMappingHandler.this.createObject(this.anchorEObject, this.feature);
                    XMLPersistenceMappingHandler.this.text = new StringBuffer();
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case 1: {
                    this.currentState = 0;
                    break;
                }
                case 2: {
                    if (this.proxy != null) {
                        XMLPersistenceMappingHandler.this.handleProxy((InternalEObject)XMLPersistenceMappingHandler.this.objects.peekEObject(), String.valueOf(XMLPersistenceMappingHandler.this.resourceURI.toString()) + "#" + XMLPersistenceMappingHandler.this.text.toString());
                        XMLPersistenceMappingHandler.this.objects.pop();
                    }
                    XMLPersistenceMappingHandler.this.text = null;
                    this.currentState = 0;
                    break;
                }
                case 5: {
                    this.currentState = -2;
                    break;
                }
                case 6: {
                    this.currentState = 5;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = 6;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }

    class LoadPatternUnknownImpl
    extends AbstractLoadPatternImpl {
        int depthsOfUnknownElements;

        public LoadPatternUnknownImpl(EObject anchorEObject, EStructuralFeature feature) {
            super(anchorEObject, feature);
            this.depthsOfUnknownElements = 0;
        }

        public void startElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -100;
                    this.depthsOfUnknownElements = 1;
                    XMLPersistenceMappingHandler.this.types.push((Object)"error");
                    XMLPersistenceMappingHandler.this.error((XMIException)new FeatureNotFoundException(xmlName, null, XMLPersistenceMappingHandler.this.getLocation(), XMLPersistenceMappingHandler.this.getLineNumber(), XMLPersistenceMappingHandler.this.getColumnNumber()));
                    break;
                }
                case -100: {
                    ++this.depthsOfUnknownElements;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }

        public void endElement(String namespace, String xmlName) {
            switch (this.currentState) {
                case 0: {
                    this.currentState = -2;
                    break;
                }
                case -100: {
                    --this.depthsOfUnknownElements;
                    if (this.depthsOfUnknownElements >= 0) break;
                    this.currentState = -2;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    assert (false) : "handshake error: the dispatcher should have switched to another load pattern instance (state=" + this.currentState + ", startElement)";
                    break;
                }
                default: {
                    assert (false) : "state machine error: unsupported state (state =" + this.currentState + ", startElement)";
                    break;
                }
            }
        }
    }
}

