/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.presentation.id.provider;

import java.util.Collection;
import java.util.List;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.provider.ProrPresentationConfigurationItemProvider;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdConfiguration;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdPackage;
import org.eclipse.rmf.reqif10.pror.presentation.id.provider.IDEditPlugin;
import org.eclipse.rmf.reqif10.pror.presentation.ui.IdLabelCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdConfigurationItemProvider
extends ProrPresentationConfigurationItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private EContentAdapter contentAdapter;
    IProrCellRenderer renderer = null;

    public IdConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPrefixPropertyDescriptor(object);
            this.addCountPropertyDescriptor(object);
            this.addVerticalAlignPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPrefixPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_prefix_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_prefix_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__PREFIX, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_count_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_count_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__COUNT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addVerticalAlignPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_verticalAlign_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_verticalAlign_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__VERTICAL_ALIGN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        IdConfiguration idConfiguration = (IdConfiguration)object;
        if (idConfiguration.getDatatype() == null) {
            return this.getString("_UI_IdConfiguration_type_not_set");
        }
        return this.getString("_UI_IdConfiguration_type", new Object[]{idConfiguration.getDatatype().getLongName(), idConfiguration.getCount()});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(IdConfiguration.class)) {
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return IDEditPlugin.INSTANCE;
    }

    public void registerPresentationConfiguration(final ProrPresentationConfiguration config, final EditingDomain editingDomain) {
        this.registerModelListener((IdConfiguration)config, editingDomain);
        config.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == ConfigurationPackage.Literals.PROR_PRESENTATION_CONFIGURATION__DATATYPE) {
                    IdConfigurationItemProvider.this.unregisterModelListener(config);
                    IdConfigurationItemProvider.this.registerModelListener((IdConfiguration)config, editingDomain);
                }
            }
        });
    }

    public void unregisterPresentationConfiguration(ProrPresentationConfiguration config) {
        this.unregisterModelListener(config);
    }

    private void registerModelListener(final IdConfiguration config, final EditingDomain editingDomain) {
        if (this.contentAdapter != null) {
            throw new IllegalStateException("Cannot register IDConfigAdapter without unregistering first!");
        }
        this.contentAdapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getNotifier() instanceof SpecElementWithAttributes) {
                    IdConfigurationItemProvider.this.updateSpecElementIfNecessary(config, (SpecElementWithAttributes)notification.getNotifier(), editingDomain);
                }
            }

            public void setTarget(Notifier target) {
                super.setTarget(target);
                if (target instanceof SpecElementWithAttributes) {
                    IdConfigurationItemProvider.this.updateSpecElementIfNecessary(config, (SpecElementWithAttributes)target, editingDomain);
                }
            }
        };
        ReqIF10Util.getReqIF((Object)config).getCoreContent().eAdapters().add((Object)this.contentAdapter);
    }

    protected void updateSpecElementIfNecessary(IdConfiguration config, SpecElementWithAttributes target, EditingDomain editingDomain) {
        if (config.getDatatype() == null) {
            return;
        }
        SpecElementWithAttributes specElement = target;
        SpecType type = ReqIF10Util.getSpecType((SpecElementWithAttributes)specElement);
        if (type == null) {
            return;
        }
        AttributeDefinitionString attrDef = null;
        for (AttributeDefinition ad : type.getSpecAttributes()) {
            DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeDefinition)ad);
            if (!config.getDatatype().equals(dd)) continue;
            attrDef = (AttributeDefinitionString)ad;
            break;
        }
        if (attrDef == null) {
            return;
        }
        AttributeValueString value = (AttributeValueString)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)specElement, attrDef);
        if (value != null) {
            return;
        }
        value = (AttributeValueString)ReqIF10Util.createAttributeValue(attrDef);
        int newCount = config.getCount() + 1;
        value.setTheValue(String.valueOf(config.getPrefix()) + newCount);
        String label = "Assigning ID " + config.getPrefix() + newCount;
        CompoundCommand cmd = new CompoundCommand(label);
        cmd.append(SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)IdPackage.Literals.ID_CONFIGURATION__COUNT, (Object)newCount));
        cmd.append(AddCommand.create((EditingDomain)editingDomain, (Object)specElement, (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)value));
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    private void unregisterModelListener(ProrPresentationConfiguration config) {
        if (this.contentAdapter != null) {
            ReqIF10Util.getReqIF((Object)config).getCoreContent().eAdapters().remove((Object)this.contentAdapter);
            this.contentAdapter = null;
        }
    }

    public Command handleDragAndDrop(Collection<?> source, Object target, EditingDomain editingDomain, int operation) {
        return null;
    }

    public String getLabel(AttributeValue av) {
        return null;
    }

    public boolean canEdit() {
        return false;
    }

    public IProrCellRenderer getCellRenderer(AttributeValue av) {
        if (this.renderer == null) {
            this.renderer = new IdLabelCellRenderer();
        }
        return this.renderer;
    }

    public CellEditor getCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, AttributeValue av, SpecElementWithAttributes parent, Object affectedObject) {
        return null;
    }

    public Class<? extends DatatypeDefinition> suggestAsDefault() {
        return null;
    }
}

