/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.propertiesview;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.DefaultCellRendererProvider;
import org.agilemore.agilegrid.ICellRenderer;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.TextCellRenderer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyCellRenderer;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyContentProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ProrPropertyCellRendererProvider
extends DefaultCellRendererProvider {
    private final ProrPropertyCellRenderer attributeCellRenderer;
    private final TextCellRenderer categoryCellRenderer;
    private final SimpleTextCellRenderer defaultAttributeRenderer;
    private ProrPropertyContentProvider contentProvider;

    public ProrPropertyCellRendererProvider(AgileGrid agileGrid, AdapterFactory adapterFactory, ProrPropertyContentProvider contentProvider) {
        super(agileGrid);
        this.contentProvider = contentProvider;
        this.attributeCellRenderer = new ProrPropertyCellRenderer(agileGrid, adapterFactory);
        this.categoryCellRenderer = new TextCellRenderer(agileGrid, 1);
        this.categoryCellRenderer.setDefaultBackground(SWTResourceManager.getColor((int)22));
        this.defaultAttributeRenderer = new SimpleTextCellRenderer(agileGrid);
    }

    public ICellRenderer getCellRenderer(int row, int col) {
        ProrPropertyContentProvider.PropertyRow propertyRow = this.contentProvider.getRowContent(row);
        if (propertyRow instanceof ProrPropertyContentProvider.Category) {
            return this.categoryCellRenderer;
        }
        if (propertyRow instanceof ProrPropertyContentProvider.Descriptor) {
            ProrPropertyContentProvider.Descriptor descriptor = (ProrPropertyContentProvider.Descriptor)propertyRow;
            if (col == 0) {
                return super.getCellRenderer(row, col);
            }
            if (descriptor.isRMFSpecific()) {
                return this.attributeCellRenderer;
            }
            return this.defaultAttributeRenderer;
        }
        throw new IllegalArgumentException("Unexpected: " + propertyRow);
    }

    private class SimpleTextCellRenderer
    extends TextCellRenderer {
        public SimpleTextCellRenderer(AgileGrid agileGrid) {
            super(agileGrid);
        }

        protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
            ProrPropertyContentProvider.PropertyRow propertyRow = ProrPropertyCellRendererProvider.this.contentProvider.getRowContent(row);
            if (!(propertyRow instanceof ProrPropertyContentProvider.Descriptor)) {
                return;
            }
            IItemPropertyDescriptor propertyDescriptor = ((ProrPropertyContentProvider.Descriptor)propertyRow).getItemPropertyDescriptor();
            Object propertyValue = propertyDescriptor.getPropertyValue(ProrPropertyCellRendererProvider.this.contentProvider.getElement());
            IItemLabelProvider labelProvider = propertyDescriptor.getLabelProvider(propertyValue);
            Image image = ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(propertyValue));
            this.drawTextImage(gc, " " + propertyRow.toString(), this.alignment, image, this.alignment, rect.x + 2, rect.y + 1, rect.width - 1, rect.height - 1);
        }
    }
}

