/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.traceability.builder.Activator;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.builder.exceptions.BuilderException;
import org.polarsys.reqcycle.traceability.builder.impl.DelegatedAndDecoratedBuilderCallBack;
import org.polarsys.reqcycle.traceability.builder.impl.ProxyResolutionBuilderCallbackWrapper;
import org.polarsys.reqcycle.traceability.builder.impl.TraceabilityVisitor;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class TraceabilityBuilder
implements ITraceabilityBuilder {
    @Inject
    IReachableManager manager;
    @Inject
    ILogger logger;
    @Inject
    IReachableListenerManager listener;

    @Override
    public void build(Reachable t, ITraceabilityBuilder.IBuilderCallBack callBack, boolean forceBuild) throws BuilderException {
        block12: {
            callBack = new DelegatedAndDecoratedBuilderCallBack(callBack);
            try {
                ReachableObject object;
                IReachableHandler h = this.manager.getHandlerFromReachable(t);
                if (h == null || (object = h.getFromReachable(t)) == null) break block12;
                ProxyResolver proxyResolver = h.getProxyResolver();
                if (proxyResolver != null) {
                    callBack = new ProxyResolutionBuilderCallbackWrapper(callBack, proxyResolver);
                }
                Reachable reachable = object.getReachable();
                if (forceBuild || callBack.needsBuild(reachable)) {
                    if (Activator.getDefault().isDebugging()) {
                        this.logger.trace(String.format("build for %s starting", t.toString()));
                    }
                    callBack.startBuild(reachable);
                    try {
                        IVisitable visitable = object.getVisitable();
                        TraceabilityVisitor visitor = new TraceabilityVisitor(callBack);
                        ZigguratInject.inject((Object[])new Object[]{visitor});
                        visitable.accept((IVisitor)visitor);
                        visitable.dispose();
                        if (proxyResolver != null) {
                            proxyResolver.dispose();
                        }
                        callBack.endBuild(reachable);
                        if (Activator.getDefault().isDebugging()) {
                            this.logger.trace(String.format("build for %s ended", t.toString()));
                        }
                        break block12;
                    }
                    catch (VisitableException e) {
                        callBack.errorOccurs(reachable, e);
                        if (Activator.getDefault().isDebugging()) {
                            this.logger.trace(String.format("build for %s failed", t.toString()));
                        }
                        break block12;
                    }
                    catch (Throwable e2) {
                        callBack.errorOccurs(reachable, e2);
                    }
                    break block12;
                }
                if (Activator.getDefault().isDebugging()) {
                    this.logger.trace(String.format("build for %s unnecessary", t.toString()));
                }
            }
            catch (IReachableHandlerException iReachableHandlerException) {
                throw new BuilderException();
            }
        }
    }
}

