/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.xcos.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.EmptyVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitable;
import org.polarsys.reqcycle.xcos.model.XcosElement;
import org.polarsys.reqcycle.xcos.model.XcosLabelProvider;
import org.polarsys.reqcycle.xcos.model.XcosModelFactory;
import org.polarsys.reqcycle.xcos.model.XcosVisitable;

public class XcosReachableObject
implements ReachableObject {
    private Reachable reachable = null;
    IFile file = null;
    private XcosElement element = null;

    public XcosReachableObject(Reachable t) {
        this.reachable = t;
        String path = t.trimFragment().toString().replaceFirst("platform:", "");
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        this.element = t.getFragment() == null ? this.getModel((IResource)this.file) : null;
    }

    private XcosElement getModel(IResource res) {
        return XcosModelFactory.getModel(res);
    }

    public Object getAdapter(Class adapter) {
        if (ILabelProvider.class.equals((Object)adapter)) {
            return new XcosLabelProvider();
        }
        if (XcosElement.class.equals((Object)adapter)) {
            return this.element;
        }
        return null;
    }

    public IVisitable getVisitable() throws VisitableException {
        if (this.element != null) {
            return new XcosVisitable(this.element);
        }
        return new EmptyVisitable();
    }

    public String getRevisionIdentification() {
        return String.valueOf(this.file.getLocalTimeStamp());
    }

    public Reachable getReachable() {
        return this.reachable;
    }
}

