/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.types.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.polarsys.reqcycle.types.ICachedTypedChecker;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypeChecker;
import org.polarsys.reqcycle.types.impl.TypesManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class Type
implements IType {
    private String label;
    private String id;
    private ImageDescriptor desc;
    private String subTypeOf;
    private Class<? extends ITypeChecker> checker;
    protected ITypeChecker instance = null;
    public IType subType = null;
    @Inject
    ICachedTypedChecker cache;

    public Type() {
    }

    public Type(String id, IType parent) {
        this.setChecker(parent.getCheckerClass());
        this.setIcon(parent.getIcon());
        this.setId(id);
        this.setLabel(parent.getLabel());
        this.setSubTypeOf(parent.getId());
    }

    protected ITypeChecker getChecker() {
        if (this.instance == null) {
            try {
                this.instance = this.checker.newInstance();
                ZigguratInject.inject((Object[])new Object[]{this.instance});
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.instance;
    }

    @Override
    public boolean is(Reachable reachable) {
        if (this.cache != null) {
            return this.cache.is(reachable, this.getChecker());
        }
        return this.getChecker().apply(reachable);
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setIcon(ImageDescriptor desc) {
        this.desc = desc;
    }

    protected void setSubTypeOf(String type) {
        this.subTypeOf = type;
    }

    protected void setChecker(Class<? extends ITypeChecker> aClass) {
        this.checker = aClass;
    }

    protected void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.desc;
    }

    @Override
    public IType getSuperType() {
        Iterator iterator;
        if (this.subType == null && (iterator = Iterables.filter(TypesManager.allTypes.values(), (Predicate)new Predicate<IType>(){

            public boolean apply(IType t) {
                return Type.this.subTypeOf != null && Type.this.subTypeOf.equals(t.getId());
            }
        }).iterator()).hasNext()) {
            this.subType = (IType)iterator.next();
        }
        return this.subType;
    }

    @Override
    public List<IType.FieldDescriptor> getDescriptors() {
        LinkedList<IType.FieldDescriptor> descriptors = new LinkedList<IType.FieldDescriptor>();
        for (Field f : this.getFieldsToInject()) {
            if (f.isAnnotationPresent(IInjectedTypeChecker.InjectValueName.class)) {
                IInjectedTypeChecker.InjectValueName annotation = f.getAnnotation(IInjectedTypeChecker.InjectValueName.class);
                descriptors.add(new IType.FieldURIDescriptor(f.getName(), f.getType(), annotation.type()));
                continue;
            }
            descriptors.add(new IType.FieldDescriptor(f.getName(), f.getType()));
        }
        return descriptors;
    }

    protected List<Field> getFieldsToInject() {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<? extends ITypeChecker> current = this.getCheckerClass();
        if (IInjectedTypeChecker.class.isAssignableFrom(current)) {
            while (current != null) {
                Field[] fieldArray = current.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (f.isAnnotationPresent(IInjectedTypeChecker.InjectValue.class) || f.isAnnotationPresent(IInjectedTypeChecker.InjectValueName.class)) {
                        fields.add(f);
                    }
                    ++n2;
                }
                current = current.getSuperclass();
            }
        }
        return fields;
    }

    @Override
    public boolean isExtensible() {
        return IInjectedTypeChecker.class.isAssignableFrom(this.getCheckerClass());
    }

    @Override
    public Class<? extends ITypeChecker> getCheckerClass() {
        return this.checker;
    }
}

