/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.config;

import java.util.Properties;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lucene.config.LuceneSailConfigSchema;

public abstract class AbstractLuceneSailConfig
extends AbstractDelegatingSailImplConfig {
    private static final String PARAMETER_PREFIX = "lucene.";
    private String indexDir;
    private final Properties parameters = new Properties();

    protected AbstractLuceneSailConfig(String type) {
        super(type);
    }

    protected AbstractLuceneSailConfig(String type, SailImplConfig delegate) {
        super(type, delegate);
    }

    protected AbstractLuceneSailConfig(String type, String luceneDir) {
        super(type);
        this.setIndexDir(luceneDir);
    }

    protected AbstractLuceneSailConfig(String type, String luceneDir, SailImplConfig delegate) {
        super(type, delegate);
        this.setIndexDir(luceneDir);
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String luceneDir) {
        this.indexDir = luceneDir;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public Set<String> getParameterNames() {
        return this.parameters.stringPropertyNames();
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (this.indexDir != null) {
            m.add(implNode, CONFIG.Lucene.indexDir, Values.literal(this.indexDir), new Resource[0]);
        }
        for (String key : this.getParameterNames()) {
            m.add(implNode, Values.iri("tag:rdf4j.org,2023:config/", PARAMETER_PREFIX + key), Values.literal(this.getParameter(key)), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        Literal indexDirLit = Configurations.getLiteralValue(graph, implNode, CONFIG.Lucene.indexDir, LuceneSailConfigSchema.INDEX_DIR).orElseThrow(() -> new SailConfigException("no value found for " + String.valueOf(CONFIG.Lucene.indexDir)));
        this.setIndexDir(indexDirLit.getLabel());
        for (Statement stmt : graph.getStatements(implNode, null, null, new Resource[0])) {
            if (!stmt.getPredicate().getNamespace().equals("tag:rdf4j.org,2023:config/") && !stmt.getPredicate().getNamespace().equals("http://www.openrdf.org/config/sail/lucene#") || !stmt.getObject().isLiteral()) continue;
            String key = stmt.getPredicate().getLocalName();
            if (key.startsWith(PARAMETER_PREFIX)) {
                key = key.substring(PARAMETER_PREFIX.length());
            }
            this.setParameter(key, stmt.getObject().stringValue());
        }
    }
}

