/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public abstract class LoggingCloseableIteration
implements CloseableIteration<ValidationTuple, SailException> {
    private final ValidationExecutionLogger validationExecutionLogger;
    private final PlanNode planNode;
    private boolean closed;
    private boolean initialized;

    public LoggingCloseableIteration(PlanNode planNode, ValidationExecutionLogger validationExecutionLogger) {
        this.planNode = planNode;
        this.validationExecutionLogger = validationExecutionLogger;
    }

    public final ValidationTuple next() throws SailException {
        assert (this.initialized);
        ValidationTuple tuple = this.loggingNext();
        if (this.validationExecutionLogger.isEnabled()) {
            this.validationExecutionLogger.log(this.planNode.depth(), this.planNode.getClass().getSimpleName() + ".next()", tuple, this.planNode, this.planNode.getId(), null);
        }
        return tuple;
    }

    public final boolean hasNext() throws SailException {
        boolean hasNext;
        if (this.closed) {
            return false;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        if (!(hasNext = this.localHasNext())) {
            assert (!this.localHasNext()) : "Iterator was initially empty, but still has more elements! " + this.getClass();
            this.close();
        }
        return hasNext;
    }

    public void close() throws SailException {
        if (!this.closed) {
            this.closed = true;
            this.localClose();
        }
    }

    protected abstract void init();

    protected abstract ValidationTuple loggingNext();

    protected abstract boolean localHasNext();

    protected abstract void localClose();

    public void remove() throws SailException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

