/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class StringCast
extends CastFunction {
    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getXsdName() + " cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                String lexicalValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (this.isValidForDatatype(lexicalValue)) {
                    return valueFactory.createLiteral(lexicalValue, this.getXsdDatatype());
                }
            } else if (datatype != null && datatype.equals((Object)this.getXsdDatatype())) {
                return literal;
            }
            return this.convert(valueFactory, (Value)literal);
        }
        return this.convert(valueFactory, args[0]);
    }

    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof IRI) {
            return valueFactory.createLiteral(value.toString(), XSD.STRING);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                return valueFactory.createLiteral(literal.getLabel(), XSD.STRING);
            }
            if (!Literals.isLanguageLiteral((Literal)literal)) {
                if (XMLDatatypeUtil.isNumericDatatype((IRI)datatype) || datatype.equals((Object)XSD.BOOLEAN) || datatype.equals((Object)XSD.DATETIME) || datatype.equals((Object)XSD.DATETIMESTAMP)) {
                    if (XMLDatatypeUtil.isValidValue((String)literal.getLabel(), (IRI)datatype)) {
                        String normalizedValue = XMLDatatypeUtil.normalize((String)literal.getLabel(), (IRI)datatype);
                        return valueFactory.createLiteral(normalizedValue, XSD.STRING);
                    }
                    return valueFactory.createLiteral(literal.getLabel(), XSD.STRING);
                }
                return valueFactory.createLiteral(literal.getLabel(), XSD.STRING);
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XSD.STRING;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return true;
    }
}

