/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.DelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public abstract class AbstractDelegatingRepositoryImplConfig
extends AbstractRepositoryImplConfig
implements DelegatingRepositoryImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private RepositoryImplConfig delegate;

    protected AbstractDelegatingRepositoryImplConfig() {
    }

    protected AbstractDelegatingRepositoryImplConfig(String type) {
        super(type);
    }

    protected AbstractDelegatingRepositoryImplConfig(String type, RepositoryImplConfig delegate) {
        this(type);
        this.setDelegate(delegate);
    }

    @Override
    public RepositoryImplConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RepositoryImplConfig delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.delegate == null) {
            throw new RepositoryConfigException("No delegate specified for " + this.getType() + " repository");
        }
        this.delegate.validate();
    }

    @Override
    public Resource export(Model model) {
        Resource resource = super.export(model);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(model);
            if (USE_CONFIG) {
                model.add(resource, CONFIG.delegate, (Value)delegateNode, new Resource[0]);
            } else {
                model.add(resource, RepositoryConfigSchema.DELEGATE, (Value)delegateNode, new Resource[0]);
            }
        }
        return resource;
    }

    @Override
    public void parse(Model model, Resource resource) throws RepositoryConfigException {
        super.parse(model, resource);
        Configurations.getResourceValue((Model)model, (Resource)resource, (IRI)CONFIG.delegate, (IRI)RepositoryConfigSchema.DELEGATE).ifPresent(delegate -> this.setDelegate(AbstractDelegatingRepositoryImplConfig.create(model, delegate)));
    }
}

