/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.eclipse.rdf4j.collection.factory.api.BindingSetKey;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultCollectionFactory;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapDbCollectionFactory
implements CollectionFactory {
    private static final int SWITCH_TO_DISK_BASED_SET_AT_SIZE = 16;
    protected volatile DB db;
    protected volatile long colectionId = 0L;
    protected final long iterationCacheSyncThreshold;
    private final CollectionFactory delegate;

    public MapDbCollectionFactory(long iterationCacheSyncThreshold) {
        this(iterationCacheSyncThreshold, (CollectionFactory)new DefaultCollectionFactory());
    }

    public MapDbCollectionFactory(long iterationCacheSyncThreshold, CollectionFactory delegate) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.db == null) {
            MapDbCollectionFactory mapDbCollectionFactory = this;
            synchronized (mapDbCollectionFactory) {
                if (this.db == null) {
                    try {
                        this.db = DBMaker.newFileDB((File)File.createTempFile("group-eval", null)).deleteFilesAfterClose().closeOnJvmShutdown().make();
                    }
                    catch (IOException e) {
                        throw new RDF4jMapDBException("could not initialize temp db", e);
                    }
                }
            }
        }
    }

    public <T> List<T> createList() {
        return this.delegate.createList();
    }

    public List<Value> createValueList() {
        return this.delegate.createValueList();
    }

    public Set<BindingSet> createSetOfBindingSets() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            MemoryTillSizeXSet set = new MemoryTillSizeXSet(this.colectionId++, this.delegate.createSetOfBindingSets());
            return new CommitingSet<BindingSet>(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createSetOfBindingSets();
    }

    public <T> Set<T> createSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            MemoryTillSizeXSet set = new MemoryTillSizeXSet(this.colectionId++, this.delegate.createSet());
            return new CommitingSet(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createSet();
    }

    public Set<Value> createValueSet() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            MemoryTillSizeXSet set = new MemoryTillSizeXSet(this.colectionId++, this.delegate.createValueSet());
            return new CommitingSet<Value>(set, this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createValueSet();
    }

    public <K, V> Map<K, V> createMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            return new CommitingMap(this.db.createHashMap(Long.toHexString(this.colectionId++)).make(), this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createMap();
    }

    public <V> Map<Value, V> createValueKeyedMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            return new CommitingMap(this.db.createHashMap(Long.toHexString(this.colectionId++)).make(), this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createValueKeyedMap();
    }

    public <T> Queue<T> createQueue() {
        return this.delegate.createQueue();
    }

    public Queue<Value> createValueQueue() {
        return this.delegate.createValueQueue();
    }

    public void close() throws RDF4JException {
        if (this.db != null) {
            this.db.close();
        }
    }

    public <E> Map<BindingSetKey, E> createGroupByMap() {
        if (this.iterationCacheSyncThreshold > 0L) {
            this.init();
            return new CommitingMap(this.db.createHashMap(Long.toHexString(this.colectionId++)).make(), this.iterationCacheSyncThreshold, this.db);
        }
        return this.delegate.createGroupByMap();
    }

    public BindingSetKey createBindingSetKey(BindingSet bindingSet, List<Function<BindingSet, Value>> getValues, ToIntFunction<BindingSet> hashOfBindingSetCalculator) {
        return this.delegate.createBindingSetKey(bindingSet, getValues, hashOfBindingSetCalculator);
    }

    protected class MemoryTillSizeXSet<V>
    extends AbstractSet<V> {
        private Set<V> wrapped;
        private final long setName;

        public MemoryTillSizeXSet(long setName, Set<V> wrapped) {
            this.setName = setName;
            this.wrapped = wrapped;
        }

        @Override
        public boolean add(V e) {
            if (this.wrapped instanceof HashSet && this.wrapped.size() > 16) {
                Set disk = MapDbCollectionFactory.this.db.getHashSet(Long.toHexString(this.setName));
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends V> arg0) {
            if (this.wrapped instanceof HashSet && arg0.size() > 16) {
                Set disk = MapDbCollectionFactory.this.db.getHashSet(Long.toHexString(this.setName));
                disk.addAll(this.wrapped);
                this.wrapped = disk;
            }
            return this.wrapped.addAll(arg0);
        }

        @Override
        public void clear() {
            this.wrapped.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapped.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.wrapped.containsAll(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            return this.wrapped.remove(o);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.wrapped.retainAll(c);
        }

        @Override
        public Object[] toArray() {
            return this.wrapped.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.wrapped.toArray(arg0);
        }

        @Override
        public Iterator<V> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    protected static final class CommitingMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingMap(Map<K, V> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public V put(K k, V v) {
            V res = this.wrapped.put(k, v);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.wrapped.entrySet();
        }
    }

    protected static final class CommitingSet<T>
    extends AbstractSet<T> {
        private final Set<T> wrapped;
        private final long iterationCacheSyncThreshold;
        private final DB db;
        private long iterationCount;

        public CommitingSet(Set<T> wrapped, long iterationCacheSyncThreshold, DB db) {
            this.wrapped = wrapped;
            this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
            this.db = db;
        }

        @Override
        public boolean add(T e) {
            boolean res = this.wrapped.add(e);
            if (this.iterationCount++ % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean res = this.wrapped.addAll(c);
            if (this.iterationCount + (long)c.size() % this.iterationCacheSyncThreshold == 0L) {
                this.db.commit();
            }
            return res;
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    private static final class RDF4jMapDBException
    extends RDF4JException {
        private static final long serialVersionUID = 1L;

        public RDF4jMapDBException(String string, IOException e) {
            super(string, (Throwable)e);
        }
    }
}

